var { ExtensionCommon } = ChromeUtils.import(
    'resource://gre/modules/ExtensionCommon.jsm'
);

var { ExtensionParent } = ChromeUtils.import(
    'resource://gre/modules/ExtensionParent.jsm'
);

var extension = ExtensionParent.GlobalManager.getExtension(
    'mailmindr@arndissler.net'
);

const { XPCOMUtils } = ChromeUtils.import(
    'resource://gre/modules/XPCOMUtils.jsm'
);

const { MailUtils } = ChromeUtils.import('resource:///modules/MailUtils.jsm');

XPCOMUtils.defineLazyModuleGetters(this, {
    MailServices: 'resource:///modules/MailServices.jsm',
    Services: 'resource://gre/modules/Services.jsm'
    // 
});

var mailmindrMessagesApi = class extends ExtensionCommon.ExtensionAPI {
    getAPI(context) {
        return {
            // 
            mailmindrMessagesApi: {
                openMessageByMessageHeaderId: async function(headerMessageId) {
                    const msgId = headerMessageId
                        .replace('>', '')
                        .replace('<', '')
                        .trim();

                    try {
                        if (MailUtils.openMessageByMessageId) {
                            MailUtils.openMessageByMessageId(msgId);
                        } else {
                            const getFirstMessageHeaderForMessageId = (
                                msgId,
                                startServer
                            ) => {
                                console.warn(
                                    `MailUtils.openMessageByMessageId doesn't exist, using fallback to manual traveral`
                                );

                                const findMsgIdInFolder = (msgId, folder) => {
                                    let msgHdr;
                                    // 
                                    if (!folder.isServer) {
                                        msgHdr = folder.msgDatabase.getMsgHdrForMessageID(
                                            msgId
                                        );
                                        if (msgHdr) {
                                            return msgHdr;
                                        }
                                    }

                                    // 
                                    for (let currentFolder of folder.subFolders) {
                                        msgHdr = findMsgIdInFolder(
                                            msgId,
                                            currentFolder
                                        );
                                        if (msgHdr) {
                                            return msgHdr;
                                        }
                                    }
                                    return null;
                                };

                                let allServers =
                                    MailServices.accounts.allServers;
                                if (startServer) {
                                    allServers = [startServer].concat(
                                        allServers.filter(
                                            s => s.key != startServer.key
                                        )
                                    );
                                }
                                for (let server of allServers) {
                                    if (
                                        server &&
                                        server.canSearchMessages &&
                                        !server.isDeferredTo
                                    ) {
                                        let msgHdr = findMsgIdInFolder(
                                            msgId,
                                            server.rootFolder
                                        );
                                        if (msgHdr) {
                                            return msgHdr;
                                        }
                                    }
                                }
                                return null;
                            };

                            let msgHdr = null;
                            if (MailUtils.getMsgHdrForMsgId) {
                                msgHdr = MailUtils.getMsgHdrForMsgId(msgId);
                            } else {
                                console.warn(
                                    `MailUtils.getMsgHdrForMsgId doesn't exist, falling back to manual traversal to find msgHdr`
                                );
                                msgHdr = getFirstMessageHeaderForMessageId(
                                    msgId
                                );
                            }

                            if (msgHdr) {
                                if (MailUtils.displayMessage) {
                                    MailUtils.displayMessage(msgHdr);
                                } else {
                                    console.error(
                                        `MailUtils.displayMessage doesn't exist, no fallback available (${navigator &&
                                            navigator.userAgent})`
                                    );
                                }
                            } else {
                                console.warn(
                                    `No headers found for msgId: '${msgId}'`
                                );
                            }
                        }
                    } catch (e) {
                        console.error(
                            '[mailmindr] mailmindrMessagesApi.openMessageByMessageHeaderId: ',
                            e
                        );
                    }
                }
            }
        };
    }

    onShutdown(isAppShutdown) {
        if (isAppShutdown) {
            return;
        }

        // 

        Services.obs.notifyObservers(null, 'startupcache-invalidate', null);
    }
};
