/* config-client.c generated by valac 0.10.4, the Vala compiler
 * generated from config-client.vala, do not modify */

/*
 * Desktop Agnostic Library: Configuration frontend.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BIND_METHOD (desktop_agnostic_config_bind_method_get_type ())

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT (desktop_agnostic_config_client_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT, DesktopAgnosticConfigClient))
#define DESKTOP_AGNOSTIC_CONFIG_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT, DesktopAgnosticConfigClientClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT))
#define DESKTOP_AGNOSTIC_CONFIG_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT))
#define DESKTOP_AGNOSTIC_CONFIG_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT, DesktopAgnosticConfigClientClass))

typedef struct _DesktopAgnosticConfigClient DesktopAgnosticConfigClient;
typedef struct _DesktopAgnosticConfigClientClass DesktopAgnosticConfigClientClass;
typedef struct _DesktopAgnosticConfigClientPrivate DesktopAgnosticConfigClientPrivate;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA (desktop_agnostic_config_schema_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchema))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchemaClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchemaClass))

typedef struct _DesktopAgnosticConfigSchema DesktopAgnosticConfigSchema;
typedef struct _DesktopAgnosticConfigSchemaClass DesktopAgnosticConfigSchemaClass;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND (desktop_agnostic_config_backend_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackend))
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackendClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND))
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackendClass))

typedef struct _DesktopAgnosticConfigBackend DesktopAgnosticConfigBackend;
typedef struct _DesktopAgnosticConfigBackendClass DesktopAgnosticConfigBackendClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION (desktop_agnostic_config_schema_option_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOption))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionClass))

typedef struct _DesktopAgnosticConfigSchemaOption DesktopAgnosticConfigSchemaOption;
typedef struct _DesktopAgnosticConfigSchemaOptionClass DesktopAgnosticConfigSchemaOptionClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE (desktop_agnostic_config_bridge_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_BRIDGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE, DesktopAgnosticConfigBridge))
#define DESKTOP_AGNOSTIC_CONFIG_BRIDGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE, DesktopAgnosticConfigBridgeClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BRIDGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BRIDGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE))
#define DESKTOP_AGNOSTIC_CONFIG_BRIDGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE, DesktopAgnosticConfigBridgeClass))

typedef struct _DesktopAgnosticConfigBridge DesktopAgnosticConfigBridge;
typedef struct _DesktopAgnosticConfigBridgeClass DesktopAgnosticConfigBridgeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_GLOBAL,
	DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_INSTANCE,
	DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK,
	DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH
} DesktopAgnosticConfigBindMethod;

struct _DesktopAgnosticConfigClient {
	GObject parent_instance;
	DesktopAgnosticConfigClientPrivate * priv;
};

struct _DesktopAgnosticConfigClientClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticConfigClientPrivate {
	DesktopAgnosticConfigSchema* _schema;
	DesktopAgnosticConfigBackend* global;
	DesktopAgnosticConfigBackend* instance;
};

typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_OPTION,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_LIST_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_NAME_EXISTS,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_GTYPE_EXISTS
} DesktopAgnosticConfigSchemaError;
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR desktop_agnostic_config_schema_error_quark ()
typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_ERROR_NO_SCHEMA,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_METADATA_NOT_FOUND,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_NOTIFY,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_DUPLICATE_BINDING
} DesktopAgnosticConfigError;
#define DESKTOP_AGNOSTIC_CONFIG_ERROR desktop_agnostic_config_error_quark ()
typedef void (*DesktopAgnosticConfigNotifyFunc) (const char* group, const char* key, GValue* value, void* user_data);

static gpointer desktop_agnostic_config_client_parent_class = NULL;

GType desktop_agnostic_config_bind_method_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_config_client_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_config_schema_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_config_backend_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_CONFIG_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT, DesktopAgnosticConfigClientPrivate))
enum  {
	DESKTOP_AGNOSTIC_CONFIG_CLIENT_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_CONFIG_CLIENT_INSTANCE_ID,
	DESKTOP_AGNOSTIC_CONFIG_CLIENT_SCHEMA_FILENAME
};
DesktopAgnosticConfigClient* desktop_agnostic_config_client_new (const char* schema_filename);
DesktopAgnosticConfigClient* desktop_agnostic_config_client_construct (GType object_type, const char* schema_filename);
DesktopAgnosticConfigClient* desktop_agnostic_config_client_new_for_instance (const char* schema_filename, const char* instance_id, GError** error);
DesktopAgnosticConfigClient* desktop_agnostic_config_client_construct_for_instance (GType object_type, const char* schema_filename, const char* instance_id, GError** error);
DesktopAgnosticConfigClient* desktop_agnostic_config_client_new_for_schema (DesktopAgnosticConfigSchema* schema, const char* instance_id, GError** error);
DesktopAgnosticConfigClient* desktop_agnostic_config_client_construct_for_schema (GType object_type, DesktopAgnosticConfigSchema* schema, const char* instance_id, GError** error);
static void desktop_agnostic_config_client_create_global_config (DesktopAgnosticConfigClient* self);
static gboolean desktop_agnostic_config_client_create_instance_config (DesktopAgnosticConfigClient* self, const char* instance_id, GError** error);
DesktopAgnosticConfigBackend* desktop_agnostic_config_new (DesktopAgnosticConfigSchema* schema, GError** error);
GQuark desktop_agnostic_config_schema_error_quark (void);
GValue* desktop_agnostic_config_schema_get_metadata_option (DesktopAgnosticConfigSchema* self, const char* name, GError** error);
static void _vala_GValue_free (GValue* self);
DesktopAgnosticConfigBackend* desktop_agnostic_config_new_for_instance (const char* instance_id, DesktopAgnosticConfigSchema* schema, GError** error);
static DesktopAgnosticConfigBackend* desktop_agnostic_config_client_get_backend (DesktopAgnosticConfigClient* self, const char* group, const char* key);
GType desktop_agnostic_config_schema_option_get_type (void) G_GNUC_CONST;
DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_get_option (DesktopAgnosticConfigSchema* self, const char* group, const char* key);
gboolean desktop_agnostic_config_schema_option_get_per_instance (DesktopAgnosticConfigSchemaOption* self);
gboolean desktop_agnostic_config_client_get_bool (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error);
gboolean desktop_agnostic_config_backend_get_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
void desktop_agnostic_config_client_set_bool (DesktopAgnosticConfigClient* self, const char* group, const char* key, gboolean value, GError** error);
void desktop_agnostic_config_backend_set_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gboolean value, GError** error);
gint desktop_agnostic_config_client_get_int (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error);
gint desktop_agnostic_config_backend_get_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
void desktop_agnostic_config_client_set_int (DesktopAgnosticConfigClient* self, const char* group, const char* key, gint value, GError** error);
void desktop_agnostic_config_backend_set_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gint value, GError** error);
float desktop_agnostic_config_client_get_float (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error);
float desktop_agnostic_config_backend_get_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
void desktop_agnostic_config_client_set_float (DesktopAgnosticConfigClient* self, const char* group, const char* key, float value, GError** error);
void desktop_agnostic_config_backend_set_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, float value, GError** error);
char* desktop_agnostic_config_client_get_string (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error);
char* desktop_agnostic_config_backend_get_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
void desktop_agnostic_config_client_set_string (DesktopAgnosticConfigClient* self, const char* group, const char* key, const char* value, GError** error);
void desktop_agnostic_config_backend_set_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, const char* value, GError** error);
GValueArray* desktop_agnostic_config_client_get_list (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error);
GValueArray* desktop_agnostic_config_backend_get_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
void desktop_agnostic_config_client_set_list (DesktopAgnosticConfigClient* self, const char* group, const char* key, GValueArray* value, GError** error);
void desktop_agnostic_config_backend_set_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValueArray* value, GError** error);
void desktop_agnostic_config_client_get_value (DesktopAgnosticConfigClient* self, const char* group, const char* key, GValue* result, GError** error);
void desktop_agnostic_config_backend_get_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* result, GError** error);
static GValue* _g_value_dup (GValue* self);
GQuark desktop_agnostic_config_error_quark (void);
void desktop_agnostic_config_client_set_value (DesktopAgnosticConfigClient* self, const char* group, const char* key, GValue* value, GError** error);
void desktop_agnostic_config_backend_set_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* value, GError** error);
void desktop_agnostic_config_client_notify_add (DesktopAgnosticConfigClient* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
void desktop_agnostic_config_backend_notify_add (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
void desktop_agnostic_config_client_notify (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error);
void desktop_agnostic_config_backend_notify (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
void desktop_agnostic_config_client_notify_remove (DesktopAgnosticConfigClient* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
void desktop_agnostic_config_backend_notify_remove (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
void desktop_agnostic_config_client_remove_instance (DesktopAgnosticConfigClient* self);
void desktop_agnostic_config_client_reset (DesktopAgnosticConfigClient* self, gboolean instance_only, GError** error);
void desktop_agnostic_config_backend_reset (DesktopAgnosticConfigBackend* self, GError** error);
void desktop_agnostic_config_client_bind (DesktopAgnosticConfigClient* self, const char* group, const char* key, GObject* obj, const char* property_name, gboolean read_only, DesktopAgnosticConfigBindMethod method, GError** error);
GType desktop_agnostic_config_bridge_get_type (void) G_GNUC_CONST;
DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_get_default (void);
void desktop_agnostic_config_bridge_bind (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GObject* obj, const char* property_name, gboolean read_only, GError** error);
void desktop_agnostic_config_client_unbind (DesktopAgnosticConfigClient* self, const char* group, const char* key, GObject* obj, const char* property_name, gboolean read_only, DesktopAgnosticConfigBindMethod method, GError** error);
void desktop_agnostic_config_bridge_remove (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GObject* obj, const char* property_name, GError** error);
void desktop_agnostic_config_client_unbind_all_for_object (DesktopAgnosticConfigClient* self, GObject* obj, GError** error);
void desktop_agnostic_config_bridge_remove_all_for_object (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, GObject* obj, GError** error);
const char* desktop_agnostic_config_client_get_instance_id (DesktopAgnosticConfigClient* self);
const char* desktop_agnostic_config_backend_get_instance_id (DesktopAgnosticConfigBackend* self);
static void desktop_agnostic_config_client_set_instance_id (DesktopAgnosticConfigClient* self, const char* value);
static void desktop_agnostic_config_client_set_schema_filename (DesktopAgnosticConfigClient* self, const char* value);
DesktopAgnosticConfigSchema* desktop_agnostic_config_schema_new (const char* filename, GError** error);
DesktopAgnosticConfigSchema* desktop_agnostic_config_schema_construct (GType object_type, const char* filename, GError** error);
static void desktop_agnostic_config_client_finalize (GObject* obj);
static void desktop_agnostic_config_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_config_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GType desktop_agnostic_config_bind_method_get_type (void) {
	static volatile gsize desktop_agnostic_config_bind_method_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_config_bind_method_type_id__volatile)) {
		static const GEnumValue values[] = {{DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_GLOBAL, "DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_GLOBAL", "global"}, {DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_INSTANCE, "DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_INSTANCE", "instance"}, {DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, "DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK", "fallback"}, {DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH, "DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH", "both"}, {0, NULL, NULL}};
		GType desktop_agnostic_config_bind_method_type_id;
		desktop_agnostic_config_bind_method_type_id = g_enum_register_static ("DesktopAgnosticConfigBindMethod", values);
		g_once_init_leave (&desktop_agnostic_config_bind_method_type_id__volatile, desktop_agnostic_config_bind_method_type_id);
	}
	return desktop_agnostic_config_bind_method_type_id__volatile;
}


DesktopAgnosticConfigClient* desktop_agnostic_config_client_construct (GType object_type, const char* schema_filename) {
	DesktopAgnosticConfigClient * self = NULL;
	g_return_val_if_fail (schema_filename != NULL, NULL);
	self = (DesktopAgnosticConfigClient*) g_object_new (object_type, "schema-filename", schema_filename, NULL);
	return self;
}


DesktopAgnosticConfigClient* desktop_agnostic_config_client_new (const char* schema_filename) {
	return desktop_agnostic_config_client_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT, schema_filename);
}


DesktopAgnosticConfigClient* desktop_agnostic_config_client_construct_for_instance (GType object_type, const char* schema_filename, const char* instance_id, GError** error) {
	DesktopAgnosticConfigClient * self = NULL;
	g_return_val_if_fail (schema_filename != NULL, NULL);
	g_return_val_if_fail (instance_id != NULL, NULL);
	self = (DesktopAgnosticConfigClient*) g_object_new (object_type, "schema-filename", schema_filename, "instance-id", instance_id, NULL);
	return self;
}


DesktopAgnosticConfigClient* desktop_agnostic_config_client_new_for_instance (const char* schema_filename, const char* instance_id, GError** error) {
	return desktop_agnostic_config_client_construct_for_instance (DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT, schema_filename, instance_id, error);
}


/**
     * Auto-determines whether an instance config object should be created.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DesktopAgnosticConfigClient* desktop_agnostic_config_client_construct_for_schema (GType object_type, DesktopAgnosticConfigSchema* schema, const char* instance_id, GError** error) {
	DesktopAgnosticConfigClient * self = NULL;
	DesktopAgnosticConfigSchema* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (schema != NULL, NULL);
	self = (DesktopAgnosticConfigClient*) g_object_new (object_type, NULL);
	self->priv->_schema = (_tmp0_ = _g_object_ref0 (schema), _g_object_unref0 (self->priv->_schema), _tmp0_);
	desktop_agnostic_config_client_create_global_config (self);
	if (instance_id != NULL) {
		desktop_agnostic_config_client_create_instance_config (self, instance_id, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	return self;
}


DesktopAgnosticConfigClient* desktop_agnostic_config_client_new_for_schema (DesktopAgnosticConfigSchema* schema, const char* instance_id, GError** error) {
	return desktop_agnostic_config_client_construct_for_schema (DESKTOP_AGNOSTIC_CONFIG_TYPE_CLIENT, schema, instance_id, error);
}


static void desktop_agnostic_config_client_create_global_config (DesktopAgnosticConfigClient* self) {
	DesktopAgnosticConfigBackend* _tmp0_;
	DesktopAgnosticConfigBackend* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = desktop_agnostic_config_new (self->priv->_schema, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->global = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->global), _tmp1_);
}


/**
     * @return whether an instance config object was created.
     */
static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static gboolean desktop_agnostic_config_client_create_instance_config (DesktopAgnosticConfigClient* self, const char* instance_id, GError** error) {
	gboolean result = FALSE;
	GValue* _tmp0_;
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GValue single_instance;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (instance_id != NULL, FALSE);
	single_instance = (_tmp2_ = G_IS_VALUE (_tmp0_ = desktop_agnostic_config_schema_get_metadata_option (self->priv->_schema, "single_instance", &_inner_error_)) ? (g_value_init (&_tmp1_, G_VALUE_TYPE (_tmp0_ = desktop_agnostic_config_schema_get_metadata_option (self->priv->_schema, "single_instance", &_inner_error_))), g_value_copy (_tmp0_ = desktop_agnostic_config_schema_get_metadata_option (self->priv->_schema, "single_instance", &_inner_error_), &_tmp1_), _tmp1_) : (*(_tmp0_ = desktop_agnostic_config_schema_get_metadata_option (self->priv->_schema, "single_instance", &_inner_error_))), __vala_GValue_free0 (_tmp0_), _tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	if (g_value_get_boolean (&single_instance)) {
		result = FALSE;
		G_IS_VALUE (&single_instance) ? (g_value_unset (&single_instance), NULL) : NULL;
		return result;
	} else {
		DesktopAgnosticConfigBackend* _tmp3_;
		DesktopAgnosticConfigBackend* _tmp4_;
		_tmp3_ = desktop_agnostic_config_new_for_instance (instance_id, self->priv->_schema, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&single_instance) ? (g_value_unset (&single_instance), NULL) : NULL;
			return FALSE;
		}
		self->priv->instance = (_tmp4_ = _tmp3_, _g_object_unref0 (self->priv->instance), _tmp4_);
		result = TRUE;
		G_IS_VALUE (&single_instance) ? (g_value_unset (&single_instance), NULL) : NULL;
		return result;
	}
	G_IS_VALUE (&single_instance) ? (g_value_unset (&single_instance), NULL) : NULL;
}


static DesktopAgnosticConfigBackend* desktop_agnostic_config_client_get_backend (DesktopAgnosticConfigClient* self, const char* group, const char* key) {
	DesktopAgnosticConfigBackend* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	if (self->priv->instance == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !desktop_agnostic_config_schema_option_get_per_instance (desktop_agnostic_config_schema_get_option (self->priv->_schema, group, key));
	}
	if (_tmp0_) {
		result = self->priv->global;
		return result;
	} else {
		result = self->priv->instance;
		return result;
	}
}


gboolean desktop_agnostic_config_client_get_bool (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = desktop_agnostic_config_backend_get_bool (desktop_agnostic_config_client_get_backend (self, group, key), group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


void desktop_agnostic_config_client_set_bool (DesktopAgnosticConfigClient* self, const char* group, const char* key, gboolean value, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	desktop_agnostic_config_backend_set_bool (desktop_agnostic_config_client_get_backend (self, group, key), group, key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


gint desktop_agnostic_config_client_get_int (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error) {
	gint result = 0;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (group != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = desktop_agnostic_config_backend_get_int (desktop_agnostic_config_client_get_backend (self, group, key), group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp0_;
	return result;
}


void desktop_agnostic_config_client_set_int (DesktopAgnosticConfigClient* self, const char* group, const char* key, gint value, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	desktop_agnostic_config_backend_set_int (desktop_agnostic_config_client_get_backend (self, group, key), group, key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


float desktop_agnostic_config_client_get_float (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error) {
	float result = 0.0F;
	float _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0F);
	g_return_val_if_fail (group != NULL, 0.0F);
	g_return_val_if_fail (key != NULL, 0.0F);
	_tmp0_ = desktop_agnostic_config_backend_get_float (desktop_agnostic_config_client_get_backend (self, group, key), group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0.0F;
	}
	result = _tmp0_;
	return result;
}


void desktop_agnostic_config_client_set_float (DesktopAgnosticConfigClient* self, const char* group, const char* key, float value, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	desktop_agnostic_config_backend_set_float (desktop_agnostic_config_client_get_backend (self, group, key), group, key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


char* desktop_agnostic_config_client_get_string (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error) {
	char* result = NULL;
	char* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = desktop_agnostic_config_backend_get_string (desktop_agnostic_config_client_get_backend (self, group, key), group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


void desktop_agnostic_config_client_set_string (DesktopAgnosticConfigClient* self, const char* group, const char* key, const char* value, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	desktop_agnostic_config_backend_set_string (desktop_agnostic_config_client_get_backend (self, group, key), group, key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


GValueArray* desktop_agnostic_config_client_get_list (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error) {
	GValueArray* result = NULL;
	GValueArray* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = desktop_agnostic_config_backend_get_list (desktop_agnostic_config_client_get_backend (self, group, key), group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


void desktop_agnostic_config_client_set_list (DesktopAgnosticConfigClient* self, const char* group, const char* key, GValueArray* value, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	desktop_agnostic_config_backend_set_list (desktop_agnostic_config_client_get_backend (self, group, key), group, key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Retrieves the value of the configuration key. If the client has an
     * instance ID and the key cannot be found in the instance config, it
     * falls back to retrieving the value from the global config.
     */
static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void desktop_agnostic_config_client_get_value (DesktopAgnosticConfigClient* self, const char* group, const char* key, GValue* result, GError** error) {
	GValue* temp_val;
	GValue val = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	temp_val = NULL;
	{
		gboolean _tmp0_ = FALSE;
		if (self->priv->instance != NULL) {
			_tmp0_ = desktop_agnostic_config_schema_option_get_per_instance (desktop_agnostic_config_schema_get_option (self->priv->_schema, group, key));
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GValue _tmp1_ = {0};
			GValue _tmp2_;
			GValue _tmp3_;
			GValue _tmp4_;
			GValue* _tmp5_;
			_tmp2_ = (desktop_agnostic_config_backend_get_value (self->priv->instance, group, key, &_tmp1_, &_inner_error_), _tmp1_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			temp_val = (_tmp5_ = __g_value_dup0 ((_tmp4_ = _tmp3_ = _tmp2_, &_tmp4_)), __vala_GValue_free0 (temp_val), _tmp5_);
			G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			if (!g_error_matches (err, DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND)) {
				_inner_error_ = _g_error_copy0 (err);
				{
					_g_error_free0 (err);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					__vala_GValue_free0 (temp_val);
					goto __finally1;
				}
			}
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		__vala_GValue_free0 (temp_val);
		return;
	}
	if (temp_val == NULL) {
		GValue _tmp6_ = {0};
		GValue _tmp7_;
		GValue _tmp8_;
		_tmp7_ = (desktop_agnostic_config_backend_get_value (self->priv->global, group, key, &_tmp6_, &_inner_error_), _tmp6_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			__vala_GValue_free0 (temp_val);
			return;
		}
		val = (_tmp8_ = _tmp7_, G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp8_);
	} else {
		GValue _tmp9_ = {0};
		GValue _tmp10_;
		val = (_tmp10_ = G_IS_VALUE (temp_val) ? (g_value_init (&_tmp9_, G_VALUE_TYPE (temp_val)), g_value_copy (temp_val, &_tmp9_), _tmp9_) : (*temp_val), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp10_);
	}
	*result = val;
	__vala_GValue_free0 (temp_val);
	return;
}


void desktop_agnostic_config_client_set_value (DesktopAgnosticConfigClient* self, const char* group, const char* key, GValue* value, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	desktop_agnostic_config_backend_set_value (desktop_agnostic_config_client_get_backend (self, group, key), group, key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void desktop_agnostic_config_client_notify_add (DesktopAgnosticConfigClient* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	desktop_agnostic_config_backend_notify_add (desktop_agnostic_config_client_get_backend (self, group, key), group, key, callback, callback_target, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void desktop_agnostic_config_client_notify (DesktopAgnosticConfigClient* self, const char* group, const char* key, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	desktop_agnostic_config_backend_notify (desktop_agnostic_config_client_get_backend (self, group, key), group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void desktop_agnostic_config_client_notify_remove (DesktopAgnosticConfigClient* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	desktop_agnostic_config_backend_notify_remove (desktop_agnostic_config_client_get_backend (self, group, key), group, key, callback, callback_target, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void desktop_agnostic_config_client_remove_instance (DesktopAgnosticConfigClient* self) {
	DesktopAgnosticConfigBackend* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->instance = (_tmp0_ = NULL, _g_object_unref0 (self->priv->instance), _tmp0_);
}


void desktop_agnostic_config_client_reset (DesktopAgnosticConfigClient* self, gboolean instance_only, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->instance != NULL) {
		desktop_agnostic_config_backend_reset (self->priv->instance, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	if (!instance_only) {
		desktop_agnostic_config_backend_reset (self->priv->global, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


/**
     * Binds a config key to a property of an object.
     *
     * @param group The configuration group.
     * @param key The configuration key.
     * @param obj The object to which to bind the config key.
     * @param property_name The name of the property to bind. Has an additional
     * use if //method// is {@link BindMethod.BOTH}.
     * @param read_only if TRUE, setting the object property does not propagate
     * to the config backend(s).
     * @param method The method of binding the config backend(s) to the object.
     * @see BindMethod
     */
void desktop_agnostic_config_client_bind (DesktopAgnosticConfigClient* self, const char* group, const char* key, GObject* obj, const char* property_name, gboolean read_only, DesktopAgnosticConfigBindMethod method, GError** error) {
	DesktopAgnosticConfigBridge* bridge;
	DesktopAgnosticConfigSchemaOption* option;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (property_name != NULL);
	bridge = desktop_agnostic_config_bridge_get_default ();
	option = desktop_agnostic_config_schema_get_option (self->priv->_schema, group, key);
	if (option == NULL) {
		g_warning ("config-client.vala:309: Could not find the schema option for %s/%s, no" \
"t binding.", group, key);
		return;
	}
	if (method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_GLOBAL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK) {
			gboolean _tmp3_ = FALSE;
			if (self->priv->instance == NULL) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = !desktop_agnostic_config_schema_option_get_per_instance (option);
			}
			_tmp2_ = _tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		char* global_prop;
		global_prop = NULL;
		if (method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH) {
			char* _tmp4_;
			global_prop = (_tmp4_ = g_strdup_printf ("%s-base", property_name), _g_free0 (global_prop), _tmp4_);
		} else {
			char* _tmp5_;
			global_prop = (_tmp5_ = g_strdup (property_name), _g_free0 (global_prop), _tmp5_);
		}
		desktop_agnostic_config_bridge_bind (bridge, self->priv->global, group, key, obj, global_prop, read_only, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (global_prop);
				return;
			} else {
				_g_free0 (global_prop);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (global_prop);
	}
	if (self->priv->instance != NULL) {
		_tmp7_ = desktop_agnostic_config_schema_option_get_per_instance (option);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		if (method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_INSTANCE) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK;
		}
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		desktop_agnostic_config_bridge_bind (bridge, self->priv->instance, group, key, obj, property_name, read_only, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


/**
     * Removes the bindings between a config key and a GObject property.
     */
void desktop_agnostic_config_client_unbind (DesktopAgnosticConfigClient* self, const char* group, const char* key, GObject* obj, const char* property_name, gboolean read_only, DesktopAgnosticConfigBindMethod method, GError** error) {
	DesktopAgnosticConfigBridge* bridge;
	DesktopAgnosticConfigSchemaOption* option;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (property_name != NULL);
	bridge = desktop_agnostic_config_bridge_get_default ();
	option = desktop_agnostic_config_schema_get_option (self->priv->_schema, group, key);
	if (option == NULL) {
		g_warning ("config-client.vala:352: Could not find the schema option for %s/%s, no" \
"t binding.", group, key);
		return;
	}
	if (method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_GLOBAL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK) {
			gboolean _tmp3_ = FALSE;
			if (self->priv->instance == NULL) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = !desktop_agnostic_config_schema_option_get_per_instance (option);
			}
			_tmp2_ = _tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		char* global_prop;
		global_prop = NULL;
		if (method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH) {
			char* _tmp4_;
			global_prop = (_tmp4_ = g_strdup_printf ("%s-base", property_name), _g_free0 (global_prop), _tmp4_);
		} else {
			char* _tmp5_;
			global_prop = (_tmp5_ = g_strdup (property_name), _g_free0 (global_prop), _tmp5_);
		}
		desktop_agnostic_config_bridge_remove (bridge, self->priv->global, group, key, obj, global_prop, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (global_prop);
				return;
			} else {
				_g_free0 (global_prop);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (global_prop);
	}
	if (self->priv->instance != NULL) {
		_tmp7_ = desktop_agnostic_config_schema_option_get_per_instance (option);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		if (method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_INSTANCE) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_BOTH;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = method == DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK;
		}
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		desktop_agnostic_config_bridge_remove (bridge, self->priv->instance, group, key, obj, property_name, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


/**
     * Removes all of the bindings for a given object.
     */
void desktop_agnostic_config_client_unbind_all_for_object (DesktopAgnosticConfigClient* self, GObject* obj, GError** error) {
	DesktopAgnosticConfigBridge* bridge;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	bridge = desktop_agnostic_config_bridge_get_default ();
	if (self->priv->instance != NULL) {
		desktop_agnostic_config_bridge_remove_all_for_object (bridge, self->priv->instance, obj, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	desktop_agnostic_config_bridge_remove_all_for_object (bridge, self->priv->global, obj, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


const char* desktop_agnostic_config_client_get_instance_id (DesktopAgnosticConfigClient* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->instance == NULL) {
		result = NULL;
		return result;
	} else {
		result = desktop_agnostic_config_backend_get_instance_id (self->priv->instance);
		return result;
	}
}


static void desktop_agnostic_config_client_set_instance_id (DesktopAgnosticConfigClient* self, const char* value) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		gboolean _tmp1_;
		_tmp1_ = desktop_agnostic_config_client_create_instance_config (self, value, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_warning ("config-client.vala:78: The configuration schema has declared that ther" \
"e can only be a single configuration instance.");
		g_warning ("config-client.vala:79: Not creating an instance config object.");
	}
	g_object_notify ((GObject *) self, "instance-id");
}


static void desktop_agnostic_config_client_set_schema_filename (DesktopAgnosticConfigClient* self, const char* value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		{
			DesktopAgnosticConfigSchema* _tmp0_;
			DesktopAgnosticConfigSchema* _tmp1_;
			_tmp0_ = desktop_agnostic_config_schema_new (value, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			self->priv->_schema = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->_schema), _tmp1_);
			desktop_agnostic_config_client_create_global_config (self);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("config-client.vala:96: Config error: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "schema-filename");
}


static void desktop_agnostic_config_client_class_init (DesktopAgnosticConfigClientClass * klass) {
	desktop_agnostic_config_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticConfigClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_config_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_config_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_CLIENT_INSTANCE_ID, g_param_spec_string ("instance-id", "instance-id", "instance-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_CLIENT_SCHEMA_FILENAME, g_param_spec_string ("schema-filename", "schema-filename", "schema-filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void desktop_agnostic_config_client_instance_init (DesktopAgnosticConfigClient * self) {
	self->priv = DESKTOP_AGNOSTIC_CONFIG_CLIENT_GET_PRIVATE (self);
}


static void desktop_agnostic_config_client_finalize (GObject* obj) {
	DesktopAgnosticConfigClient * self;
	self = DESKTOP_AGNOSTIC_CONFIG_CLIENT (obj);
	_g_object_unref0 (self->priv->_schema);
	_g_object_unref0 (self->priv->global);
	_g_object_unref0 (self->priv->instance);
	G_OBJECT_CLASS (desktop_agnostic_config_client_parent_class)->finalize (obj);
}


/**
   * A wrapper for {@link Config.Backend} and {@link Config.Bridge}
   * which handles calls to the global and/or instance objects 
   * of {@link Config.Backend}.
   *
   * NOTE: Unknown bizarre behavior may occur if one instantiates two instances
   * of this class using the same schema, but different instance IDs.
   */
GType desktop_agnostic_config_client_get_type (void) {
	static volatile gsize desktop_agnostic_config_client_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_config_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigClient), 0, (GInstanceInitFunc) desktop_agnostic_config_client_instance_init, NULL };
		GType desktop_agnostic_config_client_type_id;
		desktop_agnostic_config_client_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticConfigClient", &g_define_type_info, 0);
		g_once_init_leave (&desktop_agnostic_config_client_type_id__volatile, desktop_agnostic_config_client_type_id);
	}
	return desktop_agnostic_config_client_type_id__volatile;
}


static void desktop_agnostic_config_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigClient * self;
	self = DESKTOP_AGNOSTIC_CONFIG_CLIENT (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_CLIENT_INSTANCE_ID:
		g_value_set_string (value, desktop_agnostic_config_client_get_instance_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_config_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigClient * self;
	self = DESKTOP_AGNOSTIC_CONFIG_CLIENT (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_CLIENT_INSTANCE_ID:
		desktop_agnostic_config_client_set_instance_id (self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_CLIENT_SCHEMA_FILENAME:
		desktop_agnostic_config_client_set_schema_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




