#include "musicplayer.h"
#include "config.h"
#include <QQmlContext>

MusicPlayer::MusicPlayer (int& argc, char** argv) : QApplication (argc, argv), pView (nullptr)
{
    setOrganizationName ("UbPorts");
    setOrganizationDomain ("ubports.com");
    setApplicationName ("Music Player");
}

MusicPlayer::~MusicPlayer ()
{
    if (this->pView)
    {
        delete this->pView;
    }
}

bool MusicPlayer::setup ()
{
    this->pView = new QQuickView ();
    this->pView->setColor (Qt::black);
    this->pView->setResizeMode (QQuickView::SizeViewToRootObject);
    this->pView->setFlags (static_cast<Qt::WindowFlags>(0x00800000));
    this->pView->setTitle (tr ("Music Player"));
    this->pView->rootContext ()->setContextProperty ("mApplication", this);
    QUrl sSource (musicPlayerDirectory () + "/app/music-app.qml");
    this->pView->setSource (sSource);
    this->pView->show ();

    return true;
}
