/* Generated by re2c 3.1 on Sat Aug 24 17:13:21 2024 */
#line 1 "parser/preprocessor.re"
#include <iostream>
#include <map>

#include <lfortran/parser/preprocessor.h>
#include <libasr/assert.h>
#include <lfortran/utils.h>
#include <libasr/string_utils.h>

namespace LCompilers::LFortran {

CPreprocessor::CPreprocessor(CompilerOptions &compiler_options)
    : compiler_options{compiler_options} {
    CPPMacro md;
    md.expansion = "1";
    macro_definitions["__LFORTRAN__"] = md;
    md.expansion = "\"" + std::string(LFORTRAN_VERSION) + "\"";
    macro_definitions["__VERSION__"] = md;
    md.expansion = std::to_string(LFORTRAN_MAJOR);
    macro_definitions["__LFORTRAN_MAJOR__"] = md;
    md.expansion = std::to_string(LFORTRAN_MINOR);
    macro_definitions["__LFORTRAN_MINOR__"] = md;
    md.expansion = std::to_string(LFORTRAN_PATCHLEVEL);
    macro_definitions["__LFORTRAN_PATCHLEVEL__"] = md;
    if (compiler_options.platform == Platform::Windows) {
        md.expansion = "1";
        macro_definitions["_WIN32"] = md;
    } else if (compiler_options.platform == Platform::macOS_ARM
        || compiler_options.platform == Platform::macOS_Intel) {
        md.expansion = "1";
        macro_definitions["__APPLE__"] = md;
        if (compiler_options.platform == Platform::macOS_ARM) {
            md.expansion = "1";
            macro_definitions["__aarch64__"] = md;
        } else {
            md.expansion = "1";
            macro_definitions["__x86_64__"] = md;
        }
    } else if (compiler_options.platform == Platform::FreeBSD) {
        md.expansion = "1";
        macro_definitions["__FreeBSD__"] = md;
    } else if (compiler_options.platform == Platform::OpenBSD) {
        md.expansion = "1";
        macro_definitions["__OpenBSD__"] = md;
    } else {
        md.expansion = "1";
        macro_definitions["__linux__"] = md;
    }
#ifdef __ELF__
    md.expansion = std::to_string(__ELF__);
    macro_definitions["__ELF__"] = md;
#endif
#ifdef __SIZEOF_POINTER__
    md.expansion = std::to_string(__SIZEOF_POINTER__);
    macro_definitions["__SIZEOF_POINTER__"] = md;
#endif
#ifdef __SIZEOF_SIZE_T__
    md.expansion = std::to_string(__SIZEOF_SIZE_T__);
    macro_definitions["__SIZEOF_SIZE_T__"] = md;
#endif
#ifdef __linux__
#ifdef __x86_64__
    md.expansion = std::to_string(__x86_64__);
    macro_definitions["__x86_64__"] = md;
#endif
#ifdef __i386__
    md.expansion = std::to_string(__i386__);
    macro_definitions["__i386__"] = md;
#endif
#endif
    for (auto &d : compiler_options.c_preprocessor_defines) {
        std::size_t idx = d.find("=");
        if (idx != std::string::npos) {
            md.expansion = d.substr(idx+1);
            d = d.substr(0, idx);
        } else {
            md.expansion = "1";
        }
        macro_definitions[d] = md;
    }

    md.expansion = "\"\"";
    macro_definitions["__FILE__"] = md;
    md.expansion = "0";
    macro_definitions["__LINE__"] = md;
}
std::string CPreprocessor::token(unsigned char *tok, unsigned char* cur) const
{
    return std::string((char *)tok, cur - tok);
}

void handle_continuation_lines(std::string &s, unsigned char *&cur);

std::string parse_continuation_lines(unsigned char *&cur) {
    std::string output;
    while (*cur != '\n') {
        output += *cur;
        cur++;
    }
    cur++;
    handle_continuation_lines(output, cur);
    return output;
}

void handle_continuation_lines(std::string &s, unsigned char *&cur) {
    if (s.size() > 0 && s[s.size()-1] == '\\') {
        s = s.substr(0, s.size()-1);
        s += parse_continuation_lines(cur);
    }
}

// Parse a macro declaration argument, e.g. in:
// f(a,b, c,  d  )
std::string parse_argument(unsigned char *&cur) {
    std::string arg;
    while (*cur == ' ' && *cur != '\0') cur++;
    while (*cur != ')' && *cur != ',' && *cur != ' ') {
        if (*cur == '\0') {
            throw LCompilersException("C preprocessor: runaway argument");
        }
        arg += *cur;
        cur++;
    }
    while (*cur == ' ' && *cur != '\0') cur++;
    if (*cur == '\0') {
        throw LCompilersException("C preprocessor: runaway argument");
    }
    return arg;
}

std::string match_parentheses(unsigned char *&cur) {
    LCOMPILERS_ASSERT(*cur == '(')
    std::string arg;
    arg += *cur;
    cur++;
    while (*cur != ')') {
        if (*cur == '\0') {
            throw LCompilersException("C preprocessor: unmatched parentheses");
        }
        if (*cur == '(') {
            arg += match_parentheses(cur);
            LCOMPILERS_ASSERT(*cur == ')')
        } else {
            arg += *cur;
        }
        cur++;
    }
    arg += *cur;
    return arg;
}

// Parse a macro call argument, e.g. in:
// ASSERT(fn(3, 5))
std::string parse_argument2(unsigned char *&cur) {
    std::string arg;
    while (*cur != ')' && *cur != ',') {
        if (*cur == '\0') {
            throw LCompilersException("C preprocessor: runaway argument");
        }
        if (*cur == '(') {
            arg += match_parentheses(cur);
            LCOMPILERS_ASSERT(*cur == ')')
        } else {
            arg += *cur;
        }
        cur++;
    }
    return arg;
}

std::vector<std::string> parse_arguments(unsigned char *&cur, bool skip_spaces) {
    std::vector<std::string> args;
    LCOMPILERS_ASSERT(*cur == '(');
    cur++;
    while (*cur != ')') {
        if (skip_spaces) {
            args.push_back(parse_argument(cur));
        } else {
            args.push_back(parse_argument2(cur));
        }
        if (*cur == ',') cur++;
    }
    return args;
}

void interval_end(LocationManager &lm, size_t output_len,
                size_t input_len, size_t input_interval_len,
                uint32_t interval_type) {
    lm.files.back().out_start0.push_back(output_len);
    lm.files.back().in_start0.push_back(input_len);
    lm.files.back().in_size0.push_back(input_interval_len);
    lm.files.back().interval_type0.push_back(interval_type);
}

void interval_end_type_0(LocationManager &lm, size_t output_len,
                size_t input_len) {
    size_t input_interval_len = output_len - lm.files.back().out_start0.back();
    interval_end(lm, output_len, input_len, input_interval_len, 0);
}

struct IfDef {
    // The ifdef is active, meaning one of its branches might get executed
    // Inactive ifdef is in a dead branch of another ifdef
    bool active=true;
    // The current branch of ifdef is active
    bool branch_enabled=true;
    // Ifdef's enabled branch has been executed, now we just need to process
    // and skip all `elif` and `else`.
    bool enabled_branch_executed=false;
};

namespace {

int parse_bexpr(unsigned char *&cur, const cpp_symtab &macro_definitions);

}

std::string CPreprocessor::run(const std::string &input, LocationManager &lm,
        cpp_symtab &macro_definitions) const {
    LCOMPILERS_ASSERT(input[input.size()] == '\0');
    unsigned char *string_start=(unsigned char*)(&input[0]);
    unsigned char *cur = string_start;
    std::string output;
    lm.files.back().preprocessor = true;
    lm.get_newlines(input, lm.files.back().in_newlines0);
    lm.files.back().out_start0.push_back(0);
    lm.files.back().in_start0.push_back(0);
    std::vector<IfDef> ifdef_stack;
    bool branch_enabled = true;
    macro_definitions["__FILE__"].expansion = "\"" + lm.files.back().in_filename + "\"";
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        unsigned char *t1, *t2, *t3, *t4;
        
#line 238 "parser/preprocessor.cpp"
unsigned char *yyt1;
unsigned char *yyt2;
unsigned char *yyt3;
unsigned char *yyt4;
#line 234 "parser/preprocessor.re"

        
#line 246 "parser/preprocessor.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0, 176, 176, 176, 176, 176, 176, 176, 
		176, 240, 160, 240, 176, 240, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		240, 176, 144, 176, 176, 176, 176,  48, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 176, 176, 176, 176, 176, 176, 
		176, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 176, 176, 176, 176, 184, 
		176, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
	};
	yych = *cur;
	if (yych <= '.') {
		if (yych <= '"') {
			if (yych <= 0x00) goto yy1;
			if (yych <= ' ') goto yy2;
			if (yych <= '!') goto yy4;
			goto yy5;
		} else {
			if (yych <= '#') goto yy6;
			if (yych == '\'') goto yy7;
			goto yy2;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy8;
			if (yych <= '@') goto yy2;
			if (yych <= 'Z') goto yy9;
			goto yy2;
		} else {
			if (yych == '`') goto yy2;
			if (yych <= 'z') goto yy9;
			goto yy2;
		}
	}
yy1:
	++cur;
#line 260 "parser/preprocessor.re"
	{
                break;
            }
#line 314 "parser/preprocessor.cpp"
yy2:
	++cur;
yy3:
#line 255 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                output.append(token(tok, cur));
                continue;
            }
#line 324 "parser/preprocessor.cpp"
yy4:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy11;
yy5:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy15;
yy6:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy18;
			goto yy3;
		} else {
			if (yych == '\f') goto yy3;
			if (yych <= '\r') goto yy18;
			goto yy3;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= ' ') goto yy18;
			if (yych <= 'c') goto yy3;
			if (yych <= 'e') goto yy18;
			goto yy3;
		} else {
			if (yych <= 'i') goto yy18;
			if (yych == 'u') goto yy18;
			goto yy3;
		}
	}
yy7:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy24;
yy8:
	yych = *++cur;
	if (yych == '*') goto yy26;
	goto yy3;
yy9:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy9;
	}
#line 479 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string t = token(tok, cur);
                if (macro_definitions.find(t) != macro_definitions.end()) {
                    // Prepare the start of the interval
                    interval_end_type_0(lm, output.size(), tok-string_start);

                    // Expand the macro once
                    std::string expansion;
                    if (macro_definitions[t].function_like) {
                        if (*cur != '(') {
                            throw LCompilersException("C preprocessor: function-like macro invocation must have argument list");
                        }
                        std::vector<std::string> args;
                        args = parse_arguments(cur, false);
                        if (*cur != ')') {
                            throw LCompilersException("C preprocessor: expected )");
                        }
                        cur++;
                        expansion = function_like_macro_expansion(
                            macro_definitions[t].args,
                            macro_definitions[t].expansion,
                            args);
                    } else {
                        if (t == "__LINE__") {
                            uint32_t line;
                            if (lm.files.back().current_line == 0) {
                                uint32_t pos = cur-string_start;
                                uint32_t col;
                                std::string filename;
                                lm.pos_to_linecol(pos, line, col, filename);
                            } else {
                                line = lm.files.back().current_line;
                            }
                            expansion = std::to_string(line);
                        } else {
                            expansion = macro_definitions[t].expansion;
                        }
                    }

                    // Recursively expand the expansion
                    std::string expansion2;
                    int i = 0;
                    while (expansion2 != expansion) {
                        expansion2 = expansion;
                        LocationManager lm_tmp = lm; // Make a copy

                        uint32_t pos = cur-string_start;
                        uint32_t line, col;
                        std::string filename;
                        lm.pos_to_linecol(pos, line, col, filename);
                        lm_tmp.files.back().current_line = line;

                        expansion = run(expansion2, lm_tmp, macro_definitions);
                        i++;
                        if (i == 40) {
                            throw LCompilersException("C preprocessor: maximum recursion limit reached");
                        }
                    }

                    // Output the final recursively expanded macro
                    output.append(expansion);

                    // Prepare the end of the interval
                    interval_end(lm, output.size(), cur-string_start,
                        t.size(), 1);
                } else {
                    output.append(t);
                }
                continue;
            }
#line 445 "parser/preprocessor.cpp"
yy10:
	yych = *++cur;
yy11:
	if (yybm[0+yych] & 16) {
		goto yy10;
	}
	if (yych >= 0x01) goto yy13;
yy12:
	cur = mar;
	if (yyaccept <= 1) {
		if (yyaccept == 0) {
			goto yy3;
		} else {
			goto yy16;
		}
	} else {
		goto yy25;
	}
yy13:
	++cur;
#line 263 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                output.append(token(tok, cur));
                continue;
            }
#line 472 "parser/preprocessor.cpp"
yy14:
	yych = *++cur;
yy15:
	if (yybm[0+yych] & 32) {
		goto yy14;
	}
	if (yych <= 0x00) goto yy12;
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy14;
yy16:
#line 550 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                output.append(token(tok, cur));
                continue;
            }
#line 490 "parser/preprocessor.cpp"
yy17:
	yych = *++cur;
yy18:
	if (yybm[0+yych] & 64) {
		goto yy17;
	}
	if (yych <= 'h') {
		if (yych <= 'c') goto yy12;
		if (yych <= 'd') goto yy19;
		if (yych <= 'e') goto yy20;
		goto yy12;
	} else {
		if (yych <= 'i') goto yy21;
		if (yych == 'u') goto yy22;
		goto yy12;
	}
yy19:
	yych = *++cur;
	if (yych == 'e') goto yy27;
	goto yy12;
yy20:
	yych = *++cur;
	if (yych == 'l') goto yy28;
	if (yych == 'n') goto yy29;
	goto yy12;
yy21:
	yych = *++cur;
	if (yych == 'f') goto yy30;
	if (yych == 'n') goto yy31;
	goto yy12;
yy22:
	yych = *++cur;
	if (yych == 'n') goto yy32;
	goto yy12;
yy23:
	yych = *++cur;
yy24:
	if (yybm[0+yych] & 128) {
		goto yy23;
	}
	if (yych <= 0x00) goto yy12;
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy23;
yy25:
#line 555 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                output.append(token(tok, cur));
                continue;
            }
#line 542 "parser/preprocessor.cpp"
yy26:
	++cur;
#line 560 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                cur++;
                while (!(*cur == '/' && *(cur - 1) == '*')) {
                    cur++;
                }
                cur++;
                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 556 "parser/preprocessor.cpp"
yy27:
	yych = *++cur;
	if (yych == 'f') goto yy33;
	goto yy12;
yy28:
	yych = *++cur;
	if (yych == 'i') goto yy34;
	if (yych == 's') goto yy35;
	goto yy12;
yy29:
	yych = *++cur;
	if (yych == 'd') goto yy36;
	goto yy12;
yy30:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy37;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			goto yy37;
		}
	} else {
		if (yych <= 'c') {
			if (yych == ' ') goto yy37;
			goto yy12;
		} else {
			if (yych <= 'd') goto yy38;
			if (yych == 'n') goto yy39;
			goto yy12;
		}
	}
yy31:
	yych = *++cur;
	if (yych == 'c') goto yy40;
	goto yy12;
yy32:
	yych = *++cur;
	if (yych == 'd') goto yy41;
	goto yy12;
yy33:
	yych = *++cur;
	if (yych == 'i') goto yy42;
	goto yy12;
yy34:
	yych = *++cur;
	if (yych == 'f') goto yy43;
	goto yy12;
yy35:
	yych = *++cur;
	if (yych == 'e') goto yy44;
	goto yy12;
yy36:
	yych = *++cur;
	if (yych == 'i') goto yy45;
	goto yy12;
yy37:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy12;
			yyt1 = cur;
			goto yy46;
		} else {
			if (yych == '\n') {
				yyt1 = cur;
				goto yy47;
			}
			goto yy37;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') {
				yyt1 = cur;
				goto yy46;
			}
			goto yy37;
		} else {
			if (yych == ' ') goto yy37;
			yyt1 = cur;
			goto yy46;
		}
	}
yy38:
	yych = *++cur;
	if (yych == 'e') goto yy48;
	goto yy12;
yy39:
	yych = *++cur;
	if (yych == 'd') goto yy49;
	goto yy12;
yy40:
	yych = *++cur;
	if (yych == 'l') goto yy50;
	goto yy12;
yy41:
	yych = *++cur;
	if (yych == 'e') goto yy51;
	goto yy12;
yy42:
	yych = *++cur;
	if (yych == 'n') goto yy52;
	goto yy12;
yy43:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy53;
		if (yych <= '\n') goto yy12;
		goto yy53;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy53;
		} else {
			if (yych == ' ') goto yy53;
			goto yy12;
		}
	}
yy44:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy12;
			goto yy44;
		} else {
			if (yych <= '\n') goto yy54;
			if (yych <= '\v') goto yy44;
			goto yy12;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy44;
			if (yych <= 0x1F) goto yy12;
			goto yy44;
		} else {
			if (yych == '/') goto yy55;
			goto yy12;
		}
	}
yy45:
	yych = *++cur;
	if (yych == 'f') goto yy56;
	goto yy12;
yy46:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych != '\n') goto yy46;
yy47:
	++cur;
	t1 = yyt1;
	t2 = cur - 1;
#line 351 "parser/preprocessor.re"
	{
                IfDef ifdef;
                ifdef.active = branch_enabled;
                if (ifdef.active) {
                    bool test_true = parse_bexpr(t1, macro_definitions) > 0;
                    cur = t1;
                    if (test_true) {
                        ifdef.branch_enabled = true;
                        ifdef.enabled_branch_executed = true;
                    } else {
                        ifdef.branch_enabled = false;
                    }
                    branch_enabled = ifdef.branch_enabled;
                } else {
                    ifdef.branch_enabled = false;
                }
                ifdef_stack.push_back(ifdef);
                if (!ifdef.active) continue;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 732 "parser/preprocessor.cpp"
yy48:
	yych = *++cur;
	if (yych == 'f') goto yy57;
	goto yy12;
yy49:
	yych = *++cur;
	if (yych == 'e') goto yy58;
	goto yy12;
yy50:
	yych = *++cur;
	if (yych == 'u') goto yy59;
	goto yy12;
yy51:
	yych = *++cur;
	if (yych == 'f') goto yy60;
	goto yy12;
yy52:
	yych = *++cur;
	if (yych == 'e') goto yy61;
	goto yy12;
yy53:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy12;
			yyt1 = cur;
			goto yy62;
		} else {
			if (yych == '\n') {
				yyt1 = cur;
				goto yy63;
			}
			goto yy53;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') {
				yyt1 = cur;
				goto yy62;
			}
			goto yy53;
		} else {
			if (yych == ' ') goto yy53;
			yyt1 = cur;
			goto yy62;
		}
	}
yy54:
	++cur;
#line 373 "parser/preprocessor.re"
	{
                if (ifdef_stack.size() == 0) {
                    throw LCompilersException("C preprocessor: #else encountered outside of #ifdef or #ifndef");
                }
                IfDef ifdef = ifdef_stack[ifdef_stack.size()-1];
                if (ifdef.active) {
                    if (!ifdef.branch_enabled && !ifdef.enabled_branch_executed) {
                        ifdef.branch_enabled = true;
                        ifdef.enabled_branch_executed = true;
                    } else {
                        ifdef.branch_enabled = false;
                    }
                    ifdef_stack[ifdef_stack.size()-1] = ifdef;
                    branch_enabled = ifdef.branch_enabled;
                } else {
                    continue;
                }

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 804 "parser/preprocessor.cpp"
yy55:
	yych = *++cur;
	if (yych == '/') goto yy64;
	goto yy12;
yy56:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy12;
			goto yy56;
		} else {
			if (yych <= '\n') goto yy65;
			if (yych <= '\v') goto yy56;
			goto yy12;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy56;
			if (yych <= 0x1F) goto yy12;
			goto yy56;
		} else {
			if (yych == '/') goto yy66;
			goto yy12;
		}
	}
yy57:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '@') goto yy68;
		if (yych <= 'Z') goto yy12;
		goto yy68;
	} else {
		if (yych == '`') goto yy68;
		if (yych <= 'z') goto yy12;
		goto yy68;
	}
yy58:
	yych = *++cur;
	if (yych == 'f') goto yy69;
	goto yy12;
yy59:
	yych = *++cur;
	if (yych == 'd') goto yy70;
	goto yy12;
yy60:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '@') goto yy72;
		if (yych <= 'Z') goto yy12;
		goto yy72;
	} else {
		if (yych == '`') goto yy72;
		if (yych <= 'z') goto yy12;
		goto yy72;
	}
yy61:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '@') goto yy74;
		if (yych <= 'Z') goto yy12;
		goto yy74;
	} else {
		if (yych == '`') goto yy74;
		if (yych <= 'z') goto yy12;
		goto yy74;
	}
yy62:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych != '\n') goto yy62;
yy63:
	++cur;
	t1 = yyt1;
	t2 = cur - 1;
#line 394 "parser/preprocessor.re"
	{
                if (ifdef_stack.size() == 0) {
                    throw LCompilersException("C preprocessor: #elif encountered outside of #ifdef or #ifndef");
                }
                IfDef ifdef = ifdef_stack[ifdef_stack.size()-1];
                if (ifdef.active) {
                    if (!ifdef.branch_enabled && !ifdef.enabled_branch_executed) {
                        bool test_true = parse_bexpr(t1, macro_definitions) > 0;
                        cur = t1;
                        if (test_true) {
                            ifdef.branch_enabled = true;
                            ifdef.enabled_branch_executed = true;
                        } else {
                            ifdef.branch_enabled = false;
                        }
                    } else {
                        ifdef.branch_enabled = false;
                    }
                    branch_enabled = ifdef.branch_enabled;
                    ifdef_stack[ifdef_stack.size()-1] = ifdef;
                } else {
                    continue;
                }

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 907 "parser/preprocessor.cpp"
yy64:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '\n') goto yy54;
	goto yy64;
yy65:
	++cur;
#line 421 "parser/preprocessor.re"
	{
                if (ifdef_stack.size() == 0) {
                    throw LCompilersException("C preprocessor: #endif encountered outside of #ifdef or #ifndef");
                }
                IfDef ifdef = ifdef_stack[ifdef_stack.size()-1];
                ifdef_stack.pop_back();
                if (ifdef.active) {
                    branch_enabled = true;
                } else {
                    continue;
                }

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 931 "parser/preprocessor.cpp"
yy66:
	yych = *++cur;
	if (yych == '/') goto yy75;
	goto yy12;
yy67:
	yych = *++cur;
yy68:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy67;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy67;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy67;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') {
				yyt1 = cur;
				goto yy76;
			}
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') {
				yyt1 = cur;
				goto yy76;
			}
			goto yy12;
		}
	}
yy69:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '@') goto yy78;
		if (yych <= 'Z') goto yy12;
		goto yy78;
	} else {
		if (yych == '`') goto yy78;
		if (yych <= 'z') goto yy12;
		goto yy78;
	}
yy70:
	yych = *++cur;
	if (yych == 'e') goto yy79;
	goto yy12;
yy71:
	yych = *++cur;
yy72:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy71;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy71;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy71;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') {
				yyt1 = cur;
				goto yy80;
			}
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') {
				yyt1 = cur;
				goto yy80;
			}
			goto yy12;
		}
	}
yy73:
	yych = *++cur;
yy74:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy73;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy73;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy73;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') {
				yyt1 = cur;
				goto yy81;
			}
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') {
				yyt1 = cur;
				goto yy81;
			}
			goto yy12;
		}
	}
yy75:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '\n') goto yy65;
	goto yy75;
yy76:
	yych = *++cur;
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych <= 0x08) goto yy12;
			if (yych == '\n') {
				yyt2 = cur;
				goto yy83;
			}
			yyt2 = cur;
			goto yy82;
		} else {
			if (yych == '\r') {
				yyt2 = cur;
				goto yy82;
			}
			if (yych <= 0x1F) goto yy12;
			yyt2 = cur;
			goto yy82;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy12;
			if (yych <= '9') goto yy76;
			if (yych <= '@') goto yy12;
			goto yy76;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy12;
				goto yy76;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy76;
				goto yy12;
			}
		}
	}
yy77:
	yych = *++cur;
yy78:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy77;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy77;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy77;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') {
				yyt1 = cur;
				goto yy84;
			}
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') {
				yyt1 = cur;
				goto yy84;
			}
			goto yy12;
		}
	}
yy79:
	yych = *++cur;
	if (yych == '"') goto yy12;
	goto yy86;
yy80:
	yych = *++cur;
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych <= 0x08) goto yy12;
			if (yych == '\n') {
				yyt2 = cur;
				goto yy88;
			}
			yyt2 = cur;
			goto yy87;
		} else {
			if (yych == '\r') {
				yyt2 = cur;
				goto yy87;
			}
			if (yych <= 0x1F) goto yy12;
			yyt2 = cur;
			goto yy87;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy12;
			if (yych <= '9') goto yy80;
			if (yych <= '@') goto yy12;
			goto yy80;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy12;
				goto yy80;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy80;
				goto yy12;
			}
		}
	}
yy81:
	yych = *++cur;
	if (yych <= '\'') {
		if (yych <= '\v') {
			if (yych <= 0x08) goto yy12;
			if (yych == '\n') {
				yyt3 = yyt4 = NULL;
				yyt2 = cur;
				goto yy90;
			}
			yyt2 = cur;
			goto yy89;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy12;
				yyt2 = cur;
				goto yy89;
			} else {
				if (yych == ' ') {
					yyt2 = cur;
					goto yy89;
				}
				goto yy12;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych <= '(') {
					yyt2 = cur;
					goto yy91;
				}
				goto yy12;
			} else {
				if (yych <= '9') goto yy81;
				if (yych <= '@') goto yy12;
				goto yy81;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy12;
				goto yy81;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy81;
				goto yy12;
			}
		}
	}
yy82:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) goto yy12;
		if (yych != '\n') goto yy82;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy82;
		} else {
			if (yych == ' ') goto yy82;
			goto yy12;
		}
	}
yy83:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
#line 309 "parser/preprocessor.re"
	{
                IfDef ifdef;
                ifdef.active = branch_enabled;
                if (ifdef.active) {
                    std::string macro_name = token(t1, t2);
                    if (macro_definitions.find(macro_name) != macro_definitions.end()) {
                        ifdef.branch_enabled = true;
                        ifdef.enabled_branch_executed = true;
                    } else {
                        ifdef.branch_enabled = false;
                    }
                    branch_enabled = ifdef.branch_enabled;
                } else {
                    ifdef.branch_enabled = false;
                }
                ifdef_stack.push_back(ifdef);
                if (!ifdef.active) continue;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1243 "parser/preprocessor.cpp"
yy84:
	yych = *++cur;
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych <= 0x08) goto yy12;
			if (yych == '\n') {
				yyt2 = cur;
				goto yy93;
			}
			yyt2 = cur;
			goto yy92;
		} else {
			if (yych == '\r') {
				yyt2 = cur;
				goto yy92;
			}
			if (yych <= 0x1F) goto yy12;
			yyt2 = cur;
			goto yy92;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy12;
			if (yych <= '9') goto yy84;
			if (yych <= '@') goto yy12;
			goto yy84;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy12;
				goto yy84;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy84;
				goto yy12;
			}
		}
	}
yy85:
	yych = *++cur;
yy86:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy85;
		case '"': goto yy94;
		default: goto yy12;
	}
yy87:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) goto yy12;
		if (yych != '\n') goto yy87;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy87;
		} else {
			if (yych == ' ') goto yy87;
			goto yy12;
		}
	}
yy88:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
#line 298 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string macro_name = token(t1, t2);
                auto search = macro_definitions.find(macro_name);
                if (search != macro_definitions.end()) {
                    macro_definitions.erase(search);
                }

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1322 "parser/preprocessor.cpp"
yy89:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy12;
			yyt4 = cur;
			goto yy95;
		} else {
			if (yych != '\n') goto yy89;
			yyt3 = yyt4 = NULL;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') {
				yyt4 = cur;
				goto yy95;
			}
			goto yy89;
		} else {
			if (yych == ' ') goto yy89;
			yyt4 = cur;
			goto yy95;
		}
	}
yy90:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
	t3 = yyt4;
	t4 = yyt3;
#line 268 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string macro_name = token(t1, t2), macro_subs;
                if (t3 != nullptr) {
                    LCOMPILERS_ASSERT(t4 != nullptr);
                    macro_subs = token(t3, t4);
                    handle_continuation_lines(macro_subs, cur);
                }
                CPPMacro fn;
                fn.expansion = macro_subs;
                macro_definitions[macro_name] = fn;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1369 "parser/preprocessor.cpp"
yy91:
	yych = *++cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy91;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy91;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy91;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') goto yy96;
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') goto yy96;
			goto yy12;
		}
	}
yy92:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) goto yy12;
		if (yych != '\n') goto yy92;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy92;
		} else {
			if (yych == ' ') goto yy92;
			goto yy12;
		}
	}
yy93:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
#line 330 "parser/preprocessor.re"
	{
                IfDef ifdef;
                ifdef.active = branch_enabled;
                if (ifdef.active) {
                    std::string macro_name = token(t1, t2);
                    if (macro_definitions.find(macro_name) != macro_definitions.end()) {
                        ifdef.branch_enabled = false;
                    } else {
                        ifdef.branch_enabled = true;
                        ifdef.enabled_branch_executed = true;
                    }
                    branch_enabled = ifdef.branch_enabled;
                } else {
                    ifdef.branch_enabled = false;
                }
                ifdef_stack.push_back(ifdef);
                if (!ifdef.active) continue;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1433 "parser/preprocessor.cpp"
yy94:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '"') {
		yyt1 = yyt2 = cur;
		goto yy98;
	}
	yyt1 = cur;
	goto yy97;
yy95:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '\n') {
		yyt3 = cur;
		goto yy90;
	}
	goto yy95;
yy96:
	yych = *++cur;
	if (yych <= ')') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy12;
				goto yy99;
			} else {
				if (yych == '\v') goto yy99;
				goto yy12;
			}
		} else {
			if (yych <= 0x1F) {
				if (yych <= '\r') goto yy99;
				goto yy12;
			} else {
				if (yych <= ' ') goto yy99;
				if (yych <= '(') goto yy12;
				goto yy100;
			}
		}
	} else {
		if (yych <= '@') {
			if (yych <= ',') {
				if (yych <= '+') goto yy12;
				goto yy91;
			} else {
				if (yych <= '/') goto yy12;
				if (yych <= '9') goto yy96;
				goto yy12;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy96;
				if (yych <= '^') goto yy12;
				goto yy96;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy96;
				goto yy12;
			}
		}
	}
yy97:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych != '"') goto yy97;
	yyt2 = cur;
yy98:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '\n') goto yy101;
	goto yy98;
yy99:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy99;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			goto yy99;
		}
	} else {
		if (yych <= '(') {
			if (yych == ' ') goto yy99;
			goto yy12;
		} else {
			if (yych <= ')') goto yy100;
			if (yych == ',') goto yy91;
			goto yy12;
		}
	}
yy100:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy102;
		if (yych <= '\n') goto yy12;
		goto yy102;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy102;
		} else {
			if (yych == ' ') goto yy102;
			goto yy12;
		}
	}
yy101:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
#line 436 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string filename = token(t1, t2);
                std::vector<std::filesystem::path> include_dirs;
                include_dirs.push_back(parent_path(lm.files.back().in_filename));
                include_dirs.insert(include_dirs.end(),
                                    compiler_options.po.include_dirs.begin(),
                                    compiler_options.po.include_dirs.end());
                bool file_found = false;
                std::string include = "";
                if (is_relative_path(filename)) {
                    for (auto &path:include_dirs) {
                        std::string filepath = join_paths({path.generic_string(), filename});
                        file_found = read_file(filepath, include);
                        if (file_found) {
                            filename = filepath;
                            break;
                        }
                    }
                } else {
                    file_found = read_file(filename, include);
                }

                if (!file_found) {
                    throw LCompilersException("C preprocessor: Include file '" + filename
                        + "' not found. If an include path "
                        "is available, please use the `-I` option to specify it.");
                }

                LocationManager lm_tmp = lm; // Make a copy
                include = run(include, lm_tmp, macro_definitions);

                // Prepare the start of the interval
                interval_end_type_0(lm, output.size(), tok-string_start);

                // Include
                output.append(include);

                // Prepare the end of the interval
                interval_end(lm, output.size(), cur-string_start,
                    token(tok, cur).size()-1, 1);
                continue;
            }
#line 1587 "parser/preprocessor.cpp"
yy102:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy12;
			yyt3 = cur;
		} else {
			if (yych == '\n') {
				yyt3 = cur;
				goto yy104;
			}
			goto yy102;
		}
	} else {
		if (yych <= '\r') {
			if (yych >= '\r') goto yy102;
			yyt3 = cur;
		} else {
			if (yych == ' ') goto yy102;
			yyt3 = cur;
		}
	}
yy103:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych != '\n') goto yy103;
yy104:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
	t3 = yyt3;
	t4 = cur - 1;
#line 283 "parser/preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string macro_name = token(t1, t2),
                        macro_subs = token(t3, t4);
                handle_continuation_lines(macro_subs, cur);
                std::vector<std::string> args = parse_arguments(t2, true);
                CPPMacro fn;
                fn.function_like = true;
                fn.args = args;
                fn.expansion = macro_subs;
                macro_definitions[macro_name] = fn;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1636 "parser/preprocessor.cpp"
}
#line 570 "parser/preprocessor.re"

    }
    lm.files.back().out_start0.push_back(output.size());
    lm.files.back().in_start0.push_back(input.size());
    // The just created interval ID:
    size_t N = lm.files.back().out_start0.size()-2;
    lm.files.back().in_size0.push_back(
        lm.files.back().out_start0[N+1] - lm.files.back().out_start0[N]);
    lm.files.back().interval_type0.push_back(0);

    // Uncomment for debugging
    /*
    std::cout << "in_start0: ";
    for (auto A : lm.files.back().in_start0) { std::cout << A << " "; }
    std::cout << std::endl;
    std::cout << "in_size0: ";
    for (auto A : lm.files.back().in_size0) { std::cout << A << " "; }
    std::cout << std::endl;
    std::cout << "interval_type0: ";
    for (auto A : lm.files.back().interval_type0) { std::cout << A << " "; }
    std::cout << std::endl;
    std::cout << "out_start0: ";
    for (auto A : lm.files.back().out_start0) { std::cout << A << " "; }
    std::cout << std::endl;
    */

    return output;
}

namespace {

std::string token(unsigned char *tok, unsigned char* cur)
{
    return std::string((char *)tok, cur - tok);
}

}

std::string function_like_macro_expansion(
            std::vector<std::string> &def_args,
            std::string &expansion,
            std::vector<std::string> &call_args) {
    LCOMPILERS_ASSERT(expansion[expansion.size()] == '\0');
    unsigned char *string_start=(unsigned char*)(&expansion[0]);
    unsigned char *cur = string_start;
    std::string output;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 1689 "parser/preprocessor.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 128, 192, 192, 192, 192,  64, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 192, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 224, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};
	yych = *cur;
	if (yych <= '@') {
		if (yych <= '"') {
			if (yych <= 0x00) goto yy106;
			if (yych <= '!') goto yy107;
			goto yy109;
		} else {
			if (yych == '\'') goto yy110;
			goto yy107;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy111;
			if (yych <= '^') goto yy107;
			goto yy111;
		} else {
			if (yych <= '`') goto yy107;
			if (yych <= 'z') goto yy111;
			goto yy107;
		}
	}
yy106:
	++cur;
#line 629 "parser/preprocessor.re"
	{
                break;
            }
#line 1754 "parser/preprocessor.cpp"
yy107:
	++cur;
yy108:
#line 625 "parser/preprocessor.re"
	{
                output.append(token(tok, cur));
                continue;
            }
#line 1763 "parser/preprocessor.cpp"
yy109:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy108;
	goto yy113;
yy110:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy108;
	goto yy118;
yy111:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy111;
	}
#line 632 "parser/preprocessor.re"
	{
                std::string t = token(tok, cur);
                auto search = std::find(def_args.begin(), def_args.end(), t);
                if (search != def_args.end()) {
                    size_t i = std::distance(def_args.begin(), search);
                    output.append(call_args[i]);
                } else {
                    output.append(t);
                }
                continue;
            }
#line 1791 "parser/preprocessor.cpp"
yy112:
	yych = *++cur;
yy113:
	if (yybm[0+yych] & 64) {
		goto yy112;
	}
	if (yych >= 0x01) goto yy115;
yy114:
	cur = mar;
	if (yyaccept <= 1) {
		if (yyaccept == 0) {
			goto yy108;
		} else {
			goto yy116;
		}
	} else {
		goto yy119;
	}
yy115:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy112;
yy116:
#line 643 "parser/preprocessor.re"
	{
                output.append(token(tok, cur));
                continue;
            }
#line 1820 "parser/preprocessor.cpp"
yy117:
	yych = *++cur;
yy118:
	if (yybm[0+yych] & 128) {
		goto yy117;
	}
	if (yych <= 0x00) goto yy114;
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy117;
yy119:
#line 647 "parser/preprocessor.re"
	{
                output.append(token(tok, cur));
                continue;
            }
#line 1837 "parser/preprocessor.cpp"
}
#line 651 "parser/preprocessor.re"

    }
    return output;
}

enum CPPTokenType {
    TK_EOF, TK_NAME, TK_INTEGER, TK_STRING, TK_AND, TK_OR, TK_NEG,
    TK_LPAREN, TK_RPAREN, TK_LT, TK_GT, TK_LTE, TK_GTE, TK_NE, TK_EQ,
    TK_PLUS, TK_MINUS, TK_MUL, TK_DIV, TK_PERCENT, TK_LSHIFT, TK_RSHIFT,
    TK_BITAND, TK_BITOR
};


void get_next_token(unsigned char *&cur, CPPTokenType &type, std::string &str) {
    std::string output;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 1859 "parser/preprocessor.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   4,   0,   4,   0,   4,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  4,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		248, 248, 216, 216, 216, 216, 216, 216, 
		152, 152,   0,   0,   0,   0,   0,   0, 
		  0, 144, 144, 144, 144, 144, 144,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,   0,   0,   0,   0,  16, 
		  0, 144, 144, 144, 144, 144, 144,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	yych = *cur;
	if (yybm[0+yych] & 4) {
		goto yy124;
	}
	if (yych <= '/') {
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= 0x00) goto yy121;
				if (yych <= 0x08) goto yy122;
				if (yych <= '\n') goto yy125;
				goto yy122;
			} else {
				if (yych <= '!') goto yy126;
				if (yych <= '$') goto yy122;
				if (yych <= '%') goto yy127;
				goto yy128;
			}
		} else {
			if (yych <= '*') {
				if (yych <= '\'') goto yy122;
				if (yych <= '(') goto yy129;
				if (yych <= ')') goto yy130;
				goto yy131;
			} else {
				if (yych <= ',') {
					if (yych <= '+') goto yy132;
					goto yy122;
				} else {
					if (yych <= '-') goto yy133;
					if (yych <= '.') goto yy122;
					goto yy134;
				}
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '<') {
				if (yych <= '0') goto yy135;
				if (yych <= '9') goto yy137;
				if (yych <= ';') goto yy122;
				goto yy139;
			} else {
				if (yych <= '=') goto yy141;
				if (yych <= '>') goto yy142;
				if (yych <= '@') goto yy122;
				goto yy144;
			}
		} else {
			if (yych <= '_') {
				if (yych == '\\') goto yy145;
				if (yych <= '^') goto yy122;
				goto yy144;
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy122;
					goto yy144;
				} else {
					if (yych == '|') goto yy146;
					goto yy122;
				}
			}
		}
	}
yy121:
	++cur;
#line 679 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_EOF; return; }
#line 1964 "parser/preprocessor.cpp"
yy122:
	++cur;
yy123:
#line 675 "parser/preprocessor.re"
	{
                std::string t = token(tok, cur);
                throw LCompilersException("Unknown token: " + t);
            }
#line 1973 "parser/preprocessor.cpp"
yy124:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy124;
	}
#line 681 "parser/preprocessor.re"
	{ continue; }
#line 1981 "parser/preprocessor.cpp"
yy125:
	++cur;
#line 680 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_EOF; return; }
#line 1986 "parser/preprocessor.cpp"
yy126:
	yych = *++cur;
	if (yych == '=') goto yy147;
#line 694 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_NEG; return; }
#line 1992 "parser/preprocessor.cpp"
yy127:
	++cur;
#line 687 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_PERCENT; return; }
#line 1997 "parser/preprocessor.cpp"
yy128:
	yych = *++cur;
	if (yych == '&') goto yy148;
#line 690 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_BITAND; return; }
#line 2003 "parser/preprocessor.cpp"
yy129:
	++cur;
#line 695 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_LPAREN; return; }
#line 2008 "parser/preprocessor.cpp"
yy130:
	++cur;
#line 696 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_RPAREN; return; }
#line 2013 "parser/preprocessor.cpp"
yy131:
	++cur;
#line 685 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_MUL; return; }
#line 2018 "parser/preprocessor.cpp"
yy132:
	++cur;
#line 683 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_PLUS; return; }
#line 2023 "parser/preprocessor.cpp"
yy133:
	++cur;
#line 684 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_MINUS; return; }
#line 2028 "parser/preprocessor.cpp"
yy134:
	yych = *++cur;
	if (yych == '=') goto yy149;
#line 686 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_DIV; return; }
#line 2034 "parser/preprocessor.cpp"
yy135:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 'X') {
		if (yych <= 'N') {
			if (yych == 'B') goto yy150;
			goto yy138;
		} else {
			if (yych <= 'O') goto yy152;
			if (yych <= 'W') goto yy138;
			goto yy153;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'b') goto yy150;
			goto yy138;
		} else {
			if (yych <= 'o') goto yy152;
			if (yych == 'x') goto yy153;
			goto yy138;
		}
	}
yy136:
#line 704 "parser/preprocessor.re"
	{
                str = token(tok, cur);
                type = CPPTokenType::TK_INTEGER;
                if (str.size() > 2 && isalpha(str[1])) {
                    char ch = str[1];
                    str = str.substr(2);
                    if (ch == 'x' || ch == 'X') {
                        int64_t hex_int = std::stoll(str, nullptr, 16);
                        str = std::to_string(hex_int);
                    } else if (ch == 'o' || ch == 'O') {
                        int64_t oct_int = std::stoll(str, nullptr, 8);
                        str = std::to_string(oct_int);
                    } else {
                        int64_t bin_int = std::stoll(str, nullptr, 2);
                        str = std::to_string(bin_int);
                    }
                }
                return;
            }
#line 2078 "parser/preprocessor.cpp"
yy137:
	yych = *++cur;
yy138:
	if (yybm[0+yych] & 8) {
		goto yy137;
	}
	goto yy136;
yy139:
	yych = *++cur;
	if (yych <= ';') goto yy140;
	if (yych <= '<') goto yy154;
	if (yych <= '=') goto yy155;
yy140:
#line 697 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_LT; return; }
#line 2094 "parser/preprocessor.cpp"
yy141:
	yych = *++cur;
	if (yych == '=') goto yy156;
	goto yy123;
yy142:
	yych = *++cur;
	if (yych <= '<') goto yy143;
	if (yych <= '=') goto yy157;
	if (yych <= '>') goto yy158;
yy143:
#line 698 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_GT; return; }
#line 2107 "parser/preprocessor.cpp"
yy144:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy144;
	}
#line 723 "parser/preprocessor.re"
	{
                str = token(tok, cur);
                type = CPPTokenType::TK_NAME;
                return;
            }
#line 2119 "parser/preprocessor.cpp"
yy145:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy123;
		if (yych <= '\v') goto yy160;
		goto yy123;
	} else {
		if (yych <= '\r') goto yy160;
		if (yych == ' ') goto yy160;
		goto yy123;
	}
yy146:
	yych = *++cur;
	if (yych == '|') goto yy161;
#line 691 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_BITOR; return; }
#line 2137 "parser/preprocessor.cpp"
yy147:
	++cur;
#line 702 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_NE; return; }
#line 2142 "parser/preprocessor.cpp"
yy148:
	++cur;
#line 692 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_AND; return; }
#line 2147 "parser/preprocessor.cpp"
yy149:
	++cur;
#line 701 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_NE; return; }
#line 2152 "parser/preprocessor.cpp"
yy150:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy162;
	}
	if (yych == '_') goto yy163;
yy151:
	cur = mar;
	if (yyaccept == 0) {
		goto yy136;
	} else {
		goto yy123;
	}
yy152:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy164;
	}
	if (yych == '_') goto yy165;
	goto yy151;
yy153:
	yych = *++cur;
	if (yybm[0+yych] & 128) {
		goto yy166;
	}
	if (yych == '_') goto yy167;
	goto yy151;
yy154:
	++cur;
#line 688 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_LSHIFT; return; }
#line 2184 "parser/preprocessor.cpp"
yy155:
	++cur;
#line 699 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_LTE; return; }
#line 2189 "parser/preprocessor.cpp"
yy156:
	++cur;
#line 703 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_EQ; return; }
#line 2194 "parser/preprocessor.cpp"
yy157:
	++cur;
#line 700 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_GTE; return; }
#line 2199 "parser/preprocessor.cpp"
yy158:
	++cur;
#line 689 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_RSHIFT; return; }
#line 2204 "parser/preprocessor.cpp"
yy159:
	yych = *++cur;
yy160:
	if (yych <= '\v') {
		if (yych <= 0x08) goto yy151;
		if (yych != '\n') goto yy159;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy151;
			goto yy159;
		} else {
			if (yych == ' ') goto yy159;
			goto yy151;
		}
	}
	++cur;
#line 682 "parser/preprocessor.re"
	{ continue; }
#line 2223 "parser/preprocessor.cpp"
yy161:
	++cur;
#line 693 "parser/preprocessor.re"
	{ type = CPPTokenType::TK_OR; return; }
#line 2228 "parser/preprocessor.cpp"
yy162:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) {
		goto yy162;
	}
	if (yych != '_') goto yy136;
yy163:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy162;
	}
	goto yy151;
yy164:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 64) {
		goto yy164;
	}
	if (yych != '_') goto yy136;
yy165:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy164;
	}
	goto yy151;
yy166:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 128) {
		goto yy166;
	}
	if (yych != '_') goto yy136;
yy167:
	yych = *++cur;
	if (yybm[0+yych] & 128) {
		goto yy166;
	}
	goto yy151;
}
#line 728 "parser/preprocessor.re"

    }
}

namespace {

void accept(unsigned char *&cur, CPPTokenType type_expected) {
    CPPTokenType type;
    std::string str;
    get_next_token(cur, type, str);
    if (type != type_expected) {
        throw LCompilersException("Unexpected token type "
            + std::to_string((int)type)
            + ", expected type "
            + std::to_string((int)type_expected) );
    }
}

std::string accept_name(unsigned char *&cur) {
    CPPTokenType type;
    std::string str;
    get_next_token(cur, type, str);
    if (type != CPPTokenType::TK_NAME) {
        throw LCompilersException("Unexpected token type "
            + std::to_string((int)type)
            + ", expected TK_NAME");
    }
    return str;
}

int parse_term(unsigned char *&cur, const cpp_symtab &macro_definitions);
int parse_factor(unsigned char *&cur, const cpp_symtab &macro_definitions);
int parse_bfactor(unsigned char *&cur, const cpp_symtab &macro_definitions);

/*
b-expr
    = b-factor (("&&"|"||") b-factor)*
*/
int parse_bexpr(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    int tmp = parse_bfactor(cur, macro_definitions);

    CPPTokenType type;
    std::string str;
    unsigned char *old_cur = cur;
    get_next_token(cur, type, str);
    while (type == CPPTokenType::TK_AND || type == CPPTokenType::TK_OR) {
        bool factor = parse_bfactor(cur, macro_definitions) > 0;
        if (type == CPPTokenType::TK_AND) {
            tmp = (int)( (tmp > 0) && (factor > 0) );
        } else {
            tmp = (int)( (tmp > 0) || (factor > 0) );
        }
        old_cur = cur;
        get_next_token(cur, type, str);
    }
    cur = old_cur; // Revert the last token, as we will not consume it
    return tmp;
}

/*
expr
    = term ((+,-) term)*
*/
int parse_expr(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    int tmp;
    tmp = parse_term(cur, macro_definitions);

    CPPTokenType type;
    std::string str;
    unsigned char *old_cur = cur;
    get_next_token(cur, type, str);
    while (type == CPPTokenType::TK_PLUS || type == CPPTokenType::TK_MINUS) {
        int term = parse_term(cur, macro_definitions);
        if (type == CPPTokenType::TK_PLUS) {
            tmp = tmp + term;
        } else {
            tmp = tmp - term;
        }
        old_cur = cur;
        get_next_token(cur, type, str);
    }
    cur = old_cur; // Revert the last token, as we will not consume it
    return tmp;
}

/*
term
    = factor ((*,/,%,<<,>>,&,|) factor)*
*/
int parse_term(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    int tmp;
    tmp = parse_factor(cur, macro_definitions);

    CPPTokenType type;
    std::string str;
    unsigned char *old_cur = cur;
    get_next_token(cur, type, str);
    while (type == CPPTokenType::TK_MUL ||
           type == CPPTokenType::TK_DIV ||
           type == CPPTokenType::TK_PERCENT ||
           type == CPPTokenType::TK_LSHIFT ||
           type == CPPTokenType::TK_RSHIFT ||
           type == CPPTokenType::TK_BITAND ||
           type == CPPTokenType::TK_BITOR) {
        int term = parse_factor(cur, macro_definitions);
        if (type == CPPTokenType::TK_MUL) {
            tmp = tmp * term;
        } else if (type == CPPTokenType::TK_DIV) {
            tmp = tmp / term;
        } else if (type == CPPTokenType::TK_PERCENT) {
            tmp = tmp % term;
        } else if (type == CPPTokenType::TK_LSHIFT) {
            tmp = tmp << term;
        } else if (type == CPPTokenType::TK_RSHIFT) {
            tmp = tmp >> term;
        } else if (type == CPPTokenType::TK_BITAND) {
            tmp = tmp & term;
        } else if (type == CPPTokenType::TK_BITOR) {
            tmp = tmp | term;
        } else {
            throw LCompilersException("Unknown operator type");
        }
        old_cur = cur;
        get_next_token(cur, type, str);
    }
    cur = old_cur; // Revert the last token, as we will not consume it
    return tmp;
}

/*
factor
    = TK_INTEGER
    | TK_NAME
    | (-,+) factor
    | "(" b-expr ")"
*/
int parse_factor(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    CPPTokenType type;
    std::string str;
    get_next_token(cur, type, str);
    if (type == CPPTokenType::TK_NAME) {
        if (macro_definitions.find(str) != macro_definitions.end()) {
            std::string v;
            if (macro_definitions.at(str).function_like) {
                if (*cur != '(') {
                    throw LCompilersException("C preprocessor: function-like macro invocation must have argument list");
                }
                std::vector<std::string> args;
                args = parse_arguments(cur, false);
                if (*cur != ')') {
                    throw LCompilersException("C preprocessor: expected )");
                }
                cur++;
                std::vector<std::string> margs = macro_definitions.at(str).args;
                std::string mexpansion = macro_definitions.at(str).expansion;
                v = function_like_macro_expansion(
                    margs,
                    mexpansion,
                    args);
            } else {
                v = macro_definitions.at(str).expansion;
            }
            unsigned char *cur2 = (unsigned char*)(&v[0]);
            int i = parse_expr(cur2, macro_definitions);
            return i;
        } else {
            // If the variable/macro is not defined, we evaluate it as 0
            return 0;
        }
    } else if (type == CPPTokenType::TK_INTEGER) {
        int i = std::stoi(str);
        return i;
    } else if (type == CPPTokenType::TK_MINUS) {
        int result = parse_factor(cur, macro_definitions);
        return -result;
    } else if (type == CPPTokenType::TK_PLUS) {
        int result = parse_factor(cur, macro_definitions);
        return +result;
    } else if (type == CPPTokenType::TK_LPAREN) {
        int result = parse_bexpr(cur, macro_definitions);
        accept(cur, CPPTokenType::TK_RPAREN);
        return result;

    // This is the only place where we can get unexpected tokens. Let us
    // handle them here:
    } else if (type == CPPTokenType::TK_EOF) {
        // EOF means the expression
        throw LCompilersException("factor(): The expression is not complete, expecting integer, name, +, - or (");
    } else {
        throw LCompilersException("Unexpected token type " + std::to_string((int)type) + " in factor()");
    }
}

/*
relation
    = expr
    | expr (<,>,>=,<=,/=,!=,==) expr
*/
int parse_relation(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    int lhs;
    lhs = parse_expr(cur, macro_definitions);
    unsigned char *old_cur = cur;

    CPPTokenType type;
    std::string str;
    get_next_token(cur, type, str);
    if (type >= CPPTokenType::TK_LT && type <= CPPTokenType::TK_EQ) {
        int rhs = parse_expr(cur, macro_definitions);
        if (type == CPPTokenType::TK_LT) {
            return lhs < rhs;
        } else if (type == CPPTokenType::TK_GT) {
            return lhs > rhs;
        } else if (type == CPPTokenType::TK_LTE) {
            return lhs <= rhs;
        } else if (type == CPPTokenType::TK_GTE) {
            return lhs >= rhs;
        } else if (type == CPPTokenType::TK_NE) {
            return lhs != rhs;
        } else if (type == CPPTokenType::TK_EQ) {
            return lhs == rhs;
        } else {
            throw LCompilersException("Inconsistent ifs");
        }
    } else {
        cur = old_cur; // Revert the last token, as we will not consume it
        return lhs;
    }
}

/*
b-factor
    = "defined(" TK_NAME ")"
    | "!" b-factor
    | relation
*/
int parse_bfactor(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    CPPTokenType type;
    std::string str;
    unsigned char *old_cur = cur;
    get_next_token(cur, type, str);
    if (type == CPPTokenType::TK_NAME && str == "defined") {
        accept(cur, CPPTokenType::TK_LPAREN);
        std::string macro_name = accept_name(cur);
        accept(cur, CPPTokenType::TK_RPAREN);
        if (macro_definitions.find(macro_name) != macro_definitions.end()) {
            return true;
        } else {
            return false;
        }
    } else if (type == CPPTokenType::TK_NEG) {
        bool bresult = parse_bfactor(cur, macro_definitions) > 0;
        bresult = !bresult; // Apply "!"
        return (int) bresult;
    } else {
        // For everything else we commit to relation and handle any potential errors there:
        cur = old_cur; // Restore the token
        int result = parse_relation(cur, macro_definitions);
        return result;
    }
}

}

} // namespace LCompilers::LFortran
