<h2><?php echo tr('Final configuration steps'); ?></h2>
<p>This is the last step of the installation process.</p>
<h4><?php echo tr('Database setup'); ?></h4>
<?php if ($error === 0): ?>
<p><?php echo tr('Status'); ?>: <span class="green"><?php echo tr('Successful'); ?></span></p>
<?php else: ?>
<p><?php echo tr('Status'); ?>: <span class="red"><?php echo tr('Failed'); ?></span></p>
<p>Consider manual installation, read the README instruction file.</p>
<?php endif; ?>

<?php if ($error === 0): ?>
<p>&nbsp;</p>

<h3>Remaining manual steps</h3>
<?php
	if (file_exists(FCPATH.'install') && is_writable(dirname(FCPATH.'install'))):
		$rm = unlink(FCPATH.'install');
		$needs_manual_install_file_deletion = FALSE;

	else:
		$realpath = realpath(FCPATH.'install');
		$needs_manual_install_file_deletion = TRUE;
?>
<h4>Remove Installation file</h4>
<p>Before lauching Kalkun, you have to remove the <code>install</code> file located at the root of Kalkun directory.</p>
<p>Location: <code><?php echo $realpath; ?></code></p>
<?php	endif; ?>

<h4>Configure Kalkun daemon</h4>
<p>Please note that you also must configure the PHP daemon script of Kalkun. Otherwise you can't get your inbox, see <a href="https://github.com/kalkun-sms/Kalkun/wiki/Installation#configure-daemon--outbox_queue-scripts" target="_blank"><strong>instructions on the wiki</strong></a>.</p>
<p>The daemon scripts are provided in the <code>scripts</code> directory of the kalkun archive. In case they are still located at the root of your webserver (ie. along the <code>application</code> directory), <strong>it is advised to move them to another location</strong>.</p>

<h4>Change encryption key</h4>
<p>To improve security, it's highly recommended to change the <code>encryption_key</code> in <code>application/config/config.php</code>. <a href="https://github.com/kalkun-sms/Kalkun/wiki/Installation#change-the-default-encryption-key" target="_blank"><strong>See wiki</strong></a> for details.</p>

<?php if (isset($_SERVER['CI_ENV']) && $_SERVER['CI_ENV'] !== 'production'): ?>
<h4>Set the CodeIgniter environment variable</h4>
<p>To improve security, it's recommended to set the CI_ENV variable in the configuration of your web server to <code>production</code> (for apache it's in <code>.htaccess</code>). If set to <code>production</code> no errors will be reported. While if set to <code>development</code>, the errors will be reported, what may be a security risk. See more details in the <a href="https://codeigniter.com/userguide3/general/environments.html">CodeIgniter documentation</a>.</p>
<?php endif; ?>

<h4>Configure kalkun internals</h4>
<p>You may change some parameters in the <code>application/config/kalkun_settings.php</code> file. For example set another gateway engine than Gammu. Find some suggestions of parameters you can change on the <a href="" target="_blank"><strong>configuration page of the wiki</strong></a>.</p>
<ul>
	<li>Gammu path &amp; gammu config file. Required to send Wap links.</li>
	<li>Gateway engine (aka backend) in case you want to use an external service provider for your SMS (experimental).</li>
</ul>

<h4>Default credentials</h4>
<p>If this is your first setup, please note that default login &amp; password are 'kalkun' &amp; 'kalkun'.</p>

<p>&nbsp;</p>
<?php
	echo form_open(site_url(), 'style="display:block; text-align: center"');
	echo form_hidden('idiom', $idiom);
	echo form_submit('submit', tr_raw('Log in'), 'class="button"');
	if ($needs_manual_install_file_deletion):
		echo '<br>💡 Have you deleted install file?';
	endif;
	echo form_close();
?>

<?php endif; ?>
<p>&nbsp;</p>
