/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2020 - 2024 Intel Corporation
 */

#ifndef IPU7_FW_ISYS_ABI_H
#define IPU7_FW_ISYS_ABI_H

#include "ipu7_fw_common_abi.h"
#include "ipu7_fw_isys_abi.h"

#define IPU_INSYS_MAX_OUTPUT_QUEUES	(3U)
#define IPU_INSYS_STREAM_ID_MAX		(16U)

#define IPU_INSYS_MAX_INPUT_QUEUES	(IPU_INSYS_STREAM_ID_MAX + 1U)
#define IPU_INSYS_OUTPUT_FIRST_QUEUE	(0U)
#define IPU_INSYS_OUTPUT_LAST_QUEUE	(IPU_INSYS_MAX_OUTPUT_QUEUES - 1U)
#define IPU_INSYS_OUTPUT_MSG_QUEUE	(IPU_INSYS_OUTPUT_FIRST_QUEUE)
#define IPU_INSYS_OUTPUT_LOG_QUEUE	(IPU_INSYS_OUTPUT_FIRST_QUEUE + 1U)
#define IPU_INSYS_OUTPUT_RESERVED_QUEUE	(IPU_INSYS_OUTPUT_LAST_QUEUE)
#define IPU_INSYS_INPUT_FIRST_QUEUE	(IPU_INSYS_MAX_OUTPUT_QUEUES)
#define IPU_INSYS_INPUT_LAST_QUEUE \
	(IPU_INSYS_INPUT_FIRST_QUEUE + IPU_INSYS_MAX_INPUT_QUEUES - 1U)
#define IPU_INSYS_INPUT_DEV_QUEUE	(IPU_INSYS_INPUT_FIRST_QUEUE)
#define IPU_INSYS_INPUT_MSG_QUEUE	(IPU_INSYS_INPUT_FIRST_QUEUE + 1U)
#define IPU_INSYS_INPUT_MSG_MAX_QUEUE	(IPU_INSYS_MAX_INPUT_QUEUES - 1U)

#define MAX_IPINS			(4U)
#define MAX_OPINS			(4U)

#define MAX_OPINS_FOR_SINGLE_IPINS	(3U)
#define DEV_SEND_QUEUE_SIZE		(IPU_INSYS_STREAM_ID_MAX)

#define PIN_PLANES_MAX			(4U)

#define INSYS_MSG_ERR_STREAM_INSUFFICIENT_RESOURCES_INPUT \
	INSYS_MSG_ERR_STREAM_INSUFFICIENT_RESOURCES

typedef u64 ipu7_insys_return_token;

enum ipu7_insys_resp_type {
	IPU_INSYS_RESP_TYPE_STREAM_OPEN_DONE = 0,
	IPU_INSYS_RESP_TYPE_STREAM_START_AND_CAPTURE_ACK = 1,
	IPU_INSYS_RESP_TYPE_STREAM_CAPTURE_ACK = 2,
	IPU_INSYS_RESP_TYPE_STREAM_ABORT_ACK = 3,
	IPU_INSYS_RESP_TYPE_STREAM_FLUSH_ACK = 4,
	IPU_INSYS_RESP_TYPE_STREAM_CLOSE_ACK = 5,
	IPU_INSYS_RESP_TYPE_PIN_DATA_READY = 6,
	IPU_INSYS_RESP_TYPE_FRAME_SOF = 7,
	IPU_INSYS_RESP_TYPE_FRAME_EOF = 8,
	IPU_INSYS_RESP_TYPE_STREAM_START_AND_CAPTURE_DONE = 9,
	IPU_INSYS_RESP_TYPE_STREAM_CAPTURE_DONE = 10,
	IPU_INSYS_RESP_TYPE_PWM_IRQ = 11,
	N_IPU_INSYS_RESP_TYPE
};

enum ipu7_insys_send_type {
	IPU_INSYS_SEND_TYPE_STREAM_OPEN = 0,
	IPU_INSYS_SEND_TYPE_STREAM_START_AND_CAPTURE = 1,
	IPU_INSYS_SEND_TYPE_STREAM_CAPTURE = 2,
	IPU_INSYS_SEND_TYPE_STREAM_ABORT = 3,
	IPU_INSYS_SEND_TYPE_STREAM_FLUSH = 4,
	IPU_INSYS_SEND_TYPE_STREAM_CLOSE = 5,
	N_IPU_INSYS_SEND_TYPE
};

enum ipu7_insys_mipi_vc {
	IPU_INSYS_MIPI_VC_0 = 0,
	IPU_INSYS_MIPI_VC_1 = 1,
	IPU_INSYS_MIPI_VC_2 = 2,
	IPU_INSYS_MIPI_VC_3 = 3,
	IPU_INSYS_MIPI_VC_4 = 4,
	IPU_INSYS_MIPI_VC_5 = 5,
	IPU_INSYS_MIPI_VC_6 = 6,
	IPU_INSYS_MIPI_VC_7 = 7,
	IPU_INSYS_MIPI_VC_8 = 8,
	IPU_INSYS_MIPI_VC_9 = 9,
	IPU_INSYS_MIPI_VC_10 = 10,
	IPU_INSYS_MIPI_VC_11 = 11,
	IPU_INSYS_MIPI_VC_12 = 12,
	IPU_INSYS_MIPI_VC_13 = 13,
	IPU_INSYS_MIPI_VC_14 = 14,
	IPU_INSYS_MIPI_VC_15 = 15,
	N_IPU_INSYS_MIPI_VC
};

enum ipu7_insys_mipi_port {
	IPU_INSYS_MIPI_PORT_0 = 0,
	IPU_INSYS_MIPI_PORT_1 = 1,
	IPU_INSYS_MIPI_PORT_2 = 2,
	IPU_INSYS_MIPI_PORT_3 = 3,
	IPU_INSYS_MIPI_PORT_4 = 4,
	IPU_INSYS_MIPI_PORT_5 = 5,
	NA_IPU_INSYS_MIPI_PORT
};

enum ipu7_insys_frame_format_type {
	IPU_INSYS_FRAME_FORMAT_NV11 = 0,
	IPU_INSYS_FRAME_FORMAT_NV12 = 1,
	IPU_INSYS_FRAME_FORMAT_NV12_16 = 2,
	IPU_INSYS_FRAME_FORMAT_NV12_TILEY = 3,
	IPU_INSYS_FRAME_FORMAT_NV16 = 4,
	IPU_INSYS_FRAME_FORMAT_NV21 = 5,
	IPU_INSYS_FRAME_FORMAT_NV61 = 6,
	IPU_INSYS_FRAME_FORMAT_YV12 = 7,
	IPU_INSYS_FRAME_FORMAT_YV16 = 8,
	IPU_INSYS_FRAME_FORMAT_YUV420 = 9,
	IPU_INSYS_FRAME_FORMAT_YUV420_10 = 10,
	IPU_INSYS_FRAME_FORMAT_YUV420_12 = 11,
	IPU_INSYS_FRAME_FORMAT_YUV420_14 = 12,
	IPU_INSYS_FRAME_FORMAT_YUV420_16 = 13,
	IPU_INSYS_FRAME_FORMAT_YUV422 = 14,
	IPU_INSYS_FRAME_FORMAT_YUV422_16 = 15,
	IPU_INSYS_FRAME_FORMAT_UYVY = 16,
	IPU_INSYS_FRAME_FORMAT_YUYV = 17,
	IPU_INSYS_FRAME_FORMAT_YUV444 = 18,
	IPU_INSYS_FRAME_FORMAT_YUV_LINE = 19,
	IPU_INSYS_FRAME_FORMAT_RAW8 = 20,
	IPU_INSYS_FRAME_FORMAT_RAW10 = 21,
	IPU_INSYS_FRAME_FORMAT_RAW12 = 22,
	IPU_INSYS_FRAME_FORMAT_RAW14 = 23,
	IPU_INSYS_FRAME_FORMAT_RAW16 = 24,
	IPU_INSYS_FRAME_FORMAT_RGB565 = 25,
	IPU_INSYS_FRAME_FORMAT_PLANAR_RGB888 = 26,
	IPU_INSYS_FRAME_FORMAT_RGBA888 = 27,
	IPU_INSYS_FRAME_FORMAT_QPLANE6 = 28,
	IPU_INSYS_FRAME_FORMAT_BINARY_8 = 29,
	N_IPU_INSYS_FRAME_FORMAT
};

#define IPU_INSYS_FRAME_FORMAT_RAW (IPU_INSYS_FRAME_FORMAT_RAW16)

enum ipu7_insys_mipi_data_type {
	IPU_INSYS_MIPI_DATA_TYPE_FRAME_START_CODE = 0x00,
	IPU_INSYS_MIPI_DATA_TYPE_FRAME_END_CODE = 0x01,
	IPU_INSYS_MIPI_DATA_TYPE_LINE_START_CODE = 0x02,
	IPU_INSYS_MIPI_DATA_TYPE_LINE_END_CODE = 0x03,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x04 = 0x04,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x05 = 0x05,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x06 = 0x06,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x07 = 0x07,
	IPU_INSYS_MIPI_DATA_TYPE_GENERIC_SHORT1 = 0x08,
	IPU_INSYS_MIPI_DATA_TYPE_GENERIC_SHORT2 = 0x09,
	IPU_INSYS_MIPI_DATA_TYPE_GENERIC_SHORT3 = 0x0a,
	IPU_INSYS_MIPI_DATA_TYPE_GENERIC_SHORT4 = 0x0b,
	IPU_INSYS_MIPI_DATA_TYPE_GENERIC_SHORT5 = 0x0c,
	IPU_INSYS_MIPI_DATA_TYPE_GENERIC_SHORT6 = 0x0d,
	IPU_INSYS_MIPI_DATA_TYPE_GENERIC_SHORT7 = 0x0e,
	IPU_INSYS_MIPI_DATA_TYPE_GENERIC_SHORT8 = 0x0f,
	IPU_INSYS_MIPI_DATA_TYPE_NULL = 0x10,
	IPU_INSYS_MIPI_DATA_TYPE_BLANKING_DATA = 0x11,
	IPU_INSYS_MIPI_DATA_TYPE_EMBEDDED = 0x12,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x13 = 0x13,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x14 = 0x14,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x15 = 0x15,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x16 = 0x16,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x17 = 0x17,
	IPU_INSYS_MIPI_DATA_TYPE_YUV420_8 = 0x18,
	IPU_INSYS_MIPI_DATA_TYPE_YUV420_10 = 0x19,
	IPU_INSYS_MIPI_DATA_TYPE_YUV420_8_LEGACY = 0x1a,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x1B = 0x1b,
	IPU_INSYS_MIPI_DATA_TYPE_YUV420_8_SHIFT = 0x1c,
	IPU_INSYS_MIPI_DATA_TYPE_YUV420_10_SHIFT = 0x1d,
	IPU_INSYS_MIPI_DATA_TYPE_YUV422_8 = 0x1e,
	IPU_INSYS_MIPI_DATA_TYPE_YUV422_10 = 0x1f,
	IPU_INSYS_MIPI_DATA_TYPE_RGB_444 = 0x20,
	IPU_INSYS_MIPI_DATA_TYPE_RGB_555 = 0x21,
	IPU_INSYS_MIPI_DATA_TYPE_RGB_565 = 0x22,
	IPU_INSYS_MIPI_DATA_TYPE_RGB_666 = 0x23,
	IPU_INSYS_MIPI_DATA_TYPE_RGB_888 = 0x24,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x25 = 0x25,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x26 = 0x26,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x27 = 0x27,
	IPU_INSYS_MIPI_DATA_TYPE_RAW_6 = 0x28,
	IPU_INSYS_MIPI_DATA_TYPE_RAW_7 = 0x29,
	IPU_INSYS_MIPI_DATA_TYPE_RAW_8 = 0x2a,
	IPU_INSYS_MIPI_DATA_TYPE_RAW_10 = 0x2b,
	IPU_INSYS_MIPI_DATA_TYPE_RAW_12 = 0x2c,
	IPU_INSYS_MIPI_DATA_TYPE_RAW_14 = 0x2d,
	IPU_INSYS_MIPI_DATA_TYPE_RAW_16 = 0x2e,
	IPU_INSYS_MIPI_DATA_TYPE_BINARY_8 = 0x2f,
	IPU_INSYS_MIPI_DATA_TYPE_USER_DEF1 = 0x30,
	IPU_INSYS_MIPI_DATA_TYPE_USER_DEF2 = 0x31,
	IPU_INSYS_MIPI_DATA_TYPE_USER_DEF3 = 0x32,
	IPU_INSYS_MIPI_DATA_TYPE_USER_DEF4 = 0x33,
	IPU_INSYS_MIPI_DATA_TYPE_USER_DEF5 = 0x34,
	IPU_INSYS_MIPI_DATA_TYPE_USER_DEF6 = 0x35,
	IPU_INSYS_MIPI_DATA_TYPE_USER_DEF7 = 0x36,
	IPU_INSYS_MIPI_DATA_TYPE_USER_DEF8 = 0x37,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x38 = 0x38,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x39 = 0x39,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x3A = 0x3a,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x3B = 0x3b,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x3C = 0x3c,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x3D = 0x3d,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x3E = 0x3e,
	IPU_INSYS_MIPI_DATA_TYPE_RESERVED_0x3F = 0x3f,
	N_IPU_INSYS_MIPI_DATA_TYPE = 0x40
};

enum ipu7_insys_mipi_dt_rename_mode {
	IPU_INSYS_MIPI_DT_NO_RENAME = 0,
	IPU_INSYS_MIPI_DT_RENAMED_MODE = 1,
	N_IPU_INSYS_MIPI_DT_MODE
};

#define IPU_INSYS_SEND_MSG_ENABLED				1U
#define IPU_INSYS_SEND_MSG_DISABLED				0U

#define IPU_INSYS_STREAM_SYNC_MSG_SEND_RESP_SOF			BIT(0)
#define IPU_INSYS_STREAM_SYNC_MSG_SEND_RESP_EOF			BIT(1)
#define IPU_INSYS_STREAM_SYNC_MSG_SEND_IRQ_SOF			BIT(2)
#define IPU_INSYS_STREAM_SYNC_MSG_SEND_IRQ_EOF			BIT(3)
#define IPU_INSYS_STREAM_SYNC_MSG_SEND_RESP_SOF_DISCARDED	BIT(4)
#define IPU_INSYS_STREAM_SYNC_MSG_SEND_RESP_EOF_DISCARDED	BIT(5)
#define IPU_INSYS_STREAM_SYNC_MSG_SEND_IRQ_SOF_DISCARDED	BIT(6)
#define IPU_INSYS_STREAM_SYNC_MSG_SEND_IRQ_EOF_DISCARDED	BIT(7)
#define IPU_INSYS_STREAM_SYNC_MSG_ENABLE_MSG_SEND_RESP ( \
	IPU_INSYS_STREAM_SYNC_MSG_SEND_RESP_SOF | \
	IPU_INSYS_STREAM_SYNC_MSG_SEND_RESP_EOF | \
	IPU_INSYS_STREAM_SYNC_MSG_SEND_RESP_SOF_DISCARDED | \
	IPU_INSYS_STREAM_SYNC_MSG_SEND_RESP_EOF_DISCARDED)
#define IPU_INSYS_STREAM_SYNC_MSG_ENABLE_MSG_SEND_IRQ ( \
	IPU_INSYS_STREAM_SYNC_MSG_SEND_IRQ_SOF | \
	IPU_INSYS_STREAM_SYNC_MSG_SEND_IRQ_EOF | \
	IPU_INSYS_STREAM_SYNC_MSG_SEND_IRQ_SOF_DISCARDED | \
	IPU_INSYS_STREAM_SYNC_MSG_SEND_IRQ_EOF_DISCARDED)

#define IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_OPEN_DONE		BIT(0)
#define IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_OPEN_DONE		BIT(1)
#define IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_START_ACK		BIT(2)
#define IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_START_ACK		BIT(3)
#define IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_CLOSE_ACK		BIT(4)
#define IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_CLOSE_ACK		BIT(5)
#define IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_FLUSH_ACK		BIT(6)
#define IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_FLUSH_ACK		BIT(7)
#define IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_ABORT_ACK		BIT(8)
#define IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_ABORT_ACK		BIT(9)
#define IPU_INSYS_STREAM_ENABLE_MSG_SEND_RESP ( \
	IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_OPEN_DONE | \
	IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_START_ACK | \
	IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_CLOSE_ACK | \
	IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_FLUSH_ACK | \
	IPU_INSYS_STREAM_MSG_SEND_RESP_STREAM_ABORT_ACK)
#define IPU_INSYS_STREAM_ENABLE_MSG_SEND_IRQ ( \
	IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_OPEN_DONE | \
	IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_START_ACK | \
	IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_CLOSE_ACK | \
	IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_FLUSH_ACK | \
	IPU_INSYS_STREAM_MSG_SEND_IRQ_STREAM_ABORT_ACK)

#define IPU_INSYS_FRAME_MSG_SEND_RESP_CAPTURE_ACK		BIT(0)
#define IPU_INSYS_FRAME_MSG_SEND_IRQ_CAPTURE_ACK		BIT(1)
#define IPU_INSYS_FRAME_MSG_SEND_RESP_CAPTURE_DONE		BIT(2)
#define IPU_INSYS_FRAME_MSG_SEND_IRQ_CAPTURE_DONE		BIT(3)
#define IPU_INSYS_FRAME_MSG_SEND_RESP_PIN_DATA_READY		BIT(4)
#define IPU_INSYS_FRAME_MSG_SEND_IRQ_PIN_DATA_READY		BIT(5)
#define IPU_INSYS_FRAME_ENABLE_MSG_SEND_RESP ( \
	IPU_INSYS_FRAME_MSG_SEND_RESP_CAPTURE_ACK | \
	IPU_INSYS_FRAME_MSG_SEND_RESP_CAPTURE_DONE | \
	IPU_INSYS_FRAME_MSG_SEND_RESP_PIN_DATA_READY)
#define IPU_INSYS_FRAME_ENABLE_MSG_SEND_IRQ ( \
	IPU_INSYS_FRAME_MSG_SEND_IRQ_CAPTURE_ACK | \
	IPU_INSYS_FRAME_MSG_SEND_IRQ_CAPTURE_DONE | \
	IPU_INSYS_FRAME_MSG_SEND_IRQ_PIN_DATA_READY)

enum ipu7_insys_output_link_dest {
	IPU_INSYS_OUTPUT_LINK_DEST_MEM = 0,
	IPU_INSYS_OUTPUT_LINK_DEST_PSYS = 1,
	IPU_INSYS_OUTPUT_LINK_DEST_IPU_EXTERNAL = 2
};

enum ipu7_insys_dpcm_type {
	IPU_INSYS_DPCM_TYPE_DISABLED = 0,
	IPU_INSYS_DPCM_TYPE_10_8_10 = 1,
	IPU_INSYS_DPCM_TYPE_12_8_12 = 2,
	IPU_INSYS_DPCM_TYPE_12_10_12 = 3,
	N_IPU_INSYS_DPCM_TYPE
};

enum ipu7_insys_dpcm_predictor {
	IPU_INSYS_DPCM_PREDICTOR_1 = 0,
	IPU_INSYS_DPCM_PREDICTOR_2 = 1,
	N_IPU_INSYS_DPCM_PREDICTOR
};

enum ipu7_insys_send_queue_token_flag {
	IPU_INSYS_SEND_QUEUE_TOKEN_FLAG_NONE = 0,
	IPU_INSYS_SEND_QUEUE_TOKEN_FLAG_FLUSH_FORCE = 1
};

#pragma pack(push, 1)
struct ipu7_insys_resolution {
	u32 width;
	u32 height;
};

struct ipu7_insys_capture_output_pin_payload {
	u64 user_token;
	ia_gofo_addr_t addr;
	u8 pad[4];
};

struct ipu7_insys_output_link {
	u32 buffer_lines;
	u16 foreign_key;
	u16 granularity_pointer_update;
	u8 msg_link_streaming_mode;
	u8 pbk_id;
	u8 pbk_slot_id;
	u8 dest;
	u8 use_sw_managed;
	u8 is_snoop;
	u8 pad[2];
};

struct ipu7_insys_output_cropping {
	u16 line_top;
	u16 line_bottom;
};

struct ipu7_insys_output_dpcm {
	u8 enable;
	u8 type;
	u8 predictor;
	u8 pad;
};

struct ipu7_insys_output_pin {
	struct ipu7_insys_output_link link;
	struct ipu7_insys_output_cropping crop;
	struct ipu7_insys_output_dpcm dpcm;
	u32 stride;
	u16 ft;
	u8 send_irq;
	u8 input_pin_id;
	u8 early_ack_en;
	u8 pad[3];
};

struct ipu7_insys_input_pin {
	struct ipu7_insys_resolution input_res;
	u16 sync_msg_map;
	u8 dt;
	u8 disable_mipi_unpacking;
	u8 dt_rename_mode;
	u8 mapped_dt;
	u8 pad[2];
};

struct ipu7_insys_stream_cfg {
	struct ipu7_insys_input_pin input_pins[MAX_IPINS];
	struct ipu7_insys_output_pin output_pins[MAX_OPINS];
	u16 stream_msg_map;
	u8 port_id;
	u8 vc;
	u8 nof_input_pins;
	u8 nof_output_pins;
	u8 pad[2];
};

struct ipu7_insys_buffset {
	struct ipu7_insys_capture_output_pin_payload output_pins[MAX_OPINS];
	u8 capture_msg_map;
	u8 frame_id;
	u8 skip_frame;
	u8 pad[5];
};

struct ipu7_insys_resp {
	u64 buf_id;
	struct ipu7_insys_capture_output_pin_payload pin;
	struct ia_gofo_msg_err error_info;
	u32 timestamp[2];
	u8 type;
	u8 msg_link_streaming_mode;
	u8 stream_id;
	u8 pin_id;
	u8 frame_id;
	u8 skip_frame;
	u8 pad[2];
};

struct ipu7_insys_resp_queue_token {
	struct ipu7_insys_resp resp_info;
};

struct ipu7_insys_send_queue_token {
	u64 buf_handle;
	ia_gofo_addr_t addr;
	u16 stream_id;
	u8 send_type;
	u8 flag;
};
#pragma pack(pop)

static inline void ipu7_insys_types_test_func(void)
{
	CHECK_ALIGN32(struct ipu7_insys_resolution);
	CHECK_ALIGN64(struct ipu7_insys_capture_output_pin_payload);
	CHECK_ALIGN32(struct ipu7_insys_output_pin);
	CHECK_ALIGN32(struct ipu7_insys_input_pin);
	CHECK_ALIGN32(struct ipu7_insys_output_cropping);
	CHECK_ALIGN32(struct ipu7_insys_stream_cfg);
	CHECK_ALIGN64(struct ipu7_insys_buffset);
	CHECK_ALIGN64(struct ipu7_insys_resp);
	CHECK_ALIGN64(struct ipu7_insys_resp_queue_token);
	CHECK_ALIGN64(struct ipu7_insys_send_queue_token);
	CHECK_ALIGN32(struct ipu7_insys_output_link);
}

enum insys_msg_err_stream {
	INSYS_MSG_ERR_STREAM_OK = IA_GOFO_MSG_ERR_OK,
	INSYS_MSG_ERR_STREAM_STREAM_ID = 1,
	INSYS_MSG_ERR_STREAM_MAX_OPINS = 2,
	INSYS_MSG_ERR_STREAM_MAX_IPINS = 3,
	INSYS_MSG_ERR_STREAM_STREAM_MESSAGES_MAP = 4,
	INSYS_MSG_ERR_STREAM_SYNC_MESSAGES_MAP = 5,
	INSYS_MSG_ERR_STREAM_SENSOR_TYPE = 6,
	INSYS_MSG_ERR_STREAM_FOREIGN_KEY = 7,
	INSYS_MSG_ERR_STREAM_STREAMING_MODE = 8,
	INSYS_MSG_ERR_STREAM_DPCM_EN = 9,
	INSYS_MSG_ERR_STREAM_DPCM_TYPE = 10,
	INSYS_MSG_ERR_STREAM_DPCM_PREDICTOR = 11,
	INSYS_MSG_ERR_STREAM_GRANULARITY_POINTER_UPDATE = 12,
	INSYS_MSG_ERR_STREAM_MPF_LUT_ENTRY_RESOURCES_BUSY = 13,
	INSYS_MSG_ERR_STREAM_MPF_DEV_ID = 14,
	INSYS_MSG_ERR_STREAM_BUFFER_LINES = 15,
	INSYS_MSG_ERR_STREAM_IPIN_ID = 16,
	INSYS_MSG_ERR_STREAM_DATA_TYPE = 17,
	INSYS_MSG_ERR_STREAM_STREAMING_PROTOCOL_STATE = 18,
	INSYS_MSG_ERR_STREAM_SYSCOM_FLUSH = 19,
	INSYS_MSG_ERR_STREAM_MIPI_VC = 20,
	INSYS_MSG_ERR_STREAM_STREAM_SRC = 21,
	INSYS_MSG_ERR_STREAM_PBK_ID = 22,
	INSYS_MSG_ERR_STREAM_CMD_QUEUE_DEALLOCATE = 23,
	INSYS_MSG_ERR_STREAM_INSUFFICIENT_RESOURCES = 24,
	INSYS_MSG_ERR_STREAM_IPIN_CONFIGURATION = 25,
	INSYS_MSG_ERR_STREAM_INVALID_STATE = 26,
	INSYS_MSG_ERR_STREAM_SW_MANAGED = 27,
	INSYS_MSG_ERR_STREAM_PBK_SLOT_ID = 28,
	INSYS_MSG_ERR_STREAM_FLUSH_TIMEOUT = 29,
	INSYS_MSG_ERR_STREAM_IPIN_WIDTH = 30,
	INSYS_MSG_ERR_STREAM_IPIN_HEIGHT = 31,
	INSYS_MSG_ERR_STREAM_OUTPUT_PIN_EARLY_ACK_EN = 32,
	INSYS_MSG_ERR_STREAM_INCONSISTENT_PARAMS = 33,
	INSYS_MSG_ERR_STREAM_PLANE_COUNT = 34,
	INSYS_MSG_ERR_STREAM_FRAME_FORMAT_TYPE = 35,
	INSYS_MSG_ERR_STREAM_INSUFFICIENT_RESOURCES_OUTPUT = 36,
	INSYS_MSG_ERR_STREAM_N
};

enum insys_msg_err_capture {
	INSYS_MSG_ERR_CAPTURE_OK = IA_GOFO_MSG_ERR_OK,
	INSYS_MSG_ERR_CAPTURE_STREAM_ID = 1,
	INSYS_MSG_ERR_CAPTURE_PAYLOAD_PTR = 2,
	INSYS_MSG_ERR_CAPTURE_MEM_SLOT = 3,
	INSYS_MSG_ERR_CAPTURE_STREAMING_MODE = 4,
	INSYS_MSG_ERR_CAPTURE_AVAILABLE_CMD_SLOT = 5,
	INSYS_MSG_ERR_CAPTURE_CONSUMED_CMD_SLOT = 6,
	INSYS_MSG_ERR_CAPTURE_CMD_SLOT_PAYLOAD_PTR = 7,
	INSYS_MSG_ERR_CAPTURE_CMD_PREPARE = 8,
	INSYS_MSG_ERR_CAPTURE_OUTPUT_PIN = 9,
	INSYS_MSG_ERR_CAPTURE_SYNC_FRAME_DROP = 10,
	INSYS_MSG_ERR_CAPTURE_FRAME_MESSAGES_MAP = 11,
	INSYS_MSG_ERR_CAPTURE_TIMEOUT = 12,
	INSYS_MSG_ERR_CAPTURE_INVALID_STREAM_STATE = 13,
	INSYS_MSG_ERR_CAPTURE_HW_ERR_MULTIBIT_PH_ERROR_DETECTED = 14,
	INSYS_MSG_ERR_CAPTURE_HW_ERR_PAYLOAD_CRC_ERROR = 15,
	INSYS_MSG_ERR_CAPTURE_HW_ERR_INPUT_DATA_LOSS_ELASTIC_FIFO_OVFL  = 16,
	INSYS_MSG_ERR_CAPTURE_HW_ERR_PIXEL_BUFFER_OVERFLOW = 17,
	INSYS_MSG_ERR_CAPTURE_HW_ERR_BAD_FRAME_DIM = 18,
	INSYS_MSG_ERR_CAPTURE_HW_ERR_PHY_SYNC_ERR = 19,
	INSYS_MSG_ERR_CAPTURE_HW_ERR_SECURE_TOUCH = 20,
	INSYS_MSG_ERR_CAPTURE_HW_ERR_MASTER_SLAVE_SYNC_ERR = 21,
	INSYS_MSG_ERR_CAPTURE_FRAME_SKIP_ERR = 22,
	INSYS_MSG_ERR_CAPTURE_FE_INPUT_FIFO_OVERFLOW_ERR = 23,
	INSYS_MSG_ERR_CAPTURE_CMD_SUBMIT_TO_HW = 24,
	INSYS_MSG_ERR_CAPTURE_N
};

enum insys_msg_err_groups {
	INSYS_MSG_ERR_GROUP_RESERVED = IA_GOFO_MSG_ERR_GROUP_RESERVED,
	INSYS_MSG_ERR_GROUP_GENERAL = IA_GOFO_MSG_ERR_GROUP_GENERAL,
	INSYS_MSG_ERR_GROUP_STREAM = 2,
	INSYS_MSG_ERR_GROUP_CAPTURE = 3,
	INSYS_MSG_ERR_GROUP_N,
};

#endif
