from abc import ABC, abstractmethod


class HtmlGeneratorConfiguration(ABC):
    """HTML generator configuration interface."""

    @abstractmethod
    def get_markdown_tex_support() -> bool:
        """Get whether markdown TeX rendering is supported.

        :return: Markdown TeX supported
        :rtype: bool
        """
        raise NotImplementedError()

    @abstractmethod
    def get_line_length() -> int:
        """Get line length.

        :return: Size in pixels
        :rtype: int
        """
        raise NotImplementedError()

    @abstractmethod
    def get_markdown_use_monospace_font() -> bool:
        """Get whether to use a monospace font for the markdown render.

        :return: Using monospace font
        :rtype: bool
        """
        raise NotImplementedError()

    @abstractmethod
    def get_use_monospace_font() -> bool:
        """Get whether to use a monospace font.

        :return: Using monospace font
        :rtype: bool
        """
        raise NotImplementedError()

    @abstractmethod
    def get_font_size() -> int:
        """Get font size.

        :return: Size
        :rtype: int
        """
        raise NotImplementedError()

    @abstractmethod
    def get_markdown_render_monospace_font_ratio() -> float:
        """Get the adjustment in size from proportional to fixed width font.

        :return: Ratio
        :rtype: float
        """
        raise NotImplementedError()
