# Test suite for imediff and git-ime

This directory contains files to test imediff and git-ime.

## Test codes manually run as you write

* `./_local_test_imediff.sh`
  * Python path is adjusted as: `export PYTHONPATH=../src`
* `./_local_test_git_ime.sh`

These are meant to be executed in this directory.

## Test code used by dh_test and autopkgtest

* `test_unittest_all.py`

## Lower level test code automatically called by above

* `./_diff23.py` -- test with files (file_a, file_b file_c)
* `./_imediff.py` -- test diff2
* `./_imediff.py` -- test diff3 for line diff output
* `./_imediff.py` -- test diff3 for word diff output
* `./_initialize.py` -- test initialization
* `./_macrotrans.py` -- test key bindings

## Doctext in the python source

* `../src/imediff/diff3lib.py`
* `../src/imediff/lines2lib.py`

## Note on updating reference files

If you change configuration file format, you need to update data in this
directory.

  * update reference template z_initialize.ref
  * update alternative_imediff.conf to get z_macrotrans.ref to match (except
    new parameters)

Baseline template file for alternative_imediff.conf can be generated by running
the following command start from this directory.

```console
 $ cd ../src/imediff
 $ export PYTHONPATH=../; ./config.py
 $ mv TEMPLATE.imediff ../../test/alternative_imediff.conf.new
```

You need to make the same kind of key swaps in this
`alternative_imediff.conf` .


## NOTE

For Debian package building, dh_auto_test isn't run from here.  It looks like a
copy of test/ directory as test and a copy of src/imediff directory as imediff
are created at .pybuild/cpython3_*.*/ where the current directory is moved to.

Notable thing is that when test/ directories are copied, symlinks are copied as files.

