/* Server.c generated by valac 0.16.1, the Vala compiler
 * generated from Server.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/rtsp-server/rtsp-server.h>
#include <stdlib.h>
#include <string.h>
#include <cstuff.h>
#include <gio/gio.h>
#include <gst/rtsp-server/rtsp-media-mapping.h>
#include <gst/rtsp-server/rtsp-session-pool.h>
#include <gst/rtsp-server/rtsp-session.h>
#include <gst/rtsp/gstrtspconnection.h>
#include <gobject/gvaluecollector.h>


#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;

#define DVB_TYPE_MEDIA_MAPPING (dvb_media_mapping_get_type ())
#define DVB_MEDIA_MAPPING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MEDIA_MAPPING, DVBMediaMapping))
#define DVB_MEDIA_MAPPING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MEDIA_MAPPING, DVBMediaMappingClass))
#define DVB_IS_MEDIA_MAPPING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MEDIA_MAPPING))
#define DVB_IS_MEDIA_MAPPING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MEDIA_MAPPING))
#define DVB_MEDIA_MAPPING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MEDIA_MAPPING, DVBMediaMappingClass))

typedef struct _DVBMediaMapping DVBMediaMapping;
typedef struct _DVBMediaMappingClass DVBMediaMappingClass;
typedef struct _DvbRtspServerStartData DvbRtspServerStartData;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER (dvb_rtsp_server_stop_channel_helper_get_type ())
#define DVB_RTSP_SERVER_STOP_CHANNEL_HELPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, DVBRTSPServerStopChannelHelper))
#define DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, DVBRTSPServerStopChannelHelperClass))
#define DVB_RTSP_SERVER_IS_STOP_CHANNEL_HELPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER))
#define DVB_RTSP_SERVER_IS_STOP_CHANNEL_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER))
#define DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, DVBRTSPServerStopChannelHelperClass))

typedef struct _DVBRTSPServerStopChannelHelper DVBRTSPServerStopChannelHelper;
typedef struct _DVBRTSPServerStopChannelHelperClass DVBRTSPServerStopChannelHelperClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _dvb_rtsp_server_stop_channel_helper_unref0(var) ((var == NULL) ? NULL : (var = (dvb_rtsp_server_stop_channel_helper_unref (var), NULL)))
typedef struct _DVBRTSPServerStopChannelHelperPrivate DVBRTSPServerStopChannelHelperPrivate;
#define _gst_rtsp_url_free0(var) ((var == NULL) ? NULL : (var = (gst_rtsp_url_free (var), NULL)))
typedef struct _DVBRTSPServerParamSpecStopChannelHelper DVBRTSPServerParamSpecStopChannelHelper;

struct _DvbRtspServerStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DVBLoggingLogManager* _tmp0_;
	DVBLoggingLogger* _tmp1_;
	DVBLoggingLogger* _tmp2_;
	GstRTSPServer* _tmp3_;
	GstRTSPServer* _tmp4_;
	DVBMediaMapping* _tmp5_;
	DVBMediaMapping* _tmp6_;
	GstRTSPServer* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GstRTSPServer* _tmp10_;
	guint _tmp11_;
};

struct _DVBRTSPServerStopChannelHelper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBRTSPServerStopChannelHelperPrivate * priv;
};

struct _DVBRTSPServerStopChannelHelperClass {
	GTypeClass parent_class;
	void (*finalize) (DVBRTSPServerStopChannelHelper *self);
};

struct _DVBRTSPServerStopChannelHelperPrivate {
	GstRTSPUrl* url;
};

struct _DVBRTSPServerParamSpecStopChannelHelper {
	GParamSpec parent_instance;
};


extern DVBLoggingLogger* dvb_rtsp_server_log;
DVBLoggingLogger* dvb_rtsp_server_log = NULL;
extern GstRTSPServer* dvb_rtsp_server_server;
GstRTSPServer* dvb_rtsp_server_server = NULL;
extern guint dvb_rtsp_server_timeout_id;
guint dvb_rtsp_server_timeout_id = 0U;
static gpointer dvb_rtsp_server_stop_channel_helper_parent_class = NULL;

GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
gchar* dvb_rtsp_server_get_address (void);
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (DVBFactory* self);
gchar* dvb_settings_get_streaming_interface (DVBSettings* self);
static void dvb_rtsp_server_start_data_free (gpointer _data);
void dvb_rtsp_server_start (GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_rtsp_server_start_finish (GAsyncResult* _res_);
static gboolean dvb_rtsp_server_start_co (DvbRtspServerStartData* _data_);
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
DVBMediaMapping* dvb_media_mapping_new (void);
DVBMediaMapping* dvb_media_mapping_construct (GType object_type);
GType dvb_media_mapping_get_type (void) G_GNUC_CONST;
gboolean dvb_rtsp_server_timeout (void);
void dvb_rtsp_server_shutdown (void);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_rtsp_server_stop_streaming (DVBChannel* channel);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gchar* dvb_channel_get_URL (DVBChannel* self);
DVBRTSPServerStopChannelHelper* dvb_rtsp_server_stop_channel_helper_new (const gchar* url_str);
DVBRTSPServerStopChannelHelper* dvb_rtsp_server_stop_channel_helper_construct (GType object_type, const gchar* url_str);
gpointer dvb_rtsp_server_stop_channel_helper_ref (gpointer instance);
void dvb_rtsp_server_stop_channel_helper_unref (gpointer instance);
GParamSpec* dvb_rtsp_server_param_spec_stop_channel_helper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_rtsp_server_value_set_stop_channel_helper (GValue* value, gpointer v_object);
void dvb_rtsp_server_value_take_stop_channel_helper (GValue* value, gpointer v_object);
gpointer dvb_rtsp_server_value_get_stop_channel_helper (const GValue* value);
GType dvb_rtsp_server_stop_channel_helper_get_type (void) G_GNUC_CONST;
GstRTSPFilterResult dvb_rtsp_server_stop_channel_helper_session_filter_func (DVBRTSPServerStopChannelHelper* self, GstRTSPSessionPool* pool, GstRTSPSession* session);
static GstRTSPFilterResult _dvb_rtsp_server_stop_channel_helper_session_filter_func_gst_rtsp_session_filter_func (GstRTSPSessionPool* pool, GstRTSPSession* session, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, DVBRTSPServerStopChannelHelperPrivate))
enum  {
	DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_DUMMY_PROPERTY
};
static void dvb_rtsp_server_stop_channel_helper_finalize (DVBRTSPServerStopChannelHelper* obj);


gchar* dvb_rtsp_server_get_address (void) {
	gchar* result = NULL;
	DVBFactory* _tmp0_;
	DVBFactory* _tmp1_;
	DVBSettings* _tmp2_ = NULL;
	DVBSettings* _tmp3_;
	DVBSettings* settings;
	DVBSettings* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* iface;
	gchar* address;
	GList* _tmp6_ = NULL;
	GList* adapters;
	GList* _tmp7_;
	const gchar* _tmp14_;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_settings (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = settings;
	_tmp5_ = dvb_settings_get_streaming_interface (_tmp4_);
	iface = _tmp5_;
	address = NULL;
	_tmp6_ = get_adapters ();
	adapters = _tmp6_;
	_tmp7_ = adapters;
	{
		GList* na_collection = NULL;
		GList* na_it = NULL;
		na_collection = _tmp7_;
		for (na_it = na_collection; na_it != NULL; na_it = na_it->next) {
			struct net_adapter* na = NULL;
			na = (struct net_adapter*) na_it->data;
			{
				struct net_adapter* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp8_ = na;
				_tmp9_ = _tmp8_->name;
				_tmp10_ = iface;
				if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
					struct net_adapter* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp11_ = na;
					_tmp12_ = _tmp11_->address;
					_tmp13_ = g_strdup (_tmp12_);
					_g_free0 (address);
					address = _tmp13_;
					break;
				}
			}
		}
	}
	_tmp14_ = address;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = iface;
		g_warning ("Server.vala:43: Could not find network interface '%s'", _tmp15_);
		_tmp16_ = g_strdup ("127.0.0.1");
		_g_free0 (address);
		address = _tmp16_;
	}
	result = address;
	_g_list_free0 (adapters);
	_g_free0 (iface);
	_g_object_unref0 (settings);
	return result;
}


static void dvb_rtsp_server_start_data_free (gpointer _data) {
	DvbRtspServerStartData* _data_;
	_data_ = _data;
	g_slice_free (DvbRtspServerStartData, _data_);
}


void dvb_rtsp_server_start (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DvbRtspServerStartData* _data_;
	_data_ = g_slice_new0 (DvbRtspServerStartData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, dvb_rtsp_server_start);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dvb_rtsp_server_start_data_free);
	dvb_rtsp_server_start_co (_data_);
}


void dvb_rtsp_server_start_finish (GAsyncResult* _res_) {
	DvbRtspServerStartData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean dvb_rtsp_server_start_co (DvbRtspServerStartData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_data_->_tmp0_);
	_g_object_unref0 (dvb_rtsp_server_log);
	dvb_rtsp_server_log = _data_->_tmp1_;
	_data_->_tmp2_ = dvb_rtsp_server_log;
	dvb_logging_logger_info (_data_->_tmp2_, "Server.vala:52: Starting RTSP server");
	_data_->_tmp3_ = gst_rtsp_server_new ();
	_g_object_unref0 (dvb_rtsp_server_server);
	dvb_rtsp_server_server = _data_->_tmp3_;
	_data_->_tmp4_ = dvb_rtsp_server_server;
	_data_->_tmp5_ = dvb_media_mapping_new ();
	_data_->_tmp6_ = _data_->_tmp5_;
	gst_rtsp_server_set_media_mapping (_data_->_tmp4_, (GstRTSPMediaMapping*) _data_->_tmp6_);
	_g_object_unref0 (_data_->_tmp6_);
	_data_->_tmp7_ = dvb_rtsp_server_server;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = dvb_rtsp_server_get_address ();
	_data_->_tmp9_ = _data_->_tmp8_;
	gst_rtsp_server_set_address (_data_->_tmp7_, _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = dvb_rtsp_server_server;
	gst_rtsp_server_attach (_data_->_tmp10_, NULL);
	_data_->_tmp11_ = 0U;
	_data_->_tmp11_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, (GSourceFunc) dvb_rtsp_server_timeout, NULL, NULL);
	dvb_rtsp_server_timeout_id = _data_->_tmp11_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void dvb_rtsp_server_shutdown (void) {
	guint _tmp0_;
	_tmp0_ = dvb_rtsp_server_timeout_id;
	g_source_remove (_tmp0_);
	_g_object_unref0 (dvb_rtsp_server_server);
	dvb_rtsp_server_server = NULL;
}


static GstRTSPFilterResult _dvb_rtsp_server_stop_channel_helper_session_filter_func_gst_rtsp_session_filter_func (GstRTSPSessionPool* pool, GstRTSPSession* session, gpointer self) {
	GstRTSPFilterResult result;
	result = dvb_rtsp_server_stop_channel_helper_session_filter_func (self, pool, session);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void dvb_rtsp_server_stop_streaming (DVBChannel* channel) {
	DVBLoggingLogger* _tmp0_;
	DVBChannel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	DVBChannel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	DVBRTSPServerStopChannelHelper* _tmp8_;
	DVBRTSPServerStopChannelHelper* _tmp9_;
	DVBRTSPServerStopChannelHelper* helper;
	GstRTSPServer* _tmp10_;
	GstRTSPSessionPool* _tmp11_;
	GstRTSPSessionPool* _tmp12_;
	GList* _tmp13_ = NULL;
	GList* _tmp14_;
	g_return_if_fail (channel != NULL);
	_tmp0_ = dvb_rtsp_server_log;
	_tmp1_ = channel;
	_tmp2_ = dvb_channel_get_Name (_tmp1_);
	_tmp3_ = _tmp2_;
	dvb_logging_logger_debug (_tmp0_, "Server.vala:66: Stop streaming channel %s", _tmp3_);
	_tmp4_ = channel;
	_tmp5_ = dvb_channel_get_URL (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = dvb_rtsp_server_stop_channel_helper_new (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	helper = _tmp9_;
	_tmp10_ = dvb_rtsp_server_server;
	_tmp11_ = gst_rtsp_server_get_session_pool (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gst_rtsp_session_pool_filter (_tmp12_, _dvb_rtsp_server_stop_channel_helper_session_filter_func_gst_rtsp_session_filter_func, helper);
	_tmp14_ = _tmp13_;
	__g_list_free__g_object_unref0_0 (_tmp14_);
	_dvb_rtsp_server_stop_channel_helper_unref0 (helper);
}


gboolean dvb_rtsp_server_timeout (void) {
	gboolean result = FALSE;
	GstRTSPServer* _tmp0_;
	GstRTSPSessionPool* _tmp1_ = NULL;
	GstRTSPSessionPool* pool;
	_tmp0_ = dvb_rtsp_server_server;
	_tmp1_ = gst_rtsp_server_get_session_pool (_tmp0_);
	pool = _tmp1_;
	gst_rtsp_session_pool_cleanup (pool);
	result = TRUE;
	_g_object_unref0 (pool);
	return result;
}


DVBRTSPServerStopChannelHelper* dvb_rtsp_server_stop_channel_helper_construct (GType object_type, const gchar* url_str) {
	DVBRTSPServerStopChannelHelper* self = NULL;
	const gchar* _tmp0_;
	GstRTSPUrl* _tmp1_ = NULL;
	g_return_val_if_fail (url_str != NULL, NULL);
	self = (DVBRTSPServerStopChannelHelper*) g_type_create_instance (object_type);
	_tmp0_ = url_str;
	gst_rtsp_url_parse (_tmp0_, &_tmp1_);
	_gst_rtsp_url_free0 (self->priv->url);
	self->priv->url = _tmp1_;
	return self;
}


DVBRTSPServerStopChannelHelper* dvb_rtsp_server_stop_channel_helper_new (const gchar* url_str) {
	return dvb_rtsp_server_stop_channel_helper_construct (DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, url_str);
}


GstRTSPFilterResult dvb_rtsp_server_stop_channel_helper_session_filter_func (DVBRTSPServerStopChannelHelper* self, GstRTSPSessionPool* pool, GstRTSPSession* session) {
	GstRTSPFilterResult result = 0;
	GstRTSPSession* _tmp0_;
	GstRTSPUrl* _tmp1_;
	GstRTSPSessionMedia* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (pool != NULL, 0);
	g_return_val_if_fail (session != NULL, 0);
	_tmp0_ = session;
	_tmp1_ = self->priv->url;
	_tmp2_ = gst_rtsp_session_get_media (_tmp0_, _tmp1_);
	if (_tmp2_ != NULL) {
		result = GST_RTSP_FILTER_REMOVE;
		return result;
	} else {
		result = GST_RTSP_FILTER_KEEP;
		return result;
	}
}


static void dvb_rtsp_server_value_stop_channel_helper_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_rtsp_server_value_stop_channel_helper_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_rtsp_server_stop_channel_helper_unref (value->data[0].v_pointer);
	}
}


static void dvb_rtsp_server_value_stop_channel_helper_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_rtsp_server_stop_channel_helper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_rtsp_server_value_stop_channel_helper_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_rtsp_server_value_stop_channel_helper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBRTSPServerStopChannelHelper* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_rtsp_server_stop_channel_helper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_rtsp_server_value_stop_channel_helper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBRTSPServerStopChannelHelper** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_rtsp_server_stop_channel_helper_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_rtsp_server_param_spec_stop_channel_helper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBRTSPServerParamSpecStopChannelHelper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_rtsp_server_value_get_stop_channel_helper (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER), NULL);
	return value->data[0].v_pointer;
}


void dvb_rtsp_server_value_set_stop_channel_helper (GValue* value, gpointer v_object) {
	DVBRTSPServerStopChannelHelper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_rtsp_server_stop_channel_helper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_rtsp_server_stop_channel_helper_unref (old);
	}
}


void dvb_rtsp_server_value_take_stop_channel_helper (GValue* value, gpointer v_object) {
	DVBRTSPServerStopChannelHelper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_rtsp_server_stop_channel_helper_unref (old);
	}
}


static void dvb_rtsp_server_stop_channel_helper_class_init (DVBRTSPServerStopChannelHelperClass * klass) {
	dvb_rtsp_server_stop_channel_helper_parent_class = g_type_class_peek_parent (klass);
	DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_CLASS (klass)->finalize = dvb_rtsp_server_stop_channel_helper_finalize;
	g_type_class_add_private (klass, sizeof (DVBRTSPServerStopChannelHelperPrivate));
}


static void dvb_rtsp_server_stop_channel_helper_instance_init (DVBRTSPServerStopChannelHelper * self) {
	self->priv = DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void dvb_rtsp_server_stop_channel_helper_finalize (DVBRTSPServerStopChannelHelper* obj) {
	DVBRTSPServerStopChannelHelper * self;
	self = DVB_RTSP_SERVER_STOP_CHANNEL_HELPER (obj);
	_gst_rtsp_url_free0 (self->priv->url);
}


GType dvb_rtsp_server_stop_channel_helper_get_type (void) {
	static volatile gsize dvb_rtsp_server_stop_channel_helper_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_rtsp_server_stop_channel_helper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_rtsp_server_value_stop_channel_helper_init, dvb_rtsp_server_value_stop_channel_helper_free_value, dvb_rtsp_server_value_stop_channel_helper_copy_value, dvb_rtsp_server_value_stop_channel_helper_peek_pointer, "p", dvb_rtsp_server_value_stop_channel_helper_collect_value, "p", dvb_rtsp_server_value_stop_channel_helper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBRTSPServerStopChannelHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_rtsp_server_stop_channel_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRTSPServerStopChannelHelper), 0, (GInstanceInitFunc) dvb_rtsp_server_stop_channel_helper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_rtsp_server_stop_channel_helper_type_id;
		dvb_rtsp_server_stop_channel_helper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBRTSPServerStopChannelHelper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_rtsp_server_stop_channel_helper_type_id__volatile, dvb_rtsp_server_stop_channel_helper_type_id);
	}
	return dvb_rtsp_server_stop_channel_helper_type_id__volatile;
}


gpointer dvb_rtsp_server_stop_channel_helper_ref (gpointer instance) {
	DVBRTSPServerStopChannelHelper* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_rtsp_server_stop_channel_helper_unref (gpointer instance) {
	DVBRTSPServerStopChannelHelper* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



