/* $Id: conf.c,v 1.5 2001/04/22 13:46:22 japh Exp $
 * Written by and (c) 2000 Andreas Krennmair <a.krennmair@aon.at>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#if HAVE_LIBSLANG
# include <slang.h>
#else
# warning "In order to be able to configure francine, install libslang!"
#endif

#include <string.h>
#include <stdlib.h>
#include "conf.h"

static int CONF_support_securetty = 1;

/* will be initialized with a string via init_conf: */
static char * CONF_intro_string = NULL; 

static int CONF_set_path_env = 1;

static int CONF_check_email = 1;

static int CONF_speech_support = 0;

static char * CONF_speech_device = NULL;

static char * CONF_theme_dir = NULL;

static int CONF_timeout = 0; /* 0 means "no timeout" */



void init_conf(void)
{

#if HAVE_LIBSLANG
  SLang_Intrin_Var_Type Var_Table[] =
  {
    MAKE_VARIABLE("support_securetty",&CONF_support_securetty,
		  SLANG_INT_TYPE,0),
    MAKE_VARIABLE("set_path_env",&CONF_set_path_env,
		  SLANG_INT_TYPE,0),
    MAKE_VARIABLE("check_email",&CONF_check_email,
		  SLANG_INT_TYPE,0),
    MAKE_VARIABLE("speech_support",&CONF_speech_support,
		  SLANG_INT_TYPE,0),
    MAKE_VARIABLE("timeout",&CONF_timeout,
		  SLANG_INT_TYPE,0),
    SLANG_END_TABLE
  };
#endif

  /* 
   * PACKAGE and VERSION are defined via command line switch from the 
   * Makefile. To change them, edit configure.in (AM_INIT_AUTOMAKE)
   */
  set_intro_string("You're using " PACKAGE " " VERSION "\n"
                   "<http://francine.sourceforge.net/>\n\n");
  set_speech_device("/dev/speech");
  set_theme_dir("/usr/share/francine/default.theme");

#if HAVE_LIBSLANG
  /* initialize all slang functions */
  if (SLang_init_all() == -1)
    return;

  /* register all available hooks */
  SLang_load_string("define init_hook(){ }");
  SLang_load_string("define after_username_hook(){ }");
  SLang_load_string("define after_password_hook(){ }");
  SLang_load_string("define successful_hook(){ }");
  SLang_load_string("define failed_hook(){ }");

  /* register all intrinsic variables */
  SLadd_intrin_var_table(Var_Table,NULL);

  /* register all intrinsic functions */
  SLadd_intrinsic_function("set_intro_string",(FVOID_STAR)set_intro_string,
			   SLANG_VOID_TYPE,1,SLANG_STRING_TYPE);
  SLadd_intrinsic_function("set_speech_device",(FVOID_STAR)set_speech_device,
			   SLANG_VOID_TYPE,1,SLANG_STRING_TYPE);
  SLadd_intrinsic_function("set_theme_dir",(FVOID_STAR)set_theme_dir,
                           SLANG_VOID_TYPE,1,SLANG_STRING_TYPE);
  
  /* load the configuration */
  if (SLang_load_file("/etc/francine.sl") == -1)
    {
      SLang_restart(1);
      SLang_Error = 0;
      printf("Error while interpreting /etc/francine.sl. Please fix this.\n");
      sleep(10);
    }
#endif
}


void end_conf(void)
{
  if (CONF_speech_device!=NULL)
    free(CONF_speech_device);
  if (CONF_intro_string!=NULL)
    free(CONF_intro_string);
}


int get_timeout(void)
{
  return CONF_timeout;
}



void set_timeout(int val)
{
  CONF_timeout = val;
}



int get_speech_support(void)
{
  return CONF_speech_support;
}



void set_speech_support(int val)
{
  CONF_speech_support = val;
}



int get_set_path_env(void)
{
  return CONF_set_path_env;
}



void set_set_path_env(int val)
{
  CONF_set_path_env = val;
}



int get_check_email(void)
{
  return CONF_check_email;
}



void set_check_email(int val)
{
  CONF_check_email = val;
}



int get_support_securetty(void)
{
  return CONF_support_securetty;
}



void set_support_securetty(int val)
{
  CONF_support_securetty = val;
}



char * get_intro_string(void)
{
  return CONF_intro_string;
}



int set_intro_string(char * new_intro_string)
{
  /* reserve memory for the new intro string: */
  char * tmp = malloc(strlen(new_intro_string)+1);

  /* should the malloc() fail, we leave the intro string untouched: */
  if (tmp == NULL)
    return 0;

  /* free the old intro_string: */
  if (CONF_intro_string!=NULL)
    free(CONF_intro_string);

  /* copy new_intro_string to CONF_intro_string: */
  strcpy(tmp,new_intro_string);
  CONF_intro_string = tmp;

  /* success! */
  return 1;
}


  
char * get_speech_device(void)
{
  return CONF_speech_device;
}



int set_speech_device(char * new_speech_device)
{
  /* for comments, see set_intro_string() */
  char * tmp = malloc(strlen(new_speech_device)+1);

  if (tmp == NULL)
    return 0;

  if (CONF_speech_device!=NULL)
    free(CONF_speech_device);

  strcpy(tmp,new_speech_device);
  CONF_speech_device = tmp;

  return 1;
}


void call_init_hook(void)
{
#if HAVE_LIBSLANG
  SLang_load_string("init_hook();");
#endif
}

void call_after_username_hook(void)
{
#if HAVE_LIBSLANG
  SLang_load_string("after_username_hook();");
#endif
}

void call_after_password_hook(void)
{
#if HAVE_LIBSLANG 
  SLang_load_string("after_password_hook();");
#endif
}

void call_successful_hook(void)
{
#if HAVE_LIBSLANG
  SLang_load_string("successful_hook();");
#endif
}

void call_failed_hook(void)
{
#if HAVE_LIBSLANG
  SLang_load_string("failed_hook();");
#endif
}


int set_theme_dir(char * new_theme_dir)
{
 char * tmp = malloc(strlen(new_theme_dir)+1);

  if (tmp == NULL)
    return 0;

  if (CONF_theme_dir!=NULL)
    free(CONF_theme_dir);

  strcpy(tmp,new_theme_dir);
  CONF_theme_dir = tmp;

  return 1;
}

char * get_theme_dir(void)
{
  return CONF_theme_dir;
}

