# Generated by Django 3.2.19 on 2024-09-19 08:11

from django.db import migrations

from debusine.db.models.scopes import FALLBACK_SCOPE_NAME


def create_fallback_scope(apps, schema_editor):
    """Create the scope to use when migrating from scopeless models."""
    Scope = apps.get_model("db", "Scope")
    Scope.objects.create(name=FALLBACK_SCOPE_NAME)


def remove_fallback_scope(apps, schema_editor):
    Scope = apps.get_model("db", "Scope")
    Scope.objects.filter(name=FALLBACK_SCOPE_NAME).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('db', '0080_scope'),
    ]

    operations = [
        migrations.RunPython(create_fallback_scope, remove_fallback_scope)
    ]
