# Generated by Django 3.2.19 on 2024-02-23 15:11

import django.db.models.deletion
import django.db.models.expressions
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('db', '0016_worker_internal'),
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('name', models.CharField(max_length=255)),
                ('category', models.CharField(max_length=255)),
                (
                    'full_history_retention_period',
                    models.DurationField(blank=True, null=True),
                ),
                (
                    'metadata_only_retention_period',
                    models.DurationField(blank=True, null=True),
                ),
                ('data', models.JSONField(blank=True, default=dict)),
            ],
        ),
        migrations.CreateModel(
            name='CollectionItem',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('name', models.CharField(max_length=255)),
                (
                    'child_type',
                    models.CharField(
                        choices=[
                            ('b', 'Bare'),
                            ('a', 'Artifact'),
                            ('c', 'Collection'),
                        ],
                        max_length=1,
                    ),
                ),
                ('category', models.CharField(max_length=255)),
                ('data', models.JSONField(blank=True, default=dict)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('removed_at', models.DateTimeField(blank=True, null=True)),
                (
                    'artifact',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='collection_items',
                        to='db.artifact',
                    ),
                ),
                (
                    'collection',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='collection_items',
                        to='db.collection',
                    ),
                ),
                (
                    'created_by_user',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='user_created_collectionitem',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'parent_collection',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='child_items',
                        to='db.collection',
                    ),
                ),
                (
                    'removed_by_user',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='user_removed_collectionitem',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name='collection',
            name='child_artifacts',
            field=models.ManyToManyField(
                related_name='parent_collections',
                through='db.CollectionItem',
                to='db.Artifact',
            ),
        ),
        migrations.AddField(
            model_name='collection',
            name='child_collections',
            field=models.ManyToManyField(
                related_name='parent_collections',
                through='db.CollectionItem',
                to='db.Collection',
            ),
        ),
        migrations.AddField(
            model_name='collection',
            name='workspace',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to='db.workspace'
            ),
        ),
        migrations.AddConstraint(
            model_name='collectionitem',
            constraint=models.UniqueConstraint(
                condition=models.Q(('removed_at__isnull', True)),
                fields=('name', 'child_type', 'parent_collection'),
                name='unique_active_name_within_collectionitem',
            ),
        ),
        migrations.AddConstraint(
            model_name='collectionitem',
            constraint=models.CheckConstraint(
                check=models.Q(
                    (
                        'collection',
                        django.db.models.expressions.F('parent_collection'),
                    ),
                    _negated=True,
                ),
                name='collectionitem_parent_collection_cannot_be_same_as_collection',
            ),
        ),
        migrations.AddConstraint(
            model_name='collectionitem',
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        ('artifact__isnull', True),
                        ('child_type', 'b'),
                        ('collection__isnull', True),
                    ),
                    models.Q(
                        ('child_type', 'a'),
                        ('collection__isnull', True),
                        models.Q(
                            ('artifact__isnull', False),
                            ('removed_at__isnull', False),
                            _connector='OR',
                        ),
                    ),
                    models.Q(
                        ('artifact__isnull', True),
                        ('child_type', 'c'),
                        models.Q(
                            ('collection__isnull', False),
                            ('removed_at__isnull', False),
                            _connector='OR',
                        ),
                    ),
                    _connector='OR',
                ),
                name='collectionitem_type_removed_at_consistent',
            ),
        ),
        migrations.AddConstraint(
            model_name='collection',
            constraint=models.UniqueConstraint(
                fields=('name', 'category'), name='unique_name_category'
            ),
        ),
        migrations.AddConstraint(
            model_name='collection',
            constraint=models.CheckConstraint(
                check=models.Q(('name', ''), _negated=True),
                name='collection_name_not_empty',
            ),
        ),
        migrations.AddConstraint(
            model_name='collection',
            constraint=models.CheckConstraint(
                check=models.Q(('category', ''), _negated=True),
                name='collection_category_not_empty',
            ),
        ),
    ]
