'\"
'\" Generated from file 'critcl_pkg\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) Jean-Claude Wippler
'\" Copyright (c) Steve Landers
'\" Copyright (c) 2011-2018 Andreas Kupries
'\"
.TH "critcl" n 3\&.1\&.18 doc "C Runtime In Tcl (CriTcl)"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
critcl \- Critcl - Package Reference
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBcritcl  ?3\&.1\&.18?\fR
.sp
package require \fBplatform  ?1\&.0\&.2?\fR
.sp
package require \fBmd5  ?2?\fR
.sp
\fB::critcl::ccode\fR \fIfragment\fR
.sp
\fB::critcl::ccommand\fR \fItclname\fR \fIcname\fR
.sp
\fB::critcl::ccommand\fR \fItclname\fR \fIarguments\fR \fIbody\fR ?\fIoption\fR \fIvalue\fR\&.\&.\&.?
.sp
\fB::critcl::cdata\fR \fItclname\fR \fIdata\fR
.sp
\fB::critcl::cconst\fR \fItclname\fR \fIresulttype\fR \fIvalue\fR
.sp
\fB::critcl::cdefines\fR \fIlist of glob patterns\fR ?\fInamespace\fR?
.sp
\fB::critcl::cproc\fR \fIname\fR \fIarguments\fR \fIresulttype\fR \fIbody\fR ?\fIoption\fR \fIvalue\fR\&.\&.\&.?
.sp
\fB::critcl::cproc\fR \fIname\fR \fIarguments\fR \fIresulttype\fR
.sp
\fB::critcl::cinit\fR \fItext\fR \fIexternals\fR
.sp
\fB::critcl::include\fR \fIpath\fR
.sp
\fB::critcl::api\fR \fBimport\fR \fIname\fR \fIversion\fR
.sp
\fB::critcl::api\fR \fBfunction\fR \fIresulttype\fR \fIname\fR \fIarguments\fR
.sp
\fB::critcl::api\fR \fBheader\fR ?\fIglob pattern\fR\&.\&.\&.?
.sp
\fB::critcl::api\fR \fBextheader\fR ?\fIfile\fR\&.\&.\&.?
.sp
\fB::critcl::license\fR \fIauthor\fR ?\fItext\fR\&.\&.\&.?
.sp
\fB::critcl::summary\fR \fItext\fR
.sp
\fB::critcl::description\fR \fItext\fR
.sp
\fB::critcl::subject\fR ?\fIkey\fR\&.\&.\&.?
.sp
\fB::critcl::meta\fR \fIkey\fR ?\fIword\fR\&.\&.\&.?
.sp
\fB::critcl::meta?\fR \fIkey\fR
.sp
\fB::critcl::buildrequirement\fR \fIscript\fR
.sp
\fB::critcl::cheaders\fR ?\fIarg\fR\&.\&.\&.?
.sp
\fB::critcl::csources\fR ?\fIglob pattern\fR\&.\&.\&.?
.sp
\fB::critcl::clibraries\fR ?\fIglob pattern\fR\&.\&.\&.?
.sp
\fB::critcl::source\fR \fIglob pattern\fR
.sp
\fB::critcl::tsources\fR \fIglob pattern\fR\&.\&.\&.
.sp
\fB::critcl::owns\fR \fIglob pattern\fR\&.\&.\&.
.sp
\fB::critcl::cflags\fR ?\fIarg\fR\&.\&.\&.?
.sp
\fB::critcl::ldflags\fR ?\fIarg\fR\&.\&.\&.?
.sp
\fB::critcl::framework\fR ?\fIarg\fR\&.\&.\&.?
.sp
\fB::critcl::tcl\fR \fIversion\fR
.sp
\fB::critcl::tk\fR
.sp
\fB::critcl::preload\fR \fIlib\fR\&.\&.\&.
.sp
\fB::critcl::debug\fR \fIarea\fR\&.\&.\&.
.sp
\fB::critcl::check\fR ?\fIlabel\fR? \fItext\fR
.sp
\fB::critcl::checklink\fR ?\fIlabel\fR? \fItext\fR
.sp
\fB::critcl::msg\fR ?\fB-nonewline\fR? \fImsg\fR
.sp
\fB::critcl::print\fR ?\fB-nonewline\fR? ?\fIchan\fR? \fImsg\fR
.sp
\fB::critcl::compiled\fR
.sp
\fB::critcl::compiling\fR
.sp
\fB::critcl::done\fR
.sp
\fB::critcl::failed\fR
.sp
\fB::critcl::load\fR
.sp
\fB::critcl::config\fR \fIoption\fR ?\fIval\fR?
.sp
\fB::critcl::cache\fR ?path?
.sp
\fB::critcl::clean_cache\fR ?\fIpattern\fR\&.\&.\&.?
.sp
\fB::critcl::readconfig\fR \fIpath\fR
.sp
\fB::critcl::showconfig\fR ?\fIchan\fR?
.sp
\fB::critcl::showallconfig\fR ?\fIchan\fR?
.sp
\fB::critcl::chooseconfig\fR \fItarget\fR ?\fInomatcherr\fR?
.sp
\fB::critcl::setconfig\fR \fItarget\fR
.sp
\fB::critcl::actualtarget\fR
.sp
\fB::critcl::buildforpackage\fR ?\fIflag\fR?
.sp
\fB::critcl::cnothingtodo\fR \fIfile\fR
.sp
\fB::critcl::cresults\fR ?\fIfile\fR?
.sp
\fB::critcl::crosscheck\fR
.sp
\fB::critcl::error\fR \fImsg\fR
.sp
\fB::critcl::knowntargets\fR
.sp
\fB::critcl::sharedlibext\fR
.sp
\fB::critcl::targetconfig\fR
.sp
\fB::critcl::buildplatform\fR
.sp
\fB::critcl::targetplatform\fR
.sp
\fB::critcl::cobjects\fR ?\fIglob pattern\fR\&.\&.\&.?
.sp
\fB::critcl::scan\fR \fIpath\fR
.sp
\fB::critcl::name2c\fR \fIname\fR
.sp
\fB::critcl::argnames\fR \fIarguments\fR
.sp
\fB::critcl::argcnames\fR \fIarguments\fR
.sp
\fB::critcl::argcsignature\fR \fIarguments\fR
.sp
\fB::critcl::argvardecls\fR \fIarguments\fR
.sp
\fB::critcl::argconversion\fR \fIarguments\fR ?\fIn\fR?
.sp
\fB::critcl::argoptional\fR \fIarguments\fR
.sp
\fB::critcl::argdefaults\fR \fIarguments\fR
.sp
\fB::critcl::argsupport\fR \fIarguments\fR
.sp
\fB::critcl::userconfig\fR \fBdefine\fR \fIname\fR \fIdescription\fR \fItype\fR ?\fIdefault\fR?
.sp
\fB::critcl::userconfig\fR \fBquery\fR \fIname\fR
.sp
\fB::critcl::userconfig\fR \fBset\fR \fIname\fR \fIvalue\fR
.sp
\fB::critcl::at::caller\fR
.sp
\fB::critcl::at::caller\fR \fIoffset\fR
.sp
\fB::critcl::at::caller\fR \fIoffset\fR \fIlevel\fR
.sp
\fB::critcl::at::here\fR
.sp
\fB::critcl::at::get*\fR
.sp
\fB::critcl::at::get\fR
.sp
\fB::critcl::at::=\fR \fIfile\fR \fIline\fR
.sp
\fB::critcl::at::incr\fR \fIn\fR\&.\&.\&.
.sp
\fB::critcl::at::incrt\fR \fIstr\fR\&.\&.\&.
.sp
\fB::critcl::at::caller!\fR
.sp
\fB::critcl::at::caller!\fR \fIoffset\fR
.sp
\fB::critcl::at::caller!\fR \fIoffset\fR \fIlevel\fR
.sp
\fB::critcl::at::here!\fR
.sp
\fB::critcl::collect_begin\fR
.sp
\fB::critcl::collect_end\fR
.sp
\fB::critcl::collect\fR \fIscript\fR
.sp
\fB::critcl::make\fR \fIpath\fR \fIcontents\fR
.sp
\fB::critcl::has-resulttype\fR \fIname\fR
.sp
\fB::critcl::resulttype\fR \fIname\fR \fIbody\fR ?\fIctype\fR?
.sp
\fB::critcl::resulttype\fR \fIname\fR \fB=\fR \fIorigname\fR
.sp
\fB::critcl::has-argtype\fR \fIname\fR
.sp
\fB::critcl::argtype\fR \fIname\fR \fIbody\fR ?\fIctype\fR? ?\fIctypefun\fR?
.sp
\fB::critcl::argtype\fR \fIname\fR \fB=\fR \fIorigname\fR
.sp
\fB::critcl::argtypesupport\fR \fIname\fR \fIcode\fR ?\fIguard\fR?
.sp
\fB::critcl::argtyperelease\fR \fIname\fR \fIcode\fR
.sp
\fB::preload\fR \fIlibrary\fR
.sp
.BE
.SH DESCRIPTION
.PP
\fIC Runtime In Tcl\fR, or \fICriTcl\fR , is a system for compiling C code
embedded in Tcl on the fly and either loading the resulting objects into Tcl for
immediate use or packaging them for distribution\&.  Use \fICriTcl\fR to improve
performance by rewriting in C those routines that are performance bottlenecks\&.
.PP
The \fBcritcl\fR package is the core of the system\&.  For an overview of the
complete system, see \fIIntroduction To CriTcl\fR\&.  For the usage of the
standalone \fBcritcl\fR program, see \fICriTcl Application\fR\&.
This core package maybe be used to embed C code into Tcl scripts\&.  It also
provides access to the internals that other parts of the core use and which
are of interest to those wishing to understand the internal workings of the
core and of the API it provides to the \fICriTcl Application\fR\&.  These
advanced sections are marked as such so that those simply wishing to use the
package can skip them\&.
.PP
This package resides in the Core Package Layer of CriTcl\&.
.PP
.PS
.nf
+----------------+
|Applications    |
| critcl         |
| critcl::app    |
+----------------+

*================*
|Core Packages   |
| critcl         |
| critcl::util   |
*================*

+----------------+
|Support Packages|
| stubs::*       |
| md5, platform  |
|  \&.\&.\&.           |
+----------------+

.fi
.PE
.PP
.SH API
A short note ahead of the documentation: Instead of repeatedly talking
about
"a Tcl script with embbedded C code", or
"a Tcl script containing Critcl commands",
we call such a script a \fICritcl script\fR\&.  A file containing a
\fICritcl script\fR usually has the extension \fB\&.tcl\fR or \fB\&.critcl\fR\&.
.SS "EMBEDDED C CODE"
The following commands append C code fragments to the current module\&.  Fragments
appear in the module in the order they are appended, so the earlier fragments
(variables, functions, macros, etc\&.) are visible to later fragments\&.
.TP
\fB::critcl::ccode\fR \fIfragment\fR
Appends the C code in \fIfragment\fR to the current module and returns the
empty string\&.
See \fBRuntime Behaviour\fR\&.
.TP
\fB::critcl::ccommand\fR \fItclname\fR \fIcname\fR
As documented below, except that \fIcname\fR is the name of a C function
that already exists\&.
.TP
\fB::critcl::ccommand\fR \fItclname\fR \fIarguments\fR \fIbody\fR ?\fIoption\fR \fIvalue\fR\&.\&.\&.?
Appends the code to create a Tcl command named \fItclname\fR and a
corresponding C function whose body is \fIbody\fR and which behaves as
documented for Tcl's own
\fITcl_CreateObjCommand\fR [https://www\&.tcl-lang\&.org/man/tcl/TclLib/CrtObjCmd\&.htm]\&.
.sp
\fIaguments\fR is a list of zero to four names for the standard arguments
\fBclientdata\fR, \fBinterp\fR, \fBobjc\fR, and \fBobjv\fR\&.  The
standard default names are used in place of any missing names\&.
This is a more low-level way than \fBcritcl::cproc\fR to define a command, as
processing of the items in \fBobjv\fR is left to the author, affording
complete control over the handling of the arguments to the command\&.
See section \fBRuntime Behaviour\fR\&.
.sp
Returns the empty string\&.
.sp
Each \fIoption\fR may be one of:
.RS
.TP
\fB-clientdata\fR \fIc-expression\fR
Provides the client data for the new command\&.  \fBNULL\fR by default\&.
.TP
\fB-delproc\fR \fIc-expression\fR
Provides a function pointer of type \fITcl_CmdDeleteProc\fR [https://www\&.tcl-lang\&.org/man/tcl/TclLib/CrtObjCmd\&.htm] as the deletion function for the new command\&.  \fBNULL\fR by default\&.
.TP
\fB-cname\fR \fIboolean\fR
If \fBfalse\fR (the default), a name for the corresponding C function is
automatically derived from the fully-qualified \fItclname\fR\&.  Otherwise, name
of the C function is the last component of \fItclname\fR\&.
.RE
.TP
\fB::critcl::cdata\fR \fItclname\fR \fIdata\fR
Appends the code to create a new Tcl command named \fItclname\fR which returns
\fIdata\fR as a \fBByteArray\fR result\&.
.sp
Returns the empty string\&.
.TP
\fB::critcl::cconst\fR \fItclname\fR \fIresulttype\fR \fIvalue\fR
Appends the code to create a new Tcl command named \fItclname\fR which returns
the constant \fIvalue\fR having the Tcl type \fIresulttype\fR\&.  \fIvalue\fR can
be a C macro or a function \fIcall\fR (including the parentheses) to any
visible C function that does not take arguments\&.
Unlike \fBcritcl::cdata\fR, \fIresulttype\fR can be any type known to
\fBcritcl::cproc\fR\&.
Its semantics are equivalent to:
.CS


    cproc $tclname {} $resulttype "return $value ;"

.CE
.sp
This is more efficient than \fBcritcl::cproc\fR since there is no
C function generated\&.
.sp
Returns the empty string\&.
.TP
\fB::critcl::cdefines\fR \fIlist of glob patterns\fR ?\fInamespace\fR?
Arranges for \fIC enum\fR and \fI#define\fR values that match one of the
patterns in \fIglob patterns\fR to be created in the namespace
\fInamespace\fR, each variable having the same as the corresponding C item\&.
The default namespace is the global namespace\&.  A pattern that matches nothing
is ignored\&.
.sp
The Tcl variables are created when the module is compiled, using the
preprocessor in order to properly find all matching C definitions\&.
.sp
Produces no C code\&.  The desired C definitions must already exist\&.
.TP
\fB::critcl::cproc\fR \fIname\fR \fIarguments\fR \fIresulttype\fR \fIbody\fR ?\fIoption\fR \fIvalue\fR\&.\&.\&.?
Appends a function having \fIbody\fR as its body, another shim function to
perform the needed conversions, and the code to create a corresponding Tcl
command named \fItclname\fR\&.  Unlike \fBcritcl::ccommand\fR the arguments and
result are typed, and Critcl generates the code to convert between Tcl_Obj
values and C data types\&.
See also \fBRuntime Behaviour\fR\&.
.sp
Returns the empty string\&.
.sp
.RS
.TP
string \fIoption\fR
Each may be one of:
.RS
.TP
\fB-cname\fR \fIboolean\fR
If \fBfalse\fR (the default), a name for the corresponding C function is
automatically derived from the fully-qualified \fItclname\fR\&.  Otherwise, name
of the C function is the last component of \fItclname\fR\&.
.TP
\fB-pass-cdata\fR \fIboolean\fR
If \fBfalse\fR (the default), the shim function performing the conversion to
and from Tcl level does not pass the ClientData as the first argument to
the function\&.
.TP
\fB-arg-offset\fR \fIint\fR
A non-negative integer, \fB0\fR by default, indicating the number of hidden
arguments preceding the actual procedure arguments\&.  Used by higher-order code
generators where there are prefix arguments which are not directly seen by the
function but which influence argument counting and extraction\&.
.RE
.TP
string \fIresulttype\fR
May be one of the following predefined
types or a custom type\&.
For the latter see section \fBAdvanced: Extending cproc\fR\&.
Unless otherwise noted, the Tcl return code is always \fBTCL_OK\fR\&.
Before going into the details first a quick overview:
.CS


Critcl type   | C type         | Tcl type  | Notes
------------- | -------------- | --------- | ------------------------------
void          | n/a            | n/a       | Always OK\&. Body sets result
ok            | int            | n/a       | Result code\&. Body sets result
------------- | -------------- | --------- | ------------------------------
int           | int            | Int       |
boolean       |                |           | Alias of \fBint\fR above
bool          |                |           | Alias of \fBint\fR above
long          | long           | Long      |
wideint       | Tcl_WideInt    | WideInt   |
double        | double         | Double    |
float         | float          | Double    |
------------- | -------------- | --------- | ------------------------------
char*         | char*          | String    | \fIMakes a copy\fR
vstring       |                |           | Alias of \fBchar*\fR above
const char*   | const char*    |           | Behavior of \fBchar*\fR above
------------- | -------------- | --------- | ------------------------------
string        |                | String    | Freeable string set directly
              |                |           | \fINo copy is made\fR
dstring       |                |           | Alias of \fBstring\fR above
------------- | -------------- | --------- | ------------------------------
              |                |           | For all below: Null is ERROR
              |                |           | Body has to set any message
Tcl_Obj*      | Tcl_Obj*       | Any       | \fIrefcount --\fR
object        |                |           | Alias of \fBTcl_Obj*\fR above
Tcl_Obj*0     |                | Any       | \fIrefcount unchanged\fR
object0       |                |           | Alias of \fBTcl_Obj*0\fR above
------------- | -------------- | --------- | ------------------------------
known-channel | Tcl_Channel    | String    | Assumes to already be registered
new-channel   | Tcl_Channel    | String    | New channel, will be registered

.CE
.IP
And now the details:
.RS
.TP
Tcl_Obj*
.TP
object
If the returned \fBTcl_Obj*\fR is \fBNULL\fR, the Tcl return code
is \fBTCL_ERROR\fR and the function should \fIset an error mesage\fR [https://www\&.tcl-lang\&.org/man/tcl/TclLib/SetResult\&.htm]
as the interpreter result\&.  Otherwise, the returned \fBTcl_Obj*\fR is
set as the interpreter result\&.
.sp
Note that setting an error message requires the function body
to have access to the interpreter the function is running in\&. See the
argument type \fBTcl_Interp*\fR for the details on how to make that
happen\&.
.sp
Note further that the returned \fBTcl_Obj*\fR should have a
reference count greater than \fB0\fR\&. This is because the converter
decrements the reference count to release possession after setting the
interpreter result\&. It assumes that the function incremented the
reference count of the returned \fBTcl_Obj*\fR\&.
If a \fBTcl_Obj*\fR with a reference count of \fB0\fR were
returned, the reference count would become \fB1\fR when set as the
interpreter result, and immediately thereafter be decremented to
\fB0\fR again, causing the memory to be freed\&.  The system is then
likely to crash at some point after the return due to reuse of the
freed memory\&.
.TP
Tcl_Obj*0
.TP
object0
Like \fBTcl_Obj*\fR except that this conversion assumes that the
returned value has a reference count of \fB0\fR and
\fIdoes not\fR decrement it\&. Returning a value whose reference
count is greater than \fB0\fR is therefore likely to cause a memory
leak\&.
.sp
Note that setting an error message requires the function body
to have access to the interpreter the function is running in\&. See the
argument type \fBTcl_Interp*\fR for the details on how to make that
happen\&.
.TP
new-channel
A \fBString\fR Tcl_Obj holding the name of the returned
\fBTcl_Channel\fR is set as the interpreter result\&.
The channel is further assumed to be \fInew\fR, and therefore
registered with the interpreter to make it known\&.
.TP
known-channel
A \fBString\fR Tcl_Obj holding the name of the returned
\fBTcl_Channel\fR is set as the interpreter result\&.
The channel is further assumed to be \fIalready registered\fR
with the interpreter\&.
.TP
return-channel
This type is a variant of \fBnew-channel\fR above\&.
It varies slightly from it in the registration sequence to be properly
complementary to the argument type \fBtake-channel\fR\&.
A \fBString\fR Tcl_Obj holding the name of the returned
\fBTcl_Channel\fR is set as the interpreter result\&.
The channel is further assumed to be \fInew\fR, and therefore
registered with the interpreter to make it known\&.
.TP
char*
.TP
vstring
A \fBString\fR Tcl_Obj holding a \fIcopy\fR of the returned
\fBchar*\fR is set as the interpreter result\&. If the value is
allocated then the function itself and the extension it is a part of
are responsible for releasing the memory when the data is not in use
any longer\&.
.TP
const char*
Like \fBchar*\fR above, except that the returned string is
\fBconst\fR-qualified\&.
.TP
string
.TP
dstring
The returned \fBchar*\fR is directly set as the interpreter result
\fIwithout making a copy\fR\&.  Therefore it must be dynamically
allocated via \fBTcl_Alloc\fR\&. Release happens automatically when the
Interpreter finds that the value is not required any longer\&.
.TP
double
.TP
float
The returned \fBdouble\fR or \fBfloat\fR is converted to a \fBDouble\fR
Tcl_Obj and set as the interpreter result\&.
.TP
boolean
.TP
bool
The returned \fBint\fR value is converted to an \fBInt\fR Tcl_Obj and set as
the interpreter result\&.
.TP
int
The returned \fBint\fR value is converted to an \fBInt\fR Tcl_Obj and set as
the interpreter result\&.
.TP
long
The returned \fBlong int\fR value is converted to a \fBLong\fR Tcl_Obj and
set as the interpreter result\&.
.TP
wideint
The returned \fBTcl_WideInt\fR value is converted to a \fBWideInt\fR Tcl_Obj
and set as the interpreter result\&.
.TP
ok
The returned \fBint\fR value becomes the Tcl return code\&.
The interpreter result is left untouched and can be set by the
function if desired\&. Note that doing this requires the function body
to have access to the interpreter the function is running in\&. See the
argument type \fBTcl_Interp*\fR for the details on how to make that
happen\&.
.TP
void
The function does not return a value\&.
The interpreter result is left untouched and can be set by the function if
desired\&.
.RE
.TP
list \fIarguments\fR
Is a multi-dictionary where each key is an
argument type and its value is the argument name\&.
For example:
.CS

 int x int y
.CE
.sp
Each argument name must be a valid C identifier\&.
.sp
If the name is a list containing two items, the first item is the name
and the second item is the default value\&.  A limited form of variadic arguments
can be accomplished using such default values\&.
For example:
.CS

 int {x 1}
.CE
.IP
Here \fIx\fR is an optional argument of type \fBint\fR with a default
value of \fB1\fR\&.
.sp
Argument conversion is completely bypassed when the argument is not
provided, so a custom converter doing validation does not get the chance to
validate the default value\&.  In this case, the value should be checked in the
body of the function\&.
.sp
Each argument type may be one of the following predefined types or a
custom type\&. For the latter see \fBAdvanced: Extending cproc\fR\&.
Before going into the details first a quick overview:
.CS


Critcl type | C type         | Tcl type  | Notes
----------- | -------------- | --------- | ------------------------------
Tcl_Interp* | Tcl_Interp*    | n/a       | \fISpecial\fR, only first
----------- | -------------- | --------- | ------------------------------
Tcl_Obj*    | Tcl_Obj*       | Any       | \fIRead-only\fR
object      |                |           | Alias of \fBTcl_Obj*\fR above
list        | critcl_list    | List      | \fIRead-only\fR
----------- | -------------- | --------- | ------------------------------
char*       | const char*    | Any       | \fIRead-only\fR, \fIstring rep\fR
pstring     | critcl_pstring | Any       | \fIRead-only\fR
bytes       | critcl_bytes   | ByteArray | \fIRead-only\fR
----------- | -------------- | --------- | ------------------------------
int         | int            | Int       |
long        | long           | Long      |
wideint     | Tcl_WideInt    | WideInt   |
double      | double         | Double    |
float       | float          | Double    |
----------- | -------------- | --------- | ------------------------------
X > 0       |                |           | For X in \fBint\fR \&.\&.\&. \fBfloat\fR above\&.
X >= 0      |                |           | C types as per the base type X\&.
X < 0       |                |           | Allowed argument values are
X <= 0      |                |           | restricted as per the shown
X > 1       |                |           | relation
X >= 1      |                |           |
X < 1       |                |           | This is not a general mechanism
X <= 1      |                |           | open to other values\&. Only 0/1\&.
----------- | -------------- | --------- | ------------------------------
boolean     | int            | Boolean   |
bool        |                |           | Alias of \fBboolean\fR above
----------- | -------------- | --------- | ------------------------------
bytearray   |                |           | \fIDEPRECATED\fR
rawchar     |                |           | \fIDEPRECATED\fR
rawchar*    |                |           | \fIDEPRECATED\fR
double*     |                |           | \fIDEPRECATED\fR
float*      |                |           | \fIDEPRECATED\fR
int*        |                |           | \fIDEPRECATED\fR
void*       |                |           | \fIDEPRECATED\fR

.CE
.IP
And now the details:
.RS
.TP
Tcl_Interp*
\fIAttention\fR: This is a \fIspecial\fR argument type\&. It can
\fIonly\fR be used by the \fIfirst\fR argument of a function\&.
Any other argument using it will cause critcl to throw an error\&.
.sp
When used, the argument will contain a reference to the current
interpreter that the function body may use\&. Furthermore the argument
will \fInot\fR be an argument of the Tcl command for the function\&.
.sp
This is useful when the function has to do more than simply
returning a value\&. Examples would be setting up error messages on
failure, or querying the interpreter for variables and other data\&.
.TP
Tcl_Obj*
.TP
object
The function takes an argument of type \fBTcl_Obj*\fR\&.
No argument checking is done\&.
The Tcl level word is passed to the argument as-is\&.
Note that this value must be treated as \fIread-only\fR (except for
hidden changes to its intrep, i\&.e\&. \fIshimmering\fR)\&.
.TP
pstring
The function takes an argument of type \fBcritcl_pstring\fR
containing the original \fBTcl_Obj*\fR reference of the Tcl argument,
plus the length of the string and a pointer to the character array\&.
.CS


typedef struct critcl_pstring {
    Tcl_Obj*    o;
    const char* s;
    int         len;
} critcl_pstring;

.CE
.IP
Note the \fIconst\fR\&. The string is \fIread-only\fR\&. Any
modification can have arbitrary effects, from pulling out the rug
under the script because of string value and internal representation
not matching anymore, up to crashes anytime later\&.
.TP
list
The function takes an argument of type \fBcritcl_list\fR containing
the original \fBTcl_Obj*\fR reference of the Tcl argument, plus the
length of the Tcl list and a pointer to the array of the list
elements\&.
.CS


typedef struct critcl_list {
    Tcl_Obj*        o;
    Tcl_Obj* const* v;
    int             c;
} critcl_list;

.CE
.IP
The Tcl argument must be convertible to \fBList\fR, an error is
thrown otherwise\&.
.sp
Note the \fIconst\fR\&. The list is \fIread-only\fR\&.  Any
modification can have arbitrary effects, from pulling out the rug
under the script because of string value and internal representation
not matching anymore, up to crashes anytime later\&.
.TP
bytearray
.TP
rawchar*
.TP
rawchar
The function takes an argument of type \fBchar*\fR\&.
The Tcl argument must be convertible to \fBByteArray\fR, an error is
thrown otherwise\&.
\fINote\fR that the length of the \fBByteArray\fR is \fInot\fR
passed to the function, making this type not very usable\&.
.sp
\fIAttention\fR: These types are considered \fIDEPRECATED\fR\&.
It is planned to remove their documentation in release 3\&.2, and their
implementation in release 3\&.3\&.  Their deprecation can be undone if
good use cases are shown\&.
.TP
bytes
This is the \fInew\fR and usable \fBByteArray\fR type\&.
.sp
The function takes an argument of type \fBcritcl_bytes\fR
containing the original \fBTcl_Obj*\fR reference of the Tcl argument,
plus the length of the byte array and a pointer to the byte data\&.
.CS


typedef struct critcl_bytes {
    Tcl_Obj*             o;
    const unsigned char* s;
    int                len;
} critcl_list;

.CE
.IP
The Tcl argument must be convertible to \fBByteArray\fR, an error is
thrown otherwise\&.
.sp
Note the \fIconst\fR\&. The bytes are \fIread-only\fR\&.  Any
modification can have arbitrary effects, from pulling out the rug
under the script because of string value and internal representation
not matching anymore, up to crashes anytime later\&.
.TP
char*
The function takes an argument of type \fBconst char*\fR\&.
The string representation of the Tcl argument is passed in\&.
.sp
Note the \fIconst\fR\&. The string is \fIread-only\fR\&. Any
modification can have arbitrary effects, from pulling out the rug
under the script because of string value and internal representation
not matching anymore, up to crashes anytime later\&.
.TP
double
The function takes an argument of type \fBdouble\fR\&.
The Tcl argument must be convertible to \fBDouble\fR, an error is
thrown otherwise\&.
.TP
double > 0
.TP
double >= 0
.TP
double < 0
.TP
double <= 0
.TP
double > 1
.TP
double >= 1
.TP
double < 1
.TP
double <= 1
These are variants of \fIdouble\fR above, restricting the argument
value to the shown relation\&. An error is thrown for Tcl arguments
outside of the specified range\&.
\fINote:\fR This is not a general range specification syntax\&. Only
the listed types exist\&.
.TP
float
The function takes an argument of type \fBfloat\fR\&.
The Tcl argument must be convertible to \fBDouble\fR, an error is
thrown otherwise\&.
.TP
float > 0
.TP
float >= 0
.TP
float < 0
.TP
float <= 0
.TP
float > 1
.TP
float >= 1
.TP
float < 1
.TP
float <= 1
These are variants of \fIfloat\fR above, restricting the argument
value to the shown relation\&. An error is thrown for Tcl arguments
outside of the specified range\&.
\fINote:\fR This is not a general range specification syntax\&. Only
the listed types exist\&.
.TP
boolean
.TP
bool
The function takes an argument of type \fBint\fR\&.
The Tcl argument must be convertible to \fBBoolean\fR, an error is
thrown otherwise\&.
.TP
channel
The function takes an argument of type \fBTcl_Channel\fR\&.
The Tcl argument must be convertible to type \fBChannel\fR, an error
is thrown otherwise\&.
The channel is further assumed to be \fIalready registered\fR
with the interpreter\&.
.TP
unshared-channel
This type is an extension of \fBchannel\fR above\&.
All of the information above applies\&.
.sp
Beyond that the channel must not be shared by multiple
interpreters, an error is thrown otherwise\&.
.TP
take-channel
This type is an extension of \fBunshared-channel\fR above\&.
All of the information above applies\&.
.sp
Beyond that the code removes the channel from the current
interpreter without closing it, and disables all pre-existing event
handling for it\&.
.sp
With this the function takes full ownership of the channel in
question, taking it away from the interpreter invoking it\&. It is then
responsible for the lifecycle of the channel, up to and including
closing it\&.
.sp
Should the system the function is a part of wish to return
control of the channel back to the interpeter it then has to use the
result type \fBreturn-channel\fR\&. This will undo the registration
changes made by this argument type\&.
\fINote\fR however that the removal of pre-existing event handling
done here cannot be undone\&.
.sp
\fIAttention\fR Removal from the interpreter without closing
the channel is effected by incrementing the channel's reference count
without providing an interpreter, before decrementing the same for the
current interpreter\&. This leaves the overall reference count intact
without causing Tcl to close it when it is removed from the
interpreter structures\&. At this point the channel is effectively a
globally-owned part of the system not associated with any interpreter\&.
.sp
The complementary result type then runs this sequence in
reverse\&. And if the channel is never returned to Tcl either the
function or the system it is a part of have to unregister the global
reference when they are done with it\&.
.TP
int
The function takes an argument of type \fBint\fR\&.
The Tcl argument must be convertible to \fBInt\fR, an error is thrown
otherwise\&.
.TP
int > 0
.TP
int >= 0
.TP
int < 0
.TP
int <= 0
.TP
int > 1
.TP
int >= 1
.TP
int < 1
.TP
int <= 1
These are variants of \fIint\fR above, restricting the argument value
to the shown relation\&. An error is thrown for Tcl arguments outside of
the specified range\&.
\fINote:\fR This is not a general range specification syntax\&. Only
the listed types exist\&.
.TP
long
The function takes an argument of type \fBlong int\fR\&.
The Tcl argument must be convertible to \fBLong\fR, an error is
thrown otherwise\&.
.TP
long > 0
.TP
long >= 0
.TP
long < 0
.TP
long <= 0
.TP
long > 1
.TP
long >= 1
.TP
long < 1
.TP
long <= 1
These are variants of \fIlong\fR above, restricting the argument
value to the shown relation\&. An error is thrown for Tcl arguments
outside of the specified range\&.
\fINote:\fR This is not a general range specification syntax\&. Only
the listed types exist\&.
.TP
wideint
The function takes an argument of type \fBTcl_WideInt\fR\&.
The Tcl argument must be convertible to \fBWideInt\fR, an error is
thrown otherwise\&.
.TP
wideint > 0
.TP
wideint >= 0
.TP
wideint < 0
.TP
wideint <= 0
.TP
wideint > 1
.TP
wideint >= 1
.TP
wideint < 1
.TP
wideint <= 1
These are variants of \fIwideint\fR above, restricting the argument
value to the shown relation\&. An error is thrown for Tcl arguments
outside of the specified range\&.
\fINote:\fR This is not a general range specification syntax\&. Only
the listed types exist\&.
.TP
void*
.TP
double*
.TP
float*
.TP
int*
The function takes an argument of the same-named C type\&.
The Tcl argument must be convertible to ByteArray, an error is thrown
otherwise\&.
The bytes in the ByteArray are then re-interpreted as the raw
representation of a single C pointer of the given type which is then
passed as argument to the function\&.
In other words, this is for Tcl values somehow holding raw C pointers,
i\&.e\&. memory addresses\&.
.sp
\fIAttention\fR: These types are considered \fIDEPRECATED\fR\&.
It is planned to remove their documentation in release 3\&.2, and their
implementation in release 3\&.3\&.  Their deprecation can be undone if
good use cases are shown\&.
.RE
.RE
.TP
\fB::critcl::cproc\fR \fIname\fR \fIarguments\fR \fIresulttype\fR
As documented below, but used when the C function named \fIname\fR already
exists\&.
.TP
\fB::critcl::cinit\fR \fItext\fR \fIexternals\fR
Appends the C code in \fItext\fR and \fIexternals\fR, but only after all the
other fragments appended by the previously-listed commands regardless of their
placement in the \fICritcl script\fR relative to this command\&.  Thus, all
their content is visible\&.  See also \fBRuntime Behaviour\fR\&.
.sp
The C code in \fItext\fR is placed into the body of the initialization
function of the shared library backing the \fICritcl script\fR, and is
executed when this library is loaded into the interpreter\&.  It has access to
the variable \fBTcl_Interp* interp\fR referencing the Tcl interpreter currently
being initialized\&.
.sp
\fIexternals\fR is placed outside and just before the initialization
function, making it a good place for any external symbols required by
initialization function, but which should not be accessible by any other parts
of the C code\&.
.sp
Calls to this command are cumulative\&.
.sp
Returns the empty string\&.
.TP
\fB::critcl::include\fR \fIpath\fR
This command is a convenient shorthand for
.CS


critcl::code {
  #include <${path}>
}

.CE
.PP
.SS "STUBS TABLE MANAGEMENT"
Critcl versions 3 and later provide \fBcritcl::api\fR to create and manipulate
stubs tables, Tcl's dynamic linking mechanism handling the resolution of
symbols between C extensions\&.
See \fIhttp://wiki\&.tcl-lang\&.org/285\fR
for an introduction, and section \fBStubs Tables\fR
for the details of Critcl's particular variant\&.
.PP
Importing stubs tables, i\&.e\&. APIs, from another extension:
.TP
\fB::critcl::api\fR \fBimport\fR \fIname\fR \fIversion\fR
Adds the following include directives into the \fICritcl script\fR
\fIand\fR each of its companion "\fI\&.c\fR" files:
.RS
.IP [1]
#include <\fBname\fR/\fBname\fRDecls\&.h>
.IP [2]
#include <\fBname\fR/\fBname\fRStubLib\&.h>
.RE
.IP
Returns an error if "\fI\fBname\fR\fR" isn't in the search path for the
compiler\&.  See \fBcritcl::cheaders\fR and the critcl application's \fB-I\fR
and \fB-includedir\fR options\&.
.sp
\fIImportant:\fR If \fBname\fR is a fully-qualified name in a
non-global namespace, e\&.g\&.
"c::stack", the namespace separators "::" are converted into underscores
("_") in path names, C code, etc\&.
.sp
\fBname\fR/\fBname\fRDecls\&.h contains the stubs table type declarations,
mapping macros, etc\&., and may include package-specific headers\&.  See
\fBcritcl::api header\fR, below\&.  An \fI#include\fR directive is added at
the beginning of the generated code for \fICritcl script\fR and at the
beginning of each of its companion "\fI\&.c\fR" files\&.
.sp
\fBname\fR/\fBname\fRStubLib\&.h contains the stubs table variable
definition and the function to initialize it\&.  An \fI#include\fR directive
for it is added to the initialization code for the \fICritcl script\fR ,
along with a call to the initializer function\&.
.sp
If "\fI\fBname\fR/\fBname\fR\&.decls\fR" accompanies
\fBname\fR/\fBname\fRDecls\&.h, it should contain the external representation of
the stubs table used to generate the headers\&. The file is read and the internal
representation of the stubs table returned for use by the importing package\&.
Otherwise, the empy string is returned\&.
.sp
One possible use would be the automatic generation of C code
calling on the functions listed in the imported API\&.
.sp
When generating a TEA package the names of the imported APIs
are used to declare \fBconfigure\fR options with which the user can
declare a non-standard directory for the headers of the API\&. Any API
\fBname\fR is translated into a single configure option
\fB--with-\fBname\fR-include\fR\&.
.PP
.PP
Declaration and export of a stubs table, i\&.e\&. API, for
the \fICritcl script\fR:
.TP
\fB::critcl::api\fR \fBfunction\fR \fIresulttype\fR \fIname\fR \fIarguments\fR
Adds to the public API of the \fICritcl script\fR the signature
for the function named \fIname\fR and having the signature specified by
\fIarguments\fR and \fIresulttype\fR\&.  Code is generated for a "\fI\&.decls\fR"
file, the corresponding public headers, and a stubs table usable by
\fBcritcl::api import\fR\&.
.sp
\fIarguments\fR is a multidict where each key is an argument type and its
value is the argument name, and \fIresulttype\fR is a C type\&.
.TP
\fB::critcl::api\fR \fBheader\fR ?\fIglob pattern\fR\&.\&.\&.?
Each file matching a \fIglob pattern\fR is copied into the directory
containing the generated headers, and an \fI#include\fR directive for it is
added to "\fIDecls\&.h\fR" for the \fICritcl script\fR\&.
Returns an error if a \fIglob pattern\fR matches nothing\&.
.sp
A pattern for a relative path is resolved relative to the directory
containing the \fICritcl script\fR\&.
.TP
\fB::critcl::api\fR \fBextheader\fR ?\fIfile\fR\&.\&.\&.?
Like \fB::critcl::api header\fR, but each \fIfile\fR should exist in the
external development environment\&.  An \fI#include\fR directive is added to
"\fI\fBfoo\fRDecls\&.h\fR", but \fIfile\fR is not copied to the package header
directory\&. \fIfile\fR is not a glob pattern as Critcl has no context,
i\&.e directory, in which to expand such patterns\&.
.PP
As with the headers for an imported API, an \fI#include\fR directive is
added to the generated code for the \fICritcl script\fR and to
each companion "\fI\&.c\fR" file\&.
.PP
In "compile & run" mode the generated header files and any companion
headers are placed in the \fBResult Cache\fR subdirectory for the
\fICritcl script\fR\&. This directory is added to the include search path of
any other package importing this API and and building in mode "compile & run"\&.
.PP
In "generate package" mode \fB-includedir\fR specifies the
subdirectory in the package to place the generated headers in\&. This
directory is added to the search paths for header files, ensuring that a
package importing an API finds it if the package exporting that API used the
same setting for \fB-includedir\fR\&.
.PP
In "generate TEA" mode the static scanner recognizes
\fBcritcl::api header\fR as a source of companion files\&.
It also uses data from calls to \fBcritcl::api import\fR to
add support for \fB--with-\fBfoo\fR-include\fR options into the
generated "\fIconfigure(\&.in)\fR" so that a user may specify custom
locations for the headers of any imported API\&.
.SS "PACKAGE META DATA"
Critcl versions 3 and later can create TEApot meta-data to be placed into
"\fIteapot\&.txt\fR" in a format suitable for use by the
\fITEApot tools\fR [http://docs\&.activestate\&.com/activetcl/8\&.5/tpm/toc\&.html]\&.
.PP
In version 2, some meta data support was already present through
\fB::critcl::license\fR, but this was only used to generate "\fIlicense\&.txt\fR"\&.
.TP
\fB::critcl::license\fR \fIauthor\fR ?\fItext\fR\&.\&.\&.?
Ignored in "compile & run" mode\&.
.sp
In "generate package" mode provides information about the author of the
package and the license for the package\&.
.sp
\fItext\fR arguments are concatenated to form the text of the license, which is
written to "\fIlicense\&.terms\fR" in the same directory as "\fIpkgIndex\&.tcl\fR"\&.
If no \fItext\fR is provided the license is read from "\fIlicense\&.terms\fR"
in the same directory as the \fICritcl script\fR\&.
.sp
This information takes precedence over any information specified through
the generic API \fB::critcl::meta\fR\&.  It is additionally placed
into the meta data file "\fIteapot\&.txt\fR" under the keys \fIas::author\fR and
\fIlicense\fR\&.
.TP
\fB::critcl::summary\fR \fItext\fR
Ignored in "compile & run" mode\&.
.sp
In "generate package" mode places a short, preferably one-line description of
the package into the meta data file "\fIteapot\&.txt\fR" under the key
\fIsummary\fR\&.  This information takes precedence over information specified
through the generic API \fB::critcl::meta\fR\&.
.TP
\fB::critcl::description\fR \fItext\fR
Ignored in "compile & run" mode\&.
.sp
In "generate package" mode places a longer description of the package into the
meta data file "\fIteapot\&.txt\fR", under the key \fIdescription\fR\&.  The data
specified by this command takes precedence over any information specified
through the generic API \fB::critcl::meta\fR\&.
.TP
\fB::critcl::subject\fR ?\fIkey\fR\&.\&.\&.?
Ignored in "compile & run" mode\&.
.sp
In "generate package" mode places each \fIkey\fR into the meta data file
"\fIteapot\&.txt\fR", under the key \fIsubject\fR\&.  This information takes
precedence over any information specified through the generic API
\fB::critcl::meta\fR\&.
.sp
Calls to this command are cumulative\&.
.TP
\fB::critcl::meta\fR \fIkey\fR ?\fIword\fR\&.\&.\&.?
Provides arbitrary meta data outside of the following reserved keys:
\fIas::author\fR,
\fIas::build::date\fR,
\fIdescription\fR,
\fIlicense\fR,
\fIname\fR,
\fIplatform\fR,
\fIrequire\fR
\fIsubject\fR,
\fIsummary\fR, and
\fIversion\fR,
Its behaviour is like \fB::critcl::subject\fR in that it treats all
keys as list of words, with each call providing one or more words for
the key, and multiple calls extending the data for an existing key, if
not reserved\&.
.sp
While it is possible to declare information for one of the
reserved keys with this command such data is ignored when the final
meta data is assembled and written\&.
.sp
Use the commands
\fB::critcl::license\fR,
\fB::critcl::summary\fR,
\fB::critcl::description\fR
\fB::critcl::subject\fR,
\fBpackage require\fR, and
\fBpackage provide\fR
to declare data for the reserved keys\&.
.sp
The information for the reserved keys
\fIas::build::date\fR and
\fIplatform\fR
is automatically generated by \fBcritcl\fR itself\&.
.TP
\fB::critcl::meta?\fR \fIkey\fR
Returns the value in the metadata associated with \fIkey\fR\&.
.sp
Used primarily to retrieve the name of the package
from within utility packages having to adapt C code templates to their
environment\&. For example, \fBcritcl::class\fR uses does this\&.
.TP
\fB::critcl::buildrequirement\fR \fIscript\fR
Provides control over the capturing of dependencies declared via
\fBpackage require\fR\&. \fIscript\fR is evaluated and any dependencies
declared within are ignored, i\&.e\&. not recorded in the meta data\&.
.PP
.SS "CONTROL & INTERFACE"
These commands control the details of compilation and linking a
\fICritcl script\fR\&.  The information is used only to compile/link the
object for the \fICritcl script\fR\&.  For example, information for
"\fIFOO\&.tcl\fR" is kept separate from information for "\fIBAR\&.tcl\fR"\&.
.TP
\fB::critcl::cheaders\fR ?\fIarg\fR\&.\&.\&.?
Provides additional header locations\&.
.sp
Each argument is a glob pattern\&.  If an argument begins with \fB-\fR
it is an argument to the compiler\&.  Otherwise the parent directory of each
matching path is a directory to be searched for header files\&.  Returns an
error if a pattern matches no files\&.
A pattern for a relative path is resolved relative to the directory
containing the \fICritcl script\fR\&.
.sp
\fB#include\fR lines are not automatically generated for matching
header files\&.  Use \fBcritcl::include\fR or \fBcritcl::ccode\fR as necessary to
add them\&.
.sp
Calls to this command are cumulative\&.
.TP
\fB::critcl::csources\fR ?\fIglob pattern\fR\&.\&.\&.?
Matching paths become inputs to the compilation of the current object
along with the sources for the current \fICritcl script\fR\&.  Returns an
error if no paths match a pattern\&.
A pattern for a relative path is resolved relative to the directory
containing the \fICritcl script\fR\&.
.sp
Calls to this command are cumulative\&.
.TP
\fB::critcl::clibraries\fR ?\fIglob pattern\fR\&.\&.\&.?
provides the link step with additional libraries and library locations\&.
A \fIglob pattern\fR that begins with \fB-\fR is added as an argument to
the linker\&.  Otherwise matching files are linked into the shared library\&.
Returns an error if no paths match a pattern\&.
A pattern for a relative path is resolved relative to the directory
containing the \fICritcl script\fR\&.
.sp
Calls to this command are cumulative\&.
.TP
\fB::critcl::source\fR \fIglob pattern\fR
Evaluates as scripts the files matching each \fIglob pattern\fR\&.  Returns an
error if there are no matching files\&.
A pattern for a relative path is resolved relative to the directory
containing the \fICritcl script\fR\&.
.TP
\fB::critcl::tsources\fR \fIglob pattern\fR\&.\&.\&.
Provides the information about additional Tcl script files to source when the
shared library is loaded\&.
.sp
Matching paths are made available to the generated shared library when
it is loaded for the current \fICritcl script\fR\&.  Returns an error if a
pattern matches no files\&.
A pattern for a relative path is resolved relative to the directory
containing the \fICritcl script\fR\&.
.sp
Calls to this command are cumulative\&.
.sp
After the shared library has been loaded, the declared files are sourced
in the same order that they were provided as arguments\&.
.TP
\fB::critcl::owns\fR \fIglob pattern\fR\&.\&.\&.
Ignored in "compile and run" and "generate package" modes\&.
In "generate TEA" mode each file matching a \fIglob pattern\fR is a file to
be included in the TEA extension but that could not be ascertained as such from
previous commands like \fBcritcl::csources\fR and \fBcritcl::tsources\fR,
either because of they were specified dynamically or because they were directly
sourced\&.
.TP
\fB::critcl::cflags\fR ?\fIarg\fR\&.\&.\&.?
.sp
Each \fIarg\fR is an argument to the compiler\&.
.sp
Calls to this command are cumulative\&.
.TP
\fB::critcl::ldflags\fR ?\fIarg\fR\&.\&.\&.?
.sp
Each \fIarg\fR is an argument to the linker\&.
.sp
Calls to this command are cumulative\&.
.TP
\fB::critcl::framework\fR ?\fIarg\fR\&.\&.\&.?
Each \fIarg\fR is the name of a framework to link on MacOS X\&.  This command is
ignored if OS X is not the target so that frameworks can be specified
unconditionally\&.
.sp
Calls to this command are cumulative\&.
.TP
\fB::critcl::tcl\fR \fIversion\fR
Specifies the minimum version of the Tcl runtime
to compile and link the package for\&.  The default is \fB8\&.4\fR\&.
.TP
\fB::critcl::tk\fR
Arranges to include the Tk headers and link to the Tk stubs\&.
.TP
\fB::critcl::preload\fR \fIlib\fR\&.\&.\&.
Arranges for the external shared library \fIlib\fR to be loaded
before the shared library for the \fICritcl script\fR is loaded\&.
.sp
Calls to this command are cumulative\&.
.sp
Each library \fIFOO\fR is searched for in the directories listed below, in the order
listed\&.  The search stops at the first existing path\&.
Additional notes:
.RS
.IP \(bu
\fBplatform\fR is the placeholder for the target platform of the package\&.
.IP \(bu
The extension "\fI\&.so\fR" is the placeholder for whatever actual extension is used by the target platform for its shared libraries\&.
.IP \(bu
The search is relative to the current working directory\&.
.RE
.IP
And now the paths, depending on the exact form of the library name:
.RS
.TP
FOO
.RS
.IP [1]
FOO\&.so
.IP [2]
FOO/FOO\&.so
.IP [3]
FOO/\fBplatform\fR/FOO\&.so
.RE
.TP
PATH/FOO
The exact set searched depends on the existence of
directory "\fIPATH/FOO\fR"\&. If it exists, critcl searches
.RS
.IP [1]
FOO\&.so
.IP [2]
PATH/FOO/FOO\&.so
.IP [3]
PATH/FOO/\fBplatform\fR/FOO\&.so
.RE
.IP
Otherwise it searches
.RS
.IP [1]
FOO\&.so
.IP [2]
PATH/FOO\&.so
.IP [3]
PATH/\fBplatform\fR/FOO\&.so
.RE
.IP
instead\&.
.TP
/PATH/FOO
Even when specifying FOO with an absolute path the first path searched
is relative to the current working directory\&.
.RS
.IP [1]
FOO\&.so
.IP [2]
/PATH/FOO\&.so
.IP [3]
/PATH/\fBplatform\fR/FOO\&.so
.RE
.RE
.IP
For developers who want to understand or modify the internals of the
\fBcritcl\fR package, \fBPreloading functionality\fR explains how
preloading is implemented\&.
.TP
\fB::critcl::debug\fR \fIarea\fR\&.\&.\&.
Specifies what debugging features to activate\&. Internally each area is translated into
area-specific flags for the compiler which are then handed over to
\fBcritcl::cflags\fR\&.
.RS
.TP
\fBmemory\fR
Specifies Tcl memory debugging\&.
.TP
\fBsymbols\fR
Specifies compilation and linking with debugging symbols for use by a debugger
or other tool\&.
.TP
\fBall\fR
Specifies all available debugging\&.
.RE
.PP
.SS INTROSPECTION
The following commands control compilation and linking\&.
.TP
\fB::critcl::check\fR ?\fIlabel\fR? \fItext\fR
Returns a \fBtrue\fR if the C code in \fItext\fR compiles sucessfully, and
\fBfalse\fR otherwise\&.  Used to check for availability of features in the
build environment\&.
If provided, \fIlabel\fR is used to uniquely mark the results in the generated
log\&.
.TP
\fB::critcl::checklink\fR ?\fIlabel\fR? \fItext\fR
Like \fBcritcl::check\fR but also links the compiled objects, returning
\fBtrue\fR if the link is successful and \fBfalse\fR otherwise\&.
If specified, \fIlabel\fR is used to uniquely mark the results in the generated
log\&.
.TP
\fB::critcl::msg\fR ?\fB-nonewline\fR? \fImsg\fR
Scripts using \fBcritcl::check\fR and \fBcritcl::checklink\fR can use this
command to report results\&.  Does nothing in \fIcompile & run\fR mode\&.  Tools
like the \fICriTcl Aplication\fR may redefine this command to implement
their own message reporting\&. For example, \fBcritcl::app\fR and any
packages built on it print messages to \fIstdout\fR\&.
.TP
\fB::critcl::print\fR ?\fB-nonewline\fR? ?\fIchan\fR? \fImsg\fR
Used by the Critcl internals to report activity\&.  By default, effectively the
same thing as \fB::puts\fR\&.  Tools directly using either the Critcl package or
the Critcl application package may redefine this procedure to implement their
own output functionality\&.
.sp
For example, the newest revisions of
\fIKettle\fR [https://chiselapp\&.com/user/andreas_kupries/repository/Kettle/index]
use this to highlight build warnings\&.
.TP
\fB::critcl::compiled\fR
Returns \fBtrue\fR if the current \fICritcl script\fR is already compiled
and \fBfalse\fR otherwise\&.
.sp
Enables a \fICritcl script\fR used as its own Tcl companion file (see
\fBcritcl::tsources\fR) to distinguish between being sourced for compilation in
\fIcompile & run\fR mode and being sourced from either the result of
\fIgenerate package\fR mode or during the load phase of
\fIcompile & run\fR mode\&.
The result is \fBfalse\fR in the first case and \fBtrue\fR in the later two
cases\&.
.TP
\fB::critcl::compiling\fR
Returns \fBtrue\fR if a working C compiler is available and \fBfalse\fR
otherwise\&.
.TP
\fB::critcl::done\fR
Returns \fBtrue\fR when \fICritcl script\fR has been built and
\fBfalse\fR otherwise\&.  Only useful from within a \fICritcl script\fR\&.
Enables the Tcl parts of a \fICritcl script\fR to distinguish between
\fIprebuilt package\fR mode and \fIcompile & run\fR mode\&.
.sp
See also \fBModes Of Operation/Use\fR\&.
.TP
\fB::critcl::failed\fR
Returns \fBtrue\fR if the \fICritcl script\fR could not be built, and
\fBfalse\fR otherwise\&.  Forces the building of the package if it hasn't
already been done, but not its loading\&.  Thus, a \fICritcl script\fR can
check itself for availability of the compiled components\&.  Only useful from
within a \fICritcl script\fR\&.
.TP
\fB::critcl::load\fR
Like \fBcritcl::failed\fR except that it also forces the loading of the
generated shared library, and that it returns \fBtrue\fR on success and
\fBfalse\fR on failure\&.  Thus, a \fICritcl script\fR can check itself for
availability of the compiled components\&.  Only useful from within a
\fICritcl script\fR\&.
.PP
.SS "BUILD MANAGEMENT"
The following command manages global settings, i\&.e\&. configuration options which
are independent of any \fICritcl script\fR\&.
.PP
This command should not be needed to write a \fICritcl script\fR\&. It is
a management command which is only useful to the \fICriTcl Application\fR
or similar tools\&.
.TP
\fB::critcl::config\fR \fIoption\fR ?\fIval\fR?
Sets and returns the following global configuration options:
.RS
.TP
\fBforce\fR bool
When \fBfalse\fR (the default), the C files are not built if there is a
cached shared library\&.
.TP
\fBlines\fR bool
When \fBtrue\fR (the default), #line directives are embedded into the
generated C code\&.
.sp
This facility requires the use of a tclsh that provides
\fBinfo frame\fR\&.  Otherwise, no \fI#line\fR directives are emitted\&. The
command is supported by Tcl 8\&.5 and higher\&. It is also supported by
Tcl 8\&.4 provided that it was compiled with the define
\fB-DTCL_TIP280\fR\&. An example of such is ActiveState's ActiveTcl\&.
.sp
Developers of higher-level packages generating their own C
code, either directly or indirectly through critcl, should
also read section \fBAdvanced: Location management\fR to see how
critcl helps them in generating their directives\&.
Examples of such packages come with critcl itself\&. See
\fBcritcl::iassoc\fR and \fBcritcl::class\fR\&.
.TP
\fBtrace\fR bool
When \fBfalse\fR (the default), no code tracing the entry and exit of
Critcl-backed commands in the \fICritcl script\fR is inserted\&.  Insertion of
such code implicitly activates the tracing facility in general\&.  See
\fBcritcl::cutil\fR\&.
.TP
\fBI\fR path
A single global include path to use for all files\&. Not set by default\&.
.TP
\fBcombine\fR enum
.RS
.TP
\fBdynamic\fR (the default)
Object files have the suffix \fB_pic\fR\&.
.TP
\fBstatic\fR
Object files have the suffix \fB_stub\fR\&.
.TP
\fBstandalone\fR
Object files have no suffix, and the generated C files are compiled
without using Tcl/Tk stubs\&. The result are object files usable for
static linking into a \fIbig shell\fR\&.
.RE
.TP
\fBlanguage\fR string
.TP
\fBkeepsrc\fR bool
When \fBfalse\fR (the default), the generated "\fI\&.c\fR"
files are deleted after the "\fI\&.o\fR" files have been built\&.
.TP
\fBoutdir\fR directory
The directory where to place a generated shared library\&. By default, it is
placed into the \fBResult Cache\fR\&.
.RE
.PP
.SS "RESULT CACHE MANAGEMENT"
The following commands control the \fBResult Cache\fR\&.
These commands are not needed to simply write a \fICritcl script\fR\&.
.TP
\fB::critcl::cache\fR ?path?
Sets and returns the path to the directory for the package's result cache\&.
.sp
The default location is
"\fI~/\&.critcl/[platform::generic]\fR" and usually does not
require any changes\&.
.TP
\fB::critcl::clean_cache\fR ?\fIpattern\fR\&.\&.\&.?
Cleans the result cache, i\&.e\&. removes any and all files
and directories in it\&. If one or more patterns are specified then only
the files and directories matching them are removed\&.
.PP
.SS "BUILD CONFIGURATION"
The following commands manage the build configuration, i\&.e\&. the per-platform
information about compilers, linkers, and their commandline options\&.
These commands are not needed to simply write a \fICritcl script\fR\&.
.TP
\fB::critcl::readconfig\fR \fIpath\fR
Reads the build configuration file at \fIpath\fR and configures the package
using the information for the target platform\&.
.TP
\fB::critcl::showconfig\fR ?\fIchan\fR?
Converts the active build configuration into a human-readable string and
returns it, or if \fIchan\fR is provided prints the result to that channel\&.
.TP
\fB::critcl::showallconfig\fR ?\fIchan\fR?
Converts the set of all known build configurations from the currently active
build configuration file last set with \fBcritcl::readconfig\fR into a string
and returns it, or if \fIchan\fR is provided, prints it to that channel\&.
.TP
\fB::critcl::chooseconfig\fR \fItarget\fR ?\fInomatcherr\fR?
Matches \fItarget\fR against all known targets, returning a list containing
all the matching ones\&. This search is first done on an exact basis, and then
via glob matching\&. If no known target matches the argument the default is to
return an empty list\&. However, if the boolean \fInomatcherr\fR is specified and
set an error is thrown using \fBcritcl::error\fR instead\&.
.TP
\fB::critcl::setconfig\fR \fItarget\fR
Configures the package to use the settings of \fItarget\fR\&.
.PP
.SS "TOOL API"
The following commands provide tools like
\fICriTcl Application\fR or similar with
deeper access to the package's internals\&.
These commands are not needed to simply write a \fICritcl script\fR\&.
.TP
\fB::critcl::actualtarget\fR
Returns the platform identifier for the target platform, i\&.e\&. the platform to
build for\&. Unlike \fB::critcl::targetplatform\fR this is the true target, with
any cross-compilation information resolved\&.
.TP
\fB::critcl::buildforpackage\fR ?\fIflag\fR?
Signals whether the next file is to be built for inclusion into a package\&. If
not specified the \fIflag\fR defaults to \fBtrue\fR, i\&.e\&. building for a
package\&. This disables a number of things in the backend, namely the linking of
that file into a shared library and the loading of that library\&. It is expected
that the build results are later wrapped into a larger collection\&.
.TP
\fB::critcl::cnothingtodo\fR \fIfile\fR
Checks whether there is anything to build for \fIfile\fR\&.
.TP
\fB::critcl::cresults\fR ?\fIfile\fR?
Returns information about building \fIfile\fR, or \fBinfo script\fR If
\fIfile\fR is not provided\&.
The result in question is a dictionary containing the following items:
.RS
.TP
\fBclibraries\fR
A list of external shared libraries and/or directories needed to link
\fIfile\fR\&.
.TP
\fBldflags\fR
A list of linker flags needed to link \fIfile\fR\&.
.TP
\fBlicense\fR
The text of the license for the package \fIfile\fR is located in\&.
.TP
\fBmintcl\fR
The minimum version of Tcl required by the package \fIfile\fR
is in to run successfully\&. A proper Tcl version number\&.
.TP
\fBobjects\fR
A list of object files to link into \fIfile\fR\&.
.TP
\fBpreload\fR
A list of libraries to be preloaded in order to sucessfully load and use
\fIfile\fR\&.
.TP
\fBtk\fR
\fBtrue\fR if \fIfile\fR requires Tk and \fBfalse\fR otherwise\&.
.TP
\fBtsources\fR
A list of companion "\fI\&.tcl\fR" files to source in order to load and use the
\fICritcl script\fR \fIfile\fR\&.
.TP
\fBlog\fR
The full build log generated by the compiler/linker, including command
line data from critcl, and other things\&.
.TP
\fBexl\fR
The raw build log generated by the compiler/linker\&. Contains the output
generated by the invoked applications\&.
.RE
.TP
\fB::critcl::crosscheck\fR
Determines whether the package is configured for cross-compilation and prints a
message to the standard error channel if so\&.
.TP
\fB::critcl::error\fR \fImsg\fR
Used to report internal errors\&. The default implementation simply returns the
error\&.  Tools like the \fICriTcl Application\fR are allowed to redefine
this procedure to perform their own way of error reporting\&. There is
one constraint they are not allowed to change: The procedure must
\fInot return\fR to the caller\&.
.TP
\fB::critcl::knowntargets\fR
Returns a list of the identifiers of all targets
found during the last invocation of \fBcritcl::readconfig\fR\&.
.TP
\fB::critcl::sharedlibext\fR
Returns the file extension for shared libraries on the target platform\&.
.TP
\fB::critcl::targetconfig\fR
Returns the identifier of the target to build for, as specified by either the
user or the system\&.
.TP
\fB::critcl::buildplatform\fR
Returns the identifier of the build platform, i\&.e\&. where the package is running
on\&.
.TP
\fB::critcl::targetplatform\fR
Returns the identifier of the target platform,
i\&.e\&. the platform to compile for\&. In contrast to
\fB::critcl::actualtarget\fR this may be the name of a
cross-compilation target\&.
.TP
\fB::critcl::cobjects\fR ?\fIglob pattern\fR\&.\&.\&.?
Like \fB::critcl::clibraries\fR, but instead of matching libraries, each
\fIglob pattern\fR matches object files to be linked into the
shared object (at compile time, not runtime)\&. If a \fIglob pattern\fR matches
nothing an error is returned\&.
Not listed in \fBControl & Interface\fR because it is of no use to
package writers\&. Only tools like the \fICriTcl Application\fR need it\&.
.sp
A pattern for a relative path is resolved relative to the directory
containing the \fICritcl script\fR\&.
.sp
Calls to this command are cumulative\&.
.TP
\fB::critcl::scan\fR \fIpath\fR
The main entry point to Critcl's static code scanner\&.  Used by tools to
implement processing modes like the assembly of a directory hierarchy
containing a TEA-lookalike buildystem, etc\&.
.sp
Scans \fIpath\fR and returns a dictionary containing the following items:
.RS
.TP
version
Package version\&.
.TP
org
Author(ing organization)\&.
.TP
files
List of the companion files, relative to the directory of the input
file\&.
.RE
.TP
\fB::critcl::name2c\fR \fIname\fR
Given the Tcl-level identifier \fIname\fR, returns a list containing the
following details of its conversion to C:
.RS
.IP \(bu
Tcl namespace prefix
.IP \(bu
C namespace prefix
.IP \(bu
Tcl base name
.IP \(bu
C base name
.RE
.sp
For use by utilities that provide Tcl commands without going through
standard commands like \fBcritcl::ccommand\fR or \fBcritcl::cproc\fR\&.
\fBcritcl::class\fR does this\&.
.PP
.SS "ADVANCED: EMBEDDED C CODE"
For advanced use, the following commands used by \fBcritcl::cproc\fR itself are
exposed\&.
.TP
\fB::critcl::argnames\fR \fIarguments\fR
Given an argument declaration as documented for \fBcritcl::cproc\fR, returns a list of the corresponding user-visible names\&.
.TP
\fB::critcl::argcnames\fR \fIarguments\fR
Given an argument declaration as documented for \fBcritcl::cproc\fR, returns a list of the corresponding C variable names for the
user-visible names\&. The names returned here match the names used in the
declarations and code returned by \fB::critcl::argvardecls\fR and
\fB::critcl::argconversion\fR\&.
.TP
\fB::critcl::argcsignature\fR \fIarguments\fR
Given an argument declaration as documented for \fBcritcl::cproc\fR, returns a list of the corresponding C parameter declarations\&.
.TP
\fB::critcl::argvardecls\fR \fIarguments\fR
Given an argument declaration as documented for \fBcritcl::cproc\fR, returns a list of the corresponding C variable declarations\&.
The names used in these declarations match the names returned by
\fB::critcl::argcnames\fR\&.
.TP
\fB::critcl::argconversion\fR \fIarguments\fR ?\fIn\fR?
Given an argument declaration as documented for \fBcritcl::cproc\fR, returns a list of C code fragments converting the user visible
arguments found in the declaration from Tcl_Obj* to C types\&. The names used in
these statements match the names returned by \fB::critcl::argcnames\fR\&.
.sp
The generated code assumes that the procedure arguments start
at index \fIn\fR of the \fBobjv\fR array\&.  The default is \fB1\fR\&.
.TP
\fB::critcl::argoptional\fR \fIarguments\fR
Given an argument declaration as documented for \fBcritcl::cproc\fR, returns a list of boolean values indicating which arguments
are optional (\fBtrue\fR), and which are not (\fBfalse\fR)\&.
.TP
\fB::critcl::argdefaults\fR \fIarguments\fR
Given an argument declaration as documented for \fBcritcl::cproc\fR, returns a list containing the default values for all optional
arguments\&.
.TP
\fB::critcl::argsupport\fR \fIarguments\fR
Given an argument declaration as documented for \fBcritcl::cproc\fR, returns a list of C code fragments needed to define the
necessary supporting types\&.
.PP
.SS "CUSTOM BUILD CONFIGURATION"
This package provides one command for the management of
package-specific, i\&.e\&. developer-specified custom build configuration
options\&.
.TP
\fB::critcl::userconfig\fR \fBdefine\fR \fIname\fR \fIdescription\fR \fItype\fR ?\fIdefault\fR?
This command defines custom build configuration option, with
\fIdescription\fR, \fItype\fR and optional \fIdefault\fR value\&.
.sp
The type can be either \fBbool\fR, or a list of values\&.
.RS
.IP [1]
For \fBbool\fR the default value, if specified, must be a
boolean\&. If it is not specified it defaults to \fBtrue\fR\&.
.IP [2]
For a list of values the default value, if specified, must be a
value found in this list\&. If it is not specified it defaults to the
first value of the list\&.
.RE
.sp
The \fIdescription\fR serves as in-code documentation of the
meaning of the option and is otherwise ignored\&. When generating a TEA
wrapper the description is used for the \fBconfigure\fR option
derived from the option declared by the command\&.
.sp
A boolean option \fBFOO\fR are translated into a pair of
configure options, \fB--enable-\fBFOO\fR\fR and
\fB--disable-\fBFOO\fR\fR, whereas an option whose \fItype\fR is a
list of values is translated into a single configure option
\fB--with-\fBFOO\fR\fR\&.
.TP
\fB::critcl::userconfig\fR \fBquery\fR \fIname\fR
This command queries the database of custom build configuration option
for the current "\fI\&.critcl\fR" file and returns the chosen value\&.
This may be the default if no value was set via
\fB::critcl::userconfig set\fR\&.
.sp
It is at this point that definitions and set values are brought
together, with the latter validated against the definition\&.
.TP
\fB::critcl::userconfig\fR \fBset\fR \fIname\fR \fIvalue\fR
This command is for use by a tool, like the \fBcritcl\fR application,
to specify values for custom build configuration options\&.
.sp
At the time this command is used only the association between
option name and value is recorded, and nothing else is done\&. This
behaviour is necessary as the system may not know if an option of the
specified name exists when the command is invoked, nor its type\&.
.sp
Any and all validation is defered to when the value of an
option is asked for via \fB::critcl::userconfig query\fR\&.
.sp
This means that it is possible to set values for any option we
like, and the value will take effect only if such an option is both
defined and used later on\&.
.PP
.SS "ADVANCED: LOCATION MANAGEMENT"
First a small introduction for whose asking themselves
\'what is location management' ?
.PP
By default critcl embeds \fI#line\fR directives into the
generated C code so that any errors, warnings and notes found by the C
compiler during compilation will refer to the "\fI\&.critcl\fR" file the
faulty code comes from, instead of the generated "\fI\&.c\fR" file\&.
.PP
This facility requires the use of a tclsh that provides
\fBinfo frame\fR\&.  Otherwise, no \fI#line\fR directives are emitted\&. The
command is supported by Tcl 8\&.5 and higher\&. It is also supported by
Tcl 8\&.4 provided that it was compiled with the define
\fB-DTCL_TIP280\fR\&. An example of such is ActiveState's ActiveTcl\&.
.PP
Most users will not care about this feature beyond simply
wanting it to work and getting proper code references when reading
compiler output\&.
.PP
Developers of higher-level packages generating their own C code
however should care about this, to ensure that their generated code
contains proper references as well\&. Especially as this is key to
separating bugs concerning code generated by the package itself and
bug in the user's code going into the package, if any\&.
.PP
Examples of such packages come with critcl itself, see the
implementation of packages \fBcritcl::iassoc\fR and
\fBcritcl::class\fR\&.
.PP
To help such developers eight commands are provided to manage
such \fIlocation\fR information\&. These are listed below\&.
.PP
A main concept is that they all operate on a single
\fIstored location\fR, setting, returning and clearing it\&.
Note that this location information is completely independent of the
generation of \fI#line\fR directives within critcl itself\&.
.TP
\fB::critcl::at::caller\fR
This command stores the location of the caller of the current
procedure as a tuple of file name and linenumber\&. Any previously
stored location is overwritten\&.
The result of the command is the empty string\&.
.TP
\fB::critcl::at::caller\fR \fIoffset\fR
As above, the stored line number is modified by the specified
offset\&. In essence an implicit call of \fBcritcl::at::incr\fR\&.
.TP
\fB::critcl::at::caller\fR \fIoffset\fR \fIlevel\fR
As above, but the level the location information is taken from is
modified as well\&. Level \fB0\fR is the caller, \fB-1\fR its
caller, etc\&.
.TP
\fB::critcl::at::here\fR
This command stores the current location in the current procedure as a
tuple of file name and linenumber\&. Any previously stored location is
overwritten\&.
The result of the command is the empty string\&.
.sp
In terms of \fB::critcl::at::caller\fR this is equivalent to
.CS


	critcl::at::caller 0 1

.CE
.TP
\fB::critcl::at::get*\fR
This command takes the stored location and returns a formatted
\fI#line\fR directive ready for embedding into some C code\&. The
stored location is left untouched\&.
Note that the directive contains its own closing newline\&.
.sp
For proper nesting and use it is recommended that such
directives are always added to the beginning of a code fragment\&. This
way, should deeper layers add their own directives these will come
before ours and thus be inactive\&. End result is that the outermost
layer generating a directive will 'win', i\&.e\&. have its directive
used\&. As it should be\&.
.TP
\fB::critcl::at::get\fR
This command is like the above, except that it also clears the stored
location\&.
.TP
\fB::critcl::at::=\fR \fIfile\fR \fIline\fR
This command allows the caller to set the stored location to anything
they want, outside of critcl's control\&.
The result of the command is the empty string\&.
.TP
\fB::critcl::at::incr\fR \fIn\fR\&.\&.\&.
.TP
\fB::critcl::at::incrt\fR \fIstr\fR\&.\&.\&.
These commands allow the user to modify the line number of the stored
location, changing it incrementally\&. The increment is specified as
either a series of integer numbers (\fBincr\fR), or a series of
strings to consider (\fBincrt\fR)\&. In case of the latter the delta is
the number of lines endings found in the strings\&.
.TP
\fB::critcl::at::caller!\fR
.TP
\fB::critcl::at::caller!\fR \fIoffset\fR
.TP
\fB::critcl::at::caller!\fR \fIoffset\fR \fIlevel\fR
.TP
\fB::critcl::at::here!\fR
These are convenience commands combining \fBcaller\fR and \fBhere\fR
with \fBget\fR\&. I\&.e\&. they store the location and immediately return it
formatted as proper \fI#line\fR directive\&. Also note that after their
use the stored location is cleared\&.
.PP
.SS "ADVANCED: DIVERSIONS"
Diversions are for higher-level packages generating their own C code,
to make their use of critcl's commands generating
\fBEmbedded C Code\fR easier\&.
.PP
These commands normally generate all of their C code for the
current "\fI\&.critcl\fR" file, which may not be what is wanted by a
higher-level package\&.
.PP
With a diversion the generator output can be redirected into
memory and from there on then handled and processed as the caller
desires before it is committed to an actual "\fI\&.c\fR" file\&.
.PP
An example of such a package comes with critcl itself, see the
implementation of package \fBcritcl::class\fR\&.
.PP
To help such developers three commands are provided to manage
diversions and the collection of C code in memory\&. These are:
.TP
\fB::critcl::collect_begin\fR
This command starts the diversion of C code collection into memory\&.
.sp
The result of the command is the empty string\&.
.sp
Multiple calls are allowed, with each call opening a new
nesting level of diversion\&.
.TP
\fB::critcl::collect_end\fR
This command end the diversion of C code collection into memory and
returns the collected C code\&.
.sp
If multiple levels of diversion are open the call only closes
and returns the data from the last level\&.
.sp
The command will throw an error if no diversion is active,
indicating a mismatch in the pairing of \fBcollect_begin\fR and
\fBcollect_end\fR\&.
.TP
\fB::critcl::collect\fR \fIscript\fR
This is a convenience command which runs the \fIscript\fR under
diversion and returns the collected C code, ensuring the correct
pairing of \fBcollect_begin\fR and \fBcollect_end\fR\&.
.PP
.SS "ADVANCED: FILE GENERATION"
While file generation is related to the diversions explained in the
previous section they are not the same\&.
Even so, like diversions this feature is for higher-level packages
generating their own C code\&.
.PP
Three examples of utility packages using this facility comes
with critcl itself\&.
See the implementations of packages \fBcritcl::literals\fR,
\fBcritcl::bitmap\fR, and \fBcritcl::enum\fR\&.
.PP
When splitting a package implementation into pieces it is often
sensible to have a number of pure C companion files containing
low-level code, yet these files may require information about the code
in the main "\fI\&.critcl\fR" file\&. Such declarations are normally not
exportable and using the stub table support does not make sense, as
this is completely internal to the package\&.
.PP
With the file generation command below the main "\fI\&.critcl\fR"
file can generate any number of header files for the C companions to
pick up\&.
.TP
\fB::critcl::make\fR \fIpath\fR \fIcontents\fR
This command creates the file \fIpath\fR in a location where the C
companion files of the package are able to pick it up by simple
inclusion of \fIpath\fR during their compilation, without interfering
with the outer system at all\&.
.sp
The generated file will contain the specified \fIcontents\fR\&.
.PP
.SS "ADVANCED: EXTENDING CPROC"
While the \fBcritcl::cproc\fR command understands the most common C
types (see section \fBEmbedded C Code\fR), sometimes this is not
enough\&.
.PP
To get around this limitation the commands in this section
enable users of \fBcritcl\fR to extend the set of argument and
result types understood by \fBcritcl::cproc\fR\&. In other words, they
allow them to define their own, custom, types\&.
.TP
\fB::critcl::has-resulttype\fR \fIname\fR
This command tests if the named result-type is known or not\&.
It returns a boolean value, \fBtrue\fR if the type is known and
\fBfalse\fR otherwise\&.
.TP
\fB::critcl::resulttype\fR \fIname\fR \fIbody\fR ?\fIctype\fR?
This command defines the result type \fIname\fR, and associates it
with the C code doing the conversion (\fIbody\fR) from C to Tcl\&.
The C return type of the associated function, also the C type of the
result variable, is \fIctype\fR\&. This type defaults to \fIname\fR if
it is not specified\&.
.sp
If \fIname\fR is already declared an error is thrown\&.
\fIAttention!\fR The standard result type \fBvoid\fR is special as
it has no accompanying result variable\&. This cannot be expressed
by this extension command\&.
.sp
The \fIbody\fR's responsibility is the conversion of the
functions result into a Tcl result and a Tcl status\&. The first has to
be set into the interpreter we are in, and the second has to be
returned\&.
.sp
The C code of \fIbody\fR is guaranteed to be called last in the
wrapper around the actual implementation of the \fBcproc\fR in
question and has access to the following environment:
.RS
.TP
\fBinterp\fR
A Tcl_Interp* typed C variable referencing the
interpreter the result has to be stored into\&.
.TP
\fBrv\fR
The C variable holding the result to convert, of type
\fIctype\fR\&.
.RE
.IP
As examples here are the definitions of two standard result types:
.CS


    resulttype int {
	Tcl_SetObjResult(interp, Tcl_NewIntObj(rv));
	return TCL_OK;
    }

    resulttype ok {
	/* interp result must be set by cproc body */
	return rv;
    } int

.CE
.TP
\fB::critcl::resulttype\fR \fIname\fR \fB=\fR \fIorigname\fR
This form of the \fBresulttype\fR command declares \fIname\fR as an
alias of result type \fIorigname\fR, which has to be defined
already\&. If this is not the case an error is thrown\&.
.TP
\fB::critcl::has-argtype\fR \fIname\fR
This command tests if the named argument-type is known or not\&.
It returns a boolean value, \fBtrue\fR if the type is known and
\fBfalse\fR otherwise\&.
.TP
\fB::critcl::argtype\fR \fIname\fR \fIbody\fR ?\fIctype\fR? ?\fIctypefun\fR?
This command defines the argument type \fIname\fR, and associates it
with the C code doing the conversion (\fIbody\fR) from Tcl to C\&.
\fIctype\fR is the C type of the variable to hold the conversion result
and \fIctypefun\fR is the type of the function argument itself\&.
Both types default to \fIname\fR if they are the empty string or are not
provided\&.
.sp
If \fIname\fR is already declared an error is thrown\&.
.sp
\fIbody\fR is a C code fragment that converts a Tcl_Obj* into a
C value which is stored in a helper variable in the underlying function\&.
.sp
\fIbody\fR is called inside its own code block to isolate local
variables, and the following items are in scope:
.RS
.TP
\fBinterp\fR
A variable of type \fBTcl_Interp*\fR which is the
interpreter the code is running in\&.
.TP
\fB@@\fR
A placeholder for an expression that evaluates to the
\fBTcl_Obj*\fR to convert\&.
.TP
\fB@A\fR
A placeholder for the name of the variable to store the
converted argument into\&.
.RE
.IP
As examples, here are the definitions of two standard argument types:
.CS


    argtype int {
	if (Tcl_GetIntFromObj(interp, @@, &@A) != TCL_OK) return TCL_ERROR;
    }

    argtype float {
	double t;
	if (Tcl_GetDoubleFromObj(interp, @@, &t) != TCL_OK) return TCL_ERROR;
	@A = (float) t;
    }

.CE
.TP
\fB::critcl::argtype\fR \fIname\fR \fB=\fR \fIorigname\fR
This form of the \fBargtype\fR command declares \fIname\fR as an alias
of argument type \fIorigname\fR, which has to be defined already\&. If
this is not the case an error is thrown\&.
.TP
\fB::critcl::argtypesupport\fR \fIname\fR \fIcode\fR ?\fIguard\fR?
This command defines a C code fragment for the already defined
argument type \fIname\fR which is inserted before all functions
using that type\&. Its purpose is the definition of any supporting C
types needed by the argument type\&.
If the type is used by many functions the system ensures that only the
first of the multiple insertions of the code fragment is active, and
the others disabled\&.
The guard identifier is normally derived from \fIname\fR, but can also
be set explicitly, via \fIguard\fR\&. This latter allows different
custom types to share a common support structure without having to
perform their own guarding\&.
.TP
\fB::critcl::argtyperelease\fR \fIname\fR \fIcode\fR
This command defines a C code fragment for the already defined
argument type \fIname\fR which is inserted whenever the worker
function of a \fBcritcl::cproc\fR returns to the shim\&. It is the
responsibility of this fragment to unconditionally release any
resources the \fBcritcl::argtype\fR conversion code allocated\&.
An example of this are the \fIvariadic\fR types for the support of
the special, variadic \fIargs\fR argument to \fBcritcl::cproc\fR's\&.
They allocate a C array for the collected arguments which has to be
released when the worker returns\&. This command defines the C code
for doing that\&.
.PP
.SH CONCEPTS
.SS "MODES OF OPERATION/USE"
CriTcl can be used in three different modes of operation, called
.IP [1]
\fICompile & Run\fR, and
.IP [2]
\fIGenerate Package\fR
.IP [3]
\fIGenerate TEA Package\fR
.PP
\fICompile & Run\fR was the original mode and is the default for
\fIcritcl_pkg\fR\&.  Collects the C fragments from the
\fICritcl script\fR, builds them as needed, and caches the results to
improve load times later\&.
.PP
The second mode, \fIGenerate Package\fR, was introduced to enable
the creation of (prebuilt) deliverable packages which do not depend on
the existence of a build system, i\&.e\&. C compiler, on the target
machine\&.
This was originally done through the experimental \fBCritbind\fR tool,
and is now handled by the \fICriTcl Application\fR, also named
\fBcritcl\fR\&.
.PP
Newly introduced with Critcl version 3 is
\fIGenerate TEA Package\fR\&. This mode constructs a directory
hierarchy from the package which can later be built like a regular TEA
package, i\&.e\&. using
.CS


	\&.\&.\&./configure --prefix \&.\&.\&.
	make all isntall

.CE
.PP
Regarding the caching of results please read the section about
the \fBResult Cache\fR fore more details\&.
.SS "RUNTIME BEHAVIOUR"
The default behaviour of critcl, the package is to defer the
compilation, linking, and loading of any C code as much as possible,
given that this is an expensive operation, mainly in the time
required\&.
In other words, the C code embedded into a "\fI\&.critcl\fR" file is
built only when the first C command or procedure it provides is
invoked\&.
This part of the system uses standard functionality built into the Tcl
core, i\&.e\&. the \fBauto_index\fR variable to map from commands to
scripts providing them and the \fBunknown\fR command using this
information when the command is needed\&.
.PP
A \fIlimitation\fR of this behaviour is that it is not
possible to just use \fBinfo commands\fR check for the existence of
a critcl defined command\&. It is also necessary to search in the
\fBauto_index\fR array, in case it has not been build yet\&.
.PP
This behaviour can be changed by using the control command
\fBcritcl::load\fR\&. When invoked, the building, including loading of
the result, is forced\&. After this command has been invoked for a
"\fI\&.critcl\fR" file further definition of C code in this file is not
allowed any longer\&.
.SS "FILE MAPPING"
Each "\fI\&.critcl\fR" file is backed by a single private "\fI\&.c\fR" file
containing that code, plus the boilerplate necessary for its
compilation and linking as a single shared library\&.
.PP
The \fBEmbedded C Code\fR
fragments appear in that file in the exact same order they were
defined in the "\fI\&.critcl\fR" file, with one exception\&. The C code
provided via \fBcritcl::cinit\fR is put after all other fragments\&.
In other words all fragments have access to the symbols defined by
earlier fragments, and the \fBcritcl::cinit\fR fragment has access to
all, regardless of its placement in the "\fI\&.critcl\fR" file\&.
.PP
Note: A \fIlimitation\fR of the current system is the near
impossibility of C level access between different critcl-based
packages\&. The issue is not the necessity of writing and sharing the
proper \fBextern\fR statements, but that the management (export and
import) of package-specific stubs-tables is not supported\&. This means
that dependent parts have to be forcibly loaded before their user,
with all that entails\&. See section \fBRuntime Behaviour\fR for
the relevant critcl limitation, and remember that many older platforms
do not support the necessary resolution of symbols, the reason why
stubs were invented for Tcl in the first place\&.
.SS "RESULT CACHE"
The compilation of C code is time-consuming \fBcritcl\fR not only
defers it as much as possible, as described in section
\fBRuntime Behaviour\fR, but also caches the results\&.
.PP
This means that on the first use of a "\fI\&.critcl\fR" file
"\fIFOO\&.tcl\fR" the resulting object file and shared library are saved
into the cache, and on future uses of the same file reused,
i\&.e\&. loaded directly without requiring compilation, provided that the
contents of "\fIFOO\&.tcl\fR" did not change\&.
.PP
The change detection is based MD5 hashes\&. A single hash is
computed for each "\fI\&.critcl\fR" file, based on hashes for all C code
fragments and configuration options, i\&.e\&. everything which affects the
resulting binary\&.
.PP
As long as the input file doesn't change as per the hash a
previously built shared library found in the cache is reused,
bypassing the compilation and link stages\&.
.PP
The command to manage the cache are found in section
\fBResult Cache Management\fR\&.
Note however that they are useful only to tools based on the package,
like the \fICriTcl Application\fR\&. Package writers have no need
of them\&.
.PP
As a last note, the default directory for the cache is chosen
based on the chosen build target\&. This means that the cache can be put
on a shared (network) filesystem without having to fear interference
between machines of different architectures\&.
.SS "PRELOADING FUNCTIONALITY"
The audience of this section are developers wishing to understand
and possibly modify the internals of critcl package and application\&.
Package writers can skip this section\&.
.PP
It explains how the preloading of external libraries is realized\&.
.PP
Whenever a package declares libraries for preloading critcl will build
a supporting shared library providing a Tcl package named "preload"\&.
This package is not distributed separately, but as part of the package
requiring the preload functionality\&.
This support package exports a single Tcl command
.TP
\fB::preload\fR \fIlibrary\fR
which is invoked once per libraries to preload, with the absolute path
of that \fIlibrary\fR\&. The command then loads the \fIlibrary\fR\&.
.sp
On windows the command will further use the Tcl command
\fB::critcl::runtime::precopy\fR to copy the \fIlibrary\fR to the
disk, should its path be in a virtual filesystem which doesn't
directly support the loading of a shared library from it\&.
.PP
The command \fB::critcl::runtime::precopy\fR is provided by the file
"\fIcritcl-rt\&.tcl\fR" in the generated package, as is the command
\fB::critcl::runtime::loadlib\fR which generates the
\fIifneeded script\fR expected by Tcl's package management\&. This
generated ifneeded script contains the invocations of \fB::preload\fR\&.
.PP
The C code for the supporting library is found in the file
"\fIcritcl_c/preload\&.c\fR", which is part of the \fBcritcl\fR
package\&.
.PP
The Tcl code for the supporting runtime "\fIcritcl-rt\&.tcl\fR" is found
in the file "\fIruntime\&.tcl\fR", which is part of the
\fBcritcl::app\fR package\&.
.SS "CONFIGURATION INTERNALS"
The audience of this section are developers wishing to understand
and possibly modify the internals of critcl package and application\&.
Package writers can skip this section\&.
.PP
It explains the syntax of configuration files and the configuration
keys used by \fBcritcl\fR to configure its build backend, i\&.e\&. how
this part of the system accesses compiler, linker, etc\&.
.PP
It is recommended to open the file containing the standard
configurations ("\fIpath/to/critcl/Config\fR") in the editor of your
choice when reading this section of the documentation, using it as an
extended set of examples going beyond the simple defaults shown here\&.
.PP
First, the keys and the meaning of their values, plus examples drawn
from the standard configurations distributed with the package\&.
Note that when writing a custom configuration it is not necessary to
specify all the keys listed below, but only those whose default values
are wrong or insufficient for the platform in question\&.
.TP
version
The command to print the compiler version number\&.
Defaults to
.CS

 gcc -v
.CE
.TP
compile
The command to compile a single C source file to an object file\&.
Defaults to
.CS

 gcc -c -fPIC
.CE
.TP
debug_memory
The list of flags for the compiler to enable memory debugging in
Tcl\&.
Defaults to
.CS

 -DTCL_MEM_DEBUG
.CE
.TP
debug_symbols
The list of flags for the compiler to add symbols to the object files
and the resulting library\&.
Defaults to
.CS

 -g
.CE
.TP
include
The compiler flag to add an include directory\&.
Defaults to
.CS

 -I
.CE
.TP
tclstubs
The compiler flag to set USE_TCL_STUBS\&.
Defaults to
.CS

 -DUSE_TCL_STUBS
.CE
.TP
tkstubs
The compiler flag to set USE_TK_STUBS\&.
Defaults to
.CS

 -DUSE_TK_STUBS
.CE
.TP
threadflags
The list of compiler flags to enable a threaded build\&.
Defaults to
.CS


    -DUSE_THREAD_ALLOC=1 -D_REENTRANT=1 -D_THREAD_SAFE=1
    -DHAVE_PTHREAD_ATTR_SETSTACKSIZE=1 -DHAVE_READDIR_R=1
    -DTCL_THREADS=1

.CE
.IP\&.
.TP
noassert
The compiler flag to turn off assertions in Tcl code\&.
Defaults to
.CS

 -DNDEBUG
.CE
.TP
optimize
The compiler flag to specify optimization level\&.
Defaults to
.CS

 -O2
.CE
.TP
output
The compiler flags to set the output file of a compilation\&.
Defaults to
.CS

 -o [list $outfile]
.CE
.sp
\fINOTE\fR the use of Tcl commands and variables here\&.  At the
time \fBcritcl\fR uses the value of this key the value of the
referenced variable is substituted into it\&. The named variable is the
only variable whose value is defined for this substitution\&.
.TP
object
The file extension for object files on the platform\&.
Defaults to
.CS

 \&.o
.CE
.TP
preproc_define
The command to preprocess a C source file without compiling it, but
leaving #define's in the output\&. Defaults to
.CS

 gcc -E -dM
.CE
.TP
preproc_enum
See \fBpreproc_define\fR, except that #define's are not left in the
output\&. Defaults to
.CS

 gcc -E
.CE
.TP
link
The command to link one or more object files and create a shared
library\&. Defaults to
.CS

 gcc -shared
.CE
.TP
link_preload
The list of linker flags to use when dependent libraries are
pre-loaded\&. Defaults to
.CS

 --unresolved-symbols=ignore-in-shared-libs
.CE
.TP
strip
The flag to tell the linker to strip symbols from the shared library\&.
Defaults to
.CS

 -Wl,-s
.CE
.TP
ldoutput
Like \fBoutput\fR, but for the linker\&.
Defaults to the value of \fBoutput\fR\&.
.TP
link_debug
The list of linker flags needed to build a shared library with
symbols\&. Defaults to the empty string\&.
One platform requiring this are all variants of Windows, which uses
.CS

 -debug:full -debugtype:cv
.CE
.TP
link_release
The list of linker flags needed to build a shared library without
symbols, i\&.e\&. a regular build\&. Defaults to the empty string\&.
One platform requiring this are all variants of Windows, which uses
.CS

 -release -opt:ref -opt:icf,3 -ws:aggressive
.CE
.TP
sharedlibext
The file extension for shared library files on the platform\&.
Defaults to
.CS

 [info sharedlibextension]
.CE
.TP
platform
The identifier of the platform used in generated packages\&.
Defaults to
.CS

 [platform::generic]
.CE
.TP
target
The presence of this key marks the configuration as a
cross-compilation target and the value is the actual platform
identifier of the target\&.  No default\&.
.PP
.PP
The syntax expected from configuration files is governed by the rules below\&.
Again, it is recommended to open the file containing the standard
configurations ("\fIpath/to/critcl/Config\fR") in the editor of your
choice when reading this section of the documentation, using it as an
extended set of examples for the syntax>
.IP [1]
Each logical line of the configuration file consists of one or
more physical lines\&. In case of the latter the physical lines have to
follow each other and all but the first must be marked by a trailing
backslash\&. This is the same marker for \fIcontinuation lines\fR as
used by Tcl itself\&.
.IP [2]
A (logical) line starting with the character "#" (modulo
whitespace) is a comment which runs until the end of the line, and is
otherwise ignored\&.
.IP [3]
A (logical) line starting with the word "if" (modulo
whitespace) is interpreted as Tcl's \fBif\fR command and executed as
such\&. I\&.e\&. this command has to follow Tcl's syntax for the command,
which may stretch across multiple logical lines\&. The command will be
run in a save interpreter\&.
.IP [4]
A (logical) line starting with the word "set" (modulo
whitespace) is interpreted as Tcl's \fBset\fR command and executed as
such\&. I\&.e\&. this command has to follow Tcl's syntax for the command,
which may stretch across multiple logical lines\&. The command will be
run in a save interpreter\&.
.IP [5]
A line of the form "\fIplatform\fR \fBvariable\fR \fIvalue\fR"
defines a platform specific configuration variable and value\&.
The \fBvariable\fR has to be the name of one of the configuration keys
listed earlier in this section, and the \fIplatform\fR string
identifies the platform the setting is for\&. All settings with the same
identification string form the \fIconfiguration block\fR for this
platform\&.
.IP [6]
A line of the special form
"\fIplatform\fR \fBwhen\fR \fIexpression\fR"
marks the \fIplatform\fR and all the settings in its
\fIconfiguration block\fR as conditional on the \fIexpression\fR\&.
.sp
If the build platform is not a prefix of \fIplatform\fR,
nor vice versa the whole block is ignored\&.
Otherwise the \fIexpression\fR is evaluated via \fBexpr\fR, in the
same safe interpreter used to run any \fBset\fR and \fBif\fR commands
found in the configuration file (see above)\&.
.sp
If the expression evaluates to \fBtrue\fR this configuration block
is considered to be the build platform fo the host and chosen as the
default configuration\&.
An large example of of this feature is the handling of OS X found in
the standard configuration file, where it selects the architectures to
build based on the version of the operating system, the available SDK,
etc\&. I\&.e\&. it chooses whether the output is universal or not, and
whether it is old-style (ix86 + ppc) versus new-style (ix86 32+64) of
universality\&.
.IP [7]
A line of the special form
"\fIplatform\fR \fBcopy\fR \fIsourceplatform\fR"
copies the configuration variables and values currently defined in the
\fIconfiguration block\fR for \fIsourceplatform\fR to that of
\fIplatform\fR, overwriting existing values, and creating missing
ones\&. Variables of \fIplatform\fR not defined by by \fIsourceplatform\fR
are not touched\&.
.sp
The copied values can be overridden later in the configuration
file\&. Multiple \fBcopy\fR lines may exist for a platform and be
intermixed with normal configuration definitions\&. Only the last definition of a
variable is used\&.
.IP [8]
At last, a line of the form "\fBvariable\fR \fIvalue\fR"
defines a default configuration variable and value\&.
.PP
.SS "STUBS TABLES"		This section is for developers of extensions not based on critcl, yet
also wishing to interface with stubs as they are understood and used
by critcl, either by exporting their own stubs table to a
critcl-based extension, or importing a stubs table of a critcl-based
extension into their own\&.
.PP
To this end we describe the stubs table information of a
package \fBfoo\fR\&.
.IP [1]
Note that the differences in the capitalization of "foo",
"Foo", "FOO", etc\&. below demonstrate how to capitalize the actual
package name in each context\&.
.IP [2]
All relevant files must be available in a sub-directory
"\fIfoo\fR" which can be found on the include search paths\&.
.IP [3]
The above directory may contain a file "\fIfoo\&.decls\fR"\&. If
present it is assumed to contain the external representation
of the stubs table the headers mentioned in the following
items are based on\&.
.sp
critcl is able to use such a file to give the importing package
programmatic access to the imported API, for automatic code
generation and the like\&.
.IP [4]
The above directory must contain a header file
"\fIfooDecls\&.h\fR"\&. This file \fIdeclares\fR the exported API\&.
It is used by both exporting and importing packages\&. It is usually
generated and must contain (in the order specified):
.RS
.IP [1]
the declarations of the exported, i\&.e\&. public, functions of
\fBfoo\fR,
.IP [2]
the declaration of structure "FooStubs" for the stub table,
.IP [3]
the C preprocessor macros which route the invocations of the
public functions through the stubs table\&.
.sp
These macros must be defined if, and only if, the C preprocessor
macro USE_FOO_STUBS is defined\&. Package \fBfoo\fR does not
define this macro, as it is allowed to use the exported
functions directly\&. All importing packages however must define
this macro, to ensure that they do \fInot\fR use any of the
exported functions directly, but only through the stubs table\&.
.IP [4]
If the exported functions need additional types for their proper
declaration then these types should be put into a separate
header file (of arbitrary name) and "\fIfooDecls\&.h\fR" should
contain an #include directive to this header at the top\&.
.RE
.sp
A very reduced, yet also complete example, from a package for
low-level random number generator functions can be found at the end of
this section\&.
.IP [5]
The above directory must contain a header file
"\fIfooStubLib\&.h\fR"\&. This file \fIdefines\fR everything needed to use
the API of \fBfoo\fR\&. Consequently it is used only by importing
packages\&. It is usually generated and must contain (in the order
specified):
.RS
.IP [1]
An #include directive for "\fItcl\&.h\fR", with USE_TCL_STUBS
surely defined\&.
.IP [2]
An #include directive for "\fIfooDecls\&.h\fR", with USE_FOO_STUBS
surely defined\&.
.IP [3]
A \fIdefinition\fR of the stubs table variable, i\&.e\&.
.CS

const FooStubs* fooStubsPtr;
.CE
.IP [4]
A \fIdefinition\fR of the stubs initializer function, like
.CS

char *
Foo_InitStubs(Tcl_Interp *interp, CONST char *version, int exact)
{
    /*
     * Boiler plate C code initalizing the stubs table variable,
     * i\&.e\&. "fooStubsPtr"\&.
     */

    CONST char *actualVersion;

    actualVersion = Tcl_PkgRequireEx(interp, "foo", version,
				     exact, (ClientData *) &fooStubsPtr);

    if (!actualVersion) {
	return NULL;
    }

    if (!fooStubsPtr) {
	Tcl_SetResult(interp,
		      "This implementation of Foo does not support stubs",
		      TCL_STATIC);
	return NULL;
    }

    return (char*) actualVersion;
}
.CE
.RE
.IP
This header file must be included by an importing package
\fIexactly once\fR, so that it contains only one definition of both
stubs table and stubs initializer function\&.
.sp
The importing package's initialization function must further
contain a statement like
.CS

if (!Foo_InitStubs (ip, "1", 0)) {
    return TCL_ERROR;
}
.CE
.IP
which invokes \fBfoo\fR's stubs initializer function to set the
local stub table up\&.
.sp
For a complete example of such a header file see below, at the
end of this section\&.
.IP [6]
The last item above, about "\fIfooStubLib\&.h\fR" \fIdiffers\fR
from the regular stub stable system used by Tcl\&. The regular
system assumes that a static library "\fIlibfoostub\&.a\fR" was
installed by package \fBfoo\fR, and links it\&.
.sp
IMVHO critcl's approach is simpler, using \fIonly\fR header
files found in a single location, vs\&. header files and static
library found in multiple, different locations\&.
.sp
A second simplification is that we avoid having to extend
critcl's compiler backend with settings for the creation of
static libraries\&.
.PP
Below is a complete set of example header files, reduced, yet still
complete, from a package for low-level random number generator
functions:
.TP
"\fIrngDecls\&.h\fR":
.CS


#ifndef rng_DECLS_H
#define rng_DECLS_H

#include <tcl\&.h>

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN void rng_bernoulli(double p, int*v);

typedef struct RngStubs {
    int magic;
    const struct RngStubHooks *hooks;

    void (*rng_bernoulli) (double p, int*v); /* 0 */
} RngStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern const RngStubs *rngStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_RNG_STUBS)

/*
 * Inline function declarations:
 */

#define rng_bernoulli  (rngStubsPtr->rng_bernoulli) /* 0 */

#endif /* defined(USE_RNG_STUBS) */
#endif /* rng_DECLS_H */


.CE
.TP
"\fIrngStubLib\&.h\fR":
.CS


/*
 * rngStubLib\&.c --
 *
 * Stub object that will be statically linked into extensions that wish
 * to access rng\&.
 */

#ifndef USE_TCL_STUBS
#define USE_TCL_STUBS
#endif
#undef  USE_TCL_STUB_PROCS

#include <tcl\&.h>

#ifndef USE_RNG_STUBS
#define USE_RNG_STUBS
#endif
#undef  USE_RNG_STUB_PROCS

#include "rngDecls\&.h"

/*
 * Ensure that Rng_InitStubs is built as an exported symbol\&.  The other stub
 * functions should be built as non-exported symbols\&.
 */

#undef  TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLEXPORT

const RngStubs* rngStubsPtr;

/*
 *----------------------------------------------------------------------
 *
 * Rng_InitStubs --
 *
 * Checks that the correct version of Rng is loaded and that it
 * supports stubs\&. It then initialises the stub table pointers\&.
 *
 * Results:
 *  The actual version of Rng that satisfies the request, or
 *  NULL to indicate that an error occurred\&.
 *
 * Side effects:
 *  Sets the stub table pointers\&.
 *
 *----------------------------------------------------------------------
 */

#ifdef Rng_InitStubs
#undef Rng_InitStubs
#endif

char *
Rng_InitStubs(Tcl_Interp *interp, CONST char *version, int exact)
{
    CONST char *actualVersion;

    actualVersion = Tcl_PkgRequireEx(interp, "rng", version,
				     exact, (ClientData *) &rngStubsPtr);
    if (!actualVersion) {
	return NULL;
    }

    if (!rngStubsPtr) {
	Tcl_SetResult(interp,
		      "This implementation of Rng does not support stubs",
		      TCL_STATIC);
	return NULL;
    }

    return (char*) actualVersion;
}

.CE
.PP
.SH EXAMPLES
See section "Embedding C" in \fIUsing CriTcl\fR\&.
.PP
The latest changes are found at the top\&.
.SH "CHANGES FOR VERSION 3\&.1\&.18\&.1"
.IP [1]
\fIAttention\fR: While the overall version (of the bundle)
moves to 3\&.1\&.18\&.1 the versions of packages \fBcritcl\fR and
\fBcritcl::app\fR are \fIunchanged\fR\&.
.IP [2]
\fIBugfix\fR Generally removed a number of 8\&.5-isms which
slipped into 3\&.1\&.18, breaking ability to use it with Tcl 8\&.4\&.
.IP [3]
\fIBugfix\fR Corrected broken \fIbuild\&.tcl uninstall\fR\&.
.IP [4]
\fIBugfix\fR Package \fBcritcl::class\fR bumped to
version 1\&.1\&.1\&. Fixed partial template substitution breaking
compilation of the generated code\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.18"
.IP [1]
Feature (Developer support)\&. Merged pull request #96 from
sebres/main-direct-invoke\&. Enables direct invokation of the
"\fImain\&.tcl\fR" file for starkits from within a dev checkout,
i\&.e\&. outside of a starkit, or starpack\&.
.IP [2]
Feature\&. Added channel types to the set of builtin argument and
result types\&. The argument types are for simple channel access,
access requiring unshared channels, and taking the channel
fully into the C level, away from Tcl\&. The result type comes in
variants for newly created channels, known channels, and to
return taken channels back to Tcl\&. The first will register the
returned value in the interpreter, the second assumes that it
already is\&.
.IP [3]
Bugfix\&. Issue #96\&. Reworked the documentation around the
argument type \fBTcl_Interp*\fR to make its special status
more visible, explain uses, and call it out from result types
where its use will be necessary or at least useful\&.
.IP [4]
Feature\&. Package \fBcritcl::class\fR bumped to version 1\&.1\&.
Extended with the ability to create a C API for classes, and
the ability to disable the generation of the Tcl API\&.
.IP [5]
Bugfix\&. Merged pull request #99 from pooryorick/master\&. Fixes
to the target directory calculations done by the install code\&.
.IP [6]
Merged pull request #94 from andreas-kupries/documentation\&.
A larger documentation cleanup\&. The main work was done by
pooryorick, followed by tweaks done by myself\&.
.IP [7]
Extended the test suite with lots of cases based on the
examples for the various generator packages\&. IOW the new test
cases replicate/encapsulate the examples and demonstrate that
the packages used by the examples generate working code\&.
.IP [8]
Bugfix\&. Issue #95\&. Changed the field \fBcritcl_bytes\&.s\fR to
\fBunsigned char*\fR to match Tcl's type\&. Further constified
the field to make clear that read-only usage is the common case
for it\&.
.IP [9]
Bugfix/Feature\&. Package \fBcritcl::cutil\fR bumped to
version 0\&.2\&.  Fixed missing inclusion of header "\fIstring\&.h\fR"
in "\fIcritcl_alloc\&.h\fR", needed for \fBmemcpy\fR in macro
\fBSTREP\fR\&.  Added macros \fBALLOC_PLUS\fR and \fBSTRDUP\fR\&.
Moved documentation of \fBSTREP\&.\&.\&.\fR macros into proper place
(alloc section, not assert)\&.
.IP [10]
Merged pull request #83 from apnadkarni/vc-fixes\&.
Removed deprecated -Gs for MSVC builds, and other Windows fixups\&.
.IP [11]
Feature\&. Package \fBcritcl::iassoc\fR bumped to version 1\&.1\&.
Refactored internals to generate an include header for use by \&.c files\&.
This now matches what other generator packages do\&.
The template file is inlined and removed\&.
.IP [12]
Merged pull request #82 from gahr/home-symlink
Modified tests to handle possibility of $HOME a symlink\&.
.IP [13]
Merged pull request #81 from gahr/test-not-installed
Modified test support to find uninstalled critcl packages when
running tests\&. Handles all but critcl::md5\&.
.IP [14]
Merged pull request #85 from snoe925/issue-84
to fix Issue #84 breaking installation on OSX\&.
.IP [15]
Merged pull request #87 from apnadkarni/tea-fixes to fix Issue
#86, broken -tea option, generating an incomplete package\&.
.IP [16]
Feature\&. New package \fBcritcl::callback\fR providing
C-level functions and data structures to manage callbacks from
C to Tcl\&.
.IP [17]
Feature\&. Package \fBcritcl::literals\fR bumped to version
1\&.3\&.  Added mode \fB+list\fR enabling the conversion of
multiple literals into a list of their strings\&.
.IP [18]
Feature\&. Package \fBcritcl::enum\fR bumped to version 1\&.1\&.
Added basic mode handling, supporting \fBtcl\fR (default) and
\fB+list\fR (extension enabling the conversion of multiple
enum values into a list of their strings)\&.
.IP [19]
Feature\&. Package \fBcritcl::emap\fR bumped to version 1\&.2\&.
Extended existing mode handling with \fB+list\fR extension
enabling the conversion of multiple emap values into a list of
their strings\&.
.IP [20]
Feature\&. Extended the set of available types by applying a few
range restrictions to the scalar types (\fIint\fR,
\fIlong\fR, \fIwideint\fR, \fIdouble\fR, \fIfloat\fR)\&.
.sp
Example: \fIint > 0\fR is now a viable type name\&.
.sp
This is actually more limited than the description might
let you believe\&.
.sp
See the package reference for the details\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.17"
.IP [1]
Extension: Allow duplicate arg- and result-type definitions if
they are fully identical\&.
.IP [2]
Bugfix\&. The application mishandled the possibility of
identical-named \fBcritcl::tsource\fRs\&. Possible because
\fBcritcl::tsource\fRs can be in subdirectories, a structure
which is \fInot\fR retained in the assembled package, causing
such files to overwrite each other and at least one lost\&. Fixed
by adding a serial number to the file names in the assembled
package\&.
.IP [3]
Bugfix in the static scanner which made it loose requirement
information\&. Further added code to generally cleanup results at
the end (removal of duplicates, mainly)\&.
.IP [4]
Bugfix: Fixed issue #76\&.
Support installation directories which are not in the \fBauto_path\fR\&.
Without the patch the installed \fBcritcl\fR will not find its
own packages and fail\&. Thank you to
\fISimon Bachmann\fR [https://github\&.com/lupylucke] for the
report and patch, and then his patience with me to getting to
actually apply it\&.
.IP [5]
Bugfix: Fixed issue #75\&.
Extended \fBcritcl::include\fR to now take multiple paths\&.
.IP [6]
Added new compatibility package \fBlmap84\fR\&.
.IP [7]
Fixed typos in various documentation files\&.
.IP [8]
Fixed bug introduced by commit 86f415dd30 (3\&.1\&.16 release)\&. The
separation of \fBcritcl::ccode\fR into user and work layers
means that location retrieval has to go one more level up to
find the user location\&.
.IP [9]
New supporting package \fBcritcl::cutil\fR\&. Provides common
C level facilities useful to packages (assertions, tracing,
memory allocation shorthands)\&.
.IP [10]
Modified package \fBcritcl\fR to make use of the new
tracing facilities to provide tracing of arguments and results
for \fBcritcl::ccommand\fR and \fBcritcl::cproc\fR invokations\&.
.IP [11]
Modified packages \fBcritcl\fR and \fBcritcl::class\fR
to provide better function names for (class) method tracing\&.
Bumped package \fBcritcl::class\fR to version 1\&.0\&.7\&.
.IP [12]
Extended the support package \fBcritcl::literals\fR with
limited configurability\&. It is now able to generate code for
C-level access to the pool without Tcl types (Mode \fBc\fR)\&.
The previously existing functionality is accesssible under mode
\fBtcl\fR, which also is the default\&. Both modes can be used
together\&.
.IP [13]
Extended the support package \fBcritcl::emap\fR with
limited configurability\&. It is now able to generate code for
C-level access to the mapping without Tcl types
(Mode \fBc\fR)\&. The previously existing functionality is
accessible under mode \fBtcl\fR, which also is the
default\&. Both modes can be used together\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.16"
.IP [1]
New feature\&. Extended \fBcritcl::cproc\fR's argument handling
to allow arbitrary mixing of required and optional arguments\&.
.IP [2]
New feature\&.
\fIPotential Incompatibility\fR\&.
.sp
Extended \fBcritcl::cproc\fR's argument handling to treat an
argument \fBargs\fR as variadic if it is the last argument of
the procedure\&.
.IP [3]
New feature\&. Added two introspection commands,
\fBcritcl::has-argtype\fR and \fBcritcl::has-resulttype\fR\&.
These enable a user to test if a specific (named) type
conversion is implemented or not\&.
.IP [4]
Added new result type \fBTcl_Obj*0\fR, with alias
\fBobject0\fR\&. The difference to \fBTcl_Obj*\fR is in
the reference counting\&.
.IP [5]
Extended the command \fBcritcl::argtypesupport\fR with new
optional argument through which to explicitly specify the
identifier for guarding against multiple definitions\&.
.IP [6]
Bugfix: Fixed problem with the implementation of issue #54 (See
3\&.1\&.14)\&. Always create the secondary log file\&. Otherwise
end-of-log handling may break, unconditionally assuming its
existence\&.
.IP [7]
Bugfix: Fixed problem with the internal change to the hook
\fBHandleDeclAfterBuild\fR\&. Corrected the forgotten
\fBcritcl::cconst\fR\&.
.IP [8]
Debugging aid: Added comment holding the name of the result
type when emitting result conversions\&.
.IP [9]
Bugfix: Fixed issue #60\&. Unbundled the package directories
containing multiple packages\&. All directories under "\fIlib/\fR"
now contain exactly one package\&.
.IP [10]
Bugfix: Fixed issue #62, a few \fBdict exists\fR commands
operating on a fixed string instead of a variable\&.
.IP [11]
Bugfix: Fixed issue #56\&. Release builders are reminded to run
the tests\&.
.IP [12]
Bugfix: Fixed issue #55\&. For FreeBSD critcl's platform package
now identifies the Kernel ABI version\&. Initialization of the
cache directory now also uses \fBplatform::identify\fR for the
default path, instead of \fBplatform::generic\fR\&.
.IP [13]
Bugfix: Fixed issue #58\&. Simplified the setup and use of
md5\&. Critcl now makes use of its own package for md5, using
itself to built it\&. There is no chicken/egg problem with this
as the \fB-pkg\fR mode used for this does not use md5\&. That
is limited to mode \fIcompile & run\fR\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.15"
.IP [1]
Fixed version number bogosity with \fB3\&.1\&.14\fR\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.14"
.IP [1]
Fixed issue #36\&. Added message to target \fBall\fR of the
Makefile generated for TEA mode\&. Additionally tweaked other
parts of the output to be less noisy\&.
.IP [2]
Accepted request implied in issue #54\&. Unconditionally save
the compiler/linker build log into key \fBlog\fR of the
dictionary returned by \fBcresults\fR, and save a copy of only
the execution output in the new key \fBexl\fR ("execution
log")\&.
.IP [3]
Fixed issue #53\&. Clarified the documentation of commands
\fBcritcl::load\fR and \fBcritcl::failed\fR with regard
to their results and the throwing of errors (does not happen)\&.
.IP [4]
Fixed issue #48\&. Modified mode "compile & run" to allow new
declarations in a file, after it was build, instead of
erroring out\&. The new decls are build when needed\&. Mode
"precompile" is unchanged and will continue to trap the
situation\&.
.IP [5]
Fixed issue #52\&. Updated the local Tcl/Tk headers to
8\&.4\&.20, 8\&.5\&.13, and 8\&.6\&.4\&.
.IP [6]
Fixed issue #45\&. New feature command \fBcritcl::cconst\fR\&.
.IP [7]
\fBcritcl::util\fR: New command \fBlocate\fR to find a
file across a set of paths, and report an error when not
found\&. This is for use in autoconf-like header-searches and
similar configuration tests\&.
.IP [8]
Modified 'AbortWhenCalledAfterBuild' to dump the entire stack
(info frame!)\&. This should make it easier to determine the
location of the troubling declaration\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.13"
.IP [1]
Merged PR #43\&. Fixed bug loading adjunct Tcl sources\&.
.IP [2]
Fixes in documentation and generated code of package
"critcl::enum"\&. Bumped to version 1\&.0\&.1\&.
.IP [3]
Fixes in documentation of package "critcl::bitmap"\&.
.IP [4]
New package "critcl::emap"\&. In essence a variant or cross of
"critcl::bitmap" with behaviour like "critcl::enum"\&.
.IP [5]
Merged PR #49\&. Fixed documentation typo\&.
.IP [6]
Merged PR #46\&. Fixed documentation typo\&.
.IP [7]
Merged PR #47\&. Fixes to test results to match the accumulated
code changes\&. Also made portable across Tcl versions (varying
error syntax)\&.
.IP [8]
New predefined argument- and result-type "wideint" mapping to
Tcl_WideInt\&.
.IP [9]
New predefined argument-type "bytes" mapping to tuple of
byte-array data and length\&. Note: The existing "bytearray"
type (and its aliases) was left untouched, to keep backward
compatibility\&.
.IP [10]
Modified the internal interface between the Tcl shim and C
function underneath "critcl::cproc" with respect to the
handling of optional arguments\&.
An optional argument "X" now induces the use of two C
arguments, "X" and "has_X"\&.  The new argument "has_X" is of
boolean (int) type\&. It is set to true when X is set, and set
to false when X has the default value\&. C code which cares
about knowing if the argument is default or not is now able to
check that quickly, without having to code the default value
inside\&.
NOTE: This change is visible in the output of the advanced
commands "argcnames", "argcsignature", "argvardecls",
and "argconversion"\&.
.IP [11]
Fixed issue #50 and documented the availability of variable
"interp" (type Tcl_Interp*) within "critcl::cinit" C code
fragments\&.
Note that while the old, undocumented name of the variable,
"ip", is still usable, it is deprecated\&. It will be fully
removed in two releases, i\&.e\&. for release 3\&.1\&.15\&.
The variable name was changed to be consistent with other code
environments\&.
.IP [12]
Fixed issue #51\&. Disabled the generation of #line directives
for "critcl::config lines 0" coming from template files, or
code generated with them before the final value of this
setting was known\&.
.IP [13]
Fixed issue with handling of namespaced package names in
"critcl::iassoc"\&. Equivalent to a bug in "critcl::class" fixed
for critcl 3\&.1\&.1, critcl::class 1\&.0\&.1\&.
Note: "literals", "enum", "emap", and "bitmap" do not require
a fix as they are all built on top of "iassoc"\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.12"
.IP [1]
Fixed issue 42\&. Clear ::errorInfo immediately after startup to
prevent leakage of irrelevant (caught) errors into our script
and confusing the usage code\&.
.IP [2]
Fixed issue 40\&. Keep the order of libraries, and allow
duplicates\&. Both are things which are occasionally required for
proper linking\&.
.IP [3]
Extended the utility package \fBcritcl::literals\fR to
declare a cproc result-type for a pool\&.
.sp
Further fixed the generated header to handle multiple inclusion\&.
.sp
Bumped version to 1\&.1\&.
.IP [4]
Fixed issue with utility package \fBcritcl::bitmap\fR\&.
.sp
Fixed the generated header to handle multiple inclusion\&.
.sp
Bumped version to 1\&.0\&.1\&.
.IP [5]
Created new utility package \fBcritcl::enum\fR for the
quick and easy setup and use of mappings between C values
and Tcl strings\&.
Built on top of \fBcritcl::literals\fR\&.
.IP [6]
Added examples demonstrating the use of the utility packages
\fBcritcl::literals\fR,
\fBcritcl::bitmap\fR, and
\fBcritcl::enum\fR
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.11"
.IP [1]
Fixed issue #37, via pull request #38, with thanks to
Jos DeCoster\&. Information was stored into the v::delproc
and v::clientdata arrays using a different key than when
retrieving the same information, thus failing the latter\&.
.IP [2]
New convenience command \fBcritcl::include\fR for easy
inclusion of headers and other C files\&.
.IP [3]
New command \fBcritcl::make\fR to generate a local header of
other C files for use by other parts of a package through
inclusion\&.
.IP [4]
New utility package \fBcritcl::literals\fR for quick and
easy setup of and access to pools of fixed Tcl_Obj* strings\&.
Built on top of \fBcritcl::iassoc\fR\&.
.IP [5]
New utility package \fBcritcl::bitmap\fR for quick and easy
setup and use of mappings between C bitsets and Tcl lists whose
string elements represent that set\&.
Built on top of \fBcritcl::iassoc\fR\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.10"
.IP [1]
Fixed code version numbering forgotten with 3\&.1\&.9\&.
.IP [2]
Fixed issue #35\&. In package mode (-pkg) the object cache
directory is unique to the process, thus we do not need
content-hashing to generate unique file names\&. A simple
counter is sufficient and much faster\&.
.sp
Note that mode "compile & run" is not as blessed and still
uses content-hasing with md5 to ensure unique file names
in its per-user object cache\&.
.IP [3]
Fixed issue where the \fBccommand\fR forgot to use its body as
input for the UUID generation\&. Thus ignoring changes to it in
mode compile & run, and not rebuilding a library for changed
sources\&. Bug and fix reported by Peter Spjuth\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.9"
.IP [1]
Fixed issue #27\&. Added missing platform definitions for
various alternate linux and OS X targets\&.
.IP [2]
Fixed issue #28\&. Added missing -mXX flags for linking at the
linux-{32,64}-* targets\&.
.IP [3]
Fixed issue #29\&. Replaced the use of raw "cheaders"
information in the processing of "cdefines" with the proper
include directives derived from it\&.
.IP [4]
Fixed the issue behind rejected pull request #30 by Andrew
Shadura\&. Dynamically extract the stubs variable declarations
from the Tcl header files and generate matching variable
definitions for use in the package code\&. The generated code
will now be always consistent with the headers, even when
critcl's own copy of them is replaced by system headers\&.
.IP [5]
Fixed issue #31\&. Accepted patch by Andrew Shadura, with
changes (comments), for easier integration of critcl with
OS package systems, replacing critcl's copies of Tcl headers
with their own\&.
.IP [6]
Fixed issue #32\&. Merged pull request by Andrew Shadura\&.
Various typos in documentation and comments\&.
.IP [7]
Fixed issue #34\&. Handle files starting with a dot better\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.8"
.IP [1]
Fixed issue with package indices generated for Tcl 8\&.4\&.
Join the list of commands with semi-colon, not newline\&.
.IP [2]
Fixed issue #26 which brought up use-cases I had forgotten to
consider while fixing bug #21 (see critcl 3\&.1\&.6)\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.7"
.IP [1]
Fixed issue #24\&. Extract and unconditionally display compiler
warnings found in the build log\&. Prevents users from missing
warnings which, while not causing the build to fail, may
still indicate problems\&.
.IP [2]
New feature\&. Output hook\&. All non-messaging user output is now
routed through the command \fBcritcl::print\fR, and users are
allowed to override it when using the critcl application-as-package\&.
.IP [3]
New feature, by Ashok P\&. Nadkarni\&. Platform configurations can
inherit values from configurations defined before them\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.6"
.IP [1]
Fixed issue #21\&. While the multi-definition of the stub-table
pointer variables was ok with for all the C linkers seen so far
C++ linkers did not like this at all\&. Reworked the code to
ensure that this set of variables is generated only once, in
the wrapper around all the pieces to assemble\&.
.IP [2]
Fixed issue #22, the handling of the command identifier
arguments of \fBcritcl::ccommand\fR, \fBcritcl::cproc\fR, and
\fBcritcl::cdata\fR\&. We now properly allow any Tcl identifier
and generate proper internal C identifiers from them\&.
.sp
As part of this the signature of command \fBcritcl::name2c\fR
changed\&. The command now delivers a list of four values instead
of three\&. The new value was added at the end\&.
.sp
Further adapted the implementation of package
\fBcritcl::class\fR, a user of \fBcritcl::name2c\fR\&.
This package is now at version 1\&.0\&.6 and requires critcl 3\&.1\&.6
.sp
Lastly fixed the mis-handling of option \fB-cname\fR in
\fBcritcl::ccommand\fR, and \fBcritcl::cproc\fR\&.
.IP [3]
Fixed issue #23\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.5"
.IP [1]
Fixed issue #19\&. Made the regular expression extracting the
MSVC version number more general to make it work on german
language systems\&. This may have to be revisited in the future,
for other Windows locales\&.
.IP [2]
Fixed issue #20\&. Made option -tea work on windows, at least in
a unix emulation environment like msys/mingw\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.4"
.IP [1]
Bugfix in package \fBcritcl::class\fR\&. Generate a dummy
field in the class structure if the class has no class
variables\&. Without this change the structure would be empty,
and a number of compilers are not able to handle such a type\&.
.IP [2]
Fixed a typo which broke the win64 configuration\&.
.IP [3]
Fixed issue #16, a typo in the documentation of command
\fBcritcl::class\fR\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.3"
.IP [1]
Enhancement\&. In detail:
.IP [2]
Added new argument type "pstring", for "Pascal String", a
counted string, i\&.e\&. a combination of string pointer and string
length\&.
.IP [3]
Added new methods \fBcritcl::argtypesupport\fR and
\fB::critcl::argsupport\fR to define and use additional
supporting code for an argument type, here used by "pstring"
above to define the necessary structure\&.
.IP [4]
Semi-bugfixes in the packages \fBcritcl::class\fR and
\fBcritcl::iassoc\fR\&. Pragmas for the AS meta data scanner
to ensure that the template files are made part of the package\&.
Versions bumped to 1\&.0\&.4 and 1\&.0\&.1 respectively\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.2"
.IP [1]
Enhancement\&. In detail:
.IP [2]
Extended \fBcritcl::cproc\fR to be able to handle optional
arguments, in a limited way\&. This is automatically available to
\fBcritcl::class\fR cproc-based methods as well\&.
.IP [3]
Bugfix in \fBlassign\fR emulation for Tcl 8\&.4\&.  Properly set
unused variables to the empty string\&.  Bumped version of
emulation package \fBlassign84\fR to 1\&.0\&.1\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1\&.1"
.IP [1]
Bugfixes all around\&. In detail:
.IP [2]
Fixed the generation of wrong#args errors for
\fBcritcl::cproc\fR and derived code (\fBcritcl::class\fR
cproc-based methods)\&. Use NULL if there are no arguments, and
take the offset into account\&.
.IP [3]
Fixed the handling of package names by
\fBcritcl::class\fR\&. Forgot that they may contain namespace
separators\&. Bumped to version 1\&.0\&.1\&.
.IP [4]
Extended a \fBcritcl::class\fR generated error message in
instance creation for clarity\&. Bumped to version 1\&.0\&.2\&.
.PP
.SH "CHANGES FOR VERSION 3\&.1"
.IP [1]
Added a new higher-level package \fBcritcl::iassoc\fR\&.
.sp
This package simplifies the creation of code associating data
with an interpreter via Tcl's \fBTcl_(Get|Set)AssocData()\fR APIs\&. The
user can concentrate on his data while all the necessary boilerplate
C code to support this is generated by the package\&.
.sp
This package uses several of the new features which were added
to the core \fBcritcl\fR package, see below\&.
.IP [2]
Added the higher-level package \fBcritcl::class\fR\&.
.sp
This package simplifies the creation of C level objects with
class and instance commands\&. The user can write a class definition
with class- and instance-variables and -methods similar to a TclOO
class, with all the necessary boilerplate C code to support this
generated by the package\&.
.sp
This package uses several of the new features which were added
to the core \fBcritcl\fR package, see below\&.
.IP [3]
Extended the API for handling TEApot metadata\&. Added the
command \fBcritcl::meta?\fR to query the stored information\&. Main use
currently envisioned is retrieval of the current package's name by
utility commands, for use in constructed names\&. This particular
information is always available due to the static scan of the package
file on execution of the first critcl command\&.
.sp
The new packages \fBcritcl::iassoc\fR and
\fBcritcl::class\fR (see above) are users of this command\&.
.IP [4]
Extended the API with a command, \fBcritcl::name2c\fR, exposing
the process of converting a Tcl name into base name, namespace, and C
namespace\&. This enables higher-level code generators to generate the same
type of C identifiers as \fBcritcl\fR itself\&.
.sp
The new package \fBcritcl::class\fR (see above) is a user
of this command\&.
.IP [5]
Extended the API with a command, \fBcritcl::source\fR,
executing critcl commands found in a separate file in the context of
the current file\&. This enables easier management of larger bodies of
code as it allows the user to split such up into easier to digest
smaller chunks without causing the generation of multiple packages\&.
.IP [6]
Related to the previous item, extended the API with commands to
divert collection of generated C code into memory\&. This makes it
easier to use the commands for embedded C code in higher-level code
generators\&.
.sp
See the section \fBAdvanced: Diversions\fR for details of
the provided commands\&.
.sp
The new package \fBcritcl::class\fR (see above) is a user
of these facilities\&.
.IP [7]
Extended the API with commands helping developers with the
generation of proper C \fI#line\fR directives\&. This allows
higher-level code generators to generate and insert their own
directives, ensuring that compile errors in their code are properly
attributed\&.
.sp
See the section \fBAdvanced: Location management\fR for
details of the provided commands\&.
.sp
The new packages \fBcritcl::iassoc\fR and
\fBcritcl::class\fR (see above) are users of these facilities\&.
.IP [8]
Extended the API with commands giving users the ability to
define custom argument and result types for \fB::critcl::cproc\fR\&.
.sp
See the section \fBAdvanced: Extending cproc\fR for
details of the provided commands\&.
.PP
.SH "CHANGES FOR VERSION 3\&.0\&.7"
.IP [1]
Fixed the code generated by \fBcritcl::c++command\fR\&.
The emitted code handed a non-static string table to
\fBTcl_GetIndexFromObj\fR, in violation of the contract, which
requires the table to have a fixed address\&. This was a memory
smash waiting to happen\&. Thanks to Brian Griffin for alrerting
us to the general problem\&.
.PP
.SH "CHANGES FOR VERSION 3\&.0\&.6"
.IP [1]
Fixed github issue 10\&. The critcl application now delivers a
proper exit code (1) on build failure, instead of always
indicating success (status 0)\&.
.IP [2]
Fixed github issue 13\&. Handling of bufferoverflowU\&.lib for
release builds was inconsistent with handling for debug
builds\&. It is now identically handled (conditional) by
both cases\&.
.IP [3]
Documentation cleanup, mainly in the installation guide, and
the README\&.md shown by github
.PP
.SH "CHANGES FOR VERSION 3\&.0\&.5"
.IP [1]
Fixed bug in the new code for #line pragmas triggered when
specifying C code without leading whitespace\&.
.IP [2]
Extended the documentation to have manpages for the license,
source retrieval, installer, and developer's guides\&.
.PP
.SH "CHANGES FOR VERSION 3\&.0\&.4"
.IP [1]
Fixed generation of the package's initname when the incoming
code is read from stdin and has no proper path\&.
.IP [2]
Fixed github issue 11\&. Now using /LIBPATH instead of -L
on Windows (libinclude configuration setting)\&.
.IP [3]
Extended critcl to handle -l:path format of -l options\&.
GNU ld 2\&.22+ handles this by searching for the path as
is\&. Good when specifying static libraries, as plain -l looks
for shared libraries in preference over static\&. critcl handles
it now, as older GNU ld's do not understand it, nor the
various vendor-specific linkers\&.
.IP [4]
Fixed github issue #12\&. Critcl now determines the version of
MSVC in use and uses it to switch between various link debug
options\&. Simplified the handling of bufferoverflowU\&.lib also,
making use of the same mechanism and collapsing the two
configurations sections we had back into one\&.
.IP [5]
Reworked the insertion of #line pragmas into the generated C
code to avoid limitations on the line number argument imposed
by various compilers, and be more accurate\&.
.IP [6]
Modified argument processing\&. Option -libdir now also
implies -L for its argument\&.
.IP [7]
Extended handling of option -show (\fBcritcl::showconfig\fR)
to list the path of the configuration file the data is coming
from\&. Good for debugging configuration processing\&.
.IP [8]
Extended the build script with targets to regenerate the
embedded documentation, and diagrams, and to generate a
release\&.
.PP
.SH "CHANGES FOR VERSION 3\&.0\&.3"
.IP [1]
Fixed github issues 5 and 8, for the example build\&.tcl
scripts\&. Working around a missing variable ::errorInfo\&. It should
always be present, however there seem to be revisions of Tcl around
which violate this assumption\&.
.PP
.SH "CHANGES FOR VERSION 3\&.0\&.2"
.IP [1]
Fixed issue in compile-and-run mode where commands put into the
auto_index are not found by Tcl's [unknown] command\&.
.IP [2]
Fixed an array key mismatch breaking usage of client data and
delete function for procedure\&. Reported by Jos DeCoster, with patch\&.
.IP [3]
Implemented a command line option \fB-L\fR, an equivalent of
option \fB-I\fR, just for library search paths\&.
.IP [4]
Fixed github issues 5 and 8\&. Working around a missing variable
::errorInfo\&. It should always be present, however there seem to be
revisions of Tcl around which violate this assumption\&.
.PP
.SH "CHANGES FOR VERSION 3\&.0\&.1"
.IP [1]
Bugfixes all around\&. In detail:
.IP [2]
Fixed recording of Tcl version requirements\&. Keep package name
and version together, unbreaking generated meta data and generated
package load command\&.
.IP [3]
Fixed the build scripts: When installing, or wrapping for TEA,
generate any missing directories
.IP [4]
Modified the build scripts to properly exit the application
when the window of their GUI is closed through the (X) button\&.
.IP [5]
Removed an 8\&.5-ism (open wb) which had slipped into the main
build script\&.
.IP [6]
Modified the example build scripts to separate the output for
the different examples (and packages) by adding empty lines\&.
.IP [7]
stack::c example bugfix: Include API declarations for use in
the companion files\&.
.IP [8]
Extended the documentation: Noted the need for a working
installation of a C compiler\&.
.IP [9]
Extended the Windows target definitions and code to handle the
manifest files used by modern MS development environments\&. Note that
this code handles both possibilities, environment using manifests, and
(old(er)) environments without\&.
.IP [10]
Extended the Windows 64bit target definitions and code to
auto-detect the need for the helper library "bufferoverflowU\&.lib" and
reconfigure the compile and link commands appropriately\&. We assume
that the library must be linked when present\&. This should be no harm
if the library is present, yet not needed\&. Just superfluous\&. We search
for the library in the paths specified by the environment variable
LIB\&.
.PP
.SH "CHANGES FOR VERSION 3"
.IP [1]
The command \fBcritcl::platform\fR was deprecated in version
2\&.1, superceded by \fBcritcl::targetplatform\fR, yet kept for
compatibility\&. Now it has been removed\&.
.IP [2]
The command \fBcritcl::compiled\fR was kept with in version 2\&.1
with semantics in contradiction to its, for compatibility\&. This
contradiction has been removed, changing the visible semantics of the
command to be in line with its name\&.
.IP [3]
The change to version 3 became necessary because of the two
incompatible visible changes above\&.
.IP [4]
Extended the application package with code handling a new
option \fB-tea\fR\&. Specifying this option invokes a special mode
where critcl generates a TEA package, i\&.e\&. wraps the input into a
directory hierarchy and support files which provide it TEA-lookalike
buildsystem\&.
.sp
This new option, and \fB-pkg\fR, exclude each other\&. If
both are specified the last used option takes precedence\&.
.sp
The generated package directory hierarchy is mostly
self-contained, but not fully\&. It requires not only a working
installation of Tcl, but also working installations of the packages
\fBmd5\fR and \fBcmdline\fR\&. Both of these are provided by the
\fBTcllib\fR bundle\&. Not required, but recommended to have
installed are any of the packages which can accelerate md5's
operation, i\&.e\&. \fBcryptkit\fR, \fBtcllibc\fR, or
\fBTrf\fR\&.
.IP [5]
Extended the critcl package with a new command
\fBcritcl::scan\fR taking the path to a "\fI\&.critcl\fR" file,
statically scanning it, and returning license, version, a list of its
companion files, list of imported APIs, and list of
developer-specified custom configuration options\&. This data is the
foundation for the TEA wrapping described above\&.
.sp
Note that this is a \fIstatic\fR scan\&. While the other build
modes can (must) execute the "\fI\&.critcl\fR" file and make
platform-specific decisions regarding the assembled C code, companion
files, etc\&. the TEA wrap mode is not in a position to make
platform-specific decisions\&. It has to wrap everything which might
conceivably be needed when actually building\&. Hence the static scan\&.
This has however its own set of problems, namely the inability to
figure out any dynamic construction of companion file paths, at least
on its own\&. Thus:
.IP [6]
Extended the API used by critcl-based packages with the command
\fBcritcl::owns\fR\&. While this command is ignored by the regular build
modes the static scanner described above takes its arguments as the
names of companion files which have to be wrapped into the TEA package
and could not be figured by the scanner otherwise, like because of
dynamic paths to \fBcritcl::tsources\fR, \fBcritcl::csources\fR,
getting sourced directly, or simply being adjunct datafiles\&.
.IP [7]
Extended the API used by critcl-based packages with the command
\fBcritcl::api\fR for the management of stubs tables, be it their use,
and/or declaration and export\&.
.sp
Please see section \fIStubs Table Management\fR of the
\fBcritcl\fR package documentation for details\&.
.IP [8]
Extended the API used by critcl-based packages with the command
\fBcritcl::userconfig\fR for the management of developer-specified
custom configuration options, be it their use and/or declaration\&.
.sp
Please see section \fICustom Build Configuration\fR of the
\fBcritcl\fR package documentation for details\&.
.IP [9]
Extended the API used by critcl-based packages with the
commands \fBcritcl::description\fR, \fBcritcl::summary\fR,
\fBcritcl::subject\fR, \fBcritcl::meta\fR, and
\fBcritcl::buildrequirement\fR for the declaration of TEApot meta data
for/about the package\&.
.sp
Please see section \fIPackage Meta Data\fR of the
\fBcritcl\fR package documentation for details\&.
.PP
.SH "CHANGES FOR VERSION 2\&.1"
.IP [1]
Fixed bug where \fBcritcl::tsources\fR interpreted relative
paths as relative to the current working directory instead of
relative to the "\fI\&.critcl\fR" file using the command, as all other
commands of this type do\&.
.IP [2]
Fixed internals, preventing information collected for multiple
"\fI\&.critcl\fR" files to leak between them\&. Notably, \fBcritcl::tk\fR
is not a global configuration option anymore\&.
.IP [3]
Fixed the command \fBcritcl::license\fR to be a null-operation
in mode "compile & run", instead of throwing an error\&.
.IP [4]
Fixed the critcl application's interference with the "compile &
run" result cache in \fB-pkg\fR mode by having it use a wholly
separate (and by default transient) directory for that mode\&.
.IP [5]
Fixed bug where changes to a "\fI\&.critcl\fR" file did not result
in a rebuild for mode "compile & run"\&. All relevant API commands now
ensure UUID changes\&.
.IP [6]
Fixed bug in the backend handling of \fBcritcl::debug\fR where
the companion c-sources of a "\fI\&.critcl\fR" file were not compiled
with debug options, although the "\fI\&.critcl\fR" file was\&.
.IP [7]
Fixed bug in \fBcritcl::debug\fR which prevented recognition of
mode "all" when it was not the first argument to the command\&.
.IP [8]
Fixed bug in "\fIpreload\&.c\fR" preventing its compilation on
non-windows platforms\&.
.IP [9]
Fixed long-standing bug in the handling of namespace qualifiers
in the command name argument of \fBcritcl::cproc\fR and
\fBcritcl::ccommand\fR\&. It is now possible to specify a fully
qualified command name without issues\&.
.IP [10]
Extended/reworked \fBcritcl::tsources\fR to be the canonical
way of declaring "\fI\&.tcl\fR" companion files even for mode "compile &
run"\&.
.IP [11]
Extended/reworked \fBcritcl::tsources\fR to allow the use of a
"\fI\&.critcl\fR" file as its own Tcl companion file\&.
.IP [12]
Extended \fBcritcl::framework\fR to internally check for OS X
build target, and to ignore the declaration if its not\&.
.IP [13]
Extended \fBcritcl::failed\fR to be callable more than once in
a "\fI\&.critcl\fR" file\&. The first call forces the build, if it was not
done already, to get the result\&. Further calls return the cached
result of the first call\&.
.IP [14]
Extended the handling of environment variable CC in the code
determining the compiler to use to deal with (i\&.e\&. remove) paths to
the compiler, compiler file extensions, and compiler options specified
after the compiler itself, leaving only the bare name of the compiler\&.
.IP [15]
Extended the code handling the search for preloaded libraries
to print the paths it searched, making debugging of a search failure
easier\&.
.IP [16]
A new command \fBcritcl::tcl\fR can be used to declare the
version of Tcl minimally needed to build and run the "\fI\&.critcl\fR"
file and package\&. Defaults to 8\&.4 if not declared\&. Extended critcl to
have the stubs and headers for all of Tcl 8\&.4, 8\&.5, and 8\&.6\&.
.IP [17]
A new command \fBcritcl::load\fR forces the build and load of a
"\fI\&.critcl\fR" file\&. This is the official way for overriding critcl's
default lazy-build-&-load-on-demand scheme for mode "compile & run"\&.
.sp
\fINote\fR that after using \fBcritcl::load\fR /
\fBcritcl::failed\fR in a "\fI\&.critcl\fR" file it is not possible to
use critcl commands in that file anymore\&. Doing so will throw an
error\&.
.IP [18]
Extended the generation of '#line' pragmas to use
\fBinfo frame\fR (if available) to provide the C compiler with exact
line numbers into the "\fI\&.critcl\fR" file for the reporting of
warnings and errors\&.
.IP [19]
Extended \fBcritcl::check\fR with logging to help with
debugging build-time checks of the environment, plus an additional
optional argument to provide labeling\&.
.IP [20]
Added a new command \fBcritcl::checklink\fR which not only
tries to check the environment via compiling the code, but also
its linkability\&.
.IP [21]
Added a new command \fBcritcl::msg\fR for messaging, like
command \fBcritcl::error\fR is for error reporting\&. Likewise this is a
hook a user of the package is allowed to override\&. The default
implementation, used by mode \fIcompile & run\fR does nothing\&. The
implementation for mode \fIgenerate package\fR prints the message
to stdout\&.
.sp
Envisioned use is for the reporting of results determined by
\fBcritcl::check\fR and \fBcritcl::checklink\fR during building, to
help with debugging when something goes wrong with a check\&.
.IP [22]
Exposed the argument processing internals of \fBcritcl::proc\fR
for use by advanced users\&. The new commands are
.RS
.IP [1]
\fBcritcl::argnames\fR
.IP [2]
\fBcritcl::argcnames\fR
.IP [3]
\fBcritcl::argcsignature\fR
.IP [4]
\fBcritcl::argvardecls\fR
.IP [5]
\fBcritcl::argconversion\fR
.RE
.IP
Please see section \fIAdvanced Embedded C Code\fR of the
\fBcritcl\fR package documentation for details\&.
.IP [23]
Extended the critcl package to intercept \fBpackage
provide\fR and record the file -> package name mapping\&. Plus other
internal changes now allow the use of namespaced package names while
still using proper path names and init function\&.
.IP [24]
Dropped the unused commands \fBcritcl::optimize\fR and
\fBcritcl::include\fR\&.
.IP [25]
Dropped \fB-lib\fR mode from the critcl application\&.
.IP [26]
Dropped remnants of support for Tcl 8\&.3 and before\&.
.PP
.SH AUTHORS
Jean Claude Wippler, Steve Landers, Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report them at \fIhttps://github\&.com/andreas-kupries/critcl/issues\fR\&.
Ideas for enhancements you may have for either package, application,
and/or the documentation are also very welcome and should be reported
at \fIhttps://github\&.com/andreas-kupries/critcl/issues\fR as well\&.
.SH KEYWORDS
C code, Embedded C Code, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, generate package, linker, on demand compilation, on-the-fly compilation
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) Jean-Claude Wippler
Copyright (c) Steve Landers
Copyright (c) 2011-2018 Andreas Kupries

.fi
