/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.net.URI;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.xqj.SaxonXQDataFactory;

public class SaxonXQItemType
implements XQItemType {
    private ItemType itemType;
    private Configuration config;

    protected SaxonXQItemType(ItemType itemType, Configuration configuration) {
        this.itemType = itemType;
        this.config = configuration;
    }

    protected SaxonXQItemType(NodeInfo nodeInfo) {
        this.config = nodeInfo.getConfiguration();
        this.itemType = new SingletonNode(nodeInfo).getItemType(this.config.getTypeHierarchy());
    }

    public int getBaseType() {
        if (this.itemType instanceof AtomicType) {
            int n = this.itemType instanceof BuiltInAtomicType ? ((AtomicType)this.itemType).getFingerprint() : this.itemType.getPrimitiveType();
            return SaxonXQDataFactory.mapSaxonTypeToXQJ(n);
        }
        return -1;
    }

    public int getItemKind() {
        if (this.itemType instanceof AtomicType) {
            return 1;
        }
        if (this.itemType instanceof NodeTest) {
            if (this.itemType instanceof DocumentNodeTest) {
                return 5;
            }
            int n = ((NodeTest)this.itemType).getPrimitiveType();
            switch (n) {
                case 9: {
                    return 4;
                }
                case 1: {
                    return 6;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 10;
                }
                case 8: {
                    return 3;
                }
                case 7: {
                    return 9;
                }
                case 0: {
                    return 8;
                }
            }
        }
        return 7;
    }

    public int getItemOccurrence() {
        return 2;
    }

    public QName getNodeName() throws XQException {
        IntHashSet intHashSet;
        ItemType itemType = this.itemType;
        if (itemType instanceof DocumentNodeTest) {
            itemType = ((DocumentNodeTest)itemType).getElementTest();
        }
        if (itemType instanceof NodeTest && (intHashSet = ((NodeTest)this.itemType).getRequiredNodeNames()).size() == 1) {
            int n = intHashSet.getFirst(-1);
            NamePool namePool = this.config.getNamePool();
            String string = namePool.getURI(n);
            String string2 = namePool.getLocalName(n);
            return new QName(string, string2);
        }
        return null;
    }

    public URI getSchemaURI() {
        return null;
    }

    public String getString() {
        return ((AtomicType)this.itemType).toString(this.config.getNamePool());
    }

    public String toString() {
        return this.getString();
    }

    public QName getTypeName() throws XQException {
        SchemaType schemaType;
        ItemType itemType = this.itemType;
        if (itemType instanceof DocumentNodeTest) {
            itemType = ((DocumentNodeTest)itemType).getElementTest();
        }
        if (itemType instanceof NodeTest && (schemaType = ((NodeTest)itemType).getContentType()) != null) {
            int n = ((NodeTest)itemType).getContentType().getFingerprint();
            NamePool namePool = this.config.getNamePool();
            String string = namePool.getURI(n);
            String string2 = namePool.getLocalName(n);
            return new QName(string, string2);
        }
        throw new XQException("getTypeName() failed: itemType is not a documet, element, or attribute test");
    }

    public boolean isAnonymousType() {
        SchemaType schemaType;
        ItemType itemType = this.itemType;
        if (itemType instanceof DocumentNodeTest) {
            itemType = ((DocumentNodeTest)itemType).getElementTest();
        }
        if (itemType instanceof NodeTest && (schemaType = ((NodeTest)itemType).getContentType()) != null) {
            return schemaType.isAnonymousType();
        }
        return false;
    }

    public boolean isElementNillable() {
        return this.itemType instanceof NodeTest && ((NodeTest)this.itemType).isNillable();
    }

    public boolean isSchemaElement() {
        return false;
    }

    public XQItemType getItemType() {
        return this;
    }

    AtomicType getAtomicType() {
        if (this.itemType instanceof AtomicType) {
            return (AtomicType)this.itemType;
        }
        return null;
    }

    ItemType getSaxonItemType() {
        return this.itemType;
    }
}

