/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _AMR_DEFS_H_
#define _AMR_DEFS_H_

#include <SPACE.H>
#include <MultiFab.H>

#define intRS		D_DECL(const int&, const int&, const int&)
#define intS		intRS, intRS
#define RealPS		D_DECL(Real*, Real*, Real*)
#define CRealPS 	D_DECL(const Real*, const Real*, const Real*)
#if (BL_SPACEDIM == 1)
#define DIMLIST(a) 	a.smallEnd(0), a.bigEnd(0)
#elif (BL_SPACEDIM == 2)
#define DIMLIST(a) 	a.smallEnd(0), a.bigEnd(0), a.smallEnd(1), a.bigEnd(1)
#elif (BL_SPACEDIM == 3)
#define DIMLIST(a) 	a.smallEnd(0), a.bigEnd(0), a.smallEnd(1), a.bigEnd(1), a.smallEnd(2), a.bigEnd(2)
#endif

#include "hgparallel.H"

extern bool HG_is_debugging;

//
// Index type helper functions:
//

inline
IntVect
type (const FArrayBox& f)
{
    return f.box().type();
}

inline
IndexType::CellIndex
type (const FArrayBox& f, int idir)
{
    return f.box().type(idir);
}

inline
IntVect
type (const FabArray<FArrayBox>& r)
{
    BL_ASSERT(r.size() > 0 && r.boxArray().ok());
    return r.box(0).type();
}

inline
IndexType::CellIndex
type (const FabArray<FArrayBox>& r, int idir)
{
    BL_ASSERT(r.size() > 0 && r.boxArray().ok());
    return r.box(0).type(idir);
}

#ifdef HG_DEBUG
void hg_debug_norm_2 (const MultiFab& d, const char* str1, const char* str2);

#include <fstream>
extern std::ofstream debug_out;

#define HG_DEBUG_OUT(s) 	debug_out << s
#define HG_TEST_NORM(d, s) 	hg_debug_norm_2(d, s, #d)
#else
#define HG_DEBUG_OUT(s)
#define HG_TEST_NORM(d, s)
#endif

#endif /*_AMR_DEFS_H_*/
