/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

//
// $Id: ErrorList.cpp,v 1.10 2001/08/01 21:50:45 lijewski Exp $
//

#include <iostream>

#include <BLassert.H>
#include <ErrorList.H>

ErrorRec::ErrorRec (const std::string& nm,
                    int                ng,
                    ErrorType          etyp,
                    ErrorFunc          f)
    :
    derive_name(nm),
    ngrow(ng),
    err_func(f),
    err_type(etyp)
{}

const std::string&
ErrorRec::name () const
{
    return derive_name;
}

int
ErrorRec::nGrow () const
{
    return ngrow;
}

ErrorRec::ErrorType
ErrorRec::errType () const
{
    return err_type;
}

ErrorFunc
ErrorRec::errFunc () const
{
    return err_func;
}

int
ErrorList::size () const
{
    return vec.size();
}

void
ErrorList::add (const std::string&  name,
                int                 nextra, 
                ErrorRec::ErrorType typ,
                ErrorFunc           func)
{
    //
    // Keep list in order of definition, append().
    //
    vec.push_back(ErrorRec(name, nextra, typ, func));
}

const ErrorRec&
ErrorList::operator[] (int k) const
{
    BL_ASSERT(k < size());

    return vec[k];
}

static const char* err_name[] = { "Richardson", "Special" };

std::ostream&
operator << (std::ostream&    os,
             const ErrorList& elst)
{
    for (int i = 0; i < elst.size(); i++)
    {
        os << elst[i].name()
           << ' '
           << elst[i].nGrow()
           << ' '
           << err_name[elst[i].errType()]
           << '\n';
    }
    return os;
}
