#
#  setup packaging - Mon Feb  2 22:37:11 EST 2015
#
execute_process(COMMAND uname -m OUTPUT_VARIABLE ARCH)

set(VERSION_TEXT "")
if (EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/version.c")
    file (STRINGS "${CMAKE_CURRENT_SOURCE_DIR}/version.c" VERSION_TEXT REGEX "^static.*")
endif (EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/version.c")
if (${VERSION_TEXT} MATCHES ".*${NAME}.*") 
    STRING(REGEX REPLACE ".*Version ([0-9]+.[0-9]+.[0-9]+).*" "\\1" VERSION_TEXT "${VERSION_TEXT}")
    STRING(REGEX REPLACE "([0-9]+)[.][0-9.]*$" "\\1" MAJOR_VERSION_STRING ${VERSION_TEXT})
    STRING(REGEX REPLACE "[0-9]+[.]([0-9]+)[.][0-9.]*$" "\\1" MINOR_VERSION_STRING ${VERSION_TEXT})
    STRING(REGEX REPLACE "[0-9]+[.][0-9]+[.]([0-9]*)$" "\\1" REVISION_STRING ${VERSION_TEXT})
else (${VERSION_TEXT} MATCHES ".*${NAME}.*") 
    set(VERSION_TEXT "")
endif (${VERSION_TEXT} MATCHES ".*${NAME}.*") 

set(CPACK_PACKAGE_NAME ${CMAKE_PROJECT_NAME})
set(CPACK_PACKAGE_VERSION ${VERSION_TEXT})
set(CPACK_GENERATOR "DEB")
set(CPACK_PACKAGE_RELEASE 1)
set(CPACK_PACKAGE_CONTACT "Greg Eisenhauer")
set(CPACK_PACKAGE_VENDOR "CERCS")
set(CPACK_PACKAGING_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX})
set(CPACK_PACKAGE_FILE_NAME "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION}-${CPACK_PACKAGE_RELEASE}.${CMAKE_SYSTEM_PROCESSOR}")
set(CPACK_RPM_PACKAGE_ARCHITECTURE "${ARCH}")
include(CPack)
