setMKLthreads <- function(n){
	if (missing(n))
		n <- .Default.Revo.Threads
	if (n <= 0) 
		stop ("n must be a positive number.")
	m <- getMKLthreads() 
	.C("setThreads", n=as.integer(n), PACKAGE="Revobase")
	n1 <- getMKLthreads() 
	if (n1!=n) {
		if (m == n1) {
			cat ("\nNumber of threads at maximum: no change has been made.\n\n")
		} else {
			cat("\nMKL threads are not set as requested:\n", n1, " instead of ", n, " threads are used.\n\n")
		}
	}
	invisible(m)
}

getMKLthreads <- function() {
	x <- .C("getThreads", n=as.integer(1), PACKAGE="Revobase")
	x$n	
}
