#include "SurfaceData.h"

#include "Surface.h"

// 0x00981A1E
// Table of pre-calculated surface slopes (32) when raising the land tile for a given selection (5)
// 0x1F = new slope
// 0x20 = base height increases
constexpr uint8_t TileElementRaiseStyles[9][32] = {
    // MAP_SELECT_TYPE_CORNER_0
    { TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_CORNER_1
    { TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_CORNER_2
    { TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_CORNER_3
    { TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_FULL
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT },
    // MAP_SELECT_TYPE_EDGE_0
    { TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_EDGE_1
    { TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_EDGE_2
    { TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP },
    // MAP_SELECT_TYPE_EDGE_3
    { TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP },

};

// 0x00981ABE
// Basically the inverse of the table above.
// 0x1F = new slope
// 0x20 = base height increases
constexpr uint8_t TileElementLowerStyles[9][32] = {
    // MAP_SELECT_TYPE_CORNER_0
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_CORNER_1
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_CORNER_2
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_CORNER_3
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP
          | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP
          | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_DOUBLE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP
          | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_FULL
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      0,
      0,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0 },
    // MAP_SELECT_TYPE_EDGE_0
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP },
    // MAP_SELECT_TYPE_EDGE_1
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      0,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      0,
      0,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      0,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      0,
      0,
      TILE_ELEMENT_SLOPE_E_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP },
    // MAP_SELECT_TYPE_EDGE_2
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0,
      0,
      0,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0,
      0,
      0,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
    // MAP_SELECT_TYPE_EDGE_3
    { SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP,
      0,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      SURFACE_STYLE_FLAG_RAISE_OR_LOWER_BASE_HEIGHT | TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_E_CORNER_UP | TILE_ELEMENT_SLOPE_S_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP,
      TILE_ELEMENT_SLOPE_N_CORNER_UP | TILE_ELEMENT_SLOPE_W_CORNER_UP },
};

uint8_t LowerSurfaceCornerFlags(size_t SelectedCorner, size_t CurrentSlope)
{
    return TileElementLowerStyles[SelectedCorner][CurrentSlope];
}

uint8_t RaiseSurfaceCornerFlags(size_t SelectedCorner, size_t CurrentSlope)
{
    return TileElementRaiseStyles[SelectedCorner][CurrentSlope];
}
