#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#################################################################################


if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_GroupAssignedIdentity.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_GroupAssignedIdentity provider module";
Name = "Simple_Identity_Management_OpenDRIM_GroupAssignedIdentityModule";
Location = "cmpiSimple_Identity_Management_OpenDRIM_GroupAssignedIdentityProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_GroupAssignedIdentity provider";
Name = "Simple_Identity_Management_OpenDRIM_GroupAssignedIdentityProvider";
ProviderModuleName = "Simple_Identity_Management_OpenDRIM_GroupAssignedIdentityModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_GroupAssignedIdentity provider capabilities";
ProviderModuleName = "Simple_Identity_Management_OpenDRIM_GroupAssignedIdentityModule";
ProviderName = "Simple_Identity_Management_OpenDRIM_GroupAssignedIdentityProvider";
ClassName = "OpenDRIM_GroupAssignedIdentity";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"IdentityInfo", "ManagedElement"};
CapabilityID = "Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_GroupAssignedIdentity.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_GroupAssignedIdentity]   
   provider: Simple_Identity_Management_OpenDRIM_GroupAssignedIdentityProvider
   location: cmpiSimple_Identity_Management_OpenDRIM_GroupAssignedIdentityProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_GroupAssignedIdentity.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_GroupAssignedIdentity-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_GroupAssignedIdentity.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
