/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_LogEntryAccess.h"
#include "../OpenDRIM_RecordLog/OpenDRIM_RecordLogAccess.h"
#include "CMPIBroking.h"

#define LOG_TIME_LIMIT 15

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_unload(string& errorMessage) {
	_E_;
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_makeInstances(const string& filename, vector<OpenDRIM_LogEntry>& result, const string& discriminant,  string& errorMessage) {
	_E_;
	ifstream ifs(filename.c_str());
	if (ifs.bad()) {
		ifs.close();
		errorMessage = "Failed to open the file: "+filename;
		return FAILED;
	}

	time_t timep;
	time(&timep);
	struct tm *tp = localtime(&timep);

	OpenDRIM_LogEntry instance;
	string line;
	while (getline(ifs, line)) {
		if (line.size() < 15)
			continue;
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_populate(instance, filename, line, tp, discriminant, errorMessage));
		result.push_back(instance);
	}
	ifs.close();
	_L_;
	return OK;
}


int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_LogEntry>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	vector<OpenDRIM_RecordLog> recordLogs;
	CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_retrieve(broker, ctx, recordLogs, NULL, errorMessage, "ein"));

	for (size_t i=0; i<recordLogs.size(); i++) {
		string logInstanceID;
		recordLogs[i].getInstanceID(logInstanceID);
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_makeInstances(logInstanceID, result, discriminant, errorMessage));
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_LogEntry& instance, const char** properties, string& errorMessage) {
	_E_;
	if (!instance.InstanceID_isNULL) {
		string filename = instance.InstanceID.substr(0, instance.InstanceID.find(':'));
		string subject_timestamp = instance.InstanceID.substr(instance.InstanceID.find(':')+1);
		vector<OpenDRIM_LogEntry> result;

		ifstream ifs(filename.c_str());
		if (ifs.bad()) {
			ifs.close();
			errorMessage = "Failed to open the file: "+filename;
			return FAILED;
		}

		time_t timep;
		time(&timep);
		struct tm *tp = localtime(&timep);

		string line;
		while (getline(ifs, line)) {
			if (line.size() < 15)
				continue;
			string timestamp = CF_logTimeFormat(line.substr(0, LOG_TIME_LIMIT), tp);
			if (subject_timestamp == timestamp) {
				ifs.close();
				CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_populate(instance, filename, line, tp, "ei", errorMessage));
				return OK;
			}
		}
		ifs.close();

		errorMessage = "No instance";
		return NOT_FOUND;
	} else {
		errorMessage = "No key property";
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogEntry& newInstance, const OpenDRIM_LogEntry& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogEntry& instance, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogEntry& instance, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_populate(OpenDRIM_LogEntry& instance, const string& filename, string& line, struct tm* tp, const string& discriminant, string& errorMessage) {
	_E_;

	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID 			[KEY]
	 * [X] RecordID
	 * [X] CreationTimestamp
	 * [X] ElementName
	 * + Optional:
	 * [X] LogInstanceID
	 * [X] LogName
	 * [X] RecordData
	 * [X] RecordFormat
	 */

	string timestamp = CF_logTimeFormat(line.substr(0, LOG_TIME_LIMIT), tp);
	string id = filename+":"+timestamp;
	instance.setInstanceID(id);
	instance.setCreationTimeStamp(timestamp);
	instance.setRecordData(line);
	instance.setLogInstanceID(filename);
	instance.setRecordID(timestamp);
	instance.setRecordFormat(": string Month uint8 Day uint8 Hour:uint8 Minute:uint8 Second string HostName string Origin: string Message");
	instance.setLogName(filename);
	instance.setElementName(id);
	_L_;
	return OK;
}

// added by Frederic Desmons (2007/11/15)
int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_retrieveInDatetimeBoundaries(const string& log_file, const string& datetime_lower_limit, const string& datetime_upper_limit, vector<OpenDRIM_LogEntry>& log_entries, string& errorMessage) {
	_E_;
	ifstream ifs(log_file.c_str());
	if (ifs.bad()) {
		ifs.close();
		errorMessage = "Failed to open the file: "+log_file;
		return FAILED;
	}

	time_t timep;
	time(&timep);
	struct tm *tp = localtime(&timep);

	string line;
	while (getline(ifs, line)) {
		if (line.size() < 15)
			continue;
		string timestamp = CF_logTimeFormat(line.substr(0, LOG_TIME_LIMIT), tp);
		int upper_sign, lower_sign;
		CF_assert(CF_datetimeCmp(upper_sign, timestamp, datetime_upper_limit, errorMessage));
		CF_assert(CF_datetimeCmp(lower_sign, timestamp, datetime_lower_limit, errorMessage));
		if (upper_sign <= 0 && lower_sign >=0) {
			OpenDRIM_LogEntry instance;
			CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_populate(instance, log_file, line, tp, "ei", errorMessage));
			log_entries.push_back(instance);
		}
	}
	ifs.close();
	_L_;
	return OK;
}
