/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_PhysicalElementPackageAccess.h"

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(PhysicalAsset_CIM_PhysicalElement_load(broker, errorMessage));
	CF_assert(PhysicalAsset_CIM_PhysicalPackage_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(PhysicalAsset_CIM_PhysicalElement_unload(errorMessage));
	CF_assert(PhysicalAsset_CIM_PhysicalPackage_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_isAssociated(const Instance& PartComponent, const Instance& GroupComponent, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PhysicalElementPackage>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_enumeratePartComponents(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_enumeratePartComponents(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		PhysicalAsset_OpenDRIM_PhysicalElementPackage_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			PartComponent_classnames[0], GroupComponent_classnames[0],
			PartComponent_role.c_str(), GroupComponent_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_referencePartComponentToGroupComponent(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PhysicalElementPackage& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath PartComponent_objectpath;
	instance.getPartComponent(PartComponent_objectpath);
	Instance PartComponent_instance;
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_getPartComponent(broker, ctx, PartComponent_objectpath, PartComponent_instance, NULL, errorMessage));
	
	Objectpath GroupComponent_objectpath;
	instance.getGroupComponent(GroupComponent_objectpath);
	Instance GroupComponent_instance;
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_getGroupComponent(broker, ctx, GroupComponent_objectpath, GroupComponent_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_isAssociated(PartComponent_instance, GroupComponent_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_populate(instance, errorMessage));
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalElementPackage& newInstance, const OpenDRIM_PhysicalElementPackage& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalElementPackage& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalElementPackage& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> GroupComponent_instances;
	if (discriminant=="a")
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<GroupComponent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_isAssociated(PartComponent_instance, GroupComponent_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			GroupComponent_associatedInstances.push_back(GroupComponent_instances[i]);
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> PartComponent_instances;
	if (discriminant=="a")
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<PartComponent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_isAssociated(PartComponent_instances[i], GroupComponent_instance, isAssociated, errorMessage));
		if (isAssociated)
			PartComponent_associatedInstances.push_back(PartComponent_instances[i]);
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_PhysicalElementPackage>& OpenDRIM_PhysicalElementPackage_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < GroupComponent_instances.size(); i++) {
		OpenDRIM_PhysicalElementPackage instance;
		instance.setPartComponent(((Instance) PartComponent_instance).getObjectpath());
		instance.setGroupComponent(((Instance) GroupComponent_instances[i]).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_populate(instance, errorMessage));
		}
		
		OpenDRIM_PhysicalElementPackage_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_PhysicalElementPackage>& OpenDRIM_PhysicalElementPackage_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < PartComponent_instances.size(); i++) {
		OpenDRIM_PhysicalElementPackage instance;
		instance.setPartComponent(((Instance) PartComponent_instances[i]).getObjectpath());
		instance.setGroupComponent(((Instance) GroupComponent_instance).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(PhysicalAsset_OpenDRIM_PhysicalElementPackage_populate(instance, errorMessage));
		}
		
		OpenDRIM_PhysicalElementPackage_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalElementPackage_populate(OpenDRIM_PhysicalElementPackage& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

