//
// Copyright (c) 2020-2021, NVIDIA CORPORATION.  All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.
//

#pragma once

#include "cqi.hpp"

#include "nscq/nscq.h"

#include "nvswitch_nvlink_lane.hpp"

#include "nvswitch_nvlink_vc.hpp"

#include "nvswitch_nvlink_remote_dev.hpp"

#include <memory>

namespace nscq::cqi {

struct nvswitch_nvlink_port;

struct nvswitch_nvlink_port : public cqi {
    using cqi_t = nvswitch_nvlink_port;
    using id_t = uint8_t;
    using cqi::cqi;
    [[nodiscard]] virtual auto get_id() const -> id_t = 0;

    virtual auto make_cqi(type<nvswitch_nvlink_lane>, const nvswitch_nvlink_lane::id_t&)
        -> std::shared_ptr<nvswitch_nvlink_lane> = 0;

    virtual auto get_ids(type<nvswitch_nvlink_lane>) const
        -> std::vector<nvswitch_nvlink_lane::id_t> = 0;

    virtual auto make_cqi(type<nvswitch_nvlink_vc>, const nvswitch_nvlink_vc::id_t&)
        -> std::shared_ptr<nvswitch_nvlink_vc> = 0;

    virtual auto get_ids(type<nvswitch_nvlink_vc>) const
        -> std::vector<nvswitch_nvlink_vc::id_t> = 0;

    virtual auto has(type<nvswitch_nvlink_remote_dev>) -> bool = 0;
    virtual auto make_cqi(type<nvswitch_nvlink_remote_dev>)
        -> std::shared_ptr<nvswitch_nvlink_remote_dev> = 0;

    struct link_state_field : public watchable_field<nvswitch_nvlink_port, readable<nvlink_state_t>> {
        link_state_field(std::shared_ptr<nscq::cqi_session> &cqi_session) : watchable_field<nvswitch_nvlink_port, readable<nvlink_state_t>>(cqi_session) {}
    };
    virtual auto get(link_state_field) -> nvlink_state_t = 0;
    virtual auto watch(link_state_field) -> void = 0;
    virtual auto unwatch(link_state_field) -> void = 0;

    struct port_link_version_field: public field<nvswitch_nvlink_port, readable<std::optional<uint8_t>>> {};
    virtual auto get(port_link_version_field) -> std::optional<uint8_t> = 0;

    struct port_sublink_width_field : public field<nvswitch_nvlink_port, readable<std::optional<uint8_t>>> {};
    virtual auto get(port_sublink_width_field ) -> std::optional<uint8_t> = 0;

    struct port_bandwidth_field : public field<nvswitch_nvlink_port, readable<std::optional<uint32_t>>> {};
    virtual auto get(port_bandwidth_field) -> std::optional<uint32_t> = 0;

    struct port_data_rate_field : public field<nvswitch_nvlink_port, readable<std::optional<uint32_t>>> {};
    virtual auto get(port_data_rate_field) -> std::optional<uint32_t> = 0;

    struct port_reset_required_field : public field<nvswitch_nvlink_port, readable<bool>> {};
    virtual auto get(port_reset_required_field) -> bool = 0;

    struct port_throughput_field : public field<nvswitch_nvlink_port, readable<nscq_link_throughput_t>> {};
    virtual auto get(port_throughput_field) -> nscq_link_throughput_t = 0;
    virtual auto has(port_throughput_field) -> bool = 0;

    struct port_raw_throughput_field : public field<nvswitch_nvlink_port, readable<nscq_link_throughput_t>> {};
    virtual auto get(port_raw_throughput_field) -> nscq_link_throughput_t = 0;
    virtual auto has(port_raw_throughput_field) -> bool = 0;

    struct port_fatal_error_field : public watchable_field<nvswitch_nvlink_port, readable<std::vector<nscq_error_t>>> {
        port_fatal_error_field(std::shared_ptr<nscq::cqi_session> &cqi_session) : watchable_field<nvswitch_nvlink_port, readable<std::vector<nscq_error_t>>>(cqi_session) {}
    };
    virtual auto get(port_fatal_error_field) -> std::vector<nscq_error_t> = 0;
    virtual auto watch(port_fatal_error_field) -> void = 0;
    virtual auto unwatch(port_fatal_error_field) -> void = 0;

    struct port_nonfatal_error_field : public watchable_field<nvswitch_nvlink_port, readable<std::vector<nscq_error_t>>> {
        port_nonfatal_error_field(std::shared_ptr<nscq::cqi_session> &cqi_session) : watchable_field<nvswitch_nvlink_port,
                                  readable<std::vector<nscq_error_t>>>(cqi_session) {}
    };
    virtual auto get(port_nonfatal_error_field) -> std::vector<nscq_error_t> = 0;
    virtual auto watch(port_nonfatal_error_field) -> void = 0;
    virtual auto unwatch(port_nonfatal_error_field) -> void = 0;

    struct replay_count_field : public field<nvswitch_nvlink_port, readable<std::optional<uint64_t>>> {};
    virtual auto get(replay_count_field) -> std::optional<uint64_t> = 0;

    struct recovery_count_field : public field<nvswitch_nvlink_port, readable<std::optional<uint64_t>>> {};
    virtual auto get(recovery_count_field) -> std::optional<uint64_t> = 0;

    struct flit_err_count_field : public field<nvswitch_nvlink_port, readable<std::optional<uint64_t>>> {};
    virtual auto get(flit_err_count_field) -> std::optional<uint64_t> = 0;

    struct lane_crc_err_count_aggregate_field : public field<nvswitch_nvlink_port, readable<std::optional<uint64_t>>> {};
    virtual auto get(lane_crc_err_count_aggregate_field) -> std::optional<uint64_t> = 0;

    struct lane_ecc_err_count_aggregate_field : public field<nvswitch_nvlink_port, readable<std::optional<uint64_t>>> {};
    virtual auto get(lane_ecc_err_count_aggregate_field) -> std::optional<uint64_t> = 0;

    struct max_correctable_flit_crc_error_rate_daily_field : public field<nvswitch_nvlink_port,
               readable<std::vector<nscq_link_max_correctable_error_rate>>> {};
    virtual auto get(max_correctable_flit_crc_error_rate_daily_field) -> std::vector<nscq_link_max_correctable_error_rate> = 0;

    struct max_correctable_flit_crc_error_rate_monthly_field : public field<nvswitch_nvlink_port,
               readable<std::vector<nscq_link_max_correctable_error_rate>>> {};
    virtual auto get(max_correctable_flit_crc_error_rate_monthly_field) -> std::vector<nscq_link_max_correctable_error_rate> = 0;

    struct port_rx_sublink_state_field : public field<nvswitch_nvlink_port, readable<nvlink_rx_sublink_state_t>> {};
    virtual auto get(port_rx_sublink_state_field) -> nvlink_rx_sublink_state_t = 0;

    struct port_tx_sublink_state_field : public field<nvswitch_nvlink_port, readable<nvlink_tx_sublink_state_t>> {};
    virtual auto get(port_tx_sublink_state_field) -> nvlink_tx_sublink_state_t = 0;

};
} // namespace nscq::cqi
