#include <stdio.h>
#include "freedos.h"

/***************************************************************************
 * This function saves a copy of the input to pSave while simultaneously
 * copying to the output.
 *
 * returns: TRUE if pIn was tee'd successfully, FALSE if pSave or pOut
 * could not take input.
 *
 * maintainer: James Hall
 */

int 
outtee (FILE * pIn, FILE * pSave, FILE * pOut)
{
  char ch;

  /* Tee the output */

  while ((ch = fgetc (pIn)) != EOF)
    if ((fputc (ch, pSave) == EOF) || (fputc (ch, pOut) == EOF))
      return (FALSE);

  return (TRUE);
}
