/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIHV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgHasValue(const char * const name);

	Check if the currrent section has such value, user INI file is 
	searched first.

ob(ject): cfgHasValue
su(bsystem): inifile/2
sh(ort description): Seek to the first value \para{name}
lo(ng description): Seek to the first value with the specified name within
	the current section. First the user INI files, then the system INI file
	is checked.
	 If \para{name} == NULL, the current value is
	searched.
re(lated to): 
fi(le): cfgihv.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIHV.C 1.3 1999/12/13 02:22:25 ska Exp ska $";
#endif

int cfgHasValue(const char * const name)
{	int rv;
	DBG_ENTER("cfgHasValue", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	if(!name)
		DBG_RETURN_BI( hasValue()? CFG_ERR_NONE: CFG_ERR_ARG)

	chkHeap
	I(valLocation) = 1;		/* in user INI file */
	if((rv = cfgHasUserValue(name)) == CFG_ERR_END) {
		chkHeap
		I(valLocation) = 0;		/* in system INI file */
		rv = cfgHasSystemValue(name);
		chkHeap
	}

	if(rv != CFG_ERR_NONE)
		I(valLocation) = -1;		/* error --> no location */

	chkHeap
	DBG_RETURN_I( rv)
}
