/* playlist.c generated by valac 0.56.7, the Vala compiler
 * generated from playlist.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "xfmpc.h"
#include <src/libc/mpdclient.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

enum  {
	XFMPC_PLAYLIST_0_PROPERTY,
	XFMPC_PLAYLIST_NUM_PROPERTIES
};
static GParamSpec* xfmpc_playlist_properties[XFMPC_PLAYLIST_NUM_PROPERTIES];
typedef enum  {
	XFMPC_PLAYLIST_COLUMNS_COLUMN_ID,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT,
	XFMPC_PLAYLIST_COLUMNS_N_COLUMNS
} XfmpcPlaylistColumns;

#define XFMPC_PLAYLIST_TYPE_COLUMNS (xfmpc_playlist_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _XfmpcPlaylistPrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkListStore* store;
	GtkTreeModelFilter* filter;
	GtkTreeView* treeview;
	GtkMenu* menu;
	GtkMenuItem* mi_browse;
	GtkMenuItem* mi_information;
	gint current;
	gboolean autocenter;
};

static gint XfmpcPlaylist_private_offset;
static gpointer xfmpc_playlist_parent_class = NULL;
static GtkEntry* xfmpc_playlist_filter_entry;
static GtkEntry* xfmpc_playlist_filter_entry = NULL;

static GType xfmpc_playlist_columns_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean xfmpc_playlist_visible_func_filter_tree (GtkTreeModel* model,
                                                  GtkTreeIter* iter);
static void xfmpc_playlist_cb_browse_selection (XfmpcPlaylist* self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void xfmpc_playlist_cb_info_selection (XfmpcPlaylist* self);
static gboolean xfmpc_playlist_cb_popup_menu (XfmpcPlaylist* self);
static void xfmpc_playlist_menu_popup (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_pp_changed (XfmpcPlaylist* self,
                                   gboolean is_playing);
static void xfmpc_playlist_cb_song_changed (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_playlist_changed (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_row_activated (XfmpcPlaylist* self,
                                      GtkTreePath* path,
                                      GtkTreeViewColumn* column);
static gboolean xfmpc_playlist_cb_key_released (XfmpcPlaylist* self,
                                         GdkEventKey* event);
static gboolean xfmpc_playlist_cb_button_released (XfmpcPlaylist* self,
                                            GdkEventButton* event);
static void xfmpc_playlist_cb_filter_entry_activated (XfmpcPlaylist* self);
static gboolean xfmpc_playlist_cb_filter_entry_key_released (XfmpcPlaylist* self,
                                                      GdkEventKey* event);
static void xfmpc_playlist_cb_filter_entry_changed (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_filter_entry_icon_activated (XfmpcPlaylist* self,
                                                    GtkEntryIconPosition icon_pos,
                                                    GdkEvent* event);
static GObject * xfmpc_playlist_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _xfmpc_playlist_delete_selection_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self);
static void _xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                 gpointer self);
static void _xfmpc_playlist_cb_info_selection_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self);
static void _xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender,
                                                               gboolean is_playing,
                                                               gpointer self);
static void _xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender,
                                                                   gpointer self);
static void _xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender,
                                                                           gpointer self);
static void _xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                   GtkTreePath* path,
                                                                   GtkTreeViewColumn* column,
                                                                   gpointer self);
static gboolean _xfmpc_playlist_cb_key_released_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                       GdkEventKey* event,
                                                                       gpointer self);
static gboolean _xfmpc_playlist_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self);
static gboolean _xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                              gpointer self);
static void _xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                   gpointer self);
static gboolean _xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                                    GdkEventKey* event,
                                                                                    gpointer self);
static void _xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                   gpointer self);
static void _xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender,
                                                                            GtkEntryIconPosition icon_pos,
                                                                            GdkEvent* event,
                                                                            gpointer self);
static void _xfmpc_playlist_cb_playlist_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void xfmpc_playlist_finalize (GObject * obj);
static GType xfmpc_playlist_get_type_once (void);

static inline gpointer
xfmpc_playlist_get_instance_private (XfmpcPlaylist* self)
{
	return G_STRUCT_MEMBER_P (self, XfmpcPlaylist_private_offset);
}

static GType
xfmpc_playlist_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, "XFMPC_PLAYLIST_COLUMNS_COLUMN_ID", "column-id"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, "XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME", "column-filename"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, "XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION", "column-position"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, "XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG", "column-song"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, "XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH", "column-length"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, "XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT", "column-weight"}, {XFMPC_PLAYLIST_COLUMNS_N_COLUMNS, "XFMPC_PLAYLIST_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType xfmpc_playlist_columns_type_id;
	xfmpc_playlist_columns_type_id = g_enum_register_static ("XfmpcPlaylistColumns", values);
	return xfmpc_playlist_columns_type_id;
}

static GType
xfmpc_playlist_columns_get_type (void)
{
	static volatile gsize xfmpc_playlist_columns_type_id__once = 0;
	if (g_once_init_enter (&xfmpc_playlist_columns_type_id__once)) {
		GType xfmpc_playlist_columns_type_id;
		xfmpc_playlist_columns_type_id = xfmpc_playlist_columns_get_type_once ();
		g_once_init_leave (&xfmpc_playlist_columns_type_id__once, xfmpc_playlist_columns_type_id);
	}
	return xfmpc_playlist_columns_type_id__once;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
xfmpc_playlist_visible_func_filter_tree (GtkTreeModel* model,
                                         GtkTreeIter* iter)
{
	gchar* song = NULL;
	gchar* _tmp0_;
	gchar* search = NULL;
	gchar* _tmp1_;
	gboolean _result_ = FALSE;
	GtkTreeIter _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean result;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	song = _tmp0_;
	_tmp1_ = g_strdup ("");
	search = _tmp1_;
	_result_ = TRUE;
	_tmp2_ = *iter;
	gtk_tree_model_get (model, &_tmp2_, XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, &song, -1, -1);
	_tmp4_ = song;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = song;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	if (_tmp3_) {
		result = TRUE;
		_g_free0 (search);
		_g_free0 (song);
		return result;
	}
	_tmp6_ = xfmpc_playlist_filter_entry;
	_tmp7_ = gtk_entry_get_text (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (search);
	search = _tmp8_;
	_tmp9_ = search;
	_tmp10_ = g_utf8_casefold (_tmp9_, (gssize) -1);
	_g_free0 (search);
	search = _tmp10_;
	_tmp11_ = search;
	if (g_strcmp0 (_tmp11_, "") != 0) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp12_ = song;
		_tmp13_ = g_utf8_casefold (_tmp12_, (gssize) -1);
		_g_free0 (song);
		song = _tmp13_;
		_tmp14_ = song;
		_tmp15_ = search;
		if (string_index_of (_tmp14_, _tmp15_, 0) == -1) {
			_result_ = FALSE;
		}
	}
	result = _result_;
	_g_free0 (search);
	_g_free0 (song);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
xfmpc_playlist_cb_browse_selection (XfmpcPlaylist* self)
{
	XfmpcDbbrowser* dbbrowser = NULL;
	XfmpcExtendedInterface* extended_interface = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GtkTreeModel* model = NULL;
	GtkTreeModelFilter* _tmp6_;
	GtkTreeModel* _tmp7_;
	GList* list = NULL;
	GtkTreeSelection* _tmp8_;
	GtkTreeModel* _tmp9_ = NULL;
	GList* _tmp10_;
	GtkTreeModel* _tmp11_;
	GList* _tmp12_;
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	GList* _tmp13_;
	gconstpointer _tmp14_;
	GtkTreePath* _tmp15_;
	GtkTreeModelFilter* _tmp16_;
	GtkTreePath* _tmp17_;
	GtkTreeIter _tmp18_ = {0};
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcDbbrowser");
	dbbrowser = (XfmpcDbbrowser*) _tmp0_;
	_tmp1_ = g_object_get_data ((GObject*) self, "XfmpcExtendedInterface");
	extended_interface = (XfmpcExtendedInterface*) _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	selection = _tmp4_;
	_tmp5_ = selection;
	if (gtk_tree_selection_count_selected_rows (_tmp5_) > 1) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp6_ = self->priv->filter;
	_tmp7_ = _g_object_ref0 ((GtkTreeModel*) _tmp6_);
	model = _tmp7_;
	_tmp8_ = selection;
	_tmp10_ = gtk_tree_selection_get_selected_rows (_tmp8_, &_tmp9_);
	_g_object_unref0 (model);
	_tmp11_ = _g_object_ref0 (_tmp9_);
	model = _tmp11_;
	list = _tmp10_;
	_tmp12_ = list;
	if (g_list_length (_tmp12_) == ((guint) 0)) {
		(list == NULL) ? NULL : (list = (_g_list_free___vala_GtkTreePath_free0_ (list), NULL));
		_g_object_unref0 (model);
		_g_object_unref0 (selection);
		return;
	}
	_tmp13_ = list;
	_tmp14_ = g_list_nth_data (_tmp13_, (guint) 0);
	_tmp15_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp14_);
	path = _tmp15_;
	_tmp16_ = self->priv->filter;
	_tmp17_ = path;
	_tmp19_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp16_, &_tmp18_, _tmp17_);
	iter = _tmp18_;
	if (_tmp19_) {
		gchar* filename = NULL;
		gchar* _tmp20_;
		gchar* dir = NULL;
		GtkTreeModelFilter* _tmp21_;
		GtkTreeIter _tmp22_;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		XfmpcDbbrowser* _tmp26_;
		const gchar* _tmp27_;
		XfmpcDbbrowser* _tmp28_;
		XfmpcExtendedInterface* _tmp29_;
		_tmp20_ = g_strdup ("");
		filename = _tmp20_;
		_tmp21_ = self->priv->filter;
		_tmp22_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp21_, &_tmp22_, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, &_tmp23_, -1, -1);
		_g_free0 (filename);
		filename = _tmp23_;
		_tmp24_ = filename;
		_tmp25_ = g_path_get_dirname (_tmp24_);
		_g_free0 (dir);
		dir = _tmp25_;
		_tmp26_ = dbbrowser;
		_tmp27_ = dir;
		xfmpc_dbbrowser_set_wdir (_tmp26_, _tmp27_);
		_tmp28_ = dbbrowser;
		xfmpc_dbbrowser_reload (_tmp28_);
		_tmp29_ = extended_interface;
		xfmpc_extended_interface_set_active (_tmp29_, XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_DBBROWSER);
		_g_free0 (dir);
		_g_free0 (filename);
	}
	__vala_GtkTreePath_free0 (path);
	(list == NULL) ? NULL : (list = (_g_list_free___vala_GtkTreePath_free0_ (list), NULL));
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}

static void
xfmpc_playlist_cb_info_selection (XfmpcPlaylist* self)
{
	GtkTreeIter iter = {0};
	gint id = 0;
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* model = NULL;
	GtkTreeModelFilter* _tmp4_;
	GtkTreeModel* _tmp5_;
	GList* list = NULL;
	GtkTreeSelection* _tmp6_;
	GtkTreeModel* _tmp7_ = NULL;
	GList* _tmp8_;
	GtkTreeModel* _tmp9_;
	GList* _tmp10_;
	GtkTreePath* path = NULL;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	GtkTreePath* _tmp13_;
	GtkTreeModelFilter* _tmp14_;
	GtkTreePath* _tmp15_;
	GtkTreeIter _tmp16_ = {0};
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	id = 0;
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	if (gtk_tree_selection_count_selected_rows (_tmp3_) > 1) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp4_ = self->priv->filter;
	_tmp5_ = _g_object_ref0 ((GtkTreeModel*) _tmp4_);
	model = _tmp5_;
	_tmp6_ = selection;
	_tmp8_ = gtk_tree_selection_get_selected_rows (_tmp6_, &_tmp7_);
	_g_object_unref0 (model);
	_tmp9_ = _g_object_ref0 (_tmp7_);
	model = _tmp9_;
	list = _tmp8_;
	_tmp10_ = list;
	if (g_list_length (_tmp10_) == ((guint) 0)) {
		(list == NULL) ? NULL : (list = (_g_list_free___vala_GtkTreePath_free0_ (list), NULL));
		_g_object_unref0 (model);
		_g_object_unref0 (selection);
		return;
	}
	_tmp11_ = list;
	_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
	_tmp13_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp12_);
	path = _tmp13_;
	_tmp14_ = self->priv->filter;
	_tmp15_ = path;
	_tmp17_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp14_, &_tmp16_, _tmp15_);
	iter = _tmp16_;
	if (_tmp17_) {
		GtkTreeModelFilter* _tmp18_;
		GtkTreeIter _tmp19_;
		gint _tmp20_ = 0;
		XfmpcSongDialog* dialog = NULL;
		XfmpcSongDialog* _tmp21_;
		XfmpcSongDialog* _tmp22_;
		_tmp18_ = self->priv->filter;
		_tmp19_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp18_, &_tmp19_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &_tmp20_, -1, -1);
		id = _tmp20_;
		_tmp21_ = xfmpc_song_dialog_new (id);
		g_object_ref_sink (_tmp21_);
		dialog = _tmp21_;
		_tmp22_ = dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp22_);
		_g_object_unref0 (dialog);
	}
	__vala_GtkTreePath_free0 (path);
	(list == NULL) ? NULL : (list = (_g_list_free___vala_GtkTreePath_free0_ (list), NULL));
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}

static gboolean
xfmpc_playlist_cb_popup_menu (XfmpcPlaylist* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_playlist_menu_popup (self);
	result = TRUE;
	return result;
}

static void
xfmpc_playlist_cb_pp_changed (XfmpcPlaylist* self,
                              gboolean is_playing)
{
	g_return_if_fail (self != NULL);
	xfmpc_playlist_refresh_current_song (self);
}

static void
xfmpc_playlist_cb_song_changed (XfmpcPlaylist* self)
{
	g_return_if_fail (self != NULL);
	xfmpc_playlist_refresh_current_song (self);
}

static void
xfmpc_playlist_cb_playlist_changed (XfmpcPlaylist* self)
{
	gchar* filename = NULL;
	gchar* song = NULL;
	gchar* length = NULL;
	gint id = 0;
	gint pos = 0;
	XfmpcMpdclient* _tmp0_;
	GtkListStore* _tmp1_;
	g_return_if_fail (self != NULL);
	filename = NULL;
	song = NULL;
	length = NULL;
	id = 0;
	pos = 0;
	_tmp0_ = self->priv->mpdclient;
	self->priv->current = xfmpc_mpdclient_get_id (_tmp0_);
	_tmp1_ = self->priv->store;
	gtk_list_store_clear (_tmp1_);
	while (TRUE) {
		XfmpcMpdclient* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gboolean _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp2_ = self->priv->mpdclient;
		_tmp8_ = xfmpc_mpdclient_playlist_read (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
		id = _tmp3_;
		pos = _tmp4_;
		_g_free0 (filename);
		filename = _tmp5_;
		_g_free0 (song);
		song = _tmp6_;
		_g_free0 (length);
		length = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = filename;
		_tmp10_ = song;
		_tmp11_ = length;
		xfmpc_playlist_append (self, id, pos, _tmp9_, _tmp10_, _tmp11_);
	}
	xfmpc_playlist_refresh_current_song (self);
	_g_free0 (length);
	_g_free0 (song);
	_g_free0 (filename);
}

static void
xfmpc_playlist_cb_row_activated (XfmpcPlaylist* self,
                                 GtkTreePath* path,
                                 GtkTreeViewColumn* column)
{
	GtkTreeIter iter = {0};
	GtkTreePath* new_path = NULL;
	GtkTreePath* _tmp0_;
	gint id = 0;
	GtkTreeModelFilter* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkTreeModelFilter* _tmp5_;
	GtkTreeIter _tmp6_;
	gint _tmp7_ = 0;
	GtkEntry* _tmp8_;
	XfmpcMpdclient* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = __vala_GtkTreePath_copy0 (path);
	new_path = _tmp0_;
	id = 0;
	_tmp1_ = self->priv->filter;
	_tmp2_ = new_path;
	_tmp4_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp1_, &_tmp3_, _tmp2_);
	iter = _tmp3_;
	if (!_tmp4_) {
		__vala_GtkTreePath_free0 (new_path);
		return;
	}
	_tmp5_ = self->priv->filter;
	_tmp6_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp5_, &_tmp6_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &_tmp7_, -1, -1);
	id = _tmp7_;
	_tmp8_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_text (_tmp8_, "");
	_tmp9_ = self->priv->mpdclient;
	xfmpc_mpdclient_set_id (_tmp9_, id);
	__vala_GtkTreePath_free0 (new_path);
}

static gboolean
xfmpc_playlist_cb_key_released (XfmpcPlaylist* self,
                                GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	switch (event->keyval) {
		case 0xffff:
		{
			xfmpc_playlist_delete_selection (self);
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
xfmpc_playlist_cb_button_released (XfmpcPlaylist* self,
                                   GdkEventButton* event)
{
	GtkTreePath* path = NULL;
	GtkTreeSelection* selection = NULL;
	gboolean _tmp0_ = FALSE;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	gboolean sensitive = FALSE;
	GtkTreeSelection* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreePath* _tmp8_ = NULL;
	gboolean _tmp9_;
	GtkTreeSelection* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type != GDK_BUTTON_PRESS) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event->button != ((guint) 3);
	}
	if (_tmp0_) {
		result = FALSE;
		_g_object_unref0 (selection);
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	_tmp1_ = self->priv->treeview;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (selection);
	selection = _tmp3_;
	_tmp4_ = selection;
	sensitive = gtk_tree_selection_count_selected_rows (_tmp4_) == 1;
	_tmp5_ = self->priv->mi_browse;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, sensitive);
	_tmp6_ = self->priv->mi_information;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, sensitive);
	_tmp7_ = self->priv->treeview;
	_tmp9_ = gtk_tree_view_get_path_at_pos (_tmp7_, (gint) event->x, (gint) event->y, &_tmp8_, NULL, NULL, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp8_;
	if (_tmp9_) {
		GtkTreeSelection* _tmp10_;
		GtkTreePath* _tmp11_;
		_tmp10_ = selection;
		_tmp11_ = path;
		if (!gtk_tree_selection_path_is_selected (_tmp10_, _tmp11_)) {
			GtkTreeSelection* _tmp12_;
			GtkTreeSelection* _tmp13_;
			GtkTreePath* _tmp14_;
			_tmp12_ = selection;
			gtk_tree_selection_unselect_all (_tmp12_);
			_tmp13_ = selection;
			_tmp14_ = path;
			gtk_tree_selection_select_path (_tmp13_, _tmp14_);
		}
	}
	_tmp15_ = selection;
	if (gtk_tree_selection_count_selected_rows (_tmp15_) < 1) {
		result = TRUE;
		_g_object_unref0 (selection);
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	xfmpc_playlist_menu_popup (self);
	result = TRUE;
	_g_object_unref0 (selection);
	__vala_GtkTreePath_free0 (path);
	return result;
}

static void
xfmpc_playlist_menu_popup (XfmpcPlaylist* self)
{
	GtkMenu* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->menu;
	gtk_menu_popup_at_pointer (_tmp0_, NULL);
}

static void
xfmpc_playlist_cb_filter_entry_activated (XfmpcPlaylist* self)
{
	GtkTreeModel* model = NULL;
	GtkTreeModelFilter* _tmp0_;
	GtkTreeModel* _tmp1_;
	GList* list = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreePath* path = NULL;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GtkTreePath* _tmp9_;
	GList* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->filter;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	list = _tmp5_;
	_tmp7_ = list;
	_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
	_tmp9_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp8_);
	path = _tmp9_;
	_tmp10_ = list;
	if (g_list_length (_tmp10_) > ((guint) 0)) {
		GtkTreeView* _tmp11_;
		GtkTreePath* _tmp12_;
		GtkTreeView* _tmp13_;
		GtkTreeViewColumn* _tmp14_;
		GtkEntry* _tmp15_;
		GtkTreeView* _tmp16_;
		_tmp11_ = self->priv->treeview;
		_tmp12_ = path;
		_tmp13_ = self->priv->treeview;
		_tmp14_ = gtk_tree_view_get_column (_tmp13_, 0);
		gtk_tree_view_row_activated (_tmp11_, _tmp12_, _tmp14_);
		_tmp15_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_text (_tmp15_, "");
		xfmpc_playlist_select_row (self, self->priv->current);
		_tmp16_ = self->priv->treeview;
		gtk_widget_grab_focus ((GtkWidget*) _tmp16_);
	}
	__vala_GtkTreePath_free0 (path);
	(list == NULL) ? NULL : (list = (_g_list_free___vala_GtkTreePath_free0_ (list), NULL));
	_g_object_unref0 (model);
}

static gboolean
xfmpc_playlist_cb_filter_entry_key_released (XfmpcPlaylist* self,
                                             GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	if (event->keyval == ((guint) 0xff1b)) {
		GtkEntry* _tmp0_;
		GtkTreeView* _tmp1_;
		_tmp0_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_text (_tmp0_, "");
		xfmpc_playlist_select_row (self, self->priv->current);
		_tmp1_ = self->priv->treeview;
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	} else {
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = xfmpc_playlist_filter_entry;
		_tmp3_ = gtk_entry_get_text (_tmp2_);
		if (g_strcmp0 (_tmp3_, "") != 0) {
			xfmpc_playlist_select_row (self, 0);
		} else {
			xfmpc_playlist_select_row (self, self->priv->current);
		}
	}
	result = TRUE;
	return result;
}

static void
xfmpc_playlist_cb_filter_entry_changed (XfmpcPlaylist* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeModelFilter* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xfmpc_playlist_filter_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GtkEntry* _tmp2_;
		_tmp2_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_icon_from_icon_name (_tmp2_, GTK_ENTRY_ICON_SECONDARY, "edit-clear");
	} else {
		GtkEntry* _tmp3_;
		_tmp3_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_icon_from_icon_name (_tmp3_, GTK_ENTRY_ICON_SECONDARY, NULL);
	}
	_tmp4_ = self->priv->filter;
	gtk_tree_model_filter_refilter (_tmp4_);
}

static void
xfmpc_playlist_cb_filter_entry_icon_activated (XfmpcPlaylist* self,
                                               GtkEntryIconPosition icon_pos,
                                               GdkEvent* event)
{
	GtkEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	if (icon_pos != GTK_ENTRY_ICON_SECONDARY) {
		return;
	}
	_tmp0_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_text (_tmp0_, "");
	xfmpc_playlist_select_row (self, self->priv->current);
}

void
xfmpc_playlist_append (XfmpcPlaylist* self,
                       gint id,
                       gint pos,
                       const gchar* filename,
                       const gchar* song,
                       const gchar* length)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (song != NULL);
	g_return_if_fail (length != NULL);
	_tmp0_ = self->priv->store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->store;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, id, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, filename, XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, pos + 1, XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, song, XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, length, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_NORMAL, -1, -1);
}

void
xfmpc_playlist_refresh_current_song (XfmpcPlaylist* self)
{
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	XfmpcMpdclient* _tmp7_;
	GtkTreePath* _tmp8_;
	GtkListStore* _tmp9_;
	GtkTreePath* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_;
	gboolean _tmp15_ = FALSE;
	GtkEntry* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	if (self->priv->current < 0) {
		self->priv->current = 0;
	}
	_tmp0_ = gtk_tree_path_new_from_indices (self->priv->current, -1, -1);
	__vala_GtkTreePath_free0 (path);
	path = _tmp0_;
	_tmp1_ = self->priv->store;
	_tmp2_ = path;
	_tmp4_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp1_, &_tmp3_, _tmp2_);
	iter = _tmp3_;
	if (_tmp4_) {
		GtkListStore* _tmp5_;
		GtkTreeIter _tmp6_;
		_tmp5_ = self->priv->store;
		_tmp6_ = iter;
		gtk_list_store_set (_tmp5_, &_tmp6_, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_NORMAL, -1, -1);
	}
	_tmp7_ = self->priv->mpdclient;
	self->priv->current = xfmpc_mpdclient_get_pos (_tmp7_);
	_tmp8_ = gtk_tree_path_new_from_indices (self->priv->current, -1, -1);
	__vala_GtkTreePath_free0 (path);
	path = _tmp8_;
	_tmp9_ = self->priv->store;
	_tmp10_ = path;
	_tmp12_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp9_, &_tmp11_, _tmp10_);
	iter = _tmp11_;
	if (_tmp12_) {
		GtkListStore* _tmp13_;
		GtkTreeIter _tmp14_;
		_tmp13_ = self->priv->store;
		_tmp14_ = iter;
		gtk_list_store_set (_tmp13_, &_tmp14_, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_BOLD, -1, -1);
	}
	_tmp16_ = xfmpc_playlist_filter_entry;
	_tmp17_ = gtk_entry_get_text (_tmp16_);
	if (g_strcmp0 (_tmp17_, "") == 0) {
		_tmp15_ = self->priv->autocenter;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		xfmpc_playlist_select_row (self, self->priv->current);
	}
	__vala_GtkTreePath_free0 (path);
}

void
xfmpc_playlist_select_row (XfmpcPlaylist* self,
                           gint i)
{
	GtkTreeModelFilter* _tmp0_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkTreePath* _tmp5_;
	g_return_if_fail (self != NULL);
	if (self->priv->current < 0) {
		return;
	}
	_tmp0_ = self->priv->filter;
	if (gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp0_, NULL) == 0) {
		return;
	}
	_tmp1_ = gtk_tree_path_new_from_indices (i, -1, -1);
	path = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = path;
	gtk_tree_view_set_cursor (_tmp2_, _tmp3_, NULL, FALSE);
	_tmp4_ = self->priv->treeview;
	_tmp5_ = path;
	gtk_tree_view_scroll_to_cell (_tmp4_, _tmp5_, NULL, TRUE, (gfloat) 0.42, (gfloat) 0);
	__vala_GtkTreePath_free0 (path);
}

void
xfmpc_playlist_delete_selection (XfmpcPlaylist* self)
{
	gint id = 0;
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeModelFilter* _tmp0_;
	GtkTreeModel* _tmp1_;
	GList* list = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_;
	GtkTreeModel* _tmp6_;
	GList* _tmp7_;
	XfmpcMpdclient* _tmp17_;
	g_return_if_fail (self != NULL);
	id = 0;
	_tmp0_ = self->priv->filter;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	list = _tmp5_;
	_tmp7_ = list;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp7_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp8_;
			GtkTreePath* path = NULL;
			_tmp8_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp8_;
			{
				GtkTreeModelFilter* _tmp9_;
				GtkTreePath* _tmp10_;
				GtkTreeIter _tmp11_ = {0};
				gboolean _tmp12_;
				_tmp9_ = self->priv->filter;
				_tmp10_ = path;
				_tmp12_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp9_, &_tmp11_, _tmp10_);
				iter = _tmp11_;
				if (_tmp12_) {
					GtkTreeModelFilter* _tmp13_;
					GtkTreeIter _tmp14_;
					gint _tmp15_ = 0;
					XfmpcMpdclient* _tmp16_;
					_tmp13_ = self->priv->filter;
					_tmp14_ = iter;
					gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &_tmp15_, -1, -1);
					id = _tmp15_;
					_tmp16_ = self->priv->mpdclient;
					xfmpc_mpdclient_queue_remove_id (_tmp16_, id);
				}
				__vala_GtkTreePath_free0 (path);
			}
		}
	}
	_tmp17_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_commit (_tmp17_);
	(list == NULL) ? NULL : (list = (_g_list_free___vala_GtkTreePath_free0_ (list), NULL));
	_g_object_unref0 (model);
}

gboolean
xfmpc_playlist_has_filename (XfmpcPlaylist* self,
                             const gchar* filename,
                             gboolean is_dir)
{
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	gchar* name = NULL;
	gchar* _tmp0_;
	GtkTreePath* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	name = _tmp0_;
	_tmp1_ = gtk_tree_path_new_from_indices (0, -1, -1);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	while (TRUE) {
		GtkListStore* _tmp2_;
		GtkTreePath* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
		GtkListStore* _tmp6_;
		GtkTreeIter _tmp7_;
		gchar* _tmp8_ = NULL;
		GtkTreePath* _tmp11_;
		_tmp2_ = self->priv->store;
		_tmp3_ = path;
		_tmp5_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp2_, &_tmp4_, _tmp3_);
		iter = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = self->priv->store;
		_tmp7_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, &_tmp8_, -1, -1);
		_g_free0 (name);
		name = _tmp8_;
		if (is_dir) {
			const gchar* _tmp9_;
			_tmp9_ = name;
			if (g_str_has_prefix (_tmp9_, filename)) {
				result = TRUE;
				_g_free0 (name);
				__vala_GtkTreePath_free0 (path);
				return result;
			}
		} else {
			const gchar* _tmp10_;
			_tmp10_ = name;
			if (g_strcmp0 (_tmp10_, filename) == 0) {
				result = TRUE;
				_g_free0 (name);
				__vala_GtkTreePath_free0 (path);
				return result;
			}
		}
		_tmp11_ = path;
		gtk_tree_path_next (_tmp11_);
	}
	result = FALSE;
	_g_free0 (name);
	__vala_GtkTreePath_free0 (path);
	return result;
}

XfmpcPlaylist*
xfmpc_playlist_construct (GType object_type)
{
	XfmpcPlaylist * self = NULL;
	self = (XfmpcPlaylist*) g_object_new (object_type, NULL);
	return self;
}

XfmpcPlaylist*
xfmpc_playlist_new (void)
{
	return xfmpc_playlist_construct (XFMPC_TYPE_PLAYLIST);
}

static void
_xfmpc_playlist_delete_selection_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self)
{
	xfmpc_playlist_delete_selection ((XfmpcPlaylist*) self);
}

static void
_xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                            gpointer self)
{
	xfmpc_playlist_cb_browse_selection ((XfmpcPlaylist*) self);
}

static void
_xfmpc_playlist_cb_info_selection_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self)
{
	xfmpc_playlist_cb_info_selection ((XfmpcPlaylist*) self);
}

static void
_xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender,
                                                          gboolean is_playing,
                                                          gpointer self)
{
	xfmpc_playlist_cb_pp_changed ((XfmpcPlaylist*) self, is_playing);
}

static void
_xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender,
                                                              gpointer self)
{
	xfmpc_playlist_cb_song_changed ((XfmpcPlaylist*) self);
}

static void
_xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender,
                                                                      gpointer self)
{
	xfmpc_playlist_cb_playlist_changed ((XfmpcPlaylist*) self);
}

static void
_xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                              GtkTreePath* path,
                                                              GtkTreeViewColumn* column,
                                                              gpointer self)
{
	xfmpc_playlist_cb_row_activated ((XfmpcPlaylist*) self, path, column);
}

static gboolean
_xfmpc_playlist_cb_key_released_gtk_widget_key_release_event (GtkWidget* _sender,
                                                              GdkEventKey* event,
                                                              gpointer self)
{
	gboolean result;
	result = xfmpc_playlist_cb_key_released ((XfmpcPlaylist*) self, event);
	return result;
}

static gboolean
_xfmpc_playlist_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                  GdkEventButton* event,
                                                                  gpointer self)
{
	gboolean result;
	result = xfmpc_playlist_cb_button_released ((XfmpcPlaylist*) self, event);
	return result;
}

static gboolean
_xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                     gpointer self)
{
	gboolean result;
	result = xfmpc_playlist_cb_popup_menu ((XfmpcPlaylist*) self);
	return result;
}

static void
_xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                              gpointer self)
{
	xfmpc_playlist_cb_filter_entry_activated ((XfmpcPlaylist*) self);
}

static gboolean
_xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                           GdkEventKey* event,
                                                                           gpointer self)
{
	gboolean result;
	result = xfmpc_playlist_cb_filter_entry_key_released ((XfmpcPlaylist*) self, event);
	return result;
}

static void
_xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                              gpointer self)
{
	xfmpc_playlist_cb_filter_entry_changed ((XfmpcPlaylist*) self);
}

static void
_xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender,
                                                                       GtkEntryIconPosition icon_pos,
                                                                       GdkEvent* event,
                                                                       gpointer self)
{
	xfmpc_playlist_cb_filter_entry_icon_activated ((XfmpcPlaylist*) self, icon_pos, event);
}

static void
_xfmpc_playlist_cb_playlist_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	xfmpc_playlist_cb_playlist_changed ((XfmpcPlaylist*) self);
}

static GObject *
xfmpc_playlist_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcPlaylist * self;
	XfmpcMpdclient* _tmp0_;
	XfmpcPreferences* _tmp1_;
	XfmpcPreferences* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkListStore* _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeModelFilter* _tmp7_;
	GtkTreeModelFilter* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkTreeView* _tmp10_;
	GtkTreeSelection* _tmp11_;
	GtkTreeView* _tmp12_;
	GtkTreeView* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreeView* _tmp15_;
	GtkTreeModelFilter* _tmp16_;
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp19_;
	GtkTreeViewColumn* _tmp20_;
	GtkTreeViewColumn* _tmp21_;
	XfmpcPreferences* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GtkTreeView* _tmp25_;
	GtkTreeViewColumn* _tmp26_;
	GtkCellRendererText* _tmp27_;
	GtkCellRendererText* _tmp28_;
	GtkCellRendererText* _tmp29_;
	GtkTreeViewColumn* _tmp30_;
	GtkTreeViewColumn* _tmp31_;
	GtkTreeView* _tmp32_;
	GtkTreeViewColumn* _tmp33_;
	GtkCellRendererText* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkTreeView* _tmp36_;
	GtkCellRendererText* _tmp37_;
	GtkScrolledWindow* scrolled = NULL;
	GtkAdjustment* _tmp38_;
	GtkAdjustment* _tmp39_;
	GtkAdjustment* _tmp40_;
	GtkAdjustment* _tmp41_;
	GtkScrolledWindow* _tmp42_;
	GtkScrolledWindow* _tmp43_;
	GtkScrolledWindow* _tmp44_;
	GtkMenu* _tmp45_;
	GtkMenuItem* mi = NULL;
	GtkMenuItem* _tmp46_;
	GtkMenu* _tmp47_;
	GtkMenuItem* _tmp48_;
	GtkMenuItem* _tmp49_;
	GtkMenuItem* _tmp50_;
	GtkMenu* _tmp51_;
	GtkMenuItem* _tmp52_;
	GtkMenuItem* _tmp53_;
	GtkMenuItem* _tmp54_;
	GtkMenu* _tmp55_;
	GtkMenuItem* _tmp56_;
	GtkMenuItem* _tmp57_;
	GtkMenu* _tmp58_;
	GtkEntry* _tmp59_;
	GtkEntry* _tmp60_;
	GtkEntry* _tmp61_;
	GtkEntry* _tmp62_;
	GtkScrolledWindow* _tmp63_;
	GtkTreeView* _tmp64_;
	GtkScrolledWindow* _tmp65_;
	GtkEntry* _tmp66_;
	XfmpcMpdclient* _tmp67_;
	XfmpcMpdclient* _tmp68_;
	XfmpcMpdclient* _tmp69_;
	GtkTreeView* _tmp70_;
	GtkTreeView* _tmp71_;
	GtkTreeView* _tmp72_;
	GtkTreeView* _tmp73_;
	GtkEntry* _tmp74_;
	GtkEntry* _tmp75_;
	GtkEntry* _tmp76_;
	GtkEntry* _tmp77_;
	XfmpcPreferences* _tmp78_;
	XfmpcPreferences* _tmp79_;
	parent_class = G_OBJECT_CLASS (xfmpc_playlist_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_PLAYLIST, XfmpcPlaylist);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp2_ = self->priv->preferences;
	_tmp3_ = xfmpc_preferences_get_playlist_autocenter (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->autocenter = _tmp4_;
	_tmp5_ = gtk_list_store_new ((gint) XFMPC_PLAYLIST_COLUMNS_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT, -1);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp5_;
	_tmp6_ = self->priv->store;
	_tmp7_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp6_, NULL);
	_g_object_unref0 (self->priv->filter);
	self->priv->filter = _tmp7_;
	_tmp8_ = self->priv->filter;
	gtk_tree_model_filter_set_visible_func (_tmp8_, (GtkTreeModelFilterVisibleFunc) xfmpc_playlist_visible_func_filter_tree, NULL, NULL);
	_tmp9_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp9_;
	_tmp10_ = self->priv->treeview;
	_tmp11_ = gtk_tree_view_get_selection (_tmp10_);
	gtk_tree_selection_set_mode (_tmp11_, GTK_SELECTION_MULTIPLE);
	_tmp12_ = self->priv->treeview;
	gtk_tree_view_set_rubber_banding (_tmp12_, TRUE);
	_tmp13_ = self->priv->treeview;
	gtk_tree_view_set_enable_search (_tmp13_, FALSE);
	_tmp14_ = self->priv->treeview;
	gtk_tree_view_set_headers_visible (_tmp14_, FALSE);
	_tmp15_ = self->priv->treeview;
	_tmp16_ = self->priv->filter;
	gtk_tree_view_set_model (_tmp15_, (GtkTreeModel*) _tmp16_);
	_tmp17_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp17_);
	cell = _tmp17_;
	_tmp18_ = cell;
	g_object_set ((GtkCellRenderer*) _tmp18_, "xalign", (gfloat) 1, NULL);
	_tmp19_ = cell;
	_tmp20_ = gtk_tree_view_column_new_with_attributes ("Position", (GtkCellRenderer*) _tmp19_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	g_object_ref_sink (_tmp20_);
	column = _tmp20_;
	_tmp21_ = column;
	_tmp22_ = self->priv->preferences;
	_tmp23_ = xfmpc_preferences_get_playlist_show_position (_tmp22_);
	_tmp24_ = _tmp23_;
	gtk_tree_view_column_set_visible (_tmp21_, _tmp24_);
	_tmp25_ = self->priv->treeview;
	_tmp26_ = column;
	gtk_tree_view_append_column (_tmp25_, _tmp26_);
	_tmp27_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (cell);
	cell = _tmp27_;
	_tmp28_ = cell;
	g_object_set (_tmp28_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp29_ = cell;
	_tmp30_ = gtk_tree_view_column_new_with_attributes ("Song", (GtkCellRenderer*) _tmp29_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (column);
	column = _tmp30_;
	_tmp31_ = column;
	gtk_tree_view_column_set_expand (_tmp31_, TRUE);
	_tmp32_ = self->priv->treeview;
	_tmp33_ = column;
	gtk_tree_view_append_column (_tmp32_, _tmp33_);
	_tmp34_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (cell);
	cell = _tmp34_;
	_tmp35_ = cell;
	g_object_set ((GtkCellRenderer*) _tmp35_, "xalign", (gfloat) 1, NULL);
	_tmp36_ = self->priv->treeview;
	_tmp37_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp36_, -1, "Length", (GtkCellRenderer*) _tmp37_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	_tmp38_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp38_);
	_tmp39_ = _tmp38_;
	_tmp40_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp40_);
	_tmp41_ = _tmp40_;
	_tmp42_ = (GtkScrolledWindow*) gtk_scrolled_window_new (_tmp39_, _tmp41_);
	g_object_ref_sink (_tmp42_);
	_tmp43_ = _tmp42_;
	_g_object_unref0 (_tmp41_);
	_g_object_unref0 (_tmp39_);
	scrolled = _tmp43_;
	_tmp44_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp44_, GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	_tmp45_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp45_;
	_tmp46_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Remove"));
	g_object_ref_sink (_tmp46_);
	mi = _tmp46_;
	_tmp47_ = self->priv->menu;
	_tmp48_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp47_, _tmp48_);
	_tmp49_ = mi;
	g_signal_connect_object (_tmp49_, "activate", (GCallback) _xfmpc_playlist_delete_selection_gtk_menu_item_activate, self, 0);
	_tmp50_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Browse"));
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->mi_browse);
	self->priv->mi_browse = _tmp50_;
	_tmp51_ = self->priv->menu;
	_tmp52_ = self->priv->mi_browse;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp51_, _tmp52_);
	_tmp53_ = self->priv->mi_browse;
	g_signal_connect_object (_tmp53_, "activate", (GCallback) _xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate, self, 0);
	_tmp54_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Info"));
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->mi_information);
	self->priv->mi_information = _tmp54_;
	_tmp55_ = self->priv->menu;
	_tmp56_ = self->priv->mi_information;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp55_, _tmp56_);
	_tmp57_ = self->priv->mi_information;
	g_signal_connect_object (_tmp57_, "activate", (GCallback) _xfmpc_playlist_cb_info_selection_gtk_menu_item_activate, self, 0);
	_tmp58_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp58_);
	_tmp59_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (xfmpc_playlist_filter_entry);
	xfmpc_playlist_filter_entry = _tmp59_;
	_tmp60_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_from_icon_name (_tmp60_, GTK_ENTRY_ICON_PRIMARY, "edit-find");
	_tmp61_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_activatable (_tmp61_, GTK_ENTRY_ICON_PRIMARY, FALSE);
	_tmp62_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_activatable (_tmp62_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp63_ = scrolled;
	_tmp64_ = self->priv->treeview;
	gtk_container_add ((GtkContainer*) _tmp63_, (GtkWidget*) _tmp64_);
	_tmp65_ = scrolled;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp65_, TRUE, TRUE, (guint) 0);
	_tmp66_ = xfmpc_playlist_filter_entry;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp66_, FALSE, FALSE, (guint) 0);
	_tmp67_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp67_, "pp-changed", (GCallback) _xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed, self, 0);
	_tmp68_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp68_, "song-changed", (GCallback) _xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed, self, 0);
	_tmp69_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp69_, "playlist-changed", (GCallback) _xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp70_ = self->priv->treeview;
	g_signal_connect_object (_tmp70_, "row-activated", (GCallback) _xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated, self, 0);
	_tmp71_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp71_, "key-release-event", (GCallback) _xfmpc_playlist_cb_key_released_gtk_widget_key_release_event, self, 0);
	_tmp72_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp72_, "button-press-event", (GCallback) _xfmpc_playlist_cb_button_released_gtk_widget_button_press_event, self, 0);
	_tmp73_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp73_, "popup-menu", (GCallback) _xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp74_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object (_tmp74_, "activate", (GCallback) _xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate, self, 0);
	_tmp75_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object ((GtkWidget*) _tmp75_, "key-release-event", (GCallback) _xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event, self, 0);
	_tmp76_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object ((GtkEditable*) _tmp76_, "changed", (GCallback) _xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed, self, 0);
	_tmp77_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object (_tmp77_, "icon-release", (GCallback) _xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release, self, 0);
	_tmp78_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp78_, "notify::song-format", (GCallback) _xfmpc_playlist_cb_playlist_changed_g_object_notify, self, 0);
	_tmp79_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp79_, "notify::song-format-custom", (GCallback) _xfmpc_playlist_cb_playlist_changed_g_object_notify, self, 0);
	_g_object_unref0 (mi);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (column);
	_g_object_unref0 (cell);
	return obj;
}

static void
xfmpc_playlist_class_init (XfmpcPlaylistClass * klass,
                           gpointer klass_data)
{
	xfmpc_playlist_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XfmpcPlaylist_private_offset);
	G_OBJECT_CLASS (klass)->constructor = xfmpc_playlist_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_playlist_finalize;
}

static void
xfmpc_playlist_instance_init (XfmpcPlaylist * self,
                              gpointer klass)
{
	self->priv = xfmpc_playlist_get_instance_private (self);
	self->priv->current = 0;
}

static void
xfmpc_playlist_finalize (GObject * obj)
{
	XfmpcPlaylist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_PLAYLIST, XfmpcPlaylist);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->filter);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->mi_browse);
	_g_object_unref0 (self->priv->mi_information);
	G_OBJECT_CLASS (xfmpc_playlist_parent_class)->finalize (obj);
}

static GType
xfmpc_playlist_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XfmpcPlaylistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_playlist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcPlaylist), 0, (GInstanceInitFunc) xfmpc_playlist_instance_init, NULL };
	GType xfmpc_playlist_type_id;
	xfmpc_playlist_type_id = g_type_register_static (gtk_box_get_type (), "XfmpcPlaylist", &g_define_type_info, 0);
	XfmpcPlaylist_private_offset = g_type_add_instance_private (xfmpc_playlist_type_id, sizeof (XfmpcPlaylistPrivate));
	return xfmpc_playlist_type_id;
}

GType
xfmpc_playlist_get_type (void)
{
	static volatile gsize xfmpc_playlist_type_id__once = 0;
	if (g_once_init_enter (&xfmpc_playlist_type_id__once)) {
		GType xfmpc_playlist_type_id;
		xfmpc_playlist_type_id = xfmpc_playlist_get_type_once ();
		g_once_init_leave (&xfmpc_playlist_type_id__once, xfmpc_playlist_type_id);
	}
	return xfmpc_playlist_type_id__once;
}

