/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.sdg.xdman.gui.MediaInfo;
import org.sdg.xdman.gui.StringResource;

public class MediaTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3687589857430853297L;
    ArrayList<MediaInfo> list = new ArrayList();
    String[] cols = new String[]{StringResource.getString("FILE_NAME"), StringResource.getString("INFO"), StringResource.getString("URL")};

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.cols.length;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        MediaInfo info = this.list.get(arg0);
        switch (arg1) {
            case 0: {
                return info.name;
            }
            case 1: {
                return String.valueOf(info.type == null ? "" : info.type) + " " + (info.size == null ? "" : info.size);
            }
            case 2: {
                return info.url;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(MediaInfo info) {
        int i = 0;
        while (i < this.list.size()) {
            MediaInfo mi = this.list.get(i);
            if (mi.url.equals(info.url)) {
                return;
            }
            ++i;
        }
        ArrayList<MediaInfo> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(info);
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        ArrayList<MediaInfo> arrayList = this.list;
        synchronized (arrayList) {
            this.list.remove(index);
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<MediaInfo> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int c) {
        return this.cols[c];
    }
}

