/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JWindow;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.sdg.xdman.core.common.DownloadStateListner;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.MediaInfo;
import org.sdg.xdman.gui.MediaTableModel;
import org.sdg.xdman.gui.StaticResource;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.gui.XDMTransferHandler;
import org.sdg.xdman.util.XDMUtil;

public class DropBox
extends JWindow
implements ActionListener {
    private static final long serialVersionUID = -6560446385567170000L;
    JLabel label;
    int relx;
    int rely;
    DownloadStateListner mgr;
    Icon lblIcon;
    JButton closeBtn;
    MediaTableModel model;
    JMenu menu;
    JMenuBar bar;
    boolean isVideoMode = false;
    Cursor hc = new Cursor(12);
    public static final int VIDEO_WIDTH = 200;
    DownloadStateListner dl;
    XDMConfig config;
    JMenuItem[] items;

    public DropBox(JLabel label, DownloadStateListner mgr, MediaTableModel m, DownloadStateListner dl, XDMConfig config) {
        this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
        this.setAlwaysOnTop(true);
        this.add(label);
        this.mgr = mgr;
        this.label = label;
        this.model = m;
        this.dl = dl;
        this.config = config;
        this.label.setTransferHandler(new XDMTransferHandler(mgr));
        this.add(label);
        label.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                int x = DropBox.this.getX();
                int y = DropBox.this.getY();
                DropBox.this.setLocation(x + me.getX() - DropBox.this.relx, y + me.getY() - DropBox.this.rely);
            }
        });
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DropBox.this.relx = me.getX();
                DropBox.this.rely = me.getY();
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                int x = DropBox.this.getLocationOnScreen().x;
                int y = DropBox.this.getLocationOnScreen().y;
                if (DropBox.this.config.dbX != x || DropBox.this.config.dbY != y) {
                    DropBox.this.config.dbX = x;
                    DropBox.this.config.dbY = y;
                    System.out.println("Saving dropbox location...");
                    DropBox.this.config.save();
                }
            }
        });
        this.setSize(22, 22);
        this.closeBtn = new JButton();
        this.closeBtn.setContentAreaFilled(false);
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.setFocusPainted(false);
        this.closeBtn.setMargin(new Insets(0, 0, 0, 0));
        this.closeBtn.setIcon(StaticResource.getIcon("close_btn.png"));
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DropBox.this.setVideoPopup(false);
                DropBox.this.model.clear();
                DropBox.this.validate();
                DropBox.this.repaint();
            }
        });
        this.add((Component)this.closeBtn, "East");
        this.closeBtn.setVisible(false);
        this.closeBtn.setBackground(StaticResource.selectedColor);
        this.menu = new JMenu("DOWNLOAD VIDEO");
        this.menu.setFont(new Font("Dialog", 1, 14));
        this.menu.setForeground(Color.WHITE);
        this.menu.setBackground(StaticResource.selectedColor);
        this.menu.setBorderPainted(false);
        this.menu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                DropBox.this.populateMenu();
            }
        });
        this.bar = new JMenuBar();
        this.bar.setOpaque(false);
        this.bar.setCursor(this.hc);
        this.bar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                int x = DropBox.this.getX();
                int y = DropBox.this.getY();
                DropBox.this.setLocation(x + me.getX() - DropBox.this.relx, y + me.getY() - DropBox.this.rely);
            }
        });
        this.bar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DropBox.this.relx = me.getX();
                DropBox.this.rely = me.getY();
            }
        });
        this.getContentPane().setBackground(StaticResource.selectedColor);
        this.bar.setBackground(StaticResource.selectedColor);
        this.bar.setBorderPainted(false);
        this.bar.add(Box.createHorizontalGlue());
        this.bar.add(this.menu);
        this.bar.add(Box.createHorizontalGlue());
        this.bar.setVisible(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setVideoPopup(boolean enable) {
        try {
            if (!enable) {
                if (!this.isVideoMode) {
                    return;
                }
                this.setSize(22, 22);
                if (this.isVideoMode) {
                    int x = this.getLocationOnScreen().x + 200 - 22;
                    if (x > 0) {
                        x = Math.min(x, Toolkit.getDefaultToolkit().getScreenSize().width - 30);
                    }
                    this.setLocation(x, this.getLocationOnScreen().y);
                }
                this.closeBtn.setVisible(false);
                this.add(this.label);
                this.remove(this.bar);
            } else {
                if (this.isVideoMode) {
                    return;
                }
                int x = this.getLocationOnScreen().x - 200 + 22;
                this.setSize(200, 22);
                this.label.setOpaque(true);
                this.label.setBackground(StaticResource.selectedColor);
                this.label.setForeground(Color.WHITE);
                this.setLocation(x, this.getLocationOnScreen().y);
                this.label.setFont(StaticResource.plainFontBig);
                this.closeBtn.setVisible(true);
                this.bar.setVisible(true);
                this.add(this.bar);
                this.remove(this.label);
            }
            this.isVideoMode = enable;
            return;
        }
        finally {
            this.validate();
            this.repaint();
        }
    }

    void menuClicked(int i) {
        MediaInfo info = this.model.list.get(i);
        this.dl.addDownload(info.url, info.name, this.config.destdir, null, null, info.referer, info.cookies, info.userAgent);
    }

    void populateMenu() {
        int i;
        if (!this.isVideoMode) {
            return;
        }
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                this.menu.remove(this.items[i]);
                ++i;
            }
        }
        this.items = new JMenuItem[this.model.list.size()];
        i = 0;
        while (i < this.model.getRowCount()) {
            try {
                MediaInfo mi = this.model.list.get(i);
                String name = mi.name;
                String info = String.valueOf(mi.type == null ? "" : mi.type) + " " + (mi.size == null ? "" : mi.size);
                name = XDMUtil.createSafeFileName(name);
                if (name.length() > 30) {
                    name = String.valueOf(name.substring(0, 30)) + "...";
                }
                JMenuItem item = new JMenuItem(String.valueOf(name) + " " + info.toUpperCase());
                item.addActionListener(this);
                this.menu.add(item);
                this.items[i] = item;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                if (e.getSource() == this.items[i]) {
                    this.menuClicked(i);
                }
                ++i;
            }
        }
    }
}

