#!/bin/sh
#
# Script to automatically install all Wine Staging patches
#
# Copyright (C) 2015-2017 Sebastian Lackner
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#

# Show usage information
usage()
{
	echo ""
	echo "Usage: ./patchinstall.sh [DESTDIR=path] [--all] [-W patchset] [patchset ...]"
	echo ""
	echo "Autogenerated script to apply all Wine Staging patches on your Wine"
	echo "source tree."
	echo ""
	echo "Configuration:"
	echo "  DESTDIR=path         Specify the path to the wine source tree"
	echo "  --all                Select all patches"
	echo "  --force-autoconf     Run autoreconf and tools/make_requests after each patch"
	echo "  --help               Display this help and exit"
	echo "  --no-autoconf        Do not run autoreconf and tools/make_requests"
	echo "  --no-patchlist       Do not apply patchlist (needed for 'wine --patches')"
	echo "  --upstream-commit    Print the upstream Wine commit SHA1 and exit"
	echo "  --version            Show version information and exit"
	echo "  -W patchset          Exclude a specific patchset"
	echo ""
	echo "Backends:"
	echo "  --backend=patch      Use regular 'patch' utility to apply patches (default)"
	echo "  --backend=eapply     Use 'eapply' to apply patches (Gentoo only)"
	echo "  --backend=epatch     Use 'epatch' to apply patches (Gentoo only, deprecated)"
	echo "  --backend=git-am     Use 'git am' to apply patches"
	echo "  --backend=git-apply  Use 'git apply' to apply patches"
	echo "  --backend=stg        Import the patches using stacked git"
	echo ""
}

# Get the upstream commit sha
upstream_commit()
{
	echo "da816802e022e8aa8eb197de94e18305a92766c1"
}

# Show version information
version()
{
	echo "Wine Staging 5.0"
	echo "Copyright (C) 2014-2019 the Wine Staging project authors."
	echo "Copyright (C) 2018-2020 Alistair Leslie-Hughes"
	echo ""
	echo "Patchset to be applied on upstream Wine:"
	echo "  commit $(upstream_commit)"
	echo ""
}

# Critical error, abort
abort()
{
	printf '%s\n' "ERROR: $1" >&2
	exit 1
}

# Show a warning
warning()
{
	printf '%s\n' "WARNING: $1" >&2
}

# Enable or disable all patchsets
patch_enable_all ()
{
	enable_Compiler_Warnings="$1"
	enable_Pipelight="$1"
	enable_Staging="$1"
	enable_activeds_ADsOpenObject="$1"
	enable_advapi32_CreateRestrictedToken="$1"
	enable_advapi32_LsaLookupPrivilegeName="$1"
	enable_advapi32_LsaLookupSids="$1"
	enable_advapi32_Token_Integrity_Level="$1"
	enable_api_ms_win_Stub_DLLs="$1"
	enable_atl_AtlAxDialogBox="$1"
	enable_cmd_launch_association="$1"
	enable_comctl32_Listview_DrawItem="$1"
	enable_comctl32_alpha_bitmaps="$1"
	enable_comctl32_version_6="$1"
	enable_comctrl_rebar_capture="$1"
	enable_comdlg32_lpstrFileTitle="$1"
	enable_configure_Absolute_RPATH="$1"
	enable_crypt32_CMS_Certificates="$1"
	enable_cryptext_CryptExtOpenCER="$1"
	enable_d2d1_ID2D1Factory1="$1"
	enable_d3d11_Deferred_Context="$1"
	enable_d3d9_Direct3DShaderValidatorCreate9="$1"
	enable_d3d9_Tests="$1"
	enable_d3dx9_32bpp_Alpha_Channel="$1"
	enable_d3dx9_36_BumpLuminance="$1"
	enable_d3dx9_36_CloneEffect="$1"
	enable_d3dx9_36_D3DXCreateKeyframedAnimationSet="$1"
	enable_d3dx9_36_D3DXDisassembleShader="$1"
	enable_d3dx9_36_D3DXOptimizeVertices="$1"
	enable_d3dx9_36_D3DXSHProjectCubeMap="$1"
	enable_d3dx9_36_D3DXStubs="$1"
	enable_d3dx9_36_DDS="$1"
	enable_d3dx9_36_DrawText="$1"
	enable_d3dx9_36_Filter_Warnings="$1"
	enable_d3dx9_36_Optimize_Inplace="$1"
	enable_d3dx9_36_UpdateSkinnedMesh="$1"
	enable_dbghelp_Debug_Symbols="$1"
	enable_ddraw_Device_Caps="$1"
	enable_ddraw_EnumSurfaces="$1"
	enable_ddraw_IDirect3DTexture2_Load="$1"
	enable_ddraw_Rendering_Targets="$1"
	enable_ddraw_Silence_FIXMEs="$1"
	enable_ddraw_Texture_Wrong_Caps="$1"
	enable_ddraw_Write_Vtable="$1"
	enable_ddraw_version_check="$1"
	enable_dinput_SetActionMap_genre="$1"
	enable_dinput_axis_recalc="$1"
	enable_dinput_joy_mappings="$1"
	enable_dinput_reconnect_joystick="$1"
	enable_dinput_remap_joystick="$1"
	enable_directmanipulation_new_dll="$1"
	enable_dmime_PChannel_range="$1"
	enable_dsdmo_new_dll="$1"
	enable_dsound_EAX="$1"
	enable_dsound_Fast_Mixer="$1"
	enable_dsound_SRW="$1"
	enable_dwmapi_DwmGetTransportAttributes="$1"
	enable_dwrite_FontFallback="$1"
	enable_dxdiagn_Enumerate_DirectSound="$1"
	enable_dxdiagn_GetChildContainer_Leaf_Nodes="$1"
	enable_dxva2_Video_Decoder="$1"
	enable_eventfd_synchronization="$1"
	enable_explorer_Video_Registry_Key="$1"
	enable_fonts_Missing_Fonts="$1"
	enable_fsutil_Stub_Program="$1"
	enable_gdi32_Lazy_Font_Initialization="$1"
	enable_gdi32_rotation="$1"
	enable_gdiplus_FontFamily_RefCount="$1"
	enable_gdiplus_GdipCreateBitmapFromHBITMAP="$1"
	enable_gdiplus_Performance_Improvements="$1"
	enable_imagehlp_BindImageEx="$1"
	enable_imm32_message_on_focus="$1"
	enable_include_LdrData="$1"
	enable_include_winsock="$1"
	enable_inseng_Implementation="$1"
	enable_iphlpapi_System_Ping="$1"
	enable_kernel32_CopyFileEx="$1"
	enable_kernel32_Debugger="$1"
	enable_kernel32_FindFirstFile="$1"
	enable_kernel32_Job_Tests="$1"
	enable_kernel32_K32GetPerformanceInfo="$1"
	enable_kernel32_PE_Loader_Fixes="$1"
	enable_kernel32_Processor_Group="$1"
	enable_kernel32_SetProcessDEPPolicy="$1"
	enable_kernelbase_ReOpenFile="$1"
	enable_krnl386_exe16_GDT_LDT_Emulation="$1"
	enable_krnl386_exe16_Invalid_Console_Handles="$1"
	enable_libs_Debug_Channel="$1"
	enable_libs_Unicode_Collation="$1"
	enable_loader_KeyboardLayouts="$1"
	enable_mmsystem_dll16_MIDIHDR_Refcount="$1"
	enable_mountmgr_DosDevices="$1"
	enable_mscoree_CorValidateImage="$1"
	enable_msctf_ITfActiveLanguageProfileNotifySink="$1"
	enable_mshtml_HTMLLocation_put_hash="$1"
	enable_mshtml_TranslateAccelerator="$1"
	enable_msi_msi_vcl_get_cost="$1"
	enable_msvcrt_Math_Precision="$1"
	enable_ntdll_APC_Performance="$1"
	enable_ntdll_Activation_Context="$1"
	enable_ntdll_ApiSetMap="$1"
	enable_ntdll_Builtin_Prot="$1"
	enable_ntdll_CriticalSection="$1"
	enable_ntdll_DOS_Attributes="$1"
	enable_ntdll_Dealloc_Thread_Stack="$1"
	enable_ntdll_DeviceType_Systemroot="$1"
	enable_ntdll_Exception="$1"
	enable_ntdll_FileDispositionInformation="$1"
	enable_ntdll_FileFsFullSizeInformation="$1"
	enable_ntdll_FileFsVolumeInformation="$1"
	enable_ntdll_Fix_Alignment="$1"
	enable_ntdll_ForceBottomUpAlloc="$1"
	enable_ntdll_HashLinks="$1"
	enable_ntdll_Heap_Improvements="$1"
	enable_ntdll_Hide_Wine_Exports="$1"
	enable_ntdll_Interrupt_0x2e="$1"
	enable_ntdll_Junction_Points="$1"
	enable_ntdll_LDR_MODULE="$1"
	enable_ntdll_Manifest_Range="$1"
	enable_ntdll_MemoryWorkingSetExInformation="$1"
	enable_ntdll_NtAccessCheck="$1"
	enable_ntdll_NtContinue="$1"
	enable_ntdll_NtDevicePath="$1"
	enable_ntdll_NtQueryEaFile="$1"
	enable_ntdll_NtQuerySection="$1"
	enable_ntdll_NtQueryVirtualMemory="$1"
	enable_ntdll_NtSetLdtEntries="$1"
	enable_ntdll_Pipe_SpecialCharacters="$1"
	enable_ntdll_ProcessQuotaLimits="$1"
	enable_ntdll_RtlCreateUserThread="$1"
	enable_ntdll_RtlGetNativeSystemInformation="$1"
	enable_ntdll_RtlIpv4StringToAddress="$1"
	enable_ntdll_RtlQueryPackageIdentity="$1"
	enable_ntdll_Serial_Port_Detection="$1"
	enable_ntdll_Signal_Handler="$1"
	enable_ntdll_Status_Mapping="$1"
	enable_ntdll_Syscall_Emulation="$1"
	enable_ntdll_SystemExtendedProcessInformation="$1"
	enable_ntdll_SystemInterruptInformation="$1"
	enable_ntdll_SystemModuleInformation="$1"
	enable_ntdll_SystemRoot_Symlink="$1"
	enable_ntdll_ThreadHideFromDebugger="$1"
	enable_ntdll_ThreadTime="$1"
	enable_ntdll_Threading="$1"
	enable_ntdll_User_Shared_Data="$1"
	enable_ntdll_User_shared_data_fields="$1"
	enable_ntdll_WRITECOPY="$1"
	enable_ntdll_Wait_User_APC="$1"
	enable_ntdll_Zero_mod_name="$1"
	enable_ntdll_aarch_TEB="$1"
	enable_ntdll_ext4_case_folder="$1"
	enable_ntdll_set_full_cpu_context="$1"
	enable_ntdll_x86_64_SegDs="$1"
	enable_ntoskrnl_Stubs="$1"
	enable_nvapi_Stub_DLL="$1"
	enable_nvcuda_CUDA_Support="$1"
	enable_nvcuvid_CUDA_Video_Support="$1"
	enable_nvencodeapi_Video_Encoder="$1"
	enable_ole32_HGLOBALStream="$1"
	enable_oleaut32_CreateTypeLib="$1"
	enable_oleaut32_Load_Save_EMF="$1"
	enable_oleaut32_OLEPictureImpl_SaveAsFile="$1"
	enable_oleaut32_OleLoadPicture="$1"
	enable_oleaut32_OleLoadPictureFile="$1"
	enable_opencl_version_1_2="$1"
	enable_opengl32_wglChoosePixelFormat="$1"
	enable_packager_DllMain="$1"
	enable_pdh_PdhLookupPerfNameByIndex_processor="$1"
	enable_quartz_MediaSeeking_Positions="$1"
	enable_riched20_Class_Tests="$1"
	enable_riched20_IText_Interface="$1"
	enable_server_Desktop_Refcount="$1"
	enable_server_FileEndOfFileInformation="$1"
	enable_server_File_Permissions="$1"
	enable_server_Inherited_ACLs="$1"
	enable_server_Key_State="$1"
	enable_server_Object_Types="$1"
	enable_server_PeekMessage="$1"
	enable_server_Realtime_Priority="$1"
	enable_server_Registry_Notifications="$1"
	enable_server_Shared_Memory="$1"
	enable_server_Signal_Thread="$1"
	enable_server_Stored_ACLs="$1"
	enable_server_Timestamp_Compat="$1"
	enable_server_device_manager_destroy="$1"
	enable_setupapi_DiskSpaceList="$1"
	enable_setupapi_SPFILENOTIFY_FILEINCABINET="$1"
	enable_setupapi_SP_COPY_IN_USE_NEEDS_REBOOT="$1"
	enable_shdocvw_ParseURLFromOutsideSource_Tests="$1"
	enable_shell32_ACE_Viewer="$1"
	enable_shell32_Context_Menu="$1"
	enable_shell32_IconCache="$1"
	enable_shell32_NewMenu_Interface="$1"
	enable_shell32_Progress_Dialog="$1"
	enable_shell32_SFGAO_HASSUBFOLDER="$1"
	enable_shell32_SHFileOperation_Move="$1"
	enable_shell32_SHGetStockIconInfo="$1"
	enable_shell32_Toolbar_Bitmaps="$1"
	enable_shell32_UnixFS="$1"
	enable_shlwapi_AssocGetPerceivedType="$1"
	enable_shlwapi_SHAddDataBlock="$1"
	enable_shlwapi_UrlCanonicalize="$1"
	enable_shlwapi_UrlCombine="$1"
	enable_stdole32_idl_Typelib="$1"
	enable_stdole32_tlb_SLTG_Typelib="$1"
	enable_user32_DM_SETDEFID="$1"
	enable_user32_Dialog_Paint_Event="$1"
	enable_user32_DrawMenuItem="$1"
	enable_user32_DrawTextExW="$1"
	enable_user32_FlashWindowEx="$1"
	enable_user32_GetSystemMetrics="$1"
	enable_user32_Implement_CascadeWindows="$1"
	enable_user32_InternalGetWindowIcon="$1"
	enable_user32_LR_LOADFROMFILE="$1"
	enable_user32_ListBox_Size="$1"
	enable_user32_LoadKeyboardLayoutEx="$1"
	enable_user32_MessageBox_WS_EX_TOPMOST="$1"
	enable_user32_Mouse_Message_Hwnd="$1"
	enable_user32_Refresh_MDI_Menus="$1"
	enable_user32_ScrollWindowEx="$1"
	enable_user32_ShowWindow="$1"
	enable_user32_msgbox_Support_WM_COPY_mesg="$1"
	enable_user32_rawinput_hid="$1"
	enable_user32_rawinput_mouse="$1"
	enable_user32_rawinput_mouse_experimental="$1"
	enable_user32_rawinput_nolegacy="$1"
	enable_user32_recursive_activation="$1"
	enable_user32_window_activation="$1"
	enable_uxtheme_CloseThemeClass="$1"
	enable_uxtheme_GTK_Theming="$1"
	enable_version_VerQueryValue="$1"
	enable_widl_SLTG_Typelib_Support="$1"
	enable_windowscodecs_GIF_Encoder="$1"
	enable_windowscodecs_TIFF_Support="$1"
	enable_wine_inf_Directory_ContextMenuHandlers="$1"
	enable_wine_inf_Dummy_CA_Certificate="$1"
	enable_wine_inf_Performance="$1"
	enable_wineboot_DriveSerial="$1"
	enable_wineboot_HKEY_DYN_DATA="$1"
	enable_wineboot_ProxySettings="$1"
	enable_wineboot_drivers_etc_Stubs="$1"
	enable_winebuild_Fake_Dlls="$1"
	enable_winecfg_Libraries="$1"
	enable_winecfg_Staging="$1"
	enable_winecfg_Unmounted_Devices="$1"
	enable_wined3d_Accounting="$1"
	enable_wined3d_CSMT_Main="$1"
	enable_wined3d_Dual_Source_Blending="$1"
	enable_wined3d_Indexed_Vertex_Blending="$1"
	enable_wined3d_SWVP_shaders="$1"
	enable_wined3d_Silence_FIXMEs="$1"
	enable_wined3d_UAV_Counters="$1"
	enable_wined3d_WINED3DFMT_B8G8R8X8_UNORM="$1"
	enable_wined3d_WINED3D_RS_COLORWRITEENABLE="$1"
	enable_wined3d_WINED3D_TEXF_ANISOTROPIC="$1"
	enable_wined3d_mesa_texture_download="$1"
	enable_wined3d_unset_flip_gdi="$1"
	enable_wined3d_wined3d_guess_gl_vendor="$1"
	enable_wined3d_zero_inf_shaders="$1"
	enable_winedbg_Process_Arguments="$1"
	enable_winedevice_Default_Drivers="$1"
	enable_winemapi_user_xdg_mail="$1"
	enable_winemenubuilder_Desktop_Icon_Path="$1"
	enable_wineps_drv_PostScript_Fixes="$1"
	enable_winepulse_PulseAudio_Support="$1"
	enable_winex11_CandidateWindowPos="$1"
	enable_winex11_DefaultDisplayFrequency="$1"
	enable_winex11_MWM_Decorations="$1"
	enable_winex11_UpdateLayeredWindow="$1"
	enable_winex11_Vulkan_support="$1"
	enable_winex11_WM_WINDOWPOSCHANGING="$1"
	enable_winex11_Window_Style="$1"
	enable_winex11_XEMBED="$1"
	enable_winex11__NET_ACTIVE_WINDOW="$1"
	enable_winex11_ime_check_thread_data="$1"
	enable_winex11_key_translation="$1"
	enable_winex11_wglShareLists="$1"
	enable_winex11_drv_Query_server_position="$1"
	enable_winex11_drv_mouse_coorrds="$1"
	enable_wininet_Cleanup="$1"
	enable_winmm_Delay_Import_Depends="$1"
	enable_winmm_mciSendCommandA="$1"
	enable_wintab32_improvements="$1"
	enable_wintrust_WTHelperGetProvCertFromChain="$1"
	enable_wow64cpu_Wow64Transition="$1"
	enable_wpcap_Dynamic_Linking="$1"
	enable_ws2_32_APC_Performance="$1"
	enable_ws2_32_Connect_Time="$1"
	enable_ws2_32_TransmitFile="$1"
	enable_ws2_32_WSACleanup="$1"
	enable_ws2_32_getaddrinfo="$1"
	enable_ws2_32_getsockopt="$1"
	enable_wtsapi32_EnumerateProcesses="$1"
	enable_wusa_MSU_Package_Installer="$1"
}

# Enable or disable a specific patchset
patch_enable ()
{
	case "$1" in
		Compiler_Warnings)
			enable_Compiler_Warnings="$2"
			;;
		Pipelight)
			enable_Pipelight="$2"
			;;
		Staging)
			enable_Staging="$2"
			;;
		activeds-ADsOpenObject)
			enable_activeds_ADsOpenObject="$2"
			;;
		advapi32-CreateRestrictedToken)
			enable_advapi32_CreateRestrictedToken="$2"
			;;
		advapi32-LsaLookupPrivilegeName)
			enable_advapi32_LsaLookupPrivilegeName="$2"
			;;
		advapi32-LsaLookupSids)
			enable_advapi32_LsaLookupSids="$2"
			;;
		advapi32-Token_Integrity_Level)
			enable_advapi32_Token_Integrity_Level="$2"
			;;
		api-ms-win-Stub_DLLs)
			enable_api_ms_win_Stub_DLLs="$2"
			;;
		atl-AtlAxDialogBox)
			enable_atl_AtlAxDialogBox="$2"
			;;
		cmd-launch-association)
			enable_cmd_launch_association="$2"
			;;
		comctl32-Listview_DrawItem)
			enable_comctl32_Listview_DrawItem="$2"
			;;
		comctl32-alpha-bitmaps)
			enable_comctl32_alpha_bitmaps="$2"
			;;
		comctl32-version_6)
			enable_comctl32_version_6="$2"
			;;
		comctrl-rebar-capture)
			enable_comctrl_rebar_capture="$2"
			;;
		comdlg32-lpstrFileTitle)
			enable_comdlg32_lpstrFileTitle="$2"
			;;
		configure-Absolute_RPATH)
			enable_configure_Absolute_RPATH="$2"
			;;
		crypt32-CMS_Certificates)
			enable_crypt32_CMS_Certificates="$2"
			;;
		cryptext-CryptExtOpenCER)
			enable_cryptext_CryptExtOpenCER="$2"
			;;
		d2d1-ID2D1Factory1)
			enable_d2d1_ID2D1Factory1="$2"
			;;
		d3d11-Deferred_Context)
			enable_d3d11_Deferred_Context="$2"
			;;
		d3d9-Direct3DShaderValidatorCreate9)
			enable_d3d9_Direct3DShaderValidatorCreate9="$2"
			;;
		d3d9-Tests)
			enable_d3d9_Tests="$2"
			;;
		d3dx9-32bpp_Alpha_Channel)
			enable_d3dx9_32bpp_Alpha_Channel="$2"
			;;
		d3dx9_36-BumpLuminance)
			enable_d3dx9_36_BumpLuminance="$2"
			;;
		d3dx9_36-CloneEffect)
			enable_d3dx9_36_CloneEffect="$2"
			;;
		d3dx9_36-D3DXCreateKeyframedAnimationSet)
			enable_d3dx9_36_D3DXCreateKeyframedAnimationSet="$2"
			;;
		d3dx9_36-D3DXDisassembleShader)
			enable_d3dx9_36_D3DXDisassembleShader="$2"
			;;
		d3dx9_36-D3DXOptimizeVertices)
			enable_d3dx9_36_D3DXOptimizeVertices="$2"
			;;
		d3dx9_36-D3DXSHProjectCubeMap)
			enable_d3dx9_36_D3DXSHProjectCubeMap="$2"
			;;
		d3dx9_36-D3DXStubs)
			enable_d3dx9_36_D3DXStubs="$2"
			;;
		d3dx9_36-DDS)
			enable_d3dx9_36_DDS="$2"
			;;
		d3dx9_36-DrawText)
			enable_d3dx9_36_DrawText="$2"
			;;
		d3dx9_36-Filter_Warnings)
			enable_d3dx9_36_Filter_Warnings="$2"
			;;
		d3dx9_36-Optimize_Inplace)
			enable_d3dx9_36_Optimize_Inplace="$2"
			;;
		d3dx9_36-UpdateSkinnedMesh)
			enable_d3dx9_36_UpdateSkinnedMesh="$2"
			;;
		dbghelp-Debug_Symbols)
			enable_dbghelp_Debug_Symbols="$2"
			;;
		ddraw-Device_Caps)
			enable_ddraw_Device_Caps="$2"
			;;
		ddraw-EnumSurfaces)
			enable_ddraw_EnumSurfaces="$2"
			;;
		ddraw-IDirect3DTexture2_Load)
			enable_ddraw_IDirect3DTexture2_Load="$2"
			;;
		ddraw-Rendering_Targets)
			enable_ddraw_Rendering_Targets="$2"
			;;
		ddraw-Silence_FIXMEs)
			enable_ddraw_Silence_FIXMEs="$2"
			;;
		ddraw-Texture_Wrong_Caps)
			enable_ddraw_Texture_Wrong_Caps="$2"
			;;
		ddraw-Write_Vtable)
			enable_ddraw_Write_Vtable="$2"
			;;
		ddraw-version-check)
			enable_ddraw_version_check="$2"
			;;
		dinput-SetActionMap-genre)
			enable_dinput_SetActionMap_genre="$2"
			;;
		dinput-axis-recalc)
			enable_dinput_axis_recalc="$2"
			;;
		dinput-joy-mappings)
			enable_dinput_joy_mappings="$2"
			;;
		dinput-reconnect-joystick)
			enable_dinput_reconnect_joystick="$2"
			;;
		dinput-remap-joystick)
			enable_dinput_remap_joystick="$2"
			;;
		directmanipulation-new-dll)
			enable_directmanipulation_new_dll="$2"
			;;
		dmime-PChannel-range)
			enable_dmime_PChannel_range="$2"
			;;
		dsdmo-new-dll)
			enable_dsdmo_new_dll="$2"
			;;
		dsound-EAX)
			enable_dsound_EAX="$2"
			;;
		dsound-Fast_Mixer)
			enable_dsound_Fast_Mixer="$2"
			;;
		dsound-SRW)
			enable_dsound_SRW="$2"
			;;
		dwmapi-DwmGetTransportAttributes)
			enable_dwmapi_DwmGetTransportAttributes="$2"
			;;
		dwrite-FontFallback)
			enable_dwrite_FontFallback="$2"
			;;
		dxdiagn-Enumerate_DirectSound)
			enable_dxdiagn_Enumerate_DirectSound="$2"
			;;
		dxdiagn-GetChildContainer_Leaf_Nodes)
			enable_dxdiagn_GetChildContainer_Leaf_Nodes="$2"
			;;
		dxva2-Video_Decoder)
			enable_dxva2_Video_Decoder="$2"
			;;
		eventfd_synchronization)
			enable_eventfd_synchronization="$2"
			;;
		explorer-Video_Registry_Key)
			enable_explorer_Video_Registry_Key="$2"
			;;
		fonts-Missing_Fonts)
			enable_fonts_Missing_Fonts="$2"
			;;
		fsutil-Stub_Program)
			enable_fsutil_Stub_Program="$2"
			;;
		gdi32-Lazy_Font_Initialization)
			enable_gdi32_Lazy_Font_Initialization="$2"
			;;
		gdi32-rotation)
			enable_gdi32_rotation="$2"
			;;
		gdiplus-FontFamily-RefCount)
			enable_gdiplus_FontFamily_RefCount="$2"
			;;
		gdiplus-GdipCreateBitmapFromHBITMAP)
			enable_gdiplus_GdipCreateBitmapFromHBITMAP="$2"
			;;
		gdiplus-Performance-Improvements)
			enable_gdiplus_Performance_Improvements="$2"
			;;
		imagehlp-BindImageEx)
			enable_imagehlp_BindImageEx="$2"
			;;
		imm32-message_on_focus)
			enable_imm32_message_on_focus="$2"
			;;
		include-LdrData)
			enable_include_LdrData="$2"
			;;
		include-winsock)
			enable_include_winsock="$2"
			;;
		inseng-Implementation)
			enable_inseng_Implementation="$2"
			;;
		iphlpapi-System_Ping)
			enable_iphlpapi_System_Ping="$2"
			;;
		kernel32-CopyFileEx)
			enable_kernel32_CopyFileEx="$2"
			;;
		kernel32-Debugger)
			enable_kernel32_Debugger="$2"
			;;
		kernel32-FindFirstFile)
			enable_kernel32_FindFirstFile="$2"
			;;
		kernel32-Job_Tests)
			enable_kernel32_Job_Tests="$2"
			;;
		kernel32-K32GetPerformanceInfo)
			enable_kernel32_K32GetPerformanceInfo="$2"
			;;
		kernel32-PE_Loader_Fixes)
			enable_kernel32_PE_Loader_Fixes="$2"
			;;
		kernel32-Processor_Group)
			enable_kernel32_Processor_Group="$2"
			;;
		kernel32-SetProcessDEPPolicy)
			enable_kernel32_SetProcessDEPPolicy="$2"
			;;
		kernelbase-ReOpenFile)
			enable_kernelbase_ReOpenFile="$2"
			;;
		krnl386.exe16-GDT_LDT_Emulation)
			enable_krnl386_exe16_GDT_LDT_Emulation="$2"
			;;
		krnl386.exe16-Invalid_Console_Handles)
			enable_krnl386_exe16_Invalid_Console_Handles="$2"
			;;
		libs-Debug_Channel)
			enable_libs_Debug_Channel="$2"
			;;
		libs-Unicode_Collation)
			enable_libs_Unicode_Collation="$2"
			;;
		loader-KeyboardLayouts)
			enable_loader_KeyboardLayouts="$2"
			;;
		mmsystem.dll16-MIDIHDR_Refcount)
			enable_mmsystem_dll16_MIDIHDR_Refcount="$2"
			;;
		mountmgr-DosDevices)
			enable_mountmgr_DosDevices="$2"
			;;
		mscoree-CorValidateImage)
			enable_mscoree_CorValidateImage="$2"
			;;
		msctf-ITfActiveLanguageProfileNotifySink)
			enable_msctf_ITfActiveLanguageProfileNotifySink="$2"
			;;
		mshtml-HTMLLocation_put_hash)
			enable_mshtml_HTMLLocation_put_hash="$2"
			;;
		mshtml-TranslateAccelerator)
			enable_mshtml_TranslateAccelerator="$2"
			;;
		msi-msi_vcl_get_cost)
			enable_msi_msi_vcl_get_cost="$2"
			;;
		msvcrt-Math_Precision)
			enable_msvcrt_Math_Precision="$2"
			;;
		ntdll-APC_Performance)
			enable_ntdll_APC_Performance="$2"
			;;
		ntdll-Activation_Context)
			enable_ntdll_Activation_Context="$2"
			;;
		ntdll-ApiSetMap)
			enable_ntdll_ApiSetMap="$2"
			;;
		ntdll-Builtin_Prot)
			enable_ntdll_Builtin_Prot="$2"
			;;
		ntdll-CriticalSection)
			enable_ntdll_CriticalSection="$2"
			;;
		ntdll-DOS_Attributes)
			enable_ntdll_DOS_Attributes="$2"
			;;
		ntdll-Dealloc_Thread_Stack)
			enable_ntdll_Dealloc_Thread_Stack="$2"
			;;
		ntdll-DeviceType_Systemroot)
			enable_ntdll_DeviceType_Systemroot="$2"
			;;
		ntdll-Exception)
			enable_ntdll_Exception="$2"
			;;
		ntdll-FileDispositionInformation)
			enable_ntdll_FileDispositionInformation="$2"
			;;
		ntdll-FileFsFullSizeInformation)
			enable_ntdll_FileFsFullSizeInformation="$2"
			;;
		ntdll-FileFsVolumeInformation)
			enable_ntdll_FileFsVolumeInformation="$2"
			;;
		ntdll-Fix_Alignment)
			enable_ntdll_Fix_Alignment="$2"
			;;
		ntdll-ForceBottomUpAlloc)
			enable_ntdll_ForceBottomUpAlloc="$2"
			;;
		ntdll-HashLinks)
			enable_ntdll_HashLinks="$2"
			;;
		ntdll-Heap_Improvements)
			enable_ntdll_Heap_Improvements="$2"
			;;
		ntdll-Hide_Wine_Exports)
			enable_ntdll_Hide_Wine_Exports="$2"
			;;
		ntdll-Interrupt-0x2e)
			enable_ntdll_Interrupt_0x2e="$2"
			;;
		ntdll-Junction_Points)
			enable_ntdll_Junction_Points="$2"
			;;
		ntdll-LDR_MODULE)
			enable_ntdll_LDR_MODULE="$2"
			;;
		ntdll-Manifest_Range)
			enable_ntdll_Manifest_Range="$2"
			;;
		ntdll-MemoryWorkingSetExInformation)
			enable_ntdll_MemoryWorkingSetExInformation="$2"
			;;
		ntdll-NtAccessCheck)
			enable_ntdll_NtAccessCheck="$2"
			;;
		ntdll-NtContinue)
			enable_ntdll_NtContinue="$2"
			;;
		ntdll-NtDevicePath)
			enable_ntdll_NtDevicePath="$2"
			;;
		ntdll-NtQueryEaFile)
			enable_ntdll_NtQueryEaFile="$2"
			;;
		ntdll-NtQuerySection)
			enable_ntdll_NtQuerySection="$2"
			;;
		ntdll-NtQueryVirtualMemory)
			enable_ntdll_NtQueryVirtualMemory="$2"
			;;
		ntdll-NtSetLdtEntries)
			enable_ntdll_NtSetLdtEntries="$2"
			;;
		ntdll-Pipe_SpecialCharacters)
			enable_ntdll_Pipe_SpecialCharacters="$2"
			;;
		ntdll-ProcessQuotaLimits)
			enable_ntdll_ProcessQuotaLimits="$2"
			;;
		ntdll-RtlCreateUserThread)
			enable_ntdll_RtlCreateUserThread="$2"
			;;
		ntdll-RtlGetNativeSystemInformation)
			enable_ntdll_RtlGetNativeSystemInformation="$2"
			;;
		ntdll-RtlIpv4StringToAddress)
			enable_ntdll_RtlIpv4StringToAddress="$2"
			;;
		ntdll-RtlQueryPackageIdentity)
			enable_ntdll_RtlQueryPackageIdentity="$2"
			;;
		ntdll-Serial_Port_Detection)
			enable_ntdll_Serial_Port_Detection="$2"
			;;
		ntdll-Signal_Handler)
			enable_ntdll_Signal_Handler="$2"
			;;
		ntdll-Status_Mapping)
			enable_ntdll_Status_Mapping="$2"
			;;
		ntdll-Syscall_Emulation)
			enable_ntdll_Syscall_Emulation="$2"
			;;
		ntdll-SystemExtendedProcessInformation)
			enable_ntdll_SystemExtendedProcessInformation="$2"
			;;
		ntdll-SystemInterruptInformation)
			enable_ntdll_SystemInterruptInformation="$2"
			;;
		ntdll-SystemModuleInformation)
			enable_ntdll_SystemModuleInformation="$2"
			;;
		ntdll-SystemRoot_Symlink)
			enable_ntdll_SystemRoot_Symlink="$2"
			;;
		ntdll-ThreadHideFromDebugger)
			enable_ntdll_ThreadHideFromDebugger="$2"
			;;
		ntdll-ThreadTime)
			enable_ntdll_ThreadTime="$2"
			;;
		ntdll-Threading)
			enable_ntdll_Threading="$2"
			;;
		ntdll-User_Shared_Data)
			enable_ntdll_User_Shared_Data="$2"
			;;
		ntdll-User_shared_data_fields)
			enable_ntdll_User_shared_data_fields="$2"
			;;
		ntdll-WRITECOPY)
			enable_ntdll_WRITECOPY="$2"
			;;
		ntdll-Wait_User_APC)
			enable_ntdll_Wait_User_APC="$2"
			;;
		ntdll-Zero_mod_name)
			enable_ntdll_Zero_mod_name="$2"
			;;
		ntdll-aarch-TEB)
			enable_ntdll_aarch_TEB="$2"
			;;
		ntdll-ext4-case-folder)
			enable_ntdll_ext4_case_folder="$2"
			;;
		ntdll-set_full_cpu_context)
			enable_ntdll_set_full_cpu_context="$2"
			;;
		ntdll-x86_64_SegDs)
			enable_ntdll_x86_64_SegDs="$2"
			;;
		ntoskrnl-Stubs)
			enable_ntoskrnl_Stubs="$2"
			;;
		nvapi-Stub_DLL)
			enable_nvapi_Stub_DLL="$2"
			;;
		nvcuda-CUDA_Support)
			enable_nvcuda_CUDA_Support="$2"
			;;
		nvcuvid-CUDA_Video_Support)
			enable_nvcuvid_CUDA_Video_Support="$2"
			;;
		nvencodeapi-Video_Encoder)
			enable_nvencodeapi_Video_Encoder="$2"
			;;
		ole32-HGLOBALStream)
			enable_ole32_HGLOBALStream="$2"
			;;
		oleaut32-CreateTypeLib)
			enable_oleaut32_CreateTypeLib="$2"
			;;
		oleaut32-Load_Save_EMF)
			enable_oleaut32_Load_Save_EMF="$2"
			;;
		oleaut32-OLEPictureImpl_SaveAsFile)
			enable_oleaut32_OLEPictureImpl_SaveAsFile="$2"
			;;
		oleaut32-OleLoadPicture)
			enable_oleaut32_OleLoadPicture="$2"
			;;
		oleaut32-OleLoadPictureFile)
			enable_oleaut32_OleLoadPictureFile="$2"
			;;
		opencl-version_1_2)
			enable_opencl_version_1_2="$2"
			;;
		opengl32-wglChoosePixelFormat)
			enable_opengl32_wglChoosePixelFormat="$2"
			;;
		packager-DllMain)
			enable_packager_DllMain="$2"
			;;
		pdh-PdhLookupPerfNameByIndex-processor)
			enable_pdh_PdhLookupPerfNameByIndex_processor="$2"
			;;
		quartz-MediaSeeking_Positions)
			enable_quartz_MediaSeeking_Positions="$2"
			;;
		riched20-Class_Tests)
			enable_riched20_Class_Tests="$2"
			;;
		riched20-IText_Interface)
			enable_riched20_IText_Interface="$2"
			;;
		server-Desktop_Refcount)
			enable_server_Desktop_Refcount="$2"
			;;
		server-FileEndOfFileInformation)
			enable_server_FileEndOfFileInformation="$2"
			;;
		server-File_Permissions)
			enable_server_File_Permissions="$2"
			;;
		server-Inherited_ACLs)
			enable_server_Inherited_ACLs="$2"
			;;
		server-Key_State)
			enable_server_Key_State="$2"
			;;
		server-Object_Types)
			enable_server_Object_Types="$2"
			;;
		server-PeekMessage)
			enable_server_PeekMessage="$2"
			;;
		server-Realtime_Priority)
			enable_server_Realtime_Priority="$2"
			;;
		server-Registry_Notifications)
			enable_server_Registry_Notifications="$2"
			;;
		server-Shared_Memory)
			enable_server_Shared_Memory="$2"
			;;
		server-Signal_Thread)
			enable_server_Signal_Thread="$2"
			;;
		server-Stored_ACLs)
			enable_server_Stored_ACLs="$2"
			;;
		server-Timestamp_Compat)
			enable_server_Timestamp_Compat="$2"
			;;
		server-device_manager_destroy)
			enable_server_device_manager_destroy="$2"
			;;
		setupapi-DiskSpaceList)
			enable_setupapi_DiskSpaceList="$2"
			;;
		setupapi-SPFILENOTIFY_FILEINCABINET)
			enable_setupapi_SPFILENOTIFY_FILEINCABINET="$2"
			;;
		setupapi-SP_COPY_IN_USE_NEEDS_REBOOT)
			enable_setupapi_SP_COPY_IN_USE_NEEDS_REBOOT="$2"
			;;
		shdocvw-ParseURLFromOutsideSource_Tests)
			enable_shdocvw_ParseURLFromOutsideSource_Tests="$2"
			;;
		shell32-ACE_Viewer)
			enable_shell32_ACE_Viewer="$2"
			;;
		shell32-Context_Menu)
			enable_shell32_Context_Menu="$2"
			;;
		shell32-IconCache)
			enable_shell32_IconCache="$2"
			;;
		shell32-NewMenu_Interface)
			enable_shell32_NewMenu_Interface="$2"
			;;
		shell32-Progress_Dialog)
			enable_shell32_Progress_Dialog="$2"
			;;
		shell32-SFGAO_HASSUBFOLDER)
			enable_shell32_SFGAO_HASSUBFOLDER="$2"
			;;
		shell32-SHFileOperation_Move)
			enable_shell32_SHFileOperation_Move="$2"
			;;
		shell32-SHGetStockIconInfo)
			enable_shell32_SHGetStockIconInfo="$2"
			;;
		shell32-Toolbar_Bitmaps)
			enable_shell32_Toolbar_Bitmaps="$2"
			;;
		shell32-UnixFS)
			enable_shell32_UnixFS="$2"
			;;
		shlwapi-AssocGetPerceivedType)
			enable_shlwapi_AssocGetPerceivedType="$2"
			;;
		shlwapi-SHAddDataBlock)
			enable_shlwapi_SHAddDataBlock="$2"
			;;
		shlwapi-UrlCanonicalize)
			enable_shlwapi_UrlCanonicalize="$2"
			;;
		shlwapi-UrlCombine)
			enable_shlwapi_UrlCombine="$2"
			;;
		stdole32.idl-Typelib)
			enable_stdole32_idl_Typelib="$2"
			;;
		stdole32.tlb-SLTG_Typelib)
			enable_stdole32_tlb_SLTG_Typelib="$2"
			;;
		user32-DM_SETDEFID)
			enable_user32_DM_SETDEFID="$2"
			;;
		user32-Dialog_Paint_Event)
			enable_user32_Dialog_Paint_Event="$2"
			;;
		user32-DrawMenuItem)
			enable_user32_DrawMenuItem="$2"
			;;
		user32-DrawTextExW)
			enable_user32_DrawTextExW="$2"
			;;
		user32-FlashWindowEx)
			enable_user32_FlashWindowEx="$2"
			;;
		user32-GetSystemMetrics)
			enable_user32_GetSystemMetrics="$2"
			;;
		user32-Implement-CascadeWindows)
			enable_user32_Implement_CascadeWindows="$2"
			;;
		user32-InternalGetWindowIcon)
			enable_user32_InternalGetWindowIcon="$2"
			;;
		user32-LR_LOADFROMFILE)
			enable_user32_LR_LOADFROMFILE="$2"
			;;
		user32-ListBox_Size)
			enable_user32_ListBox_Size="$2"
			;;
		user32-LoadKeyboardLayoutEx)
			enable_user32_LoadKeyboardLayoutEx="$2"
			;;
		user32-MessageBox_WS_EX_TOPMOST)
			enable_user32_MessageBox_WS_EX_TOPMOST="$2"
			;;
		user32-Mouse_Message_Hwnd)
			enable_user32_Mouse_Message_Hwnd="$2"
			;;
		user32-Refresh_MDI_Menus)
			enable_user32_Refresh_MDI_Menus="$2"
			;;
		user32-ScrollWindowEx)
			enable_user32_ScrollWindowEx="$2"
			;;
		user32-ShowWindow)
			enable_user32_ShowWindow="$2"
			;;
		user32-msgbox-Support-WM_COPY-mesg)
			enable_user32_msgbox_Support_WM_COPY_mesg="$2"
			;;
		user32-rawinput-hid)
			enable_user32_rawinput_hid="$2"
			;;
		user32-rawinput-mouse)
			enable_user32_rawinput_mouse="$2"
			;;
		user32-rawinput-mouse-experimental)
			enable_user32_rawinput_mouse_experimental="$2"
			;;
		user32-rawinput-nolegacy)
			enable_user32_rawinput_nolegacy="$2"
			;;
		user32-recursive-activation)
			enable_user32_recursive_activation="$2"
			;;
		user32-window-activation)
			enable_user32_window_activation="$2"
			;;
		uxtheme-CloseThemeClass)
			enable_uxtheme_CloseThemeClass="$2"
			;;
		uxtheme-GTK_Theming)
			enable_uxtheme_GTK_Theming="$2"
			;;
		version-VerQueryValue)
			enable_version_VerQueryValue="$2"
			;;
		widl-SLTG_Typelib_Support)
			enable_widl_SLTG_Typelib_Support="$2"
			;;
		windowscodecs-GIF_Encoder)
			enable_windowscodecs_GIF_Encoder="$2"
			;;
		windowscodecs-TIFF_Support)
			enable_windowscodecs_TIFF_Support="$2"
			;;
		wine.inf-Directory_ContextMenuHandlers)
			enable_wine_inf_Directory_ContextMenuHandlers="$2"
			;;
		wine.inf-Dummy_CA_Certificate)
			enable_wine_inf_Dummy_CA_Certificate="$2"
			;;
		wine.inf-Performance)
			enable_wine_inf_Performance="$2"
			;;
		wineboot-DriveSerial)
			enable_wineboot_DriveSerial="$2"
			;;
		wineboot-HKEY_DYN_DATA)
			enable_wineboot_HKEY_DYN_DATA="$2"
			;;
		wineboot-ProxySettings)
			enable_wineboot_ProxySettings="$2"
			;;
		wineboot-drivers_etc_Stubs)
			enable_wineboot_drivers_etc_Stubs="$2"
			;;
		winebuild-Fake_Dlls)
			enable_winebuild_Fake_Dlls="$2"
			;;
		winecfg-Libraries)
			enable_winecfg_Libraries="$2"
			;;
		winecfg-Staging)
			enable_winecfg_Staging="$2"
			;;
		winecfg-Unmounted_Devices)
			enable_winecfg_Unmounted_Devices="$2"
			;;
		wined3d-Accounting)
			enable_wined3d_Accounting="$2"
			;;
		wined3d-CSMT_Main)
			enable_wined3d_CSMT_Main="$2"
			;;
		wined3d-Dual_Source_Blending)
			enable_wined3d_Dual_Source_Blending="$2"
			;;
		wined3d-Indexed_Vertex_Blending)
			enable_wined3d_Indexed_Vertex_Blending="$2"
			;;
		wined3d-SWVP-shaders)
			enable_wined3d_SWVP_shaders="$2"
			;;
		wined3d-Silence_FIXMEs)
			enable_wined3d_Silence_FIXMEs="$2"
			;;
		wined3d-UAV_Counters)
			enable_wined3d_UAV_Counters="$2"
			;;
		wined3d-WINED3DFMT_B8G8R8X8_UNORM)
			enable_wined3d_WINED3DFMT_B8G8R8X8_UNORM="$2"
			;;
		wined3d-WINED3D_RS_COLORWRITEENABLE)
			enable_wined3d_WINED3D_RS_COLORWRITEENABLE="$2"
			;;
		wined3d-WINED3D_TEXF_ANISOTROPIC)
			enable_wined3d_WINED3D_TEXF_ANISOTROPIC="$2"
			;;
		wined3d-mesa_texture_download)
			enable_wined3d_mesa_texture_download="$2"
			;;
		wined3d-unset-flip-gdi)
			enable_wined3d_unset_flip_gdi="$2"
			;;
		wined3d-wined3d_guess_gl_vendor)
			enable_wined3d_wined3d_guess_gl_vendor="$2"
			;;
		wined3d-zero-inf-shaders)
			enable_wined3d_zero_inf_shaders="$2"
			;;
		winedbg-Process_Arguments)
			enable_winedbg_Process_Arguments="$2"
			;;
		winedevice-Default_Drivers)
			enable_winedevice_Default_Drivers="$2"
			;;
		winemapi-user-xdg-mail)
			enable_winemapi_user_xdg_mail="$2"
			;;
		winemenubuilder-Desktop_Icon_Path)
			enable_winemenubuilder_Desktop_Icon_Path="$2"
			;;
		wineps.drv-PostScript_Fixes)
			enable_wineps_drv_PostScript_Fixes="$2"
			;;
		winepulse-PulseAudio_Support)
			enable_winepulse_PulseAudio_Support="$2"
			;;
		winex11-CandidateWindowPos)
			enable_winex11_CandidateWindowPos="$2"
			;;
		winex11-DefaultDisplayFrequency)
			enable_winex11_DefaultDisplayFrequency="$2"
			;;
		winex11-MWM_Decorations)
			enable_winex11_MWM_Decorations="$2"
			;;
		winex11-UpdateLayeredWindow)
			enable_winex11_UpdateLayeredWindow="$2"
			;;
		winex11-Vulkan_support)
			enable_winex11_Vulkan_support="$2"
			;;
		winex11-WM_WINDOWPOSCHANGING)
			enable_winex11_WM_WINDOWPOSCHANGING="$2"
			;;
		winex11-Window_Style)
			enable_winex11_Window_Style="$2"
			;;
		winex11-XEMBED)
			enable_winex11_XEMBED="$2"
			;;
		winex11-_NET_ACTIVE_WINDOW)
			enable_winex11__NET_ACTIVE_WINDOW="$2"
			;;
		winex11-ime-check-thread-data)
			enable_winex11_ime_check_thread_data="$2"
			;;
		winex11-key_translation)
			enable_winex11_key_translation="$2"
			;;
		winex11-wglShareLists)
			enable_winex11_wglShareLists="$2"
			;;
		winex11.drv-Query_server_position)
			enable_winex11_drv_Query_server_position="$2"
			;;
		winex11.drv-mouse-coorrds)
			enable_winex11_drv_mouse_coorrds="$2"
			;;
		wininet-Cleanup)
			enable_wininet_Cleanup="$2"
			;;
		winmm-Delay_Import_Depends)
			enable_winmm_Delay_Import_Depends="$2"
			;;
		winmm-mciSendCommandA)
			enable_winmm_mciSendCommandA="$2"
			;;
		wintab32-improvements)
			enable_wintab32_improvements="$2"
			;;
		wintrust-WTHelperGetProvCertFromChain)
			enable_wintrust_WTHelperGetProvCertFromChain="$2"
			;;
		wow64cpu-Wow64Transition)
			enable_wow64cpu_Wow64Transition="$2"
			;;
		wpcap-Dynamic_Linking)
			enable_wpcap_Dynamic_Linking="$2"
			;;
		ws2_32-APC_Performance)
			enable_ws2_32_APC_Performance="$2"
			;;
		ws2_32-Connect_Time)
			enable_ws2_32_Connect_Time="$2"
			;;
		ws2_32-TransmitFile)
			enable_ws2_32_TransmitFile="$2"
			;;
		ws2_32-WSACleanup)
			enable_ws2_32_WSACleanup="$2"
			;;
		ws2_32-getaddrinfo)
			enable_ws2_32_getaddrinfo="$2"
			;;
		ws2_32-getsockopt)
			enable_ws2_32_getsockopt="$2"
			;;
		wtsapi32-EnumerateProcesses)
			enable_wtsapi32_EnumerateProcesses="$2"
			;;
		wusa-MSU_Package_Installer)
			enable_wusa_MSU_Package_Installer="$2"
			;;
		*)
			return 1
			;;
	esac
	return 0
}

# Default settings
patch_enable_all 0
enable_patchlist=1
enable_autoconf=1
patchlist="/dev/null"
backend="patch"

# Find location of patches
patchdir="$(cd "$(dirname "$0")" && pwd)"
if test ! -f "$patchdir/patchinstall.sh"; then
	if test -f ./patchinstall.sh; then
		patchdir="$(pwd)"
	else
		abort "Failed to find patch directory."
	fi
fi

# Parse commandline arguments
if test "$#" -eq 0; then
	abort "No commandline arguments given, don't know what to do."
fi

while test "$#" -gt 0; do
	case "$1" in
		DESTDIR=*)
			DESTDIR="${1#*=}"
			shift
			;;

		--all)
			patch_enable_all 1
			shift
			;;

		--backend=*)
			backend="${1#*=}"
			shift
			;;

		--force-autoconf)
			enable_autoconf=2
			shift
			;;

		--help)
			usage
			exit 0
			;;

		--no-patchlist)
			enable_patchlist=0
			shift
			;;

		--no-autoconf)
			enable_autoconf=0
			shift
			;;

		--upstream-commit)
			upstream_commit
			exit 0
			;;

		--version)
			version
			exit 0
			;;

		-W)
			# Disable patchset
			if ! patch_enable "$2" 2; then
				abort "Wrong usage of -W commandline argument, expected patchname."
			fi
			shift
			shift
			;;

		*)
			# Enable patchset
			if ! patch_enable "$1" 1; then
				abort "Unknown commandline argument $1."
			fi
			shift
			;;
	esac
done

# Determine DESTDIR if not explicitly specified
if test -z "$DESTDIR" -a -f ./tools/make_requests; then
	DESTDIR="$(pwd)"

elif test ! -f "$DESTDIR/tools/make_requests"; then
	abort "DESTDIR does not point to the Wine source tree."
fi

# Change directory to DESTDIR, eapply/epatch depends on that
if ! cd "$DESTDIR"; then
	abort "Unable to change directory to $DESTDIR."
fi

# Helper to update configure / the wineserver protocol if required
if ! command -v diff >/dev/null 2>&1 ||
   ! command -v grep >/dev/null 2>&1 ||
   ! command -v cmp >/dev/null 2>&1; then

	update_configure()
	{
		autoreconf -f
	}

	update_protocol()
	{
		./tools/make_requests
	}

else

	update_configure()
	{
		_file="./configure"

		if ! cp -a "$_file" "$_file.old"; then
			abort "failed to create $_file.old"
		fi

		if ! autoreconf -f; then
			rm "$_file.old"
			unset _file
			return 1
		fi

		# Shifting by 62 bits is undefined behaviour when off_t is 32-bit, see also
		# https://launchpad.net/ubuntu/+source/autoconf/2.69-6 - the bug is still
		# present in some other distros (including Archlinux).
		_large_off_old="^#define LARGE_OFF_T (((off_t) 1 << 62) - 1 + ((off_t) 1 << 62))\$"
		_large_off_new="#define LARGE_OFF_T ((((off_t) 1 << 31) << 31) - 1 + (((off_t) 1 << 31) << 31))"
		sed -i'' -e "s|$_large_off_old|$_large_off_new|g" "$_file"
		unset _large_off_old _large_off_new

		# Restore original timestamp when nothing changed
		if ! cmp "$_file.old" "$_file" >/dev/null; then
			rm "$_file.old"
		else
			mv "$_file.old" "$_file"
		fi

		unset _file
		return 0
	}

	update_protocol()
	{
		_file="./include/wine/server_protocol.h"

		if ! cp -a "$_file" "$_file.old"; then
			abort "failed to create $_file.old"
		fi

		if ! ./tools/make_requests; then
			rm "$_file.old"
			unset _file
			return 1
		fi

		# Restore original timestamp when nothing changed
		if diff -u "$_file.old" "$_file" |
		   grep -v "^[+-]#define SERVER_PROTOCOL_VERSION" |
		   grep -v "^\(+++\|---\)" | grep -q "^[+-]"; then
			rm "$_file.old"
		else
			mv "$_file.old" "$_file"
		fi

		unset _file
		return 0
	}
fi


# Most backends will try to use git, either directly or indirectly.
# Unfortunately this does not work when "$DESTDIR" points to a
# subdirectory of a git tree, which has the effect that no patches
# are applied, but the exitcode is zero. To avoid broken builds we
# will workaround this issue or abort.
test ! -e ".git" && git rev-parse --git-dir >/dev/null 2>&1
workaround_git_bug="$?"

# Apply the patches using gitapply.sh, a small wrapper around 'patch'
if test "$backend" = "patch"; then

	if test "$workaround_git_bug" -eq 0; then
		gitapply_args="--nogit"
	else
		gitapply_args=""
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		printf '%s\n' "Applying $1"
		if ! "$patchdir/gitapply.sh" $gitapply_args < "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
	}

# 'eapply/epatch' backend - used on Gentoo
elif test "$backend" = "eapply" -o "$backend" = "epatch"; then

	if test "$workaround_git_bug" -eq 0; then
		gitapply_args="--nogit"
	else
		gitapply_args=""
	fi

	if ! command -v "$backend"  >/dev/null 2>&1 || \
	   ! command -v ebegin      >/dev/null 2>&1 || \
	   ! command -v eend        >/dev/null 2>&1 || \
	   ! command -v nonfatal    >/dev/null 2>&1; then
		abort "Shell functions $backend/ebegin/eend/nonfatal not found. You have to source this script from your ebuild."
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		_shortname="$(basename "$1")"
		if grep -q "^GIT binary patch" "$1"; then
			ebegin "Applying $_shortname"
			"$patchdir/gitapply.sh" $gitapply_args < "$1"
			if ! eend $?; then
				exit 1
			fi
		else
			# we are run from a subshell, so we can't call die
			if ! nonfatal "$backend" "$1"; then
				exit 1
			fi
		fi
		unset _shortname
	}

# GIT backend - apply patches using 'git am'
elif test "$backend" = "git" -o "$backend" = "git-am"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'git-am' not possible when DESTDIR points to a git subdirectory."
	fi

	patch_apply_file()
	{
		printf '%s\n' "Applying $1"
		if ! git am "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
		if test "$enable_autoconf" -gt 1; then
			_do_commit=0

			# Run 'autoreconf -f' if required
			if git show --pretty=format: --name-only | grep -q "^\(configure.ac\|aclocal.m4\)$"; then
				if ! update_configure; then
					abort "'autoreconf -f' failed."
				fi
				git add ./configure
				git add ./include/config.h.in
				_do_commit=1
			fi

			# Run './tools/make_requests' if required
			if git show --pretty=format: --name-only | grep -q "^server/"; then
				if ! update_protocol; then
					abort "'./tools/make_requests' failed."
				fi
				git add ./include/wine/server_protocol.h
				git add ./server/trace.c
				git add ./server/request.h
				_do_commit=1
			fi

			if test "$_do_commit" -ne 0; then
				if ! git commit --amend --reuse-message HEAD; then
					abort "Failed to include autogenerated changes in commit."
				fi
			fi

			unset _do_commit
		fi
	}

# Git apply backend
elif test "$backend" = "git-apply"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'git-apply' not possible when DESTDIR points to a git subdirectory."
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		printf '%s\n' "Applying $1"
		if ! git apply "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
	}

# Stacked GIT backend - import the patches (mainly for developers)
elif test "$backend" = "stg"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'stg' not possible when DESTDIR points to a git subdirectory."
	fi

	# Only import the regular patches, no autogenerated ones -
	# moreover, don't run autoreconf or ./tools/make_requests.
	enable_patchlist=0
	enable_autoconf=0

	patch_apply_file()
	{
		printf '%s\n' "Applying $1"
		_shortname="$(basename "$1")"
		if ! printf '%s\n' "staging/$_shortname" | cat - "$1" | stg import; then
			abort "Failed to apply patch, aborting!"
		fi
		unset _shortname
	}

else
	abort "Selected backend $backend not supported."
fi

patch_apply()
{
	patch_apply_file "$patchdir/$1"
}


if test "$enable_ws2_32_TransmitFile" -eq 1; then
	if test "$enable_server_Desktop_Refcount" -gt 1; then
		abort "Patchset server-Desktop_Refcount disabled, but ws2_32-TransmitFile depends on that."
	fi
	enable_server_Desktop_Refcount=1
fi

if test "$enable_winex11_WM_WINDOWPOSCHANGING" -eq 1; then
	if test "$enable_winex11__NET_ACTIVE_WINDOW" -gt 1; then
		abort "Patchset winex11-_NET_ACTIVE_WINDOW disabled, but winex11-WM_WINDOWPOSCHANGING depends on that."
	fi
	enable_winex11__NET_ACTIVE_WINDOW=1
fi

if test "$enable_winedevice_Default_Drivers" -eq 1; then
	if test "$enable_dxva2_Video_Decoder" -gt 1; then
		abort "Patchset dxva2-Video_Decoder disabled, but winedevice-Default_Drivers depends on that."
	fi
	if test "$enable_ntoskrnl_Stubs" -gt 1; then
		abort "Patchset ntoskrnl-Stubs disabled, but winedevice-Default_Drivers depends on that."
	fi
	enable_dxva2_Video_Decoder=1
	enable_ntoskrnl_Stubs=1
fi

if test "$enable_wined3d_Indexed_Vertex_Blending" -eq 1; then
	if test "$enable_wined3d_SWVP_shaders" -gt 1; then
		abort "Patchset wined3d-SWVP-shaders disabled, but wined3d-Indexed_Vertex_Blending depends on that."
	fi
	enable_wined3d_SWVP_shaders=1
fi

if test "$enable_wineboot_ProxySettings" -eq 1; then
	if test "$enable_wineboot_DriveSerial" -gt 1; then
		abort "Patchset wineboot-DriveSerial disabled, but wineboot-ProxySettings depends on that."
	fi
	if test "$enable_wineboot_drivers_etc_Stubs" -gt 1; then
		abort "Patchset wineboot-drivers_etc_Stubs disabled, but wineboot-ProxySettings depends on that."
	fi
	enable_wineboot_DriveSerial=1
	enable_wineboot_drivers_etc_Stubs=1
fi

if test "$enable_windowscodecs_TIFF_Support" -eq 1; then
	if test "$enable_windowscodecs_GIF_Encoder" -gt 1; then
		abort "Patchset windowscodecs-GIF_Encoder disabled, but windowscodecs-TIFF_Support depends on that."
	fi
	enable_windowscodecs_GIF_Encoder=1
fi

if test "$enable_uxtheme_GTK_Theming" -eq 1; then
	if test "$enable_uxtheme_CloseThemeClass" -gt 1; then
		abort "Patchset uxtheme-CloseThemeClass disabled, but uxtheme-GTK_Theming depends on that."
	fi
	enable_uxtheme_CloseThemeClass=1
fi

if test "$enable_user32_window_activation" -eq 1; then
	if test "$enable_user32_recursive_activation" -gt 1; then
		abort "Patchset user32-recursive-activation disabled, but user32-window-activation depends on that."
	fi
	enable_user32_recursive_activation=1
fi

if test "$enable_user32_rawinput_mouse_experimental" -eq 1; then
	if test "$enable_user32_rawinput_nolegacy" -gt 1; then
		abort "Patchset user32-rawinput-nolegacy disabled, but user32-rawinput-mouse-experimental depends on that."
	fi
	enable_user32_rawinput_nolegacy=1
fi

if test "$enable_user32_rawinput_hid" -eq 1; then
	if test "$enable_user32_rawinput_nolegacy" -gt 1; then
		abort "Patchset user32-rawinput-nolegacy disabled, but user32-rawinput-hid depends on that."
	fi
	enable_user32_rawinput_nolegacy=1
fi

if test "$enable_user32_rawinput_nolegacy" -eq 1; then
	if test "$enable_user32_rawinput_mouse" -gt 1; then
		abort "Patchset user32-rawinput-mouse disabled, but user32-rawinput-nolegacy depends on that."
	fi
	enable_user32_rawinput_mouse=1
fi

if test "$enable_user32_rawinput_mouse" -eq 1; then
	if test "$enable_winex11_drv_mouse_coorrds" -gt 1; then
		abort "Patchset winex11.drv-mouse-coorrds disabled, but user32-rawinput-mouse depends on that."
	fi
	enable_winex11_drv_mouse_coorrds=1
fi

if test "$enable_stdole32_tlb_SLTG_Typelib" -eq 1; then
	if test "$enable_widl_SLTG_Typelib_Support" -gt 1; then
		abort "Patchset widl-SLTG_Typelib_Support disabled, but stdole32.tlb-SLTG_Typelib depends on that."
	fi
	enable_widl_SLTG_Typelib_Support=1
fi

if test "$enable_shell32_ACE_Viewer" -eq 1; then
	if test "$enable_shell32_Progress_Dialog" -gt 1; then
		abort "Patchset shell32-Progress_Dialog disabled, but shell32-ACE_Viewer depends on that."
	fi
	enable_shell32_Progress_Dialog=1
fi

if test "$enable_shell32_Progress_Dialog" -eq 1; then
	if test "$enable_kernel32_CopyFileEx" -gt 1; then
		abort "Patchset kernel32-CopyFileEx disabled, but shell32-Progress_Dialog depends on that."
	fi
	if test "$enable_shell32_SHFileOperation_Move" -gt 1; then
		abort "Patchset shell32-SHFileOperation_Move disabled, but shell32-Progress_Dialog depends on that."
	fi
	enable_kernel32_CopyFileEx=1
	enable_shell32_SHFileOperation_Move=1
fi

if test "$enable_server_Object_Types" -eq 1; then
	if test "$enable_server_Shared_Memory" -gt 1; then
		abort "Patchset server-Shared_Memory disabled, but server-Object_Types depends on that."
	fi
	enable_server_Shared_Memory=1
fi

if test "$enable_server_Inherited_ACLs" -eq 1; then
	if test "$enable_server_Stored_ACLs" -gt 1; then
		abort "Patchset server-Stored_ACLs disabled, but server-Inherited_ACLs depends on that."
	fi
	enable_server_Stored_ACLs=1
fi

if test "$enable_server_Stored_ACLs" -eq 1; then
	if test "$enable_ntdll_DOS_Attributes" -gt 1; then
		abort "Patchset ntdll-DOS_Attributes disabled, but server-Stored_ACLs depends on that."
	fi
	if test "$enable_server_File_Permissions" -gt 1; then
		abort "Patchset server-File_Permissions disabled, but server-Stored_ACLs depends on that."
	fi
	enable_ntdll_DOS_Attributes=1
	enable_server_File_Permissions=1
fi

if test "$enable_server_Desktop_Refcount" -eq 1; then
	if test "$enable_eventfd_synchronization" -gt 1; then
		abort "Patchset eventfd_synchronization disabled, but server-Desktop_Refcount depends on that."
	fi
	if test "$enable_ws2_32_WSACleanup" -gt 1; then
		abort "Patchset ws2_32-WSACleanup disabled, but server-Desktop_Refcount depends on that."
	fi
	enable_eventfd_synchronization=1
	enable_ws2_32_WSACleanup=1
fi

if test "$enable_oleaut32_OLEPictureImpl_SaveAsFile" -eq 1; then
	if test "$enable_oleaut32_Load_Save_EMF" -gt 1; then
		abort "Patchset oleaut32-Load_Save_EMF disabled, but oleaut32-OLEPictureImpl_SaveAsFile depends on that."
	fi
	enable_oleaut32_Load_Save_EMF=1
fi

if test "$enable_nvencodeapi_Video_Encoder" -eq 1; then
	if test "$enable_nvcuvid_CUDA_Video_Support" -gt 1; then
		abort "Patchset nvcuvid-CUDA_Video_Support disabled, but nvencodeapi-Video_Encoder depends on that."
	fi
	enable_nvcuvid_CUDA_Video_Support=1
fi

if test "$enable_nvcuvid_CUDA_Video_Support" -eq 1; then
	if test "$enable_nvapi_Stub_DLL" -gt 1; then
		abort "Patchset nvapi-Stub_DLL disabled, but nvcuvid-CUDA_Video_Support depends on that."
	fi
	enable_nvapi_Stub_DLL=1
fi

if test "$enable_ntdll_User_shared_data_fields" -eq 1; then
	if test "$enable_wow64cpu_Wow64Transition" -gt 1; then
		abort "Patchset wow64cpu-Wow64Transition disabled, but ntdll-User_shared_data_fields depends on that."
	fi
	enable_wow64cpu_Wow64Transition=1
fi

if test "$enable_wow64cpu_Wow64Transition" -eq 1; then
	if test "$enable_advapi32_Token_Integrity_Level" -gt 1; then
		abort "Patchset advapi32-Token_Integrity_Level disabled, but wow64cpu-Wow64Transition depends on that."
	fi
	enable_advapi32_Token_Integrity_Level=1
fi

if test "$enable_ntdll_Syscall_Emulation" -eq 1; then
	if test "$enable_winebuild_Fake_Dlls" -gt 1; then
		abort "Patchset winebuild-Fake_Dlls disabled, but ntdll-Syscall_Emulation depends on that."
	fi
	enable_winebuild_Fake_Dlls=1
fi

if test "$enable_ntdll_Signal_Handler" -eq 1; then
	if test "$enable_ntdll_WRITECOPY" -gt 1; then
		abort "Patchset ntdll-WRITECOPY disabled, but ntdll-Signal_Handler depends on that."
	fi
	enable_ntdll_WRITECOPY=1
fi

if test "$enable_ntdll_WRITECOPY" -eq 1; then
	if test "$enable_ntdll_User_Shared_Data" -gt 1; then
		abort "Patchset ntdll-User_Shared_Data disabled, but ntdll-WRITECOPY depends on that."
	fi
	enable_ntdll_User_Shared_Data=1
fi

if test "$enable_ntdll_NtQueryEaFile" -eq 1; then
	if test "$enable_ntdll_Junction_Points" -gt 1; then
		abort "Patchset ntdll-Junction_Points disabled, but ntdll-NtQueryEaFile depends on that."
	fi
	enable_ntdll_Junction_Points=1
fi

if test "$enable_ntdll_NtContinue" -eq 1; then
	if test "$enable_winebuild_Fake_Dlls" -gt 1; then
		abort "Patchset winebuild-Fake_Dlls disabled, but ntdll-NtContinue depends on that."
	fi
	enable_winebuild_Fake_Dlls=1
fi

if test "$enable_ntdll_MemoryWorkingSetExInformation" -eq 1; then
	if test "$enable_ntdll_NtQueryVirtualMemory" -gt 1; then
		abort "Patchset ntdll-NtQueryVirtualMemory disabled, but ntdll-MemoryWorkingSetExInformation depends on that."
	fi
	enable_ntdll_NtQueryVirtualMemory=1
fi

if test "$enable_ntdll_NtQueryVirtualMemory" -eq 1; then
	if test "$enable_ntdll_NtDevicePath" -gt 1; then
		abort "Patchset ntdll-NtDevicePath disabled, but ntdll-NtQueryVirtualMemory depends on that."
	fi
	enable_ntdll_NtDevicePath=1
fi

if test "$enable_ntdll_NtDevicePath" -eq 1; then
	if test "$enable_ntdll_Pipe_SpecialCharacters" -gt 1; then
		abort "Patchset ntdll-Pipe_SpecialCharacters disabled, but ntdll-NtDevicePath depends on that."
	fi
	enable_ntdll_Pipe_SpecialCharacters=1
fi

if test "$enable_ntdll_HashLinks" -eq 1; then
	if test "$enable_ntdll_LDR_MODULE" -gt 1; then
		abort "Patchset ntdll-LDR_MODULE disabled, but ntdll-HashLinks depends on that."
	fi
	enable_ntdll_LDR_MODULE=1
fi

if test "$enable_ntdll_DOS_Attributes" -eq 1; then
	if test "$enable_ntdll_Junction_Points" -gt 1; then
		abort "Patchset ntdll-Junction_Points disabled, but ntdll-DOS_Attributes depends on that."
	fi
	enable_ntdll_Junction_Points=1
fi

if test "$enable_ntdll_Builtin_Prot" -eq 1; then
	if test "$enable_ntdll_User_Shared_Data" -gt 1; then
		abort "Patchset ntdll-User_Shared_Data disabled, but ntdll-Builtin_Prot depends on that."
	fi
	enable_ntdll_User_Shared_Data=1
fi

if test "$enable_ntdll_ApiSetMap" -eq 1; then
	if test "$enable_ntdll_ThreadTime" -gt 1; then
		abort "Patchset ntdll-ThreadTime disabled, but ntdll-ApiSetMap depends on that."
	fi
	enable_ntdll_ThreadTime=1
fi

if test "$enable_kernel32_Processor_Group" -eq 1; then
	if test "$enable_api_ms_win_Stub_DLLs" -gt 1; then
		abort "Patchset api-ms-win-Stub_DLLs disabled, but kernel32-Processor_Group depends on that."
	fi
	enable_api_ms_win_Stub_DLLs=1
fi

if test "$enable_kernel32_CopyFileEx" -eq 1; then
	if test "$enable_ntdll_FileDispositionInformation" -gt 1; then
		abort "Patchset ntdll-FileDispositionInformation disabled, but kernel32-CopyFileEx depends on that."
	fi
	enable_ntdll_FileDispositionInformation=1
fi

if test "$enable_ntdll_FileDispositionInformation" -eq 1; then
	if test "$enable_server_File_Permissions" -gt 1; then
		abort "Patchset server-File_Permissions disabled, but ntdll-FileDispositionInformation depends on that."
	fi
	enable_server_File_Permissions=1
fi

if test "$enable_server_File_Permissions" -eq 1; then
	if test "$enable_ntdll_Junction_Points" -gt 1; then
		abort "Patchset ntdll-Junction_Points disabled, but server-File_Permissions depends on that."
	fi
	enable_ntdll_Junction_Points=1
fi

if test "$enable_eventfd_synchronization" -eq 1; then
	if test "$enable_advapi32_Token_Integrity_Level" -gt 1; then
		abort "Patchset advapi32-Token_Integrity_Level disabled, but eventfd_synchronization depends on that."
	fi
	if test "$enable_kernel32_K32GetPerformanceInfo" -gt 1; then
		abort "Patchset kernel32-K32GetPerformanceInfo disabled, but eventfd_synchronization depends on that."
	fi
	if test "$enable_ntdll_Junction_Points" -gt 1; then
		abort "Patchset ntdll-Junction_Points disabled, but eventfd_synchronization depends on that."
	fi
	if test "$enable_ntdll_RtlCreateUserThread" -gt 1; then
		abort "Patchset ntdll-RtlCreateUserThread disabled, but eventfd_synchronization depends on that."
	fi
	if test "$enable_ntdll_SystemRoot_Symlink" -gt 1; then
		abort "Patchset ntdll-SystemRoot_Symlink disabled, but eventfd_synchronization depends on that."
	fi
	if test "$enable_ntdll_User_Shared_Data" -gt 1; then
		abort "Patchset ntdll-User_Shared_Data disabled, but eventfd_synchronization depends on that."
	fi
	if test "$enable_server_Realtime_Priority" -gt 1; then
		abort "Patchset server-Realtime_Priority disabled, but eventfd_synchronization depends on that."
	fi
	if test "$enable_server_Shared_Memory" -gt 1; then
		abort "Patchset server-Shared_Memory disabled, but eventfd_synchronization depends on that."
	fi
	if test "$enable_ws2_32_WSACleanup" -gt 1; then
		abort "Patchset ws2_32-WSACleanup disabled, but eventfd_synchronization depends on that."
	fi
	enable_advapi32_Token_Integrity_Level=1
	enable_kernel32_K32GetPerformanceInfo=1
	enable_ntdll_Junction_Points=1
	enable_ntdll_RtlCreateUserThread=1
	enable_ntdll_SystemRoot_Symlink=1
	enable_ntdll_User_Shared_Data=1
	enable_server_Realtime_Priority=1
	enable_server_Shared_Memory=1
	enable_ws2_32_WSACleanup=1
fi

if test "$enable_server_Shared_Memory" -eq 1; then
	if test "$enable_ntdll_Threading" -gt 1; then
		abort "Patchset ntdll-Threading disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_ntdll_Wait_User_APC" -gt 1; then
		abort "Patchset ntdll-Wait_User_APC disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_Key_State" -gt 1; then
		abort "Patchset server-Key_State disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_PeekMessage" -gt 1; then
		abort "Patchset server-PeekMessage disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_Signal_Thread" -gt 1; then
		abort "Patchset server-Signal_Thread disabled, but server-Shared_Memory depends on that."
	fi
	enable_ntdll_Threading=1
	enable_ntdll_Wait_User_APC=1
	enable_server_Key_State=1
	enable_server_PeekMessage=1
	enable_server_Signal_Thread=1
fi

if test "$enable_server_Realtime_Priority" -eq 1; then
	if test "$enable_ntdll_ThreadTime" -gt 1; then
		abort "Patchset ntdll-ThreadTime disabled, but server-Realtime_Priority depends on that."
	fi
	enable_ntdll_ThreadTime=1
fi

if test "$enable_ntdll_SystemRoot_Symlink" -eq 1; then
	if test "$enable_ntdll_Exception" -gt 1; then
		abort "Patchset ntdll-Exception disabled, but ntdll-SystemRoot_Symlink depends on that."
	fi
	enable_ntdll_Exception=1
fi

if test "$enable_ntdll_RtlCreateUserThread" -eq 1; then
	if test "$enable_winebuild_Fake_Dlls" -gt 1; then
		abort "Patchset winebuild-Fake_Dlls disabled, but ntdll-RtlCreateUserThread depends on that."
	fi
	enable_winebuild_Fake_Dlls=1
fi

if test "$enable_winebuild_Fake_Dlls" -eq 1; then
	if test "$enable_ntdll_User_Shared_Data" -gt 1; then
		abort "Patchset ntdll-User_Shared_Data disabled, but winebuild-Fake_Dlls depends on that."
	fi
	enable_ntdll_User_Shared_Data=1
fi

if test "$enable_ntdll_User_Shared_Data" -eq 1; then
	if test "$enable_ntdll_Hide_Wine_Exports" -gt 1; then
		abort "Patchset ntdll-Hide_Wine_Exports disabled, but ntdll-User_Shared_Data depends on that."
	fi
	enable_ntdll_Hide_Wine_Exports=1
fi

if test "$enable_ntdll_Hide_Wine_Exports" -eq 1; then
	if test "$enable_advapi32_Token_Integrity_Level" -gt 1; then
		abort "Patchset advapi32-Token_Integrity_Level disabled, but ntdll-Hide_Wine_Exports depends on that."
	fi
	if test "$enable_ntdll_ThreadTime" -gt 1; then
		abort "Patchset ntdll-ThreadTime disabled, but ntdll-Hide_Wine_Exports depends on that."
	fi
	enable_advapi32_Token_Integrity_Level=1
	enable_ntdll_ThreadTime=1
fi

if test "$enable_dxdiagn_GetChildContainer_Leaf_Nodes" -eq 1; then
	if test "$enable_dxdiagn_Enumerate_DirectSound" -gt 1; then
		abort "Patchset dxdiagn-Enumerate_DirectSound disabled, but dxdiagn-GetChildContainer_Leaf_Nodes depends on that."
	fi
	enable_dxdiagn_Enumerate_DirectSound=1
fi

if test "$enable_dsound_EAX" -eq 1; then
	if test "$enable_dsound_Fast_Mixer" -gt 1; then
		abort "Patchset dsound-Fast_Mixer disabled, but dsound-EAX depends on that."
	fi
	enable_dsound_Fast_Mixer=1
fi

if test "$enable_dinput_SetActionMap_genre" -eq 1; then
	if test "$enable_dinput_joy_mappings" -gt 1; then
		abort "Patchset dinput-joy-mappings disabled, but dinput-SetActionMap-genre depends on that."
	fi
	enable_dinput_joy_mappings=1
fi

if test "$enable_ddraw_version_check" -eq 1; then
	if test "$enable_ddraw_Device_Caps" -gt 1; then
		abort "Patchset ddraw-Device_Caps disabled, but ddraw-version-check depends on that."
	fi
	enable_ddraw_Device_Caps=1
fi

if test "$enable_ddraw_Texture_Wrong_Caps" -eq 1; then
	if test "$enable_ddraw_Rendering_Targets" -gt 1; then
		abort "Patchset ddraw-Rendering_Targets disabled, but ddraw-Texture_Wrong_Caps depends on that."
	fi
	enable_ddraw_Rendering_Targets=1
fi

if test "$enable_d3d11_Deferred_Context" -eq 1; then
	if test "$enable_nvapi_Stub_DLL" -gt 1; then
		abort "Patchset nvapi-Stub_DLL disabled, but d3d11-Deferred_Context depends on that."
	fi
	enable_nvapi_Stub_DLL=1
fi

if test "$enable_nvapi_Stub_DLL" -eq 1; then
	if test "$enable_nvcuda_CUDA_Support" -gt 1; then
		abort "Patchset nvcuda-CUDA_Support disabled, but nvapi-Stub_DLL depends on that."
	fi
	enable_nvcuda_CUDA_Support=1
fi

if test "$enable_advapi32_Token_Integrity_Level" -eq 1; then
	if test "$enable_Staging" -gt 1; then
		abort "Patchset Staging disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_advapi32_CreateRestrictedToken" -gt 1; then
		abort "Patchset advapi32-CreateRestrictedToken disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	enable_Staging=1
	enable_advapi32_CreateRestrictedToken=1
fi


# If autoupdate is enabled then create a tempfile to keep track of all patches
if test "$enable_patchlist" -eq 1; then
	if test "$enable_Staging" -eq 1; then
		# macOS 10.10 and prior do not allow mktemp with empty argument
		patchlist=$(mktemp 2>/dev/null || mktemp -t tmp)
		if test ! -f "$patchlist"; then
			abort "Unable to create temporary file for patchlist."
		fi
	else
		warning "Skipping generation of patchlist because 'Staging' patchset is disabled."
		enable_patchlist=0
	fi
fi


# Patchset Compiler_Warnings
# |
# | Modified files:
# |   *	dlls/d2d1/bitmap.c, dlls/d2d1/brush.c, dlls/d2d1/dc_render_target.c, dlls/d2d1/geometry.c,
# | 	dlls/d2d1/hwnd_render_target.c, dlls/d2d1/state_block.c, dlls/d3d11/view.c, dlls/d3d8/texture.c, dlls/d3d9/texture.c,
# | 	dlls/ddraw/viewport.c, dlls/dwrite/font.c, dlls/dwrite/layout.c, dlls/msxml3/schema.c, dlls/oleaut32/oleaut.c,
# | 	dlls/rpcrt4/cstub.c, dlls/vbscript/vbdisp.c, dlls/windowscodecs/info.c, dlls/wsdapi/msgparams.c, include/wine/list.h,
# | 	include/wine/rbtree.h, include/winnt.h
# |
if test "$enable_Compiler_Warnings" -eq 1; then
	patch_apply Compiler_Warnings/0001-windowscodecs-Avoid-implicit-cast-of-interface-point.patch
	patch_apply Compiler_Warnings/0021-d2d1-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0022-d3d11-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0023-d3d8-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0024-d3d9-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0025-ddraw-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0026-dwrite-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0027-msxml3-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0028-oleaut32-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0029-rpcrt4-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0030-vbscript-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0031-include-Check-element-type-in-CONTAINING_RECORD-and-.patch
	patch_apply Compiler_Warnings/0032-wsdapi-Avoid-implicit-cast-of-interface-pointer.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "windowscodecs: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d2d1: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3d11: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3d8: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3d9: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ddraw: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "dwrite: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "msxml3: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "rpcrt4: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "vbscript: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "include: Check element type in CONTAINING_RECORD and similar macros.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wsdapi: Avoid implicit cast of interface pointer.", 1 },';
	) >> "$patchlist"
fi

# Patchset Pipelight
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/user32/tests/msg.c, dlls/winex11.drv/init.c, dlls/winex11.drv/opengl.c,
# | 	dlls/winex11.drv/x11drv.h
# |
if test "$enable_Pipelight" -eq 1; then
	patch_apply Pipelight/0001-winex11-Implement-X11DRV_FLUSH_GDI_DISPLAY-ExtEscape-c.patch
	patch_apply Pipelight/0002-user32-Decrease-minimum-SetTimer-interval-to-5-ms.patch
	patch_apply Pipelight/0004-winex11.drv-Indicate-direct-rendering-through-OpenGL.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winex11: Implement X11DRV_FLUSH_GDI_DISPLAY ExtEscape command.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "user32: Decrease minimum SetTimer interval to 5 ms.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "winex11.drv: Indicate direct rendering through OpenGL extension.", 1 },';
	) >> "$patchlist"
fi

# Patchset Staging
# |
# | Modified files:
# |   *	dlls/kernel32/process.c, dlls/ntdll/misc.c, dlls/ntdll/ntdll.spec, include/wine/library.h, libs/wine/Makefile.in,
# | 	libs/wine/config.c, libs/wine/loader.c, libs/wine/wine.map, loader/main.c
# |
if test "$enable_Staging" -eq 1; then
	patch_apply Staging/0001-kernel32-Add-winediag-message-to-show-warning-that-t.patch
	patch_apply Staging/0002-winelib-Append-Staging-at-the-end-of-the-version-s.patch
	patch_apply Staging/0003-loader-Add-commandline-option-patches-to-show-the-pa.patch
	patch_apply Staging/0004-loader-Add-commandline-option-check-libs.patch
	patch_apply Staging/0005-loader-Print-library-paths-for-check-libs-on-Mac-OS-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32: Add winediag message to show warning, that this isn'\''t vanilla wine.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "winelib: Append '\''(Staging)'\'' at the end of the version string.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "loader: Add commandline option --patches to show the patch list.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "loader: Add commandline option --check-libs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "loader: Print library paths for --check-libs on Mac OS X.", 1 },';
	) >> "$patchlist"
fi

# Patchset activeds-ADsOpenObject
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40649] activeds: Implement ADsOpenObject.
# |
# | Modified files:
# |   *	dlls/activeds/Makefile.in, dlls/activeds/activeds_main.c, dlls/adsldp/Makefile.in, dlls/adsldp/adsldp.c,
# | 	dlls/adsldp/adsldp.idl, dlls/adsldp/adsldp.rgs, dlls/adsldp/rsrc.rc, dlls/adsldp/tests/Makefile.in,
# | 	dlls/adsldp/tests/ldap.c, dlls/adsldp/tests/sysinfo.c, include/Makefile.in, include/adserr.h, include/iads.idl
# |
if test "$enable_activeds_ADsOpenObject" -eq 1; then
	patch_apply activeds-ADsOpenObject/0001-include-Add-adserr.h.patch
	patch_apply activeds-ADsOpenObject/0002-activeds-Implement-ADsOpenObject.patch
	patch_apply activeds-ADsOpenObject/0003-adsldp-Add-LDAPNamespace-stubs.patch
	patch_apply activeds-ADsOpenObject/0004-adsldp-Add-IADsOpenDSObject-stubs.patch
	patch_apply activeds-ADsOpenObject/0005-adsldp-tests-Add-some-tests-for-LDAPNamespace.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "include: Add adserr.h.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "activeds: Implement ADsOpenObject.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "adsldp: Add LDAPNamespace stubs.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "adsldp: Add IADsOpenDSObject stubs.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "adsldp/tests: Add some tests for LDAPNamespace.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-CreateRestrictedToken
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25834] Implement advapi32.CreateRestrictedToken
# |
# | Modified files:
# |   *	dlls/kernelbase/security.c, dlls/ntdll/nt.c, dlls/ntdll/ntdll.spec, include/winnt.h, include/winternl.h,
# | 	server/process.c, server/protocol.def, server/security.h, server/token.c
# |
if test "$enable_advapi32_CreateRestrictedToken" -eq 1; then
	patch_apply advapi32-CreateRestrictedToken/0001-ntdll-Implement-NtFilterToken.patch
	patch_apply advapi32-CreateRestrictedToken/0002-advapi32-Implement-CreateRestrictedToken.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement NtFilterToken.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "advapi32: Implement CreateRestrictedToken.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-LsaLookupPrivilegeName
# |
# | Modified files:
# |   *	dlls/advapi32/lsa.c, dlls/advapi32/tests/lsa.c
# |
if test "$enable_advapi32_LsaLookupPrivilegeName" -eq 1; then
	patch_apply advapi32-LsaLookupPrivilegeName/0001-advapi32-Fix-error-code-when-calling-LsaOpenPolicy-f.patch
	patch_apply advapi32-LsaLookupPrivilegeName/0002-advapi32-Use-TRACE-for-LsaOpenPolicy-LsaClose.patch
	(
		printf '%s\n' '+    { "Michael Müller", "advapi32: Fix error code when calling LsaOpenPolicy for non existing remote machine.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "advapi32: Use TRACE for LsaOpenPolicy/LsaClose.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-LsaLookupSids
# |
# | Modified files:
# |   *	dlls/advapi32/lsa.c, dlls/advapi32/security.c, dlls/advapi32/tests/security.c
# |
if test "$enable_advapi32_LsaLookupSids" -eq 1; then
	patch_apply advapi32-LsaLookupSids/0002-advapi32-Prepend-a-hidden-LSA_TRUST_INFORMATION-in-L.patch
	patch_apply advapi32-LsaLookupSids/0003-advapi32-Prepend-a-hidden-LSA_TRUST_INFORMATION-in-L.patch
	patch_apply advapi32-LsaLookupSids/0004-advapi32-Fallback-to-Sid-string-when-LookupAccountSi.patch
	patch_apply advapi32-LsaLookupSids/0007-advapi32-Fix-name-and-use-of-DOMAIN_GROUP_RID_USERS.patch
	(
		printf '%s\n' '+    { "Qian Hong", "advapi32: Prepend a hidden LSA_TRUST_INFORMATION in LsaLookupSids to avoid crash when Domains[-1] incorrectly accessed by application.", 2 },';
		printf '%s\n' '+    { "Qian Hong", "advapi32: Prepend a hidden LSA_TRUST_INFORMATION in LsaLookupNames2 to avoid crash when Domains[-1] incorrectly accessed by application.", 2 },';
		printf '%s\n' '+    { "Qian Hong", "advapi32: Fallback to Sid string when LookupAccountSid fails.", 1 },';
		printf '%s\n' '+    { "Qian Hong", "advapi32: Fix name and use of DOMAIN_GROUP_RID_USERS.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-Token_Integrity_Level
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40613] Basic implementation for token integrity levels and UAC handling
# |   *	[#39262] Run explorer.exe as unevaluated process
# |
# | Modified files:
# |   *	configure.ac, dlls/advapi32/tests/Makefile.in, dlls/advapi32/tests/security.c, dlls/kernelbase/process.c,
# | 	dlls/ntdll/loader.c, dlls/ntdll/nt.c, dlls/ntdll/ntdll.spec, dlls/ntdll/ntdll_misc.h, dlls/ntdll/process.c,
# | 	dlls/shell32/shlexec.c, dlls/user32/win.c, programs/runas/Makefile.in, programs/runas/runas.c, programs/runas/runas.h,
# | 	programs/runas/runas.rc, server/process.c, server/process.h, server/protocol.def, server/request.c, server/security.h,
# | 	server/token.c
# |
if test "$enable_advapi32_Token_Integrity_Level" -eq 1; then
	patch_apply advapi32-Token_Integrity_Level/0001-advapi32-tests-Extend-security-label-token-integrity.patch
	patch_apply advapi32-Token_Integrity_Level/0002-server-Implement-token-elevation-information.patch
	patch_apply advapi32-Token_Integrity_Level/0003-server-Correctly-treat-zero-access-mask-in-duplicate.patch
	patch_apply advapi32-Token_Integrity_Level/0004-server-Implement-token-integrity-level.patch
	patch_apply advapi32-Token_Integrity_Level/0005-server-Use-all-group-attributes-in-create_token.patch
	patch_apply advapi32-Token_Integrity_Level/0006-ntdll-Add-function-to-create-new-tokens-for-elevatio.patch
	patch_apply advapi32-Token_Integrity_Level/0007-shell32-Implement-process-elevation-using-runas-verb.patch
	patch_apply advapi32-Token_Integrity_Level/0008-ntdll-Implement-process-token-elevation-through-mani.patch
	patch_apply advapi32-Token_Integrity_Level/0010-server-Implement-support-for-creating-processes-usin.patch
	patch_apply advapi32-Token_Integrity_Level/0012-user32-Start-explorer.exe-using-limited-rights.patch
	patch_apply advapi32-Token_Integrity_Level/0013-server-Correctly-assign-security-labels-for-tokens.patch
	patch_apply advapi32-Token_Integrity_Level/0014-programs-runas-Basic-implementation-for-starting-pro.patch
	patch_apply advapi32-Token_Integrity_Level/0015-ntdll-Add-semi-stub-for-TokenLinkedToken-info-class.patch
	(
		printf '%s\n' '+    { "Michael Müller", "advapi32/tests: Extend security label / token integrity tests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Implement token elevation information.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Correctly treat zero access mask in duplicate_token wineserver call.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Implement token integrity level.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Use all group attributes in create_token.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add function to create new tokens for elevation purposes.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Implement process elevation using runas verb.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement process token elevation through manifests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Implement support for creating processes using a token.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "user32: Start explorer.exe using limited rights.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Correctly assign security labels for tokens.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "programs/runas: Basic implementation for starting processes with a different trustlevel.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add semi-stub for TokenLinkedToken info class.", 1 },';
	) >> "$patchlist"
fi

# Patchset api-ms-win-Stub_DLLs
# |
# | Modified files:
# |   *	configure.ac, dlls/ext-ms-win-appmodel-usercontext-l1-1-0/Makefile.in, dlls/ext-ms-win-appmodel-usercontext-l1-1-0/ext-
# | 	ms-win-appmodel-usercontext-l1-1-0.spec, dlls/ext-ms-win-appmodel-usercontext-l1-1-0/main.c, dlls/ext-ms-win-xaml-
# | 	pal-l1-1-0/Makefile.in, dlls/ext-ms-win-xaml-pal-l1-1-0/ext-ms-win-xaml-pal-l1-1-0.spec, dlls/ext-ms-win-xaml-
# | 	pal-l1-1-0/main.c, dlls/iertutil/Makefile.in, dlls/iertutil/iertutil.spec, dlls/iertutil/main.c,
# | 	dlls/uiautomationcore/Makefile.in, dlls/uiautomationcore/uia_main.c
# |
if test "$enable_api_ms_win_Stub_DLLs" -eq 1; then
	patch_apply api-ms-win-Stub_DLLs/0006-iertutil-Add-dll-and-add-stub-for-ordinal-811.patch
	patch_apply api-ms-win-Stub_DLLs/0009-ext-ms-win-xaml-pal-l1-1-0-Add-dll-and-add-stub-for-.patch
	patch_apply api-ms-win-Stub_DLLs/0010-ext-ms-win-appmodel-usercontext-l1-1-0-Add-dll-and-a.patch
	patch_apply api-ms-win-Stub_DLLs/0012-ext-ms-win-xaml-pal-l1-1-0-Add-stub-for-GetThemeServ.patch
	patch_apply api-ms-win-Stub_DLLs/0027-uiautomationcore-Add-dll-and-stub-some-functions.patch
	(
		printf '%s\n' '+    { "Michael Müller", "iertutil: Add dll and add stub for ordinal 811.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-xaml-pal-l1-1-0: Add dll and add stub for XamlBehaviorEnabled.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-appmodel-usercontext-l1-1-0: Add dll and add stub for UserContextExtInitialize.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-xaml-pal-l1-1-0: Add stub for GetThemeServices.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "uiautomationcore: Add dll and stub some functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset atl-AtlAxDialogBox
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32749] atl: Implemented AtlAxDialogBox[A,W]
# |
# | Modified files:
# |   *	dlls/atl/atl_ax.c
# |
if test "$enable_atl_AtlAxDialogBox" -eq 1; then
	patch_apply atl-AtlAxDialogBox/0001-atl-Implement-AtlAxDialogBox-A-W.patch
	(
		printf '%s\n' '+    { "Qian Hong", "atl: Implement AtlAxDialogBox[A,W].", 1 },';
	) >> "$patchlist"
fi

# Patchset cmd-launch-association
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18154] cmd: Support for launching programs based on file association
# |
# | Modified files:
# |   *	programs/cmd/builtins.c, programs/cmd/tests/test_builtins.cmd, programs/cmd/tests/test_builtins.cmd.exp,
# | 	programs/cmd/wcmdmain.c
# |
if test "$enable_cmd_launch_association" -eq 1; then
	patch_apply cmd-launch-association/0001-cmd-Support-for-launching-programs-based-on-file-ass.patch
	patch_apply cmd-launch-association/0002-cmd-ftype-failed-to-clear-file-associations.patch
	(
		printf '%s\n' '+    { "Jason Edmeades", "cmd: Support for launching programs based on file association.", 1 },';
		printf '%s\n' '+    { "Jason Edmeades", "cmd: Ftype failed to clear file associations.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctl32-Listview_DrawItem
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38941] Preserve custom colors between subitems for listview control
# |
# | Modified files:
# |   *	dlls/comctl32/listview.c
# |
if test "$enable_comctl32_Listview_DrawItem" -eq 1; then
	patch_apply comctl32-Listview_DrawItem/0001-comctl32-Preserve-custom-colors-between-subitems.patch
	(
		printf '%s\n' '+    { "Michael Müller", "comctl32: Preserve custom colors between subitems.", 2 },';
	) >> "$patchlist"
fi

# Patchset comctl32-alpha-bitmaps
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47018] Paint 32-bpp bitmaps with an alpha channel using GdiAlphaBlend
# |
# | Modified files:
# |   *	dlls/comctl32/static.c
# |
if test "$enable_comctl32_alpha_bitmaps" -eq 1; then
	patch_apply comctl32-alpha-bitmaps/0001-comctl32-Switch-to-using-a-structure-for-extra-stora.patch
	patch_apply comctl32-alpha-bitmaps/0002-comctl32-Paint-32-bpp-bitmaps-with-an-alpha-channel-.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "comctl32: Switch to using a structure for extra storage.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "comctl32: Paint 32-bpp bitmaps with an alpha channel using GdiAlphaBlend.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctl32-version_6
# |
# | Modified files:
# |   *	dlls/comctl32/comctl32.h, dlls/comctl32/comctl32.rc, include/commctrl.h
# |
if test "$enable_comctl32_version_6" -eq 1; then
	patch_apply comctl32-version_6/0001-comctl32-Bump-version-to-6.0.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "comctl32: Bump version to 6.0.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctrl-rebar-capture
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#14750] comctl32: Fixed rebar behaviour when there's capture and no drag.
# |
# | Modified files:
# |   *	dlls/comctl32/rebar.c
# |
if test "$enable_comctrl_rebar_capture" -eq 1; then
	patch_apply comctrl-rebar-capture/0001-comctl32-Fixed-rebar-behaviour-when-there-s-capture-.patch
	(
		printf '%s\n' '+    { "Andrej Shadura", "comctl32: Fixed rebar behaviour when there'\''s capture and no drag.", 1 },';
	) >> "$patchlist"
fi

# Patchset comdlg32-lpstrFileTitle
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38400] Postpone setting lpstrFileTitle in GetSaveFileNameW
# |   *	[#35200] Postpone setting lpstrFileTitle in GetSaveFileNameA
# |
# | Modified files:
# |   *	dlls/comdlg32/filedlg.c
# |
if test "$enable_comdlg32_lpstrFileTitle" -eq 1; then
	patch_apply comdlg32-lpstrFileTitle/0001-comdlg32-Postpone-setting-ofn-lpstrFileTitle-to-work.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "comdlg32: Postpone setting ofn->lpstrFileTitle to work around an application bug.", 1 },';
	) >> "$patchlist"
fi

# Patchset configure-Absolute_RPATH
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26256] Support for setcap on wine-preloader
# |
# | Modified files:
# |   *	configure.ac
# |
if test "$enable_configure_Absolute_RPATH" -eq 1; then
	patch_apply configure-Absolute_RPATH/0001-configure-Also-add-the-absolute-RPATH-when-linking-a.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "configure: Also add the absolute RPATH when linking against libwine.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-CMS_Certificates
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34388] Skip unknown item when decoding a CMS certificate
# |
# | Modified files:
# |   *	dlls/crypt32/decode.c
# |
if test "$enable_crypt32_CMS_Certificates" -eq 1; then
	patch_apply crypt32-CMS_Certificates/0001-crypt32-Skip-unknown-item-when-decoding-a-CMS-certif.patch
	(
		printf '%s\n' '+    { "Charles Davis", "crypt32: Skip unknown item when decoding a CMS certificate.", 1 },';
	) >> "$patchlist"
fi

# Patchset cryptext-CryptExtOpenCER
# |
# | Modified files:
# |   *	configure, configure.ac, dlls/cryptext/Makefile.in, dlls/cryptext/cryptext.spec, dlls/cryptext/cryptext_main.c,
# | 	dlls/cryptext/tests/Makefile.in, dlls/cryptext/tests/cryptext.c
# |
if test "$enable_cryptext_CryptExtOpenCER" -eq 1; then
	patch_apply cryptext-CryptExtOpenCER/0001-cryptext-Implement-CryptExtOpenCER.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "cryptext: Implement CryptExtOpenCER.", 1 },';
	) >> "$patchlist"
fi

# Patchset d2d1-ID2D1Factory1
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44052] - Add ID2D1Bitmap1/ID2D1Factory1 support
# |
# | Modified files:
# |   *	dlls/d2d1/d2d1_private.h, dlls/d2d1/factory.c, dlls/d2d1/geometry.c
# |
if test "$enable_d2d1_ID2D1Factory1" -eq 1; then
	patch_apply d2d1-ID2D1Factory1/0001-d2d1-Use-ID2D1Factory2-in-d2d_geometry.patch
	(
		printf '%s\n' '+    { "Lucian Poston", "d2d1: Use ID2D1Factory2 in d2d_geometry.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvcuda-CUDA_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37664] MediaCoder needs CUDA for video encoding
# |
# | Modified files:
# |   *	configure.ac, dlls/nvcuda/Makefile.in, dlls/nvcuda/internal.c, dlls/nvcuda/nvcuda.c, dlls/nvcuda/nvcuda.h,
# | 	dlls/nvcuda/nvcuda.rc, dlls/nvcuda/nvcuda.spec, dlls/nvcuda/tests/Makefile.in, dlls/nvcuda/tests/nvcuda.c,
# | 	include/Makefile.in, include/cuda.h
# |
if test "$enable_nvcuda_CUDA_Support" -eq 1; then
	patch_apply nvcuda-CUDA_Support/0001-include-Add-cuda.h.h.patch
	patch_apply nvcuda-CUDA_Support/0002-nvcuda-Add-stub-dll.patch
	patch_apply nvcuda-CUDA_Support/0003-nvcuda-First-implementation.patch
	patch_apply nvcuda-CUDA_Support/0004-nvcuda-Implement-new-functions-added-in-CUDA-6.5.patch
	patch_apply nvcuda-CUDA_Support/0005-nvcuda-Properly-wrap-undocumented-ContextStorage-int.patch
	patch_apply nvcuda-CUDA_Support/0006-nvcuda-Emulate-two-d3d9-initialization-functions.patch
	patch_apply nvcuda-CUDA_Support/0007-nvcuda-Properly-wrap-stream-callbacks-by-forwarding-.patch
	patch_apply nvcuda-CUDA_Support/0008-nvcuda-Add-support-for-CUDA-7.0.patch
	patch_apply nvcuda-CUDA_Support/0009-nvcuda-Implement-cuModuleLoad-wrapper-function.patch
	patch_apply nvcuda-CUDA_Support/0010-nvcuda-Search-for-dylib-library-on-Mac-OS-X.patch
	patch_apply nvcuda-CUDA_Support/0011-nvcuda-Add-semi-stub-for-cuD3D10GetDevice.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "include: Add cuda.h.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Add stub dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: First implementation.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Implement new functions added in CUDA 6.5.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: Properly wrap undocumented '\''ContextStorage'\'' interface and add tests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: Emulate two d3d9 initialization functions.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Properly wrap stream callbacks by forwarding them to a worker thread.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Add support for CUDA 7.0.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Implement cuModuleLoad wrapper function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: Search for dylib library on Mac OS X.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: Add semi stub for cuD3D10GetDevice.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvapi-Stub_DLL
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35062] Fix graphical corruption in FarCry 3 with NVIDIA drivers
# |   *	[#43862] CS:GO fails to start when nvapi cannot be initialized
# |
# | Modified files:
# |   *	configure.ac, dlls/d3d11/device.c, dlls/nvapi/Makefile.in, dlls/nvapi/nvapi.c, dlls/nvapi/nvapi.spec,
# | 	dlls/nvapi/tests/Makefile.in, dlls/nvapi/tests/nvapi.c, dlls/nvapi64/Makefile.in, dlls/nvapi64/nvapi64.spec,
# | 	include/Makefile.in, include/nvapi.h, include/wine/wined3d.h
# |
if test "$enable_nvapi_Stub_DLL" -eq 1; then
	patch_apply nvapi-Stub_DLL/0001-nvapi-First-implementation.patch
	patch_apply nvapi-Stub_DLL/0002-nvapi-Add-stubs-for-NvAPI_EnumLogicalGPUs-and-undocu.patch
	patch_apply nvapi-Stub_DLL/0003-nvapi-Add-NvAPI_GetPhysicalGPUsFromLogicalGPU.patch
	patch_apply nvapi-Stub_DLL/0004-nvapi-Add-stub-for-NvAPI_EnumPhysicalGPUs.patch
	patch_apply nvapi-Stub_DLL/0005-nvapi-Add-stubs-for-NvAPI_GPU_GetFullName.patch
	patch_apply nvapi-Stub_DLL/0006-nvapi-Explicity-return-NULL-for-0x33c7358c-and-0x593.patch
	patch_apply nvapi-Stub_DLL/0007-nvapi-Add-stub-for-NvAPI_DISP_GetGDIPrimaryDisplayId.patch
	patch_apply nvapi-Stub_DLL/0008-nvapi-Add-stub-for-EnumNvidiaDisplayHandle.patch
	patch_apply nvapi-Stub_DLL/0009-nvapi-Add-stub-for-NvAPI_SYS_GetDriverAndBranchVersi.patch
	patch_apply nvapi-Stub_DLL/0010-nvapi-Add-stub-for-NvAPI_Unload.patch
	patch_apply nvapi-Stub_DLL/0011-nvapi-Add-stub-for-NvAPI_D3D_GetCurrentSLIState.patch
	patch_apply nvapi-Stub_DLL/0012-nvapi-tests-Use-structure-to-list-imports.patch
	patch_apply nvapi-Stub_DLL/0013-nvapi-Add-stub-for-NvAPI_GetLogicalGPUFromDisplay.patch
	patch_apply nvapi-Stub_DLL/0014-nvapi-Add-stub-for-NvAPI_D3D_GetObjectHandleForResou.patch
	patch_apply nvapi-Stub_DLL/0015-nvapi-Add-stub-for-NvAPI_D3D9_RegisterResource.patch
	patch_apply nvapi-Stub_DLL/0016-nvapi-Improve-NvAPI_D3D_GetCurrentSLIState.patch
	patch_apply nvapi-Stub_DLL/0017-nvapi-Implement-NvAPI_GPU_Get-Physical-Virtual-Frame.patch
	patch_apply nvapi-Stub_DLL/0018-nvapi-Add-stub-for-NvAPI_GPU_GetGpuCoreCount.patch
	patch_apply nvapi-Stub_DLL/0019-nvapi-Implement-NvAPI_D3D11_SetDepthBoundsTest.patch
	patch_apply nvapi-Stub_DLL/0020-nvapi-Implement-NvAPI_D3D11_CreateDevice-and-NvAPI_D.patch
	(
		printf '%s\n' '+    { "Michael Müller", "nvapi: First implementation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stubs for NvAPI_EnumLogicalGPUs and undocumented equivalent.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add NvAPI_GetPhysicalGPUsFromLogicalGPU.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_EnumPhysicalGPUs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stubs for NvAPI_GPU_GetFullName.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Explicity return NULL for 0x33c7358c and 0x593e8644.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_DISP_GetGDIPrimaryDisplayId.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for EnumNvidiaDisplayHandle.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_SYS_GetDriverAndBranchVersion.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_Unload.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D_GetCurrentSLIState.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi/tests: Use structure to list imports.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_GetLogicalGPUFromDisplay.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D_GetObjectHandleForResource.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D9_RegisterResource.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Improve NvAPI_D3D_GetCurrentSLIState.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Implement NvAPI_GPU_Get{Physical,Virtual}FrameBufferSize.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_GPU_GetGpuCoreCount.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Implement NvAPI_D3D11_SetDepthBoundsTest.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Implement NvAPI_D3D11_CreateDevice and NvAPI_D3D11_CreateDeviceAndSwapChain.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d11-Deferred_Context
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support, nvapi-Stub_DLL
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42191] Add semi-stub for D3D11 deferred context implementation
# |   *	[#43743] No 3D graphics in Wolcen: Lords of Mayhem
# |   *	[#44089] Correcly align the mapinfo buffer.
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/d3d11/tests/d3d11.c, dlls/wined3d/buffer.c, dlls/wined3d/resource.c, dlls/wined3d/texture.c,
# | 	dlls/wined3d/wined3d.spec, dlls/wined3d/wined3d_private.h, include/wine/wined3d.h
# |
if test "$enable_d3d11_Deferred_Context" -eq 1; then
	patch_apply d3d11-Deferred_Context/0001-d3d11-Add-stub-deferred-rendering-context.patch
	patch_apply d3d11-Deferred_Context/0002-wined3d-Add-wined3d_resource_map_info-function.patch
	patch_apply d3d11-Deferred_Context/0003-d3d11-Initial-implementation-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0004-d3d11-Implement-CSSetShader-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0005-d3d11-Implement-CSSetConstantBuffers-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0006-d3d11-Implement-Dispatch-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0007-d3d11-Implement-CSSetUnorderedAccessViews-for-deferr.patch
	patch_apply d3d11-Deferred_Context/0008-d3d11-Implement-ClearRenderTargetView-for-deferred-c.patch
	patch_apply d3d11-Deferred_Context/0009-d3d11-Implement-Draw-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0010-d3d11-Implement-ClearDepthStencilView-for-deferred-c.patch
	patch_apply d3d11-Deferred_Context/0011-d3d11-Implement-GSSetShader-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0012-d3d11-Implement-GSSetConstantBuffers-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0013-d3d11-Implement-CSSetShaderResources-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0014-d3d11-Implement-GSSetShaderResources-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0015-d3d11-Implement-HSSetShaderResources-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0016-d3d11-Implement-VSSetShaderResources-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0017-d3d11-Implement-CSSetSamplers-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0018-d3d11-Implement-GSSetSamplers-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0019-d3d11-Implement-HSSetSamplers-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0020-d3d11-Implement-VSSetSamplers-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0021-d3d11-Implement-Begin-and-End-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0022-d3d11-Implement-CopyResource-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0023-d3d11-Implement-SetResourceMinLOD-for-deferred-conte.patch
	patch_apply d3d11-Deferred_Context/0024-d3d11-Implement-CopySubresourceRegion-for-deferred-c.patch
	patch_apply d3d11-Deferred_Context/0025-d3d11-Implement-ResolveSubresource-for-deferred-cont.patch
	patch_apply d3d11-Deferred_Context/0026-d3d11-Implement-CopyStructureCount-for-deferred-cont.patch
	patch_apply d3d11-Deferred_Context/0027-d3d11-Implement-DrawAuto-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0028-d3d11-Implement-DrawInstanced-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0029-d3d11-Implement-DrawInstancedIndirect-for-deferred-c.patch
	patch_apply d3d11-Deferred_Context/0030-d3d11-Implement-DrawIndexedInstancedIndirect-for-def.patch
	patch_apply d3d11-Deferred_Context/0031-d3d11-Implement-ClearUnorderedAccessViewUint-for-def.patch
	patch_apply d3d11-Deferred_Context/0032-d3d11-Implement-ClearUnorderedAccessViewFloat-for-de.patch
	patch_apply d3d11-Deferred_Context/0033-d3d11-Implement-RsSetScissorRects-for-deferred-conte.patch
	patch_apply d3d11-Deferred_Context/0034-d3d11-Implement-OMSetRenderTargetsAndUnorderedAccess.patch
	patch_apply d3d11-Deferred_Context/0035-d3d11-Implement-SOSetTargets-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0036-d3d11-Implement-GenerateMips-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0037-d3d11-Implement-DispatchIndirect-for-deferred-contex.patch
	patch_apply d3d11-Deferred_Context/0038-d3d11-Implement-SetPredication-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0039-d3d11-Implement-d3d11_deferred_context_UpdateSubreso.patch
	patch_apply d3d11-Deferred_Context/0040-d3d11-Implement-restoring-of-state-after-executing-a.patch
	patch_apply d3d11-Deferred_Context/0041-d3d11-Allow-NULL-pointer-for-initial-count-in-d3d11_.patch
	patch_apply d3d11-Deferred_Context/0042-d3d11-Correctly-align-map-info-buffer.patch
	patch_apply d3d11-Deferred_Context/0043-d3d11-tests-Add-a-basic-test-for-drawing-with-deferr.patch
	(
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Add stub deferred rendering context.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add wined3d_resource_map_info function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Initial implementation for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement CSSetShader for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement CSSetConstantBuffers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement Dispatch for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement CSSetUnorderedAccessViews for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement ClearRenderTargetView for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement Draw for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement ClearDepthStencilView for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement GSSetShader for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement GSSetConstantBuffers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement CSSetShaderResources for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement GSSetShaderResources for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement HSSetShaderResources for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement VSSetShaderResources for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement CSSetSamplers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement GSSetSamplers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement HSSetSamplers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement VSSetSamplers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement Begin and End for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement CopyResource for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement SetResourceMinLOD for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement CopySubresourceRegion for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement ResolveSubresource for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement CopyStructureCount for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DrawAuto for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DrawInstanced for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DrawInstancedIndirect for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DrawIndexedInstancedIndirect for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement ClearUnorderedAccessViewUint for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement ClearUnorderedAccessViewFloat for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement RsSetScissorRects for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement OMSetRenderTargetsAndUnorderedAccessViews for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement SOSetTargets for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement GenerateMips for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DispatchIndirect for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement SetPredication for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement d3d11_deferred_context_UpdateSubresource.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement restoring of state after executing a command list.", 1 },';
		printf '%s\n' '+    { "Steve Melenchuk", "d3d11: Allow NULL pointer for initial count in d3d11_deferred_context_CSSetUnorderedAccessViews.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Correctly align map info buffer.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "d3d11/tests: Add a basic test for drawing with deferred context.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d9-Direct3DShaderValidatorCreate9
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46735] The Sims 2 demo needs Direct3DShaderValidatorCreate9() implementation
# |
# | Modified files:
# |   *	dlls/d3d9/d3d9_main.c
# |
if test "$enable_d3d9_Direct3DShaderValidatorCreate9" -eq 1; then
	patch_apply d3d9-Direct3DShaderValidatorCreate9/0001-d3d9-Return-a-stub-interface-from-Direct3DShaderVali.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "d3d9: Return a stub interface from Direct3DShaderValidatorCreate9().", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d9-Tests
# |
# | Modified files:
# |   *	dlls/d3d9/tests/device.c, dlls/d3d9/tests/visual.c
# |
if test "$enable_d3d9_Tests" -eq 1; then
	patch_apply d3d9-Tests/0001-d3d9-tests-Avoid-test-failures-on-specific-Nvidia-graphic-.patch
	patch_apply d3d9-Tests/0002-d3d9-tests-Avoid-crash-when-surface-and-texture-crea.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "d3d9/tests: Avoid test failures on specific Nvidia graphic cards.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3d9/tests: Avoid crash when surface and texture creation fails.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9-32bpp_Alpha_Channel
# |
# | Modified files:
# |   *	dlls/d3dx9_36/surface.c, dlls/d3dx9_36/tests/surface.c
# |
if test "$enable_d3dx9_32bpp_Alpha_Channel" -eq 1; then
	patch_apply d3dx9-32bpp_Alpha_Channel/0001-d3dx9-Return-D3DFMT_A8R8G8B8-in-D3DXGetImageInfoFrom.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9: Return D3DFMT_A8R8G8B8 in D3DXGetImageInfoFromFileInMemory for 32 bpp BMP with alpha.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-BumpLuminance
# |
# | Modified files:
# |   *	dlls/d3dx9_36/surface.c, dlls/d3dx9_36/util.c
# |
if test "$enable_d3dx9_36_BumpLuminance" -eq 1; then
	patch_apply d3dx9_36-BumpLuminance/0001-d3dx9_36-Recognize-bump-luminance-X8L8V8U8-when-load.patch
	patch_apply d3dx9_36-BumpLuminance/0002-d3dx9_36-Add-format-description-for-X8L8V8U8-for-for.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Recognize bump luminance X8L8V8U8 when loading dds file.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Add format description for X8L8V8U8 for format conversions.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-CloneEffect
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44635] Improve stub for ID3DXEffectImpl_CloneEffect
# |
# | Modified files:
# |   *	dlls/d3dx9_36/effect.c, dlls/d3dx9_36/tests/effect.c
# |
if test "$enable_d3dx9_36_CloneEffect" -eq 1; then
	patch_apply d3dx9_36-CloneEffect/0001-d3dx9_36-Improve-stub-for-ID3DXEffectImpl_CloneEffec.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "d3dx9_36: Improve stub for ID3DXEffectImpl_CloneEffect.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXCreateKeyframedAnimationSet
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45481] d3dx9_36: Implement D3DXCreateKeyframedAnimationSet
# |
# | Modified files:
# |   *	dlls/d3dx9_36/animation.c, dlls/d3dx9_36/tests/mesh.c
# |
if test "$enable_d3dx9_36_D3DXCreateKeyframedAnimationSet" -eq 1; then
	patch_apply d3dx9_36-D3DXCreateKeyframedAnimationSet/0001-d3dx9_36-Implement-D3DXCreateKeyframedAnimationSet.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9_36: Implement D3DXCreateKeyframedAnimationSet.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXDisassembleShader
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46649] Multiple applications need D3DXDisassembleShader() implementation (Tom Clancy's Rainbow Six: Vegas 2, The Void)
# |
# | Modified files:
# |   *	dlls/d3dx9_36/shader.c, dlls/d3dx9_36/tests/shader.c
# |
if test "$enable_d3dx9_36_D3DXDisassembleShader" -eq 1; then
	patch_apply d3dx9_36-D3DXDisassembleShader/0004-d3dx9_36-Implement-D3DXDisassembleShader.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0005-d3dx9_36-tests-Add-initial-tests-for-D3DXDisassemble.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0006-d3dx9_36-tests-Add-additional-tests-for-special-case.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Implement D3DXDisassembleShader.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3dx9_36/tests: Add initial tests for D3DXDisassembleShader.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36/tests: Add additional tests for special cases.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXOptimizeVertices
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47776] Timeshift needs D3DXOptimizeVertices()
# |
# | Modified files:
# |   *	dlls/d3dx9_24/d3dx9_24.spec, dlls/d3dx9_25/d3dx9_25.spec, dlls/d3dx9_26/d3dx9_26.spec, dlls/d3dx9_27/d3dx9_27.spec,
# | 	dlls/d3dx9_28/d3dx9_28.spec, dlls/d3dx9_29/d3dx9_29.spec, dlls/d3dx9_30/d3dx9_30.spec, dlls/d3dx9_31/d3dx9_31.spec,
# | 	dlls/d3dx9_32/d3dx9_32.spec, dlls/d3dx9_33/d3dx9_33.spec, dlls/d3dx9_34/d3dx9_34.spec, dlls/d3dx9_35/d3dx9_35.spec,
# | 	dlls/d3dx9_36/d3dx9_36.spec, dlls/d3dx9_36/mesh.c, dlls/d3dx9_36/tests/mesh.c, dlls/d3dx9_37/d3dx9_37.spec,
# | 	dlls/d3dx9_38/d3dx9_38.spec, dlls/d3dx9_39/d3dx9_39.spec, dlls/d3dx9_40/d3dx9_40.spec, dlls/d3dx9_41/d3dx9_41.spec,
# | 	dlls/d3dx9_42/d3dx9_42.spec, dlls/d3dx9_43/d3dx9_43.spec
# |
if test "$enable_d3dx9_36_D3DXOptimizeVertices" -eq 1; then
	patch_apply d3dx9_36-D3DXOptimizeVertices/0001-d3dx9_36-tests-Remove-useless-n-within-some-ok-messa.patch
	patch_apply d3dx9_36-D3DXOptimizeVertices/0002-d3dx9_36-Add-semi-stub-for-D3DXOptimizeVertices.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36/tests: Remove useless \\n within some ok messages.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Add semi-stub for D3DXOptimizeVertices.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXSHProjectCubeMap
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46284] Add D3DXSHProjectCubeMap stub
# |
# | Modified files:
# |   *	dlls/d3dx9_24/d3dx9_24.spec, dlls/d3dx9_25/d3dx9_25.spec, dlls/d3dx9_26/d3dx9_26.spec, dlls/d3dx9_27/d3dx9_27.spec,
# | 	dlls/d3dx9_28/d3dx9_28.spec, dlls/d3dx9_29/d3dx9_29.spec, dlls/d3dx9_30/d3dx9_30.spec, dlls/d3dx9_31/d3dx9_31.spec,
# | 	dlls/d3dx9_32/d3dx9_32.spec, dlls/d3dx9_33/d3dx9_33.spec, dlls/d3dx9_34/d3dx9_34.spec, dlls/d3dx9_35/d3dx9_35.spec,
# | 	dlls/d3dx9_36/math.c, dlls/d3dx9_37/d3dx9_37.spec, dlls/d3dx9_38/d3dx9_38.spec, dlls/d3dx9_39/d3dx9_39.spec,
# | 	dlls/d3dx9_40/d3dx9_40.spec, dlls/d3dx9_41/d3dx9_41.spec, dlls/d3dx9_42/d3dx9_42.spec, dlls/d3dx9_43/d3dx9_43.spec,
# | 	include/d3dx9math.h
# |
if test "$enable_d3dx9_36_D3DXSHProjectCubeMap" -eq 1; then
	patch_apply d3dx9_36-D3DXSHProjectCubeMap/0001-d3dx9_-Add-D3DXSHProjectCubeMap-stub.patch
	(
		printf '%s\n' '+    { "Andrey Gusev", "d3dx9_*: Add D3DXSHProjectCubeMap stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXStubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41697] Add stub for D3DXComputeTangent
# |
# | Modified files:
# |   *	dlls/d3dx9_24/d3dx9_24.spec, dlls/d3dx9_25/d3dx9_25.spec, dlls/d3dx9_26/d3dx9_26.spec, dlls/d3dx9_27/d3dx9_27.spec,
# | 	dlls/d3dx9_28/d3dx9_28.spec, dlls/d3dx9_29/d3dx9_29.spec, dlls/d3dx9_30/d3dx9_30.spec, dlls/d3dx9_31/d3dx9_31.spec,
# | 	dlls/d3dx9_32/d3dx9_32.spec, dlls/d3dx9_33/d3dx9_33.spec, dlls/d3dx9_34/d3dx9_34.spec, dlls/d3dx9_35/d3dx9_35.spec,
# | 	dlls/d3dx9_36/d3dx9_36.spec, dlls/d3dx9_36/mesh.c, dlls/d3dx9_37/d3dx9_37.spec, dlls/d3dx9_38/d3dx9_38.spec,
# | 	dlls/d3dx9_39/d3dx9_39.spec, dlls/d3dx9_40/d3dx9_40.spec, dlls/d3dx9_41/d3dx9_41.spec, dlls/d3dx9_42/d3dx9_42.spec,
# | 	dlls/d3dx9_43/d3dx9_43.spec
# |
if test "$enable_d3dx9_36_D3DXStubs" -eq 1; then
	patch_apply d3dx9_36-D3DXStubs/0003-d3dx9-Implement-D3DXComputeTangent.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9: Implement D3DXComputeTangent.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-DDS
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26898] Support for DDS file format in D3DXSaveTextureToFileInMemory
# |
# | Modified files:
# |   *	dlls/d3dx9_36/d3dx9_private.h, dlls/d3dx9_36/surface.c, dlls/d3dx9_36/texture.c
# |
if test "$enable_d3dx9_36_DDS" -eq 1; then
	patch_apply d3dx9_36-DDS/0001-d3dx9_36-Add-support-for-FOURCC-surface-to-save_dds_.patch
	patch_apply d3dx9_36-DDS/0002-d3dx9_36-Improve-D3DXSaveTextureToFile-to-save-simpl.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Add support for FOURCC surface to save_dds_surface_to_memory.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Improve D3DXSaveTextureToFile to save simple texture to dds file.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-DrawText
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24754] Support for ID3DXFont::DrawTextA/W
# |
# | Modified files:
# |   *	dlls/d3dx9_36/font.c, dlls/d3dx9_36/tests/core.c
# |
if test "$enable_d3dx9_36_DrawText" -eq 1; then
	patch_apply d3dx9_36-DrawText/0001-d3dx9_36-Implement-ID3DXFontImpl_DrawText.patch
	patch_apply d3dx9_36-DrawText/0002-d3dx9_36-Fix-horizontal-centering-in-ID3DXFont_DrawT.patch
	patch_apply d3dx9_36-DrawText/0003-d3dx9_36-Support-NULL-terminated-strings-in-ID3DXFon.patch
	patch_apply d3dx9_36-DrawText/0004-d3dx9_36-ID3DXFont_DrawText-calc_rect-can-be-null.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Implement ID3DXFontImpl_DrawText.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Fix horizontal centering in ID3DXFont_DrawText.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9_36: Support NULL terminated strings in ID3DXFont_DrawText.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9_36: ID3DXFont_DrawText calc_rect can be null.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Filter_Warnings
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33770] D3DCompileShader should filter specific warning messages
# |
# | Modified files:
# |   *	dlls/d3dx9_36/shader.c
# |
if test "$enable_d3dx9_36_Filter_Warnings" -eq 1; then
	patch_apply d3dx9_36-Filter_Warnings/0001-d3dx9_36-Filter-out-D3DCompile-warning-messages-that.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Filter out D3DCompile warning messages that are not present with D3DCompileShader.", 4 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Optimize_Inplace
# |
# | Modified files:
# |   *	dlls/d3dx9_36/mesh.c
# |
if test "$enable_d3dx9_36_Optimize_Inplace" -eq 1; then
	patch_apply d3dx9_36-Optimize_Inplace/0001-d3dx9_36-No-need-to-fail-if-we-don-t-support-vertice.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: No need to fail if we don'\''t support vertices reordering in D3DXMESHOPT_ATTRSORT.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-UpdateSkinnedMesh
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32572] Support for ID3DXSkinInfoImpl_UpdateSkinnedMesh
# |
# | Modified files:
# |   *	dlls/d3dx9_36/skin.c, dlls/d3dx9_36/tests/mesh.c
# |
if test "$enable_d3dx9_36_UpdateSkinnedMesh" -eq 1; then
	patch_apply d3dx9_36-UpdateSkinnedMesh/0001-d3dx9_36-Implement-ID3DXSkinInfoImpl_UpdateSkinnedMe.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Implement ID3DXSkinInfoImpl_UpdateSkinnedMesh.", 1 },';
	) >> "$patchlist"
fi

# Patchset dbghelp-Debug_Symbols
# |
# | Modified files:
# |   *	dlls/dbghelp/Makefile.in, dlls/dbghelp/elf_module.c
# |
if test "$enable_dbghelp_Debug_Symbols" -eq 1; then
	patch_apply dbghelp-Debug_Symbols/0001-dbghelp-Always-check-for-debug-symbols-in-BINDIR.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "dbghelp: Always check for debug symbols in BINDIR.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Device_Caps
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#27002] Properly initialize caps->dwZBufferBitDepths in ddraw7_GetCaps
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/tests/ddraw7.c
# |
if test "$enable_ddraw_Device_Caps" -eq 1; then
	patch_apply ddraw-Device_Caps/0001-ddraw-Don-t-set-HWTRANSFORMANDLIGHT-flag-on-d3d7-RGB.patch
	patch_apply ddraw-Device_Caps/0002-ddraw-Set-dwZBufferBitDepth-in-ddraw7_GetCaps.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Don'\''t set HWTRANSFORMANDLIGHT flag on d3d7 RGB device.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ddraw: Set dwZBufferBitDepth in ddraw7_GetCaps.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-EnumSurfaces
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17233] Implement DDENUMSURFACES_CANBECREATED in IDirectDraw7::EnumSurfaces
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/tests/d3d.c
# |
if test "$enable_ddraw_EnumSurfaces" -eq 1; then
	patch_apply ddraw-EnumSurfaces/0001-ddraw-tests-Add-more-tests-for-IDirectDraw7-EnumSurf.patch
	patch_apply ddraw-EnumSurfaces/0003-ddraw-Implement-DDENUMSURFACES_CANBECREATED-flag-in-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw/tests: Add more tests for IDirectDraw7::EnumSurfaces.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ddraw: Implement DDENUMSURFACES_CANBECREATED flag in ddraw7_EnumSurfaces.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-IDirect3DTexture2_Load
# |
# | Modified files:
# |   *	dlls/ddraw/surface.c, dlls/ddraw/tests/d3d.c, dlls/ddraw/tests/ddraw2.c
# |
if test "$enable_ddraw_IDirect3DTexture2_Load" -eq 1; then
	patch_apply ddraw-IDirect3DTexture2_Load/0001-ddraw-Allow-size-and-format-conversions-in-IDirect3D.patch
	patch_apply ddraw-IDirect3DTexture2_Load/0002-ddraw-tests-Add-more-tests-for-IDirect3DTexture2-Loa.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Allow size and format conversions in IDirect3DTexture2::Load.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ddraw/tests: Add more tests for IDirect3DTexture2::Load.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Rendering_Targets
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34906] Use video memory for rendering targets if possible
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/ddraw_private.h, dlls/ddraw/device.c, dlls/ddraw/surface.c
# |
if test "$enable_ddraw_Rendering_Targets" -eq 1; then
	patch_apply ddraw-Rendering_Targets/0001-ddraw-Create-rendering-targets-in-video-memory-if-po.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Create rendering targets in video memory if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/ddraw/executebuffer.c
# |
if test "$enable_ddraw_Silence_FIXMEs" -eq 1; then
	patch_apply ddraw-Silence_FIXMEs/0001-ddraw-Silence-noisy-FIXME-about-unimplemented-D3DPRO.patch
	(
		printf '%s\n' '+    { "Christian Costa", "ddraw: Silence noisy FIXME about unimplemented D3DPROCESSVERTICES_UPDATEEXTENTS.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Texture_Wrong_Caps
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ddraw-Rendering_Targets
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46948] Allow setting texture without DDSCAPS_TEXTURE for software device
# |
# | Modified files:
# |   *	dlls/ddraw/device.c, dlls/ddraw/tests/ddraw4.c
# |
if test "$enable_ddraw_Texture_Wrong_Caps" -eq 1; then
	patch_apply ddraw-Texture_Wrong_Caps/0001-ddraw-Allow-setting-texture-without-DDSCAPS_TEXTURE-.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "ddraw: Allow setting texture without DDSCAPS_TEXTURE for software device.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Write_Vtable
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39534] Make ddraw1 and ddraw_surface1 vtable as writable.
# |   *	[#46949] Make ddraw[2-7] and palette vtable as writable.
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/palette.c, dlls/ddraw/surface.c
# |
if test "$enable_ddraw_Write_Vtable" -eq 1; then
	patch_apply ddraw-Write_Vtable/0001-ddraw-Remove-const-from-ddraw1_vtbl-and-ddraw_surfac.patch
	patch_apply ddraw-Write_Vtable/0002-ddraw-Allow-writing-to-vtable-for-surface-and-palett.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Remove const from ddraw1_vtbl and ddraw_surface1_vtbl.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "ddraw: Allow writing to vtable for surface and palette.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-version-check
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ddraw-Device_Caps
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#19153] https://bugs.winehq.org/show_bug.cgi?id=19153
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c
# |
if test "$enable_ddraw_version_check" -eq 1; then
	patch_apply ddraw-version-check/0001-ddraw-Return-correct-devices-based-off-requested-Dir.patch
	(
		printf '%s\n' '+    { "Andrew D'\''Addesio", "ddraw: Return correct devices based off requested DirectX version.", 1 },';
	) >> "$patchlist"
fi

# Patchset dinput-joy-mappings
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34108] dinput: Improve support for user Joystick configuration.
# |
# | Modified files:
# |   *	dlls/dinput/config.c, dlls/dinput/device.c, dlls/dinput/device_private.h, dlls/dinput/dinput_main.c,
# | 	dlls/dinput/joystick.c, dlls/dinput/keyboard.c, dlls/dinput/mouse.c, dlls/dinput8/tests/device.c
# |
if test "$enable_dinput_joy_mappings" -eq 1; then
	patch_apply dinput-joy-mappings/0001-dinput-Load-users-Joystick-mappings.patch
	patch_apply dinput-joy-mappings/0002-dinput-Allow-empty-Joystick-mappings.patch
	patch_apply dinput-joy-mappings/0003-dinput-Support-username-in-Config-dialog.patch
	patch_apply dinput-joy-mappings/0004-dinput-Dont-allow-Fixed-actions-to-be-changed.patch
	(
		printf '%s\n' '+    { "Jetro Jormalainen", "dinput: Load users Joystick mappings.", 1 },';
		printf '%s\n' '+    { "Jetro Jormalainen", "dinput: Allow empty Joystick mappings.", 1 },';
		printf '%s\n' '+    { "Jetro Jormalainen", "dinput: Support username in Config dialog.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dinput: Dont allow Fixed actions to be changed.", 1 },';
	) >> "$patchlist"
fi

# Patchset dinput-SetActionMap-genre
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dinput-joy-mappings
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47326] dinput: Allow mapping of controls based of genre type.
# |
# | Modified files:
# |   *	dlls/dinput/device.c, dlls/dinput/dinput_main.c
# |
if test "$enable_dinput_SetActionMap_genre" -eq 1; then
	patch_apply dinput-SetActionMap-genre/0001-dinput-Allow-mapping-of-controls-based-of-Genre-type.patch
	patch_apply dinput-SetActionMap-genre/0002-dinput-Improved-tracing-of-Semantic-value.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dinput: Allow mapping of controls based of Genre type.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dinput: Improved tracing of Semantic value.", 1 },';
	) >> "$patchlist"
fi

# Patchset dinput-axis-recalc
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41317] dinput: Recalculated Axis after deadzone change.
# |
# | Modified files:
# |   *	dlls/dinput/joystick.c
# |
if test "$enable_dinput_axis_recalc" -eq 1; then
	patch_apply dinput-axis-recalc/0001-dinput-Recalculated-Axis-after-deadzone-change.patch
	(
		printf '%s\n' '+    { "Bruno Jesus", "dinput: Recalculated Axis after deadzone change.", 1 },';
	) >> "$patchlist"
fi

# Patchset dinput-reconnect-joystick
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34297] dinput: Allow reconnecting to disconnected joysticks
# |
# | Modified files:
# |   *	dlls/dinput/joystick_linuxinput.c
# |
if test "$enable_dinput_reconnect_joystick" -eq 1; then
	patch_apply dinput-reconnect-joystick/0001-dinput-Allow-reconnecting-to-disconnected-joysticks.patch
	(
		printf '%s\n' '+    { "Andrew Church", "dinput: Allow reconnecting to disconnected joysticks.", 1 },';
	) >> "$patchlist"
fi

# Patchset dinput-remap-joystick
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35815] dinput: Allow remapping of joystick buttons.
# |
# | Modified files:
# |   *	dlls/dinput/joystick.c, dlls/dinput/joystick_linux.c, dlls/dinput/joystick_linuxinput.c, dlls/dinput/joystick_osx.c,
# | 	dlls/dinput/joystick_private.h
# |
if test "$enable_dinput_remap_joystick" -eq 1; then
	patch_apply dinput-remap-joystick/0001-dinput-Allow-remapping-of-joystick-buttons.patch
	(
		printf '%s\n' '+    { "Andrew Church", "dinput: Allow remapping of joystick buttons.", 1 },';
	) >> "$patchlist"
fi

# Patchset directmanipulation-new-dll
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44865] directmanipulation: New DLL.
# |
# | Modified files:
# |   *	configure, configure.ac, dlls/directmanipulation/Makefile.in, dlls/directmanipulation/directmanip.idl,
# | 	dlls/directmanipulation/directmanipulation.c, dlls/directmanipulation/directmanipulation.spec,
# | 	dlls/directmanipulation/tests/Makefile.in, dlls/directmanipulation/tests/manipulation.c, dlls/uuid/uuid.c,
# | 	include/Makefile.in, include/directmanipulation.idl
# |
if test "$enable_directmanipulation_new_dll" -eq 1; then
	patch_apply directmanipulation-new-dll/0001-include-Add-directmanipulation.idl.patch
	patch_apply directmanipulation-new-dll/0002-directmanipulation-New-dll.patch
	patch_apply directmanipulation-new-dll/0003-uuid-Add-directmanipulation.h.patch
	patch_apply directmanipulation-new-dll/0004-directmanipulation-Create-DirectManipulationManager-.patch
	patch_apply directmanipulation-new-dll/0005-include-Add-DCompManipulationCompositor-coclass-and-.patch
	patch_apply directmanipulation-new-dll/0006-directmanipulation-Support-DCompManipulationComposit.patch
	patch_apply directmanipulation-new-dll/0007-directmanipulation-Supprot-IDirectManipulationFrameI.patch
	patch_apply directmanipulation-new-dll/0008-directmanipulation-Implement-IDirectManipulationMana.patch
	patch_apply directmanipulation-new-dll/0009-directmanipulation-Implement-IDirectManipulationComp.patch
	patch_apply directmanipulation-new-dll/0010-include-Add-IDirectManipulationViewport2-interface.patch
	patch_apply directmanipulation-new-dll/0011-directmanipulation-Implement-IDirectManipulationMana.patch
	patch_apply directmanipulation-new-dll/0012-directmanipulation-tests-Initial-tests.patch
	patch_apply directmanipulation-new-dll/0013-directmanipulation-Fake-success-from-IDirectManipula.patch
	patch_apply directmanipulation-new-dll/0014-include-Add-IDirectManipulationPrimaryContent-interf.patch
	patch_apply directmanipulation-new-dll/0015-directmanipulation-Implement-IDirectManipulationView.patch
	patch_apply directmanipulation-new-dll/0016-directmanipulation-Support-IDirectManipulationConten.patch
	patch_apply directmanipulation-new-dll/0017-directmanipulation-Fake-success-in-some-functions.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "include: Add directmanipulation.idl.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: New dll.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "uuid: Add directmanipulation.h.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Create DirectManipulationManager/DirectManipulationSharedManager objects.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "include: Add DCompManipulationCompositor coclass and supporting interfaces.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Support DCompManipulationCompositor interface.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Supprot IDirectManipulationFrameInfoProvider interface in IDirectManipulationCompositor.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Implement IDirectManipulationManager2 GetUpdateManager.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Implement IDirectManipulationCompositor SetUpdateManager.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "include: Add IDirectManipulationViewport2 interface.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Implement IDirectManipulationManager2 CreateViewport.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation/tests: Initial tests.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Fake success from IDirectManipulationViewport2 ActivateConfiguration.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "include: Add IDirectManipulationPrimaryContent interface.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Implement IDirectManipulationViewport2 GetPrimaryContent.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Support IDirectManipulationContent in IDirectManipulationPrimaryContent interface.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "directmanipulation: Fake success in some functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset dmime-PChannel-range
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17766] Empire Earth crashes on start without native directmusic
# |   *	[#24740] Trinklet Supreme crashes on startup
# |   *	[#31562] Stop crash when using lithtech game engine.
# |
# | Modified files:
# |   *	dlls/dmime/performance.c, dlls/dmime/tests/performance.c
# |
if test "$enable_dmime_PChannel_range" -eq 1; then
	patch_apply dmime-PChannel-range/0003-dmime-Implement-IDirectMusicPerformance8_PChannelInf.patch
	(
		printf '%s\n' '+    { "Michael Stefaniuc", "dmime: Implement IDirectMusicPerformance8_PChannelInfo().", 1 },';
	) >> "$patchlist"
fi

# Patchset dsdmo-new-dll
# |
# | Modified files:
# |   *	dlls/dsdmo/Makefile.in, dlls/dsdmo/chorus.c, dlls/dsdmo/compressor.c, dlls/dsdmo/distortion.c,
# | 	dlls/dsdmo/dsdmo_classes.idl, dlls/dsdmo/dsdmo_private.h, dlls/dsdmo/echo.c, dlls/dsdmo/flanger.c, dlls/dsdmo/gargle.c,
# | 	dlls/dsdmo/main.c, dlls/dsdmo/parameq.c, dlls/dsdmo/reverb.c, dlls/dsdmo/reverb2.c, dlls/dsound/buffer.c,
# | 	dlls/dsound/tests/dsound8.c
# |
if test "$enable_dsdmo_new_dll" -eq 1; then
	patch_apply dsdmo-new-dll/0002-dsdmo-Add-IDirectSoundFXEcho-support.patch
	patch_apply dsdmo-new-dll/0003-dsdmo-Add-IDirectSoundFXChorus-support.patch
	patch_apply dsdmo-new-dll/0004-dsdmo-Add-IDirectSoundFXCompressor-support.patch
	patch_apply dsdmo-new-dll/0005-dsdmo-Add-IDirectSoundFXDistortion-support.patch
	patch_apply dsdmo-new-dll/0006-dsdmo-Add-IDirectSoundFXFlanger-support.patch
	patch_apply dsdmo-new-dll/0007-dsdmo-Add-IDirectSoundFXGargle-support.patch
	patch_apply dsdmo-new-dll/0008-dsdmo-Add-IDirectSoundFXParamEq-support.patch
	patch_apply dsdmo-new-dll/0009-dsdmo-Add-IDirectSoundFXWavesReverb-support.patch
	patch_apply dsdmo-new-dll/0010-dsdmo-Add-IDirectSoundFXI3DL2Reverb-support.patch
	patch_apply dsdmo-new-dll/0011-dsdmo-Implement-IDirectSoundFXEcho-GetAllParameters.patch
	patch_apply dsdmo-new-dll/0012-dsdmo-Implement-IDirectSoundFXGargle-GetAllParameter.patch
	patch_apply dsdmo-new-dll/0013-dsdmo-Implemnet-IDirectSoundFXChorus-GetAllParameter.patch
	patch_apply dsdmo-new-dll/0014-dsdmo-Implemnet-IDirectSoundFXFlanger-GetAllParamete.patch
	patch_apply dsdmo-new-dll/0015-dsdmo-Implemnet-IDirectSoundFXDistortion-GetAllParam.patch
	patch_apply dsdmo-new-dll/0016-dsdmo-Implemnet-IDirectSoundFXCompressor-GetAllParam.patch
	patch_apply dsdmo-new-dll/0017-dsdmo-Implemnet-IDirectSoundFXParamEq-GetAllParamete.patch
	patch_apply dsdmo-new-dll/0018-dsdmo-Implemnet-IDirectSoundFXI3DL2Reverb-GetAllPara.patch
	patch_apply dsdmo-new-dll/0019-dsound-IDirectSoundBuffer8-GetObjectInPath-loops-for.patch
	patch_apply dsdmo-new-dll/0020-dsdmo-Implement-IDirectSoundFXEcho-SetAllParameters.patch
	patch_apply dsdmo-new-dll/0021-dsdmo-Implement-IDirectSoundFXGargle-SetAllParameter.patch
	patch_apply dsdmo-new-dll/0022-dsdmo-Implement-IDirectSoundFXChorus-SetAllParameter.patch
	patch_apply dsdmo-new-dll/0023-dsdmo-Implement-IDirectSoundFXFlanger-SetAllParamete.patch
	patch_apply dsdmo-new-dll/0024-dsdmo-Implement-IDirectSoundFXDistortion-SetAllParam.patch
	patch_apply dsdmo-new-dll/0025-dsdmo-Implement-IDirectSoundFXCompressor-SetAllParam.patch
	patch_apply dsdmo-new-dll/0026-dsdmo-Implement-IDirectSoundFXParamEq-SetAllParamete.patch
	patch_apply dsdmo-new-dll/0027-dsdmo-Implement-IDirectSoundFXI3DL2Reverb-SetAllPara.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXEcho support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXChorus support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXCompressor support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXDistortion support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXFlanger support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXGargle support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXParamEq support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXWavesReverb support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Add IDirectSoundFXI3DL2Reverb support.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXEcho GetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXGargle GetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implemnet IDirectSoundFXChorus GetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implemnet IDirectSoundFXFlanger GetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implemnet IDirectSoundFXDistortion GetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implemnet IDirectSoundFXCompressor GetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implemnet IDirectSoundFXParamEq GetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implemnet IDirectSoundFXI3DL2Reverb GetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsound: IDirectSoundBuffer8 GetObjectInPath loops for the requested interface.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXEcho SetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXGargle SetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXChorus SetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXFlanger SetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXDistortion SetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXCompressor SetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXParamEq SetAllParameters.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "dsdmo: Implement IDirectSoundFXI3DL2Reverb SetAllParameters.", 1 },';
	) >> "$patchlist"
fi

# Patchset dsound-Fast_Mixer
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30639] Audio stuttering and performance drops in multiple applications
# |
# | Modified files:
# |   *	dlls/dsound/dsound_main.c, dlls/dsound/dsound_private.h, dlls/dsound/mixer.c
# |
if test "$enable_dsound_Fast_Mixer" -eq 1; then
	patch_apply dsound-Fast_Mixer/0001-dsound-Add-a-linear-resampler-for-use-with-a-large-n.patch
	(
		printf '%s\n' '+    { "Alexander E. Patrakov", "dsound: Add a linear resampler for use with a large number of mixing buffers.", 2 },';
	) >> "$patchlist"
fi

# Patchset dsound-EAX
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dsound-Fast_Mixer
# |
# | Modified files:
# |   *	dlls/dsound/Makefile.in, dlls/dsound/buffer.c, dlls/dsound/dsound.c, dlls/dsound/dsound_eax.h,
# | 	dlls/dsound/dsound_main.c, dlls/dsound/dsound_private.h, dlls/dsound/eax.c, dlls/dsound/mixer.c
# |
if test "$enable_dsound_EAX" -eq 1; then
	patch_apply dsound-EAX/0001-dsound-Apply-filters-before-sound-is-multiplied-to-s.patch
	patch_apply dsound-EAX/0002-dsound-Add-EAX-v1-constants-and-structs.patch
	patch_apply dsound-EAX/0003-dsound-Report-that-we-support-EAX-v1.patch
	patch_apply dsound-EAX/0004-dsound-Add-EAX-propset-stubs.patch
	patch_apply dsound-EAX/0005-dsound-Add-EAX-presets.patch
	patch_apply dsound-EAX/0006-dsound-Support-getting-and-setting-EAX-properties.patch
	patch_apply dsound-EAX/0007-dsound-Support-getting-and-setting-EAX-buffer-proper.patch
	patch_apply dsound-EAX/0008-dsound-Add-EAX-init-and-free-stubs.patch
	patch_apply dsound-EAX/0009-dsound-Feed-data-through-EAX-function.patch
	patch_apply dsound-EAX/0010-dsound-Allocate-EAX-delay-lines.patch
	patch_apply dsound-EAX/0011-dsound-Add-EAX-VerbPass-stub.patch
	patch_apply dsound-EAX/0012-dsound-Implement-EAX-lowpass-filter.patch
	patch_apply dsound-EAX/0013-dsound-Add-delay-line-EAX-functions.patch
	patch_apply dsound-EAX/0014-dsound-Implement-EAX-early-reflections.patch
	patch_apply dsound-EAX/0015-dsound-Implement-EAX-decorrelator.patch
	patch_apply dsound-EAX/0016-dsound-Implement-EAX-late-reverb.patch
	patch_apply dsound-EAX/0017-dsound-Implement-EAX-late-all-pass-filter.patch
	patch_apply dsound-EAX/0018-dsound-Various-improvements-to-EAX-support.patch
	patch_apply dsound-EAX/0019-dsound-Allow-disabling-of-EAX-support-in-the-registr.patch
	patch_apply dsound-EAX/0020-dsound-Add-stub-support-for-DSPROPSETID_EAX20_Listen.patch
	patch_apply dsound-EAX/0021-dsound-Add-stub-support-for-DSPROPSETID_EAX20_Buffer.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "dsound: Apply filters before sound is multiplied to speakers.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX v1 constants and structs.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Report that we support EAX.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX propset stubs.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX presets.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Support getting and setting EAX properties.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Support getting and setting EAX buffer properties.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX init and free stubs.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Feed data through EAX function.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Allocate EAX delay lines.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX VerbPass stub.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX lowpass filter.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add delay line EAX functions.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX early reflections.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX decorrelator.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX late reverb.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX late all-pass filter.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "dsound: Various improvements to EAX support.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "dsound: Allow disabling of EAX support in the registry.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "dsound: Add stub support for DSPROPSETID_EAX20_ListenerProperties.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "dsound: Add stub support for DSPROPSETID_EAX20_BufferProperties.", 1 },';
	) >> "$patchlist"
fi

# Patchset dsound-SRW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#48408] dsound: Use an SRW lock for buffer_list_lock.
# |
# | Modified files:
# |   *	dlls/dsound/buffer.c, dlls/dsound/dsound.c, dlls/dsound/dsound_private.h, dlls/dsound/mixer.c, dlls/dsound/primary.c
# |
if test "$enable_dsound_SRW" -eq 1; then
	patch_apply dsound-SRW/0001-dsound-Use-an-SRW-lock-for-buffer_list_lock.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "dsound: Use an SRW lock for buffer_list_lock.", 1 },';
	) >> "$patchlist"
fi

# Patchset dwmapi-DwmGetTransportAttributes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#31350] T-Online Mediencenter Assistent (.NET 3.5 WPF app) installer fails ('dwmapi.dll' stubs insufficient in
# | 	Vista/Win7 mode)
# |
# | Modified files:
# |   *	configure, configure.ac, dlls/dwmapi/tests/Makefile.in, dlls/dwmapi/tests/dwmapi.c
# |
if test "$enable_dwmapi_DwmGetTransportAttributes" -eq 1; then
	patch_apply dwmapi-DwmGetTransportAttributes/0002-dwmapi-add-initial-tests.patch
	(
		printf '%s\n' '+    { "Louis Lenders", "dwmapi: Add initial tests.", 1 },';
	) >> "$patchlist"
fi

# Patchset dwrite-FontFallback
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44052] - Support for font fallback.
# |
# | Modified files:
# |   *	dlls/dwrite/analyzer.c, dlls/dwrite/layout.c, dlls/dwrite/tests/layout.c
# |
if test "$enable_dwrite_FontFallback" -eq 1; then
	patch_apply dwrite-FontFallback/0001-dwrite-Test-IDWriteTextFormat-with-nonexistent-font.patch
	patch_apply dwrite-FontFallback/0002-dwrite-Test-GetMetrics-with-custom-fontcollection.patch
	patch_apply dwrite-FontFallback/0004-dwrite-Use-font-fallback-when-mapping-characters.patch
	patch_apply dwrite-FontFallback/0005-dwrite-Use-MapCharacters-for-non-visual-characters.patch
	patch_apply dwrite-FontFallback/0006-dwrite-Use-MapCharacters-for-dummy-line-metrics.patch
	(
		printf '%s\n' '+    { "Lucian Poston", "dwrite: Test IDWriteTextFormat with nonexistent font.", 1 },';
		printf '%s\n' '+    { "Lucian Poston", "dwrite: Test GetMetrics with custom fontcollection.", 1 },';
		printf '%s\n' '+    { "Lucian Poston", "dwrite: Use font fallback when mapping characters.", 1 },';
		printf '%s\n' '+    { "Lucian Poston", "dwrite: Use MapCharacters for non-visual characters.", 1 },';
		printf '%s\n' '+    { "Lucian Poston", "dwrite: Use MapCharacters for dummy line metrics.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiagn-Enumerate_DirectSound
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32613] Implement enumeration of sound devices and basic properties to dxdiagn
# |
# | Modified files:
# |   *	dlls/dxdiagn/Makefile.in, dlls/dxdiagn/provider.c, dlls/dxdiagn/tests/container.c
# |
if test "$enable_dxdiagn_Enumerate_DirectSound" -eq 1; then
	patch_apply dxdiagn-Enumerate_DirectSound/0001-dxdiagn-Enumerate-DirectSound-devices-and-add-some-b.patch
	(
		printf '%s\n' '+    { "Michael Müller", "dxdiagn: Enumerate DirectSound devices and add some basic properties.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiagn-GetChildContainer_Leaf_Nodes
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dxdiagn-Enumerate_DirectSound
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38014] Implement special handling for calling GetChildContainer with an empty string
# |
# | Modified files:
# |   *	dlls/dxdiagn/container.c, dlls/dxdiagn/tests/container.c
# |
if test "$enable_dxdiagn_GetChildContainer_Leaf_Nodes" -eq 1; then
	patch_apply dxdiagn-GetChildContainer_Leaf_Nodes/0001-dxdiagn-Calling-GetChildContainer-with-an-empty-stri.patch
	(
		printf '%s\n' '+    { "Michael Müller", "dxdiagn: Calling GetChildContainer with an empty string on a leaf container returns the object itself.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxva2-Video_Decoder
# |
# | Modified files:
# |   *	configure.ac, dlls/dxva2/Makefile.in, dlls/dxva2/backend.idl, dlls/dxva2/devicemanager.c, dlls/dxva2/dxva2_private.h,
# | 	dlls/dxva2/genericdecoder.c, dlls/dxva2/main.c, dlls/dxva2/softwareprocessor.c, dlls/dxva2/tests/Makefile.in,
# | 	dlls/dxva2/tests/dxva2.c, dlls/dxva2/vaapi-h264.c, dlls/dxva2/vaapi-mpeg2.c, dlls/dxva2/vaapi.c,
# | 	dlls/dxva2/videoservices.c, include/dxva2api.idl
# |
if test "$enable_dxva2_Video_Decoder" -eq 1; then
	patch_apply dxva2-Video_Decoder/0001-dxva2-Implement-semi-stub-for-Direct3DDeviceManager9.patch
	patch_apply dxva2-Video_Decoder/0002-dxva2-Implement-stubbed-interfaces-for-IDirectXVideo.patch
	patch_apply dxva2-Video_Decoder/0004-dxva2-Implement-stubbed-DirectX-Software-VideoProces.patch
	patch_apply dxva2-Video_Decoder/0006-dxva2-tests-Add-tests-for-dxva2-decoder.patch
	patch_apply dxva2-Video_Decoder/0007-dxva2-Initial-implementation-of-MPEG2-decoder-using-.patch
	patch_apply dxva2-Video_Decoder/0008-dxva2-Implement-h264-decoder.patch
	patch_apply dxva2-Video_Decoder/0009-dxva2-Add-DRM-mode-for-vaapi.patch
	patch_apply dxva2-Video_Decoder/0010-dxva2-Fill-h264-luma-and-chroma-weights-offsets-with.patch
	patch_apply dxva2-Video_Decoder/0011-dxva2-Always-destroy-buffers-when-calling-vaRenderPi.patch
	patch_apply dxva2-Video_Decoder/0012-dxva2-Only-declare-debug-channels-when-they-are-actu.patch
	patch_apply dxva2-Video_Decoder/0013-Revert-dxva2-Build-with-msvcrt.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "dxva2: Implement semi-stub for Direct3DDeviceManager9 interface.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Implement stubbed interfaces for IDirectXVideo{Acceleration,Decoder,Processor}Service.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Implement stubbed DirectX Software VideoProcessor interface.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2/tests: Add tests for dxva2 decoder.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Initial implementation of MPEG2 decoder using vaapi backend.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Implement h264 decoder.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Add DRM mode for vaapi.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Fill h264 luma and chroma weights / offsets with default values in case they are not specified.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Always destroy buffers when calling vaRenderPicture.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Only declare debug channels when they are actually used.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "Revert \"dxva2: Build with msvcrt.\".", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-K32GetPerformanceInfo
# |
# | Modified files:
# |   *	dlls/kernel32/cpu.c, server/process.c, server/protocol.def
# |
if test "$enable_kernel32_K32GetPerformanceInfo" -eq 1; then
	patch_apply kernel32-K32GetPerformanceInfo/0001-kernel32-Make-K32GetPerformanceInfo-faster.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Make K32GetPerformanceInfo faster.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Junction_Points
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12401] Support for Junction Points
# |
# | Modified files:
# |   *	configure.ac, dlls/kernel32/path.c, dlls/kernel32/tests/path.c, dlls/kernel32/volume.c, dlls/msvcp120/tests/msvcp120.c,
# | 	dlls/msvcp140/tests/msvcp140.c, dlls/ntdll/directory.c, dlls/ntdll/file.c, dlls/ntdll/tests/file.c, include/Makefile.in,
# | 	include/ntifs.h, include/wine/port.h, include/winternl.h, libs/port/Makefile.in, libs/port/renameat2.c, server/fd.c
# |
if test "$enable_ntdll_Junction_Points" -eq 1; then
	patch_apply ntdll-Junction_Points/0001-ntdll-Add-support-for-junction-point-creation.patch
	patch_apply ntdll-Junction_Points/0002-ntdll-Add-support-for-reading-junction-points.patch
	patch_apply ntdll-Junction_Points/0003-ntdll-Add-support-for-deleting-junction-points.patch
	patch_apply ntdll-Junction_Points/0004-ntdll-Add-a-test-for-junction-point-advertisement.patch
	patch_apply ntdll-Junction_Points/0005-kernel32-ntdll-Add-support-for-deleting-junction-poi.patch
	patch_apply ntdll-Junction_Points/0006-kernel32-Advertise-junction-point-support.patch
	patch_apply ntdll-Junction_Points/0007-ntdll-Add-support-for-absolute-symlink-creation.patch
	patch_apply ntdll-Junction_Points/0008-ntdll-Add-support-for-reading-absolute-symlinks.patch
	patch_apply ntdll-Junction_Points/0009-ntdll-Add-support-for-deleting-symlinks.patch
	patch_apply ntdll-Junction_Points/0010-ntdll-Add-support-for-relative-symlink-creation.patch
	patch_apply ntdll-Junction_Points/0011-ntdll-Add-support-for-reading-relative-symlinks.patch
	patch_apply ntdll-Junction_Points/0012-ntdll-Add-support-for-file-symlinks.patch
	patch_apply ntdll-Junction_Points/0013-ntdll-Allow-creation-of-dangling-reparse-points-to-n.patch
	patch_apply ntdll-Junction_Points/0014-ntdll-Correctly-report-file-symbolic-links-as-files.patch
	patch_apply ntdll-Junction_Points/0015-kernel32-Set-error-code-when-attempting-to-delete-fi.patch
	patch_apply ntdll-Junction_Points/0016-server-Properly-handle-file-symlink-deletion.patch
	patch_apply ntdll-Junction_Points/0017-ntdll-Always-report-symbolic-links-as-containing-zer.patch
	patch_apply ntdll-Junction_Points/0018-ntdll-Find-dangling-symlinks-quickly.patch
	patch_apply ntdll-Junction_Points/0019-kernel32-Implement-CreateSymbolicLink-A-W-with-ntdll.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for junction point creation.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for reading junction points.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for deleting junction points.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add a test for junction point advertisement.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32,ntdll: Add support for deleting junction points with RemoveDirectory.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32: Advertise junction point support.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for absolute symlink creation.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for reading absolute symlinks.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for deleting symlinks.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for relative symlink creation.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for reading relative symlinks.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for file symlinks.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Allow creation of dangling reparse points to non-existent paths.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Correctly report file symbolic links as files.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32: Set error code when attempting to delete file symlinks as directories.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Properly handle file symlink deletion.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Always report symbolic links as containing zero bytes.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Find dangling symlinks quickly.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32: Implement CreateSymbolicLink[A|W] with ntdll reparse points.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ThreadTime
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#20230] Return correct values for GetThreadTimes function
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/process.c, dlls/ntdll/thread.c, server/protocol.def,
# | 	server/snapshot.c, server/thread.c, server/thread.h
# |
if test "$enable_ntdll_ThreadTime" -eq 1; then
	patch_apply ntdll-ThreadTime/0001-ntdll-Return-correct-values-in-GetThreadTimes-for-al.patch
	patch_apply ntdll-ThreadTime/0002-ntdll-Set-correct-thread-creation-time-for-SystemPro.patch
	patch_apply ntdll-ThreadTime/0003-ntdll-Fill-process-kernel-and-user-time.patch
	patch_apply ntdll-ThreadTime/0004-ntdll-Set-process-start-time.patch
	patch_apply ntdll-ThreadTime/0005-ntdll-Fill-out-thread-times-in-process-enumeration.patch
	patch_apply ntdll-ThreadTime/0006-ntdll-Fill-process-virtual-memory-counters-in-NtQuer.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Return correct values in GetThreadTimes() for all threads.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Set correct thread creation time for SystemProcessInformation in NtQuerySystemInformation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fill process kernel and user time.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Set process start time.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fill out thread times in process enumeration.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fill process virtual memory counters in NtQuerySystemInformation.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Hide_Wine_Exports
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38656] Add support for hiding wine version information from applications
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c, dlls/ntdll/ntdll_misc.h
# |
if test "$enable_ntdll_Hide_Wine_Exports" -eq 1; then
	patch_apply ntdll-Hide_Wine_Exports/0001-ntdll-Add-support-for-hiding-wine-version-informatio.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add support for hiding wine version information from applications.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-User_Shared_Data
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime, ntdll-Hide_Wine_Exports
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29168] Update user shared data at realtime
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c, dlls/ntdll/ntdll.spec, dlls/ntdll/ntdll_misc.h, dlls/ntdll/tests/time.c, dlls/ntdll/thread.c,
# | 	dlls/ntdll/virtual.c, dlls/ntoskrnl.exe/instr.c
# |
if test "$enable_ntdll_User_Shared_Data" -eq 1; then
	patch_apply ntdll-User_Shared_Data/0001-ntdll-Move-code-to-update-user-shared-data-into-a-se.patch
	patch_apply ntdll-User_Shared_Data/0002-ntoskrnl-Update-USER_SHARED_DATA-before-accessing-me.patch
	patch_apply ntdll-User_Shared_Data/0003-ntdll-Create-thread-to-update-user_shared_data-time-.patch
	patch_apply ntdll-User_Shared_Data/0004-ntdll-tests-Test-updating-TickCount-in-user_shared_d.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Move code to update user shared data into a separate function.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntoskrnl: Update USER_SHARED_DATA before accessing memory.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Create thread to update user_shared_data time values when necessary.", 1 },';
		printf '%s\n' '+    { "Andrew Wesie", "ntdll/tests: Test updating TickCount in user_shared_data.", 1 },';
	) >> "$patchlist"
fi

# Patchset winebuild-Fake_Dlls
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime, ntdll-Hide_Wine_Exports,
# | 	ntdll-User_Shared_Data
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21232] Chromium-based browser engines (Chrome, Opera, Comodo Dragon, SRWare Iron) crash on startup unless '--no-
# | 	sandbox' is used (native API sandboxing/hooking scheme incompatible with Wine)
# |   *	[#42741] StarCraft I: 1.18 PTR fails to initialize ClientSdk.dll
# |   *	[#45349] Multiple applications and games crash due to missing support for 64-bit syscall thunks (StreetFighter V)
# |
# | Modified files:
# |   *	dlls/dbghelp/cpu_i386.c, dlls/kernel32/tests/loader.c, dlls/krnl386.exe16/kernel.c,
# | 	dlls/krnl386.exe16/kernel16_private.h, dlls/krnl386.exe16/ne_module.c, dlls/krnl386.exe16/ne_segment.c,
# | 	dlls/krnl386.exe16/task.c, dlls/krnl386.exe16/thunk.c, dlls/krnl386.exe16/wowthunk.c, dlls/ntdll/actctx.c,
# | 	dlls/ntdll/directory.c, dlls/ntdll/loader.c, dlls/ntdll/locale.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/path.c,
# | 	dlls/ntdll/process.c, dlls/ntdll/signal_i386.c, dlls/ntdll/signal_x86_64.c, dlls/ntdll/tests/exception.c,
# | 	dlls/ntdll/thread.c, dlls/system.drv16/system.c, dlls/toolhelp.dll16/toolhelp.c, dlls/user.exe16/message.c,
# | 	dlls/user.exe16/user.c, dlls/user.exe16/window.c, include/winternl.h, libs/wine/loader.c, tools/winebuild/build.h,
# | 	tools/winebuild/import.c, tools/winebuild/parser.c, tools/winebuild/relay.c, tools/winebuild/res32.c,
# | 	tools/winebuild/spec16.c, tools/winebuild/spec32.c, tools/winebuild/utils.c
# |
if test "$enable_winebuild_Fake_Dlls" -eq 1; then
	patch_apply winebuild-Fake_Dlls/0001-kernel32-tests-Add-basic-tests-for-fake-dlls.patch
	patch_apply winebuild-Fake_Dlls/0002-krnl386.exe16-Do-not-abuse-WOW32Reserved-field-for-1.patch
	patch_apply winebuild-Fake_Dlls/0003-winebuild-Generate-syscall-thunks-for-ntdll-exports.patch
	patch_apply winebuild-Fake_Dlls/0004-winebuild-Use-multipass-label-system-to-generate-fak.patch
	patch_apply winebuild-Fake_Dlls/0005-winebuild-Add-stub-functions-in-fake-dlls.patch
	patch_apply winebuild-Fake_Dlls/0006-winebuild-Add-syscall-thunks-in-fake-dlls.patch
	patch_apply winebuild-Fake_Dlls/0007-winebuild-Fix-size-of-relocation-information-in-fake.patch
	patch_apply winebuild-Fake_Dlls/0008-winebuild-Try-to-make-sure-RVA-matches-between-fake-.patch
	patch_apply winebuild-Fake_Dlls/0009-libs-wine-Use-same-file-alignment-for-fake-and-built.patch
	patch_apply winebuild-Fake_Dlls/0010-tools-winebuild-Add-syscall-thunks-for-64-bit.patch
	patch_apply winebuild-Fake_Dlls/0011-ntdll-Call-NtOpenFile-through-syscall-thunk.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32/tests: Add basic tests for fake dlls.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "krnl386.exe16: Do not abuse WOW32Reserved field for 16-bit stack address.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Generate syscall thunks for ntdll exports.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Use multipass label system to generate fake dlls.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Add stub functions in fake dlls.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Add syscall thunks in fake dlls.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Fix size of relocation information in fake dlls.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Try to make sure RVA matches between fake and builtin DLLs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "libs/wine: Use same file alignment for fake and builtin DLLs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "tools/winebuild: Add syscall thunks for 64 bit.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Call NtOpenFile through syscall thunk.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlCreateUserThread
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime, ntdll-Hide_Wine_Exports,
# | 	ntdll-User_Shared_Data, winebuild-Fake_Dlls
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45571] League of Legends 8.12+ fails to start a game (anticheat engine, hooking of NtCreateThread/Ex)
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/thread.c, include/winternl.h
# |
if test "$enable_ntdll_RtlCreateUserThread" -eq 1; then
	patch_apply ntdll-RtlCreateUserThread/0001-ntdll-Refactor-RtlCreateUserThread-into-NtCreateThre.patch
	(
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: Refactor RtlCreateUserThread into NtCreateThreadEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Exception
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44819] Throw second DBG_PRINTEXCEPTION_C when debugging.
# |
# | Modified files:
# |   *	dlls/kernelbase/debug.c, dlls/ntdll/tests/exception.c
# |
if test "$enable_ntdll_Exception" -eq 1; then
	patch_apply ntdll-Exception/0002-ntdll-OutputDebugString-should-throw-the-exception-a.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: OutputDebugString should throw the exception a second time, if a debugger is attached.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemRoot_Symlink
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Exception
# |
# | Modified files:
# |   *	dlls/ntdll/om.c
# |
if test "$enable_ntdll_SystemRoot_Symlink" -eq 1; then
	patch_apply ntdll-SystemRoot_Symlink/0001-ntdll-Add-special-handling-for-SystemRoot-to-satisfy.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add special handling for \\SystemRoot to satisfy MSYS2 case-insensitive system check.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Realtime_Priority
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-ThreadTime
# |
# | Modified files:
# |   *	server/Makefile.in, server/main.c, server/scheduler.c, server/thread.c, server/thread.h
# |
if test "$enable_server_Realtime_Priority" -eq 1; then
	patch_apply server-Realtime_Priority/0001-wineserver-Draft-to-implement-priority-levels-throug.patch
	(
		printf '%s\n' '+    { "Joakim Hernberg", "wineserver: Draft to implement priority levels through POSIX scheduling policies on linux.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Threading
# |
# | Modified files:
# |   *	dlls/ntdll/thread.c
# |
if test "$enable_ntdll_Threading" -eq 1; then
	patch_apply ntdll-Threading/0001-ntdll-Fix-race-condition-when-threads-are-killed-dur.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Fix race-condition when threads are killed during shutdown.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Wait_User_APC
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#14697] Do not allow interruption of system APC in server_select
# |
# | Modified files:
# |   *	dlls/kernel32/tests/sync.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/server.c, dlls/ntdll/sync.c
# |
if test "$enable_ntdll_Wait_User_APC" -eq 1; then
	patch_apply ntdll-Wait_User_APC/0001-ntdll-Block-signals-while-executing-system-APCs.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Block signals while executing system APCs.", 2 },';
	) >> "$patchlist"
fi

# Patchset server-Key_State
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#31899] Implement locking and synchronization of key states
# |   *	[#35907] Fix caps lock state issues with multiple processes
# |
# | Modified files:
# |   *	server/queue.c
# |
if test "$enable_server_Key_State" -eq 1; then
	patch_apply server-Key_State/0001-server-Introduce-a-helper-function-to-update-the-thr.patch
	patch_apply server-Key_State/0002-server-Implement-locking-and-synchronization-of-keys.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Introduce a helper function to update the thread_input key state.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Implement locking and synchronization of keystate buffer.", 3 },';
	) >> "$patchlist"
fi

# Patchset server-PeekMessage
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28884] GetMessage should remove already seen messages with higher priority
# |
# | Modified files:
# |   *	dlls/user32/tests/msg.c, server/queue.c
# |
if test "$enable_server_PeekMessage" -eq 1; then
	patch_apply server-PeekMessage/0001-server-Fix-handling-of-GetMessage-after-previous-Pee.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Fix handling of GetMessage after previous PeekMessage call.", 3 },';
	) >> "$patchlist"
fi

# Patchset server-Signal_Thread
# |
# | Modified files:
# |   *	server/thread.c, server/thread.h
# |
if test "$enable_server_Signal_Thread" -eq 1; then
	patch_apply server-Signal_Thread/0001-server-Do-not-signal-thread-until-it-is-really-gone.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Do not signal violently terminated threads until they are really gone.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Shared_Memory
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Threading, ntdll-Wait_User_APC, server-Key_State, server-PeekMessage, server-Signal_Thread
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll_misc.h, dlls/ntdll/server.c, dlls/ntdll/thread.c, dlls/ntdll/virtual.c, dlls/user32/focus.c,
# | 	dlls/user32/input.c, dlls/user32/message.c, dlls/user32/user_private.h, include/wine/server.h, include/winternl.h,
# | 	server/fd.c, server/file.h, server/main.c, server/mapping.c, server/protocol.def, server/queue.c, server/thread.c,
# | 	server/thread.h
# |
if test "$enable_server_Shared_Memory" -eq 1; then
	patch_apply server-Shared_Memory/0001-ntdll-Implement-virtual_map_shared_memory.patch
	patch_apply server-Shared_Memory/0002-server-Implement-support-for-global-and-local-shared.patch
	patch_apply server-Shared_Memory/0003-user32-Get-rid-of-wineserver-call-for-GetInputState.patch
	patch_apply server-Shared_Memory/0004-user32-Avoid-unnecessary-wineserver-calls-in-PeekMes.patch
	patch_apply server-Shared_Memory/0005-user32-Get-rid-of-wineserver-call-for-GetLastInputIn.patch
	patch_apply server-Shared_Memory/0006-ntdll-Only-enable-wineserver-shared-memory-communica.patch
	patch_apply server-Shared_Memory/0007-server-Store-a-list-of-associated-queues-for-each-th.patch
	patch_apply server-Shared_Memory/0008-user32-Get-rid-of-wineserver-call-for-GetActiveWindo.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Implement virtual_map_shared_memory.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Implement support for global and local shared memory blocks based on memfd.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Get rid of wineserver call for GetInputState.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Avoid unnecessary wineserver calls in PeekMessage/GetMessage.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "user32: Get rid of wineserver call for GetLastInputInfo.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Only enable wineserver shared memory communication when a special environment variable is set.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Store a list of associated queues for each thread input.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Get rid of wineserver call for GetActiveWindow, GetFocus, GetCapture.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-WSACleanup
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18670] Properly close sockets when WSACleanup is called
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/server.c, dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, include/wine/server.h,
# | 	server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_WSACleanup" -eq 1; then
	patch_apply ws2_32-WSACleanup/0001-ws2_32-Proper-WSACleanup-implementation-using-winese.patch
	patch_apply ws2_32-WSACleanup/0002-ws2_32-Invalidate-client-side-file-descriptor-cache-.patch
	(
		printf '%s\n' '+    { "Matt Durgavich", "ws2_32: Proper WSACleanup implementation using wineserver function.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Invalidate client-side file descriptor cache in WSACleanup.", 1 },';
	) >> "$patchlist"
fi

# Patchset eventfd_synchronization
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, kernel32-K32GetPerformanceInfo, ntdll-
# | 	Junction_Points, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-User_Shared_Data, winebuild-Fake_Dlls, ntdll-
# | 	RtlCreateUserThread, ntdll-Exception, ntdll-SystemRoot_Symlink, server-Realtime_Priority, ntdll-Threading, ntdll-
# | 	Wait_User_APC, server-Key_State, server-PeekMessage, server-Signal_Thread, server-Shared_Memory, ws2_32-WSACleanup
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36692] Many multi-threaded applications have poor performance due to heavy use of synchronization primitives
# |
# | Modified files:
# |   *	README.esync, configure.ac, dlls/kernel32/tests/sync.c, dlls/ntdll/Makefile.in, dlls/ntdll/critsection.c,
# | 	dlls/ntdll/esync.c, dlls/ntdll/esync.h, dlls/ntdll/loader.c, dlls/ntdll/ntdll.spec, dlls/ntdll/ntdll_misc.h,
# | 	dlls/ntdll/om.c, dlls/ntdll/server.c, dlls/ntdll/sync.c, dlls/ntdll/thread.c, dlls/rpcrt4/rpc_server.c,
# | 	dlls/user32/hook.c, dlls/wineandroid.drv/window.c, dlls/winemac.drv/macdrv_main.c, dlls/winex11.drv/x11drv_main.c,
# | 	server/Makefile.in, server/async.c, server/atom.c, server/change.c, server/clipboard.c, server/completion.c,
# | 	server/console.c, server/debugger.c, server/device.c, server/directory.c, server/esync.c, server/esync.h,
# | 	server/event.c, server/fd.c, server/file.c, server/file.h, server/handle.c, server/hook.c, server/mailslot.c,
# | 	server/main.c, server/mapping.c, server/mutex.c, server/named_pipe.c, server/object.h, server/process.c,
# | 	server/process.h, server/protocol.def, server/queue.c, server/registry.c, server/request.c, server/semaphore.c,
# | 	server/serial.c, server/signal.c, server/snapshot.c, server/sock.c, server/symlink.c, server/thread.c, server/thread.h,
# | 	server/timer.c, server/token.c, server/winstation.c
# |
if test "$enable_eventfd_synchronization" -eq 1; then
	patch_apply eventfd_synchronization/0001-configure-Check-for-sys-eventfd.h-ppoll-and-shm_open.patch
	patch_apply eventfd_synchronization/0002-server-Create-server-objects-for-eventfd-based-synch.patch
	patch_apply eventfd_synchronization/0003-ntdll-Create-eventfd-based-objects-for-semaphores.patch
	patch_apply eventfd_synchronization/0004-ntdll-Store-esync-objects-locally.patch
	patch_apply eventfd_synchronization/0005-ntdll-Implement-NtReleaseSemaphore.patch
	patch_apply eventfd_synchronization/0006-ntdll-Close-esync-objects.patch
	patch_apply eventfd_synchronization/0007-ntdll-Implement-waiting-on-esync-objects.patch
	patch_apply eventfd_synchronization/0008-ntdll-Create-esync-objects-for-events.patch
	patch_apply eventfd_synchronization/0009-ntdll-Implement-NtSetEvent.patch
	patch_apply eventfd_synchronization/0010-ntdll-Implement-NtResetEvent.patch
	patch_apply eventfd_synchronization/0011-ntdll-Implement-NtPulseEvent.patch
	patch_apply eventfd_synchronization/0012-ntdll-Implement-waiting-on-events.patch
	patch_apply eventfd_synchronization/0013-server-Add-an-object-operation-to-grab-the-esync-fil.patch
	patch_apply eventfd_synchronization/0014-server-Add-a-request-to-get-the-eventfd-file-descrip.patch
	patch_apply eventfd_synchronization/0015-server-Create-eventfd-file-descriptors-for-process-o.patch
	patch_apply eventfd_synchronization/0016-ntdll-server-Implement-waiting-on-server-bound-objec.patch
	patch_apply eventfd_synchronization/0017-server-Create-eventfd-file-descriptors-for-event-obj.patch
	patch_apply eventfd_synchronization/0018-server-Allow-re-setting-esync-events-on-the-server-s.patch
	patch_apply eventfd_synchronization/0019-ntdll-Try-again-if-poll-returns-EINTR.patch
	patch_apply eventfd_synchronization/0020-server-Create-eventfd-file-descriptors-for-thread-ob.patch
	patch_apply eventfd_synchronization/0021-rpcrt4-Avoid-closing-the-server-thread-handle-while-.patch
	patch_apply eventfd_synchronization/0022-server-Create-eventfd-file-descriptors-for-message-q.patch
	patch_apply eventfd_synchronization/0023-ntdll-wineandroid.drv-winemac.drv-winex11.drv-Store-.patch
	patch_apply eventfd_synchronization/0024-server-ntdll-Also-wait-on-the-queue-fd-when-waiting-.patch
	patch_apply eventfd_synchronization/0025-server-Create-eventfd-descriptors-for-device-manager.patch
	patch_apply eventfd_synchronization/0026-ntdll-Create-esync-objects-for-mutexes.patch
	patch_apply eventfd_synchronization/0027-ntdll-Implement-NtReleaseMutant.patch
	patch_apply eventfd_synchronization/0028-ntdll-Implement-waiting-on-mutexes.patch
	patch_apply eventfd_synchronization/0029-ntdll-Implement-wait-all.patch
	patch_apply eventfd_synchronization/0030-esync-Add-a-README.patch
	patch_apply eventfd_synchronization/0031-ntdll-Implement-NtSignalAndWaitForSingleObject.patch
	patch_apply eventfd_synchronization/0032-server-ntdll-Also-store-the-esync-type-in-the-server.patch
	patch_apply eventfd_synchronization/0033-ntdll-server-Implement-NtOpenSemaphore.patch
	patch_apply eventfd_synchronization/0034-ntdll-Implement-NtOpenEvent.patch
	patch_apply eventfd_synchronization/0035-ntdll-Implement-NtOpenMutant.patch
	patch_apply eventfd_synchronization/0036-ntdll-Record-the-current-count-of-a-semaphore-locall.patch
	patch_apply eventfd_synchronization/0037-server-Implement-esync_map_access.patch
	patch_apply eventfd_synchronization/0038-server-Alter-conditions-in-is_queue_hung.patch
	patch_apply eventfd_synchronization/0039-ntdll-server-Allow-DuplicateHandle-to-succeed-by-imp.patch
	patch_apply eventfd_synchronization/0040-server-Create-eventfd-descriptors-for-timers.patch
	patch_apply eventfd_synchronization/0041-server-Allocate-shared-memory-segments-for-semaphore.patch
	patch_apply eventfd_synchronization/0042-ntdll-Use-shared-memory-segments-to-store-semaphore-.patch
	patch_apply eventfd_synchronization/0043-ntdll-Lock-creating-and-opening-objects-with-volatil.patch
	patch_apply eventfd_synchronization/0044-server-ntdll-Pass-the-shared-memory-index-back-from-.patch
	patch_apply eventfd_synchronization/0045-server-ntdll-Implement-alertable-waits.patch
	patch_apply eventfd_synchronization/0046-esync-Update-README.patch
	patch_apply eventfd_synchronization/0047-kernel32-tests-Mark-some-existing-tests-as-failing-u.patch
	patch_apply eventfd_synchronization/0048-kernel32-tests-Add-some-semaphore-tests.patch
	patch_apply eventfd_synchronization/0049-kernel32-tests-Add-some-event-tests.patch
	patch_apply eventfd_synchronization/0050-kernel32-tests-Add-some-mutex-tests.patch
	patch_apply eventfd_synchronization/0051-kernel32-tests-Add-some-tests-for-wait-timeouts.patch
	patch_apply eventfd_synchronization/0052-ntdll-Go-through-the-server-if-necessary-when-perfor.patch
	patch_apply eventfd_synchronization/0053-server-Create-eventfd-descriptors-for-console_input_.patch
	patch_apply eventfd_synchronization/0054-server-Alter-conditions-in-is_queue_hung-again.patch
	patch_apply eventfd_synchronization/0055-ntdll-Let-the-server-know-when-we-are-doing-a-messag.patch
	patch_apply eventfd_synchronization/0056-ntdll-Avoid-server_select-when-waiting-for-critical-.patch
	patch_apply eventfd_synchronization/0057-user32-Remove-hooks-that-time-out.patch
	patch_apply eventfd_synchronization/0058-server-Don-t-check-for-a-hung-queue-when-sending-low.patch
	patch_apply eventfd_synchronization/0059-kernel32-tests-Zigzag-test.patch
	patch_apply eventfd_synchronization/0060-server-Try-to-remove-a-pre-xisting-shm-file.patch
	patch_apply eventfd_synchronization/0061-ntdll-Implement-NtQuerySemaphore.patch
	patch_apply eventfd_synchronization/0062-ntdll-Implement-NtQueryEvent.patch
	patch_apply eventfd_synchronization/0063-ntdll-Implement-NtQueryMutant.patch
	patch_apply eventfd_synchronization/0064-server-Create-eventfd-descriptors-for-pseudo-fd-obje.patch
	patch_apply eventfd_synchronization/0065-ntdll-Cache-the-esync-struct-itself-instead-of-a-poi.patch
	patch_apply eventfd_synchronization/0066-esync-Update-README.patch
	patch_apply eventfd_synchronization/0067-esync-Add-note-about-file-limits-not-being-raised-wh.patch
	patch_apply eventfd_synchronization/0068-ntdll-Ignore-pseudo-handles.patch
	patch_apply eventfd_synchronization/0069-ntdll-Try-to-avoid-poll-for-uncontended-objects.patch
	patch_apply eventfd_synchronization/0070-ntdll-Store-an-event-s-signaled-state-internally.patch
	patch_apply eventfd_synchronization/0071-ntdll-Fix-growing-the-shm_addrs-array.patch
	patch_apply eventfd_synchronization/0072-server-Update-the-shared-memory-state-when-re-settin.patch
	patch_apply eventfd_synchronization/0073-ntdll-Fix-a-missing-break-statement.patch
	patch_apply eventfd_synchronization/0074-ntdll-server-Abort-if-esync-is-enabled-for-the-serve.patch
	patch_apply eventfd_synchronization/0075-esync-Update-README.patch
	patch_apply eventfd_synchronization/0076-ntdll-Correctly-allocate-the-esync-handle-cache.patch
	patch_apply eventfd_synchronization/0077-ntdll-server-Specify-EFD_SEMAPHORE-on-the-server-sid.patch
	patch_apply eventfd_synchronization/0078-ntdll-server-Initialize-the-shared-memory-portion-on.patch
	patch_apply eventfd_synchronization/0079-ntdll-server-Revert-to-old-implementation-of-hung-qu.patch
	patch_apply eventfd_synchronization/0080-ntdll-Fix-a-couple-of-misplaced-global-variables.patch
	patch_apply eventfd_synchronization/0081-ntdll-Yield-during-PulseEvent.patch
	patch_apply eventfd_synchronization/0082-ntdll-server-Check-the-value-of-WINEESYNC-instead-of.patch
	patch_apply eventfd_synchronization/0083-esync-Update-README.patch
	patch_apply eventfd_synchronization/0084-server-Use-default_fd_get_esync_fd-for-directory-cha.patch
	patch_apply eventfd_synchronization/0085-server-Only-signal-the-APC-fd-for-user-APCs.patch
	patch_apply eventfd_synchronization/0086-ntdll-Check-the-APC-fd-first.patch
	patch_apply eventfd_synchronization/0087-ntdll-esync-Lock-accessing-the-shm_addrs-array.patch
	patch_apply eventfd_synchronization/0088-ntdll-Get-rid-of-the-per-event-spinlock-for-auto-res.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "configure: Check for sys/eventfd.h, ppoll(), and shm_open().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create server objects for eventfd-based synchronization objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Create eventfd-based objects for semaphores.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Store esync objects locally.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtReleaseSemaphore().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Close esync objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement waiting on esync objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Create esync objects for events.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtSetEvent().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtResetEvent().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtPulseEvent().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement waiting on events.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Add an object operation to grab the esync file descriptor.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Add a request to get the eventfd file descriptor associated with a waitable handle.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create eventfd file descriptors for process objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, server: Implement waiting on server-bound objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create eventfd file descriptors for event objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Allow (re)setting esync events on the server side.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Try again if poll() returns EINTR.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create eventfd file descriptors for thread objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "rpcrt4: Avoid closing the server thread handle while it is being waited on.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create eventfd file descriptors for message queues.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, wineandroid.drv, winemac.drv, winex11.drv: Store the thread'\''s queue fd in ntdll.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server, ntdll: Also wait on the queue fd when waiting for driver events.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create eventfd descriptors for device manager objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Create esync objects for mutexes.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtReleaseMutant().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement waiting on mutexes.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement wait-all.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "esync: Add a README.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtSignalAndWaitForSingleObject().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server, ntdll: Also store the esync type in the server.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, server: Implement NtOpenSemaphore().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtOpenEvent().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtOpenMutant().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Record the current count of a semaphore locally.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Implement esync_map_access().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Alter conditions in is_queue_hung().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, server: Allow DuplicateHandle() to succeed by implementing esync_get_esync_fd().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create eventfd descriptors for timers.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Allocate shared memory segments for semaphores and mutexes.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Use shared memory segments to store semaphore and mutex state.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Lock creating and opening objects with volatile state.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server, ntdll: Pass the shared memory index back from get_esync_fd.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server, ntdll: Implement alertable waits.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "esync: Update README.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "kernel32/tests: Mark some existing tests as failing under esync.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "kernel32/tests: Add some semaphore tests.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "kernel32/tests: Add some event tests.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "kernel32/tests: Add some mutex tests.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "kernel32/tests: Add some tests for wait timeouts.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Go through the server if necessary when performing event/semaphore/mutex ops.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create eventfd descriptors for console_input_events objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Alter conditions in is_queue_hung(), again.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Let the server know when we are doing a message wait.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Avoid server_select() when waiting for critical sections.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "user32: Remove hooks that time out.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Don'\''t check for a hung queue when sending low-level hooks.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "kernel32/tests: Zigzag test.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "=?UTF-8?q?server:=20Try=20to=20remove=20a=20pre?= =?UTF-8?q?=C3=ABxisting=20shm=20file.?=.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtQuerySemaphore().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtQueryEvent().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Implement NtQueryMutant().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create eventfd descriptors for pseudo-fd objects and use them for named pipes.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Cache the esync struct itself instead of a pointer to it.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "esync: Update README.", 1 },';
		printf '%s\n' '+    { "Mathieu Comandon", "esync: Add note about file limits not being raised when using systemd.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Ignore pseudo-handles.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Try to avoid poll() for uncontended objects.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Store an event'\''s signaled state internally.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Fix growing the shm_addrs array.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Update the shared memory state when (re)setting an event.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Fix a missing break statement.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, server: Abort if esync is enabled for the server but not the client, and vice versa.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "esync: Update README.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Correctly allocate the esync handle cache.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, server: Specify EFD_SEMAPHORE on the server side.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, server: Initialize the shared memory portion on the server side.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, server: Revert to old implementation of hung queue detection.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Fix a couple of misplaced global variables.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Yield during PulseEvent().", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll, server: Check the value of WINEESYNC instead of just the presence.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "esync: Update README.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Create esync file descriptors for true file objects and use them for directory change notifications.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "server: Only signal the APC fd for user APCs.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Check the APC fd first.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll/esync: Lock accessing the shm_addrs array.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Get rid of the per-event spinlock for auto-reset events.", 1 },';
	) >> "$patchlist"
fi

# Patchset explorer-Video_Registry_Key
# |
# | Modified files:
# |   *	dlls/advapi32/tests/registry.c, programs/explorer/desktop.c
# |
if test "$enable_explorer_Video_Registry_Key" -eq 1; then
	patch_apply explorer-Video_Registry_Key/0001-explorer-Create-CurrentControlSet-Control-Video-regi.patch
	(
		printf '%s\n' '+    { "Michael Müller", "explorer: Create CurrentControlSet\\Control\\Video registry key as non-volatile.", 1 },';
	) >> "$patchlist"
fi

# Patchset fonts-Missing_Fonts
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32323] Implement an Arial replacement font
# |   *	[#32342] Implement a Times New Roman replacement font
# |   *	[#20456] Implement a Courier New replacement font
# |   *	[#13829] Implement a Microsoft Yahei replacement font
# |
# | Modified files:
# |   *	COPYING.arial, COPYING.cour, COPYING.msyh, COPYING.times, LICENSE, fonts/Makefile.in, fonts/arial.sfd, fonts/arial.ttf,
# | 	fonts/cour.sfd, fonts/cour.ttf, fonts/msyh.sfd, fonts/msyh.ttf, fonts/times.sfd, fonts/times.ttf
# |
if test "$enable_fonts_Missing_Fonts" -eq 1; then
	patch_apply fonts-Missing_Fonts/0001-fonts-Add-Liberation-Sans-as-an-Arial-replacement.patch
	patch_apply fonts-Missing_Fonts/0002-fonts-Add-Liberation-Serif-as-an-Times-New-Roman-rep.patch
	patch_apply fonts-Missing_Fonts/0003-fonts-Add-Liberation-Mono-as-an-Courier-New-replacem.patch
	patch_apply fonts-Missing_Fonts/0004-fonts-Add-WenQuanYi-Micro-Hei-as-a-Microsoft-Yahei-r.patch
	patch_apply fonts-Missing_Fonts/0005-Add-licenses-for-fonts-as-separate-files.patch
	(
		printf '%s\n' '+    { "Torsten Kurbad", "fonts: Add Liberation Sans as an Arial replacement.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "fonts: Add Liberation Serif as an Times New Roman replacement.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "fonts: Add Liberation Mono as an Courier New replacement.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "fonts: Add WenQuanYi Micro Hei as a Microsoft Yahei replacement.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "Add licenses for fonts as separate files.", 1 },';
	) >> "$patchlist"
fi

# Patchset fsutil-Stub_Program
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22749] Add stub for fsutil.exe hardlink command
# |
# | Modified files:
# |   *	programs/fsutil/Makefile.in, programs/fsutil/fsutil.rc, programs/fsutil/main.c, programs/fsutil/resources.h
# |
if test "$enable_fsutil_Stub_Program" -eq 1; then
	patch_apply fsutil-Stub_Program/0001-fsutil-Add-fsutil-program-with-support-for-creating-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "fsutil: Add fsutil program with support for creating hard links.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-Lazy_Font_Initialization
# |
# | Modified files:
# |   *	dlls/gdi32/dc.c, dlls/gdi32/freetype.c
# |
if test "$enable_gdi32_Lazy_Font_Initialization" -eq 1; then
	patch_apply gdi32-Lazy_Font_Initialization/0001-gdi32-Perform-lazy-initialization-of-fonts-to-improv.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "gdi32: Perform lazy initialization of fonts to improve startup performance.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-rotation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34579] gdi32: fix for rotated Arc, ArcTo, Chord and Pie drawing problem
# |   *	[#35331] gdi32: fix for rotated ellipse
# |
# | Modified files:
# |   *	dlls/gdi32/dibdrv/graphics.c, dlls/gdi32/gdi_private.h
# |
if test "$enable_gdi32_rotation" -eq 1; then
	patch_apply gdi32-rotation/0001-gdi32-fix-for-rotated-Arc-ArcTo-Chord-and-Pie-drawin.patch
	patch_apply gdi32-rotation/0002-gdi32-fix-for-rotated-ellipse.patch
	(
		printf '%s\n' '+    { "Daniel Wendt", "gdi32: Fix for rotated Arc, ArcTo, Chord and Pie drawing problem.", 1 },';
		printf '%s\n' '+    { "Daniel Wendt", "gdi32: Fix for rotated ellipse.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdiplus-FontFamily-RefCount
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#48489] gdiplus: Reference cound the GpFontFamily object.
# |
# | Modified files:
# |   *	dlls/gdiplus/font.c, dlls/gdiplus/gdiplus_private.h, dlls/gdiplus/tests/font.c
# |
if test "$enable_gdiplus_FontFamily_RefCount" -eq 1; then
	patch_apply gdiplus-FontFamily-RefCount/0001-gdiplus-Use-refcounting-for-GpFontFamily-instead-of-.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Use refcounting for GpFontFamily instead of cloning.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdiplus-GdipCreateBitmapFromHBITMAP
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#48338] Unknown application paints GIF images incorrectly.
# |
# | Modified files:
# |   *	dlls/gdiplus/image.c, dlls/gdiplus/tests/image.c
# |
if test "$enable_gdiplus_GdipCreateBitmapFromHBITMAP" -eq 1; then
	patch_apply gdiplus-GdipCreateBitmapFromHBITMAP/0001-gdiplus-GdipCreateBitmapFromHBITMAP-should-use-palet.patch
	patch_apply gdiplus-GdipCreateBitmapFromHBITMAP/0002-gdiplus-Reimplement-GdipCreateBitmapFromGdiDib-by-us.patch
	patch_apply gdiplus-GdipCreateBitmapFromHBITMAP/0003-gdiplus-tests-Add-more-tests-for-GdipCreateBitmapFro.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: GdipCreateBitmapFromHBITMAP should use palette from the GDI bitmap.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Reimplement GdipCreateBitmapFromGdiDib by using GdipCreateBitmapFromHBITMAP.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus/tests: Add more tests for GdipCreateBitmapFromHBITMAP and palette images.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdiplus-Performance-Improvements
# |
# | Modified files:
# |   *	dlls/gdiplus/graphics.c
# |
if test "$enable_gdiplus_Performance_Improvements" -eq 1; then
	patch_apply gdiplus-Performance-Improvements/0001-gdiplus-Change-the-order-of-x-y-loops-in-the-scaler.patch
	patch_apply gdiplus-Performance-Improvements/0002-gdiplus-Change-multiplications-by-additions-in-the-x.patch
	patch_apply gdiplus-Performance-Improvements/0003-gdiplus-Remove-ceilf-floorf-calls-from-bilinear-scal.patch
	patch_apply gdiplus-Performance-Improvements/0004-gdiplus-Prefer-using-pre-multiplied-ARGB-data-in-the.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Change the order of x/y loops in the scaler.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Change multiplications by additions in the x/y scaler loops.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Remove ceilf/floorf calls from bilinear scaler.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Prefer using pre-multiplied ARGB data in the scaler.", 1 },';
	) >> "$patchlist"
fi

# Patchset imagehlp-BindImageEx
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#3591] Support for BindImageEx
# |
# | Modified files:
# |   *	dlls/imagehlp/modify.c, dlls/imagehlp/tests/image.c
# |
if test "$enable_imagehlp_BindImageEx" -eq 1; then
	patch_apply imagehlp-BindImageEx/0001-imagehlp-Implement-parts-of-BindImageEx-to-make-free.patch
	(
		printf '%s\n' '+    { "Bernhard Reiter", "imagehlp: Implement parts of BindImageEx to make freezing Python scripts work.", 1 },';
	) >> "$patchlist"
fi

# Patchset imm32-message_on_focus
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#31157] imm32: Only generate 'WM_IME_SETCONTEXT' message if window has focus.
# |
# | Modified files:
# |   *	dlls/imm32/imm.c
# |
if test "$enable_imm32_message_on_focus" -eq 1; then
	patch_apply imm32-message_on_focus/0001-imm32-Only-generate-WM_IME_SETCONTEXT-message-if-win.patch
	(
		printf '%s\n' '+    { "Gijs Vermeulen", "imm32: Only generate '\''WM_IME_SETCONTEXT'\'' message if window has focus.", 1 },';
	) >> "$patchlist"
fi

# Patchset include-LdrData
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#48289] Grand Theft Auto 5 crashes after loading.
# |
# | Modified files:
# |   *	include/winternl.h
# |
if test "$enable_include_LdrData" -eq 1; then
	patch_apply include-LdrData/0001-include-winternl.h-Add-Vista-PEB_LDR_DATA-structure-.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "include/winternl.h: Add Vista+ PEB_LDR_DATA structure fields.", 1 },';
	) >> "$patchlist"
fi

# Patchset include-winsock
# |
# | Modified files:
# |   *	include/winsock.h
# |
if test "$enable_include_winsock" -eq 1; then
	patch_apply include-winsock/0001-include-Always-define-hton-ntoh-macros.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "include: Always define hton/ntoh macros.", 1 },';
	) >> "$patchlist"
fi

# Patchset inseng-Implementation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39456] Implement CIF reader and download functionality in inseng.dll
# |
# | Modified files:
# |   *	dlls/inseng/Makefile.in, dlls/inseng/icif.c, dlls/inseng/inf.c, dlls/inseng/inseng.spec, dlls/inseng/inseng_main.c,
# | 	dlls/inseng/inseng_private.h, include/inseng.idl
# |
if test "$enable_inseng_Implementation" -eq 1; then
	patch_apply inseng-Implementation/0001-inseng-Implement-CIF-reader-and-download-functions.patch
	(
		printf '%s\n' '+    { "Michael Müller", "inseng: Implement CIF reader and download functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset iphlpapi-System_Ping
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8332] Fallback to system ping command when CAP_NET_RAW is not available
# |
# | Modified files:
# |   *	dlls/iphlpapi/icmp.c
# |
if test "$enable_iphlpapi_System_Ping" -eq 1; then
	patch_apply iphlpapi-System_Ping/0001-iphlpapi-Fallback-to-system-ping-when-ICMP-permissio.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "iphlpapi: Fallback to system ping when ICMP permissions are not present.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-File_Permissions
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38970] Improve mapping of DACL to file permissions
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/ntdll/tests/file.c, server/fd.c, server/file.c
# |
if test "$enable_server_File_Permissions" -eq 1; then
	patch_apply server-File_Permissions/0001-server-Improve-STATUS_CANNOT_DELETE-checks-for-direc.patch
	patch_apply server-File_Permissions/0002-server-Allow-to-open-files-without-any-permission-bi.patch
	patch_apply server-File_Permissions/0003-server-When-creating-new-directories-temporarily-giv.patch
	patch_apply server-File_Permissions/0004-advapi32-tests-Add-tests-for-ACL-inheritance-in-Crea.patch
	patch_apply server-File_Permissions/0005-advapi32-tests-Add-ACL-inheritance-tests-for-creatin.patch
	patch_apply server-File_Permissions/0006-ntdll-tests-Added-tests-for-open-behaviour-on-readon.patch
	patch_apply server-File_Permissions/0007-server-FILE_WRITE_ATTRIBUTES-should-succeed-for-read.patch
	patch_apply server-File_Permissions/0008-server-Improve-mapping-of-DACL-to-file-permissions.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Improve STATUS_CANNOT_DELETE checks for directory case.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Allow to open files without any permission bits.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: When creating new directories temporarily give read-permissions until they are opened.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "advapi32/tests: Add tests for ACL inheritance in CreateDirectoryA.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "advapi32/tests: Add ACL inheritance tests for creating subdirectories with NtCreateFile.", 1 },';
		printf '%s\n' '+    { "Qian Hong", "ntdll/tests: Added tests for open behaviour on readonly files.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: FILE_WRITE_ATTRIBUTES should succeed for readonly files.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Improve mapping of DACL to file permissions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileDispositionInformation
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points, server-File_Permissions
# |
# | Modified files:
# |   *	dlls/ntdll/tests/file.c, server/fd.c
# |
if test "$enable_ntdll_FileDispositionInformation" -eq 1; then
	patch_apply ntdll-FileDispositionInformation/0001-ntdll-tests-Added-tests-to-set-disposition-on-file-w.patch
	patch_apply ntdll-FileDispositionInformation/0002-server-Do-not-allow-to-set-disposition-on-file-which.patch
	patch_apply ntdll-FileDispositionInformation/0003-server-When-combining-root-and-name-make-sure-there-.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll/tests: Added tests to set disposition on file which is mapped to memory.", 1 },';
		printf '%s\n' '+    { "Qian Hong", "server: Do not allow to set disposition on file which has a file mapping.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: When combining root and name, make sure there is only one slash.", 2 },';
	) >> "$patchlist"
fi

# Patchset kernel32-CopyFileEx
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points, server-File_Permissions, ntdll-FileDispositionInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22692] Add support for CopyFileEx progress callback
# |   *	[#22690] Allow to cancel a file operation via progress callback
# |
# | Modified files:
# |   *	dlls/kernel32/path.c, dlls/kernel32/tests/file.c
# |
if test "$enable_kernel32_CopyFileEx" -eq 1; then
	patch_apply kernel32-CopyFileEx/0001-kernel32-Add-support-for-progress-callback-in-CopyFi.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Add support for progress callback in CopyFileEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Debugger
# |
# | Modified files:
# |   *	dlls/kernelbase/debug.c
# |
if test "$enable_kernel32_Debugger" -eq 1; then
	patch_apply kernel32-Debugger/0001-kernel32-Always-start-debugger-on-WinSta0.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32: Always start debugger on WinSta0.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-FindFirstFile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22635] Strip invalid characters from mask in FindFirstFileExW
# |
# | Modified files:
# |   *	dlls/kernel32/tests/file.c, dlls/kernelbase/file.c
# |
if test "$enable_kernel32_FindFirstFile" -eq 1; then
	patch_apply kernel32-FindFirstFile/0001-kernel32-Strip-invalid-characters-from-mask-in-FindF.patch
	patch_apply kernel32-FindFirstFile/0002-kernel32-tests-Add-tests-for-FindFirstFileA-with-inv.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Strip invalid characters from mask in FindFirstFileExW.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "kernel32/tests: Add tests for FindFirstFileA with invalid characters.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Job_Tests
# |
# | Modified files:
# |   *	dlls/kernel32/tests/process.c
# |
if test "$enable_kernel32_Job_Tests" -eq 1; then
	patch_apply kernel32-Job_Tests/0001-kernel32-tests-Add-tests-for-job-object-accounting.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "kernel32/tests: Add tests for job object accounting.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-PE_Loader_Fixes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42125] Various PE loader fixes for 8k demos
# |   *	[#38176] Optical Circuit 4K demo crashes on startup
# |
# | Modified files:
# |   *	dlls/kernel32/process.c, dlls/kernel32/tests/loader.c, dlls/ntdll/virtual.c, server/mapping.c
# |
if test "$enable_kernel32_PE_Loader_Fixes" -eq 1; then
	patch_apply kernel32-PE_Loader_Fixes/0001-server-All-fields-up-to-CheckSum-are-mandatory-regar.patch
	patch_apply kernel32-PE_Loader_Fixes/0002-ntdll-If-PE-image-size-is-larger-than-the-backed-fil.patch
	patch_apply kernel32-PE_Loader_Fixes/0003-kernel32-On-process-entry-store-PEB-address-in-ebx.patch
	patch_apply kernel32-PE_Loader_Fixes/0005-kernel32-tests-Add-a-PE-test-image-that-resembles-fo.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "server: All fields up to CheckSum are mandatory regardless of SizeOfOptionalHeader value.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: If PE image size is larger than the backed file size then treat file as removable.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: On process entry store PEB address in %ebx.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32/tests: Add a PE test image that resembles format of some of 8k demos.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Processor_Group
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	api-ms-win-Stub_DLLs
# |
# | Modified files:
# |   *	dlls/api-ms-win-core-kernel32-legacy-l1-1-0/api-ms-win-core-kernel32-legacy-l1-1-0.spec, dlls/api-ms-win-core-
# | 	kernel32-legacy-l1-1-1/api-ms-win-core-kernel32-legacy-l1-1-1.spec, dlls/kernel32/cpu.c, dlls/kernel32/kernel32.spec,
# | 	dlls/kernel32/tests/process.c, dlls/kernelbase/thread.c, include/winnt.h
# |
if test "$enable_kernel32_Processor_Group" -eq 1; then
	patch_apply kernel32-Processor_Group/0001-kernel32-Implement-some-processor-group-functions.patch
	patch_apply kernel32-Processor_Group/0002-kernel32-Add-stub-for-SetThreadIdealProcessorEx.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Implement some processor group functions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "kernel32: Add stub for SetThreadIdealProcessorEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-SetProcessDEPPolicy
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24125] kernel32: Implement SetProcessDEPPolicy.
# |
# | Modified files:
# |   *	dlls/kernel32/process.c
# |
if test "$enable_kernel32_SetProcessDEPPolicy" -eq 1; then
	patch_apply kernel32-SetProcessDEPPolicy/0001-kernel32-Implement-SetProcessDEPPolicy.patch
	patch_apply kernel32-SetProcessDEPPolicy/0002-kernel32-Implement-GetSystemDEPPolicy.patch
	patch_apply kernel32-SetProcessDEPPolicy/0003-kernel32-Make-system-DEP-policy-affect-GetProcessDEP.patch
	(
		printf '%s\n' '+    { "Olivier F. R. Dierick", "kernel32: Implement SetProcessDEPPolicy().", 1 },';
		printf '%s\n' '+    { "Olivier F. R. Dierick", "kernel32: Implement GetSystemDEPPolicy().", 1 },';
		printf '%s\n' '+    { "Olivier F. R. Dierick", "kernel32: Make system DEP policy affect GetProcessDEPPolicy().", 1 },';
	) >> "$patchlist"
fi

# Patchset kernelbase-ReOpenFile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47668] Logos 8 (.NET/WPF 4.7.2 application) fails to download resources (needs ReOpenFile implementation)
# |
# | Modified files:
# |   *	dlls/kernel32/tests/file.c, dlls/kernelbase/file.c
# |
if test "$enable_kernelbase_ReOpenFile" -eq 1; then
	patch_apply kernelbase-ReOpenFile/0001-kernelbase-Implement-ReOpenFile.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "kernelbase: Implement ReOpenFile().", 1 },';
	) >> "$patchlist"
fi

# Patchset krnl386.exe16-GDT_LDT_Emulation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30237] Implement emulation of GDT and LDT access in Win98 mode
# |
# | Modified files:
# |   *	dlls/krnl386.exe16/instr.c
# |
if test "$enable_krnl386_exe16_GDT_LDT_Emulation" -eq 1; then
	patch_apply krnl386.exe16-GDT_LDT_Emulation/0001-krnl386.exe16-Emulate-GDT-and-LDT-access.patch
	(
		printf '%s\n' '+    { "Michael Müller", "krnl386.exe16: Emulate GDT and LDT access.", 1 },';
	) >> "$patchlist"
fi

# Patchset krnl386.exe16-Invalid_Console_Handles
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#7106] Translate all invalid console handles into usable DOS handles
# |
# | Modified files:
# |   *	dlls/krnl386.exe16/file.c
# |
if test "$enable_krnl386_exe16_Invalid_Console_Handles" -eq 1; then
	patch_apply krnl386.exe16-Invalid_Console_Handles/0001-krnl386.exe16-Really-translate-all-invalid-console-h.patch
	(
		printf '%s\n' '+    { "Michael Müller", "krnl386.exe16: Really translate all invalid console handles into usable DOS handles.", 1 },';
	) >> "$patchlist"
fi

# Patchset libs-Debug_Channel
# |
# | Modified files:
# |   *	dlls/ntdll/debugtools.c
# |
if test "$enable_libs_Debug_Channel" -eq 1; then
	patch_apply libs-Debug_Channel/0001-libwine-Add-process-specific-debug-channels.patch
	(
		printf '%s\n' '+    { "Michael Müller", "libwine: Add process specific debug channels.", 1 },';
	) >> "$patchlist"
fi

# Patchset libs-Unicode_Collation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#10767] Fix comparison of punctuation characters in lstrcmp
# |   *	[#32490] Graphical issues in Inquisitor
# |
# | Modified files:
# |   *	dlls/kernel32/tests/locale.c, dlls/kernelbase/collation.c, libs/port/collation.c
# |
if test "$enable_libs_Unicode_Collation" -eq 1; then
	patch_apply libs-Unicode_Collation/0001-libs-Fix-most-problems-with-CompareString.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "libs: Fix most problems with CompareString.", 1 },';
	) >> "$patchlist"
fi

# Patchset loader-KeyboardLayouts
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47439] loader: Add Keyboard Layouts registry enteries.
# |
# | Modified files:
# |   *	dlls/user32/driver.c, dlls/user32/tests/input.c, loader/wine.inf.in
# |
if test "$enable_loader_KeyboardLayouts" -eq 1; then
	patch_apply loader-KeyboardLayouts/0001-loader-Add-Keyboard-Layouts-registry-enteries.patch
	patch_apply loader-KeyboardLayouts/0002-user32-Improve-GetKeyboardLayoutList.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "loader: Add Keyboard Layouts registry enteries.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "user32: Improve GetKeyboardLayoutList.", 1 },';
	) >> "$patchlist"
fi

# Patchset mmsystem.dll16-MIDIHDR_Refcount
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40024] Fix multiple issues in mmsystem.dll16 when translating MIDI messages
# |
# | Modified files:
# |   *	dlls/mmsystem.dll16/message16.c
# |
if test "$enable_mmsystem_dll16_MIDIHDR_Refcount" -eq 1; then
	patch_apply mmsystem.dll16-MIDIHDR_Refcount/0001-mmsystem.dll16-Refcount-midihdr-to-work-around-buggy.patch
	patch_apply mmsystem.dll16-MIDIHDR_Refcount/0002-mmsystem.dll16-Translate-MidiIn-messages.patch
	(
		printf '%s\n' '+    { "Michael Müller", "mmsystem.dll16: Refcount midihdr to work around buggy application which unprepares buffer during a callback.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "mmsystem.dll16: Translate MidiIn messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset mountmgr-DosDevices
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38235] Fix device paths in HKLM\SYSTEM\MountedDevices
# |
# | Modified files:
# |   *	dlls/mountmgr.sys/device.c, dlls/mountmgr.sys/mountmgr.c, dlls/mountmgr.sys/mountmgr.h
# |
if test "$enable_mountmgr_DosDevices" -eq 1; then
	patch_apply mountmgr-DosDevices/0001-mountmgr.sys-Write-usable-device-paths-into-HKLM-SYS.patch
	(
		printf '%s\n' '+    { "Michael Müller", "mountmgr.sys: Write usable device paths into HKLM\\SYSTEM\\MountedDevices.", 1 },';
	) >> "$patchlist"
fi

# Patchset mscoree-CorValidateImage
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38662] Implement mscoree._CorValidateImage for mono runtime
# |
# | Modified files:
# |   *	dlls/mscoree/mscoree_main.c
# |
if test "$enable_mscoree_CorValidateImage" -eq 1; then
	patch_apply mscoree-CorValidateImage/0001-mscoree-Implement-_CorValidateImage.patch
	(
		printf '%s\n' '+    { "Michael Müller", "mscoree: Implement semi-stub for _CorValidateImage.", 1 },';
	) >> "$patchlist"
fi

# Patchset msctf-ITfActiveLanguageProfileNotifySink
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44502] msctf: Added ITfActiveLanguageProfileNotifySink support in ITfSource.
# |
# | Modified files:
# |   *	dlls/msctf/msctf_internal.h, dlls/msctf/threadmgr.c
# |
if test "$enable_msctf_ITfActiveLanguageProfileNotifySink" -eq 1; then
	patch_apply msctf-ITfActiveLanguageProfileNotifySink/0001-msctf-Added-ITfActiveLanguageProfileNotifySink-suppo.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "msctf: Added ITfActiveLanguageProfileNotifySink support in ITfSource.", 1 },';
	) >> "$patchlist"
fi

# Patchset mshtml-HTMLLocation_put_hash
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32967] Add IHTMLLocation::hash property's getter implementation
# |
# | Modified files:
# |   *	dlls/mshtml/htmllocation.c, dlls/mshtml/tests/htmldoc.c
# |
if test "$enable_mshtml_HTMLLocation_put_hash" -eq 1; then
	patch_apply mshtml-HTMLLocation_put_hash/0001-mshtml-Add-IHTMLLocation-hash-property-s-getter-impl.patch
	(
		printf '%s\n' '+    { "Zhenbo Li", "mshtml: Add IHTMLLocation::hash property'\''s getter implementation.", 1 },';
	) >> "$patchlist"
fi

# Patchset mshtml-TranslateAccelerator
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37058] mshtml: Improve IOleInPlaceActiveObject TranslateAccelerator
# |
# | Modified files:
# |   *	dlls/mshtml/oleobj.c
# |
if test "$enable_mshtml_TranslateAccelerator" -eq 1; then
	patch_apply mshtml-TranslateAccelerator/0001-mshtml-Improve-IOleInPlaceActiveObject-TranslateAcce.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "mshtml: Improve IOleInPlaceActiveObject TranslateAccelerator.", 1 },';
	) >> "$patchlist"
fi

# Patchset msi-msi_vcl_get_cost
# |
# | Modified files:
# |   *	dlls/msi/dialog.c
# |
if test "$enable_msi_msi_vcl_get_cost" -eq 1; then
	patch_apply msi-msi_vcl_get_cost/0001-msi-Do-not-sign-extend-after-multiplying.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "msi: Do not sign extend after multiplying.", 1 },';
	) >> "$patchlist"
fi

# Patchset msvcrt-Math_Precision
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37149] Calculate msvcrt exponential math operations with higher precision
# |
# | Modified files:
# |   *	dlls/msvcrt/math.c
# |
if test "$enable_msvcrt_Math_Precision" -eq 1; then
	patch_apply msvcrt-Math_Precision/0001-msvcrt-Calculate-sinh-cosh-exp-pow-with-higher-preci.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "msvcrt: Calculate sinh/cosh/exp/pow with higher precision.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-APC_Performance
# |
# | Modified files:
# |   *	dlls/ntdll/file.c
# |
if test "$enable_ntdll_APC_Performance" -eq 1; then
	patch_apply ntdll-APC_Performance/0001-ntdll-Reuse-old-async-fileio-structures-if-possible.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Reuse old async fileio structures if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Activation_Context
# |
# | Modified files:
# |   *	dlls/kernel32/tests/actctx.c, dlls/ntdll/actctx.c
# |
if test "$enable_ntdll_Activation_Context" -eq 1; then
	patch_apply ntdll-Activation_Context/0001-ntdll-Fix-return-value-for-missing-ACTIVATION_CONTEX.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Fix return value for missing ACTIVATION_CONTEXT_SECTION_ASSEMBLY_INFORMATION key.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ApiSetMap
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-ThreadTime
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44658] Add dummy apiset to PEB struct
# |
# | Modified files:
# |   *	dlls/ntdll/thread.c, include/Makefile.in, include/apiset.h, include/winternl.h
# |
if test "$enable_ntdll_ApiSetMap" -eq 1; then
	patch_apply ntdll-ApiSetMap/0001-ntdll-Add-dummy-apiset-to-PEB.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add dummy apiset to PEB.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Builtin_Prot
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime, ntdll-Hide_Wine_Exports,
# | 	ntdll-User_Shared_Data
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44650] Fix holes in ELF mappings
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c, dlls/psapi/tests/psapi_main.c
# |
if test "$enable_ntdll_Builtin_Prot" -eq 1; then
	patch_apply ntdll-Builtin_Prot/0001-ntdll-Fix-holes-in-ELF-mappings.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fix holes in ELF mappings.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-CriticalSection
# |
# | Modified files:
# |   *	dlls/ntdll/critsection.c, dlls/ntdll/heap.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/threadpool.c, include/wine/port.h
# |
if test "$enable_ntdll_CriticalSection" -eq 1; then
	patch_apply ntdll-CriticalSection/0001-include-Move-interlocked_inc-dec-to-port.h.patch
	patch_apply ntdll-CriticalSection/0002-ntdll-Add-inline-versions-of-RtlEnterCriticalSection.patch
	patch_apply ntdll-CriticalSection/0003-ntdll-Use-fast-CS-functions-for-heap-locking.patch
	patch_apply ntdll-CriticalSection/0004-ntdll-Use-fast-CS-functions-for-threadpool-locking.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "include: Move interlocked_inc/dec to port.h.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add inline versions of RtlEnterCriticalSection / RtlLeaveCriticalSections.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Use fast CS functions for heap locking.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Use fast CS functions for threadpool locking.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DOS_Attributes
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#9158] Support for DOS hidden/system file attributes
# |   *	[#15679] cygwin symlinks not working in wine
# |
# | Modified files:
# |   *	configure.ac, dlls/ntdll/directory.c, dlls/ntdll/file.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/tests/directory.c,
# | 	dlls/ntdll/tests/file.c, include/wine/port.h, libs/port/Makefile.in, libs/port/xattr.c
# |
if test "$enable_ntdll_DOS_Attributes" -eq 1; then
	patch_apply ntdll-DOS_Attributes/0001-ntdll-Implement-retrieving-DOS-attributes-in-NtQuery.patch
	patch_apply ntdll-DOS_Attributes/0002-ntdll-Implement-retrieving-DOS-attributes-in-NtQuery.patch
	patch_apply ntdll-DOS_Attributes/0003-ntdll-Implement-storing-DOS-attributes-in-NtSetInfor.patch
	patch_apply ntdll-DOS_Attributes/0004-ntdll-Implement-storing-DOS-attributes-in-NtCreateFi.patch
	patch_apply ntdll-DOS_Attributes/0005-libport-Add-support-for-Mac-OS-X-style-extended-attr.patch
	patch_apply ntdll-DOS_Attributes/0006-libport-Add-support-for-FreeBSD-style-extended-attri.patch
	patch_apply ntdll-DOS_Attributes/0007-ntdll-Perform-the-Unix-style-hidden-file-check-withi.patch
	patch_apply ntdll-DOS_Attributes/0008-ntdll-Always-store-SAMBA_XATTR_DOS_ATTRIB-when-path-.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Implement retrieving DOS attributes in NtQueryInformationFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Implement retrieving DOS attributes in NtQuery[Full]AttributesFile and NtQueryDirectoryFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Implement storing DOS attributes in NtSetInformationFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Implement storing DOS attributes in NtCreateFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "libport: Add support for Mac OS X style extended attributes.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "libport: Add support for FreeBSD style extended attributes.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Perform the Unix-style hidden file check within the unified file info grabbing routine.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Always store SAMBA_XATTR_DOS_ATTRIB when path could be interpreted as hidden.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Dealloc_Thread_Stack
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll_misc.h, dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_Dealloc_Thread_Stack" -eq 1; then
	patch_apply ntdll-Dealloc_Thread_Stack/0001-ntdll-Do-not-allow-to-allocate-thread-stack-for-curr.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Do not allow to deallocate thread stack for current thread.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DeviceType_Systemroot
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36546] Return fake device type when systemroot is located on virtual disk
# |
# | Modified files:
# |   *	dlls/ntdll/file.c
# |
if test "$enable_ntdll_DeviceType_Systemroot" -eq 1; then
	patch_apply ntdll-DeviceType_Systemroot/0001-ntdll-Return-fake-device-type-when-systemroot-is-loc.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Return fake device type when systemroot is located on virtual disk.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileFsFullSizeInformation
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_FileFsFullSizeInformation" -eq 1; then
	patch_apply ntdll-FileFsFullSizeInformation/0001-ntdll-Add-support-for-FileFsFullSizeInformation-clas.patch
	(
		printf '%s\n' '+    { "Jianqiu Zhang", "ntdll: Add support for FileFsFullSizeInformation class in NtQueryVolumeInformationFile.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileFsVolumeInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21466] Add semi-stub for FileFsVolumeInformation information class
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_FileFsVolumeInformation" -eq 1; then
	patch_apply ntdll-FileFsVolumeInformation/0001-ntdll-Add-semi-stub-for-FileFsVolumeInformation-info.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add semi-stub for FileFsVolumeInformation information class.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Fix_Alignment
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33162] Ensure NtProtectVirtualMemory and NtCreateSection are on separate pages
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_Fix_Alignment" -eq 1; then
	patch_apply ntdll-Fix_Alignment/0001-ntdll-Move-NtProtectVirtualMemory-and-NtCreateSectio.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Move NtProtectVirtualMemory and NtCreateSection to separate pages on x86.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ForceBottomUpAlloc
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#48175] AION (64 bit) - crashes in crysystem.dll.CryFree() due to high memory pointers allocated
# |   *	[#46568] 64-bit msxml6.dll from Microsoft Core XML Services 6.0 redist package fails to load (Wine doesn't respect
# | 	44-bit user-mode VA limitation from Windows < 8.1)
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c, include/wine/library.h, libs/wine/mmap.c, libs/wine/wine.map
# |
if test "$enable_ntdll_ForceBottomUpAlloc" -eq 1; then
	patch_apply ntdll-ForceBottomUpAlloc/0001-ntdll-Stop-search-on-mmap-error-in-try_map_free_area.patch
	patch_apply ntdll-ForceBottomUpAlloc/0002-ntdll-Use-MAP_FIXED_NOREPLACE-flag-in-try_map_free_a.patch
	patch_apply ntdll-ForceBottomUpAlloc/0003-ntdll-Force-bottom-up-allocation-order-for-64-bit-ar.patch
	patch_apply ntdll-ForceBottomUpAlloc/0004-ntdll-Increase-step-after-failed-map-attempt-in-try_.patch
	patch_apply ntdll-ForceBottomUpAlloc/0005-libs-wine-Add-functions-for-managing-free-area-list.patch
	patch_apply ntdll-ForceBottomUpAlloc/0006-ntdll-Use-free-area-list-for-virtual-memory-allocati.patch
	patch_apply ntdll-ForceBottomUpAlloc/0007-ntdll-Permanently-exclude-natively-mapped-areas-from.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Stop search on mmap() error in try_map_free_area().", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Use MAP_FIXED_NOREPLACE flag in try_map_free_area() if available.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Force bottom up allocation order for 64 bit arch unless top down is requested.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Increase step after failed map attempt in try_map_free_area().", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "libs/wine: Add functions for managing free area list.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Use free area list for virtual memory allocation.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Permanently exclude natively mapped areas from free areas list.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-LDR_MODULE
# |
# | Modified files:
# |   *	include/winternl.h
# |
if test "$enable_ntdll_LDR_MODULE" -eq 1; then
	patch_apply ntdll-LDR_MODULE/0002-include-Update-LDR_MODULE-to-more-recent-windows-ver.patch
	(
		printf '%s\n' '+    { "Michael Müller", "include: Update LDR_MODULE to more recent windows versions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-HashLinks
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-LDR_MODULE
# |
# | Modified files:
# |   *	dlls/kernel32/tests/loader.c, dlls/ntdll/loader.c, include/winternl.h
# |
if test "$enable_ntdll_HashLinks" -eq 1; then
	patch_apply ntdll-HashLinks/0001-ntdll-Implement-HashLinks-field-in-LDR-module-data.patch
	patch_apply ntdll-HashLinks/0002-ntdll-Use-HashLinks-when-searching-for-a-dll-using-t.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement HashLinks field in LDR module data.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Use HashLinks when searching for a dll using the basename.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Heap_Improvements
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43224] Improvement for heap allocation performance
# |
# | Modified files:
# |   *	configure.ac, dlls/ntdll/heap.c
# |
if test "$enable_ntdll_Heap_Improvements" -eq 1; then
	patch_apply ntdll-Heap_Improvements/0001-ntdll-Add-helper-function-to-delete-free-blocks.patch
	patch_apply ntdll-Heap_Improvements/0002-ntdll-Improve-heap-allocation-performance.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add helper function to delete free blocks.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Improve heap allocation performance.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Interrupt-0x2e
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42647] Implement stub handler for int 0x2e
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c
# |
if test "$enable_ntdll_Interrupt_0x2e" -eq 1; then
	patch_apply ntdll-Interrupt-0x2e/0001-ntdll-Catch-windows-int-0x2e-syscall-on-i386.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Catch windows int 0x2e syscall on i386.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Manifest_Range
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18889] ntdll: Support ISOLATIONAWARE_MANIFEST_RESOURCE_ID range
# |
# | Modified files:
# |   *	dlls/ntdll/actctx.c
# |
if test "$enable_ntdll_Manifest_Range" -eq 1; then
	patch_apply ntdll-Manifest_Range/0001-ntdll-Support-ISOLATIONAWARE_MANIFEST_RESOURCE_ID-ra.patch
	(
		printf '%s\n' '+    { "André Hentschel", "ntdll: Support ISOLATIONAWARE_MANIFEST_RESOURCE_ID range.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Pipe_SpecialCharacters
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28995] Allow special characters in pipe names
# |
# | Modified files:
# |   *	dlls/kernel32/tests/pipe.c, dlls/ntdll/directory.c
# |
if test "$enable_ntdll_Pipe_SpecialCharacters" -eq 1; then
	patch_apply ntdll-Pipe_SpecialCharacters/0001-ntdll-Allow-special-characters-in-pipe-names.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Allow special characters in pipe names.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtDevicePath
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Pipe_SpecialCharacters
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37487] Resolve \\SystemRoot\\ prefix when opening files
# |
# | Modified files:
# |   *	dlls/ntdll/directory.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_NtDevicePath" -eq 1; then
	patch_apply ntdll-NtDevicePath/0001-ntdll-Implement-opening-files-through-nt-device-path.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement opening files through nt device paths.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtQueryVirtualMemory
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Pipe_SpecialCharacters, ntdll-NtDevicePath
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23999] Implement MemorySectionName class in NtQueryVirtualMemory
# |   *	[#27248] Implement K32GetMappedFileName
# |
# | Modified files:
# |   *	dlls/kernel32/virtual.c, dlls/ntdll/directory.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/tests/info.c, dlls/ntdll/virtual.c,
# | 	dlls/psapi/tests/psapi_main.c, server/mapping.c, server/protocol.def
# |
if test "$enable_ntdll_NtQueryVirtualMemory" -eq 1; then
	patch_apply ntdll-NtQueryVirtualMemory/0002-ntdll-Split-logic-for-MemoryBasicInformation-into-a-.patch
	patch_apply ntdll-NtQueryVirtualMemory/0003-ntdll-Implement-NtQueryVirtualMemory-MemorySectionNa.patch
	patch_apply ntdll-NtQueryVirtualMemory/0004-ntdll-tests-Add-tests-for-NtQueryVirtualMemory-Memor.patch
	patch_apply ntdll-NtQueryVirtualMemory/0005-ntdll-tests-Add-test-to-ensure-section-name-is-full-.patch
	patch_apply ntdll-NtQueryVirtualMemory/0006-ntdll-Allow-to-query-section-names-from-other-proces.patch
	patch_apply ntdll-NtQueryVirtualMemory/0007-kernel32-Implement-K32GetMappedFileName.-v2.patch
	patch_apply ntdll-NtQueryVirtualMemory/0008-ntdll-Resolve-drive-symlinks-before-returning-sectio.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: Split logic for MemoryBasicInformation into a separate function.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: Implement NtQueryVirtualMemory(MemorySectionName).", 3 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll/tests: Add tests for NtQueryVirtualMemory(MemorySectionName).", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll/tests: Add test to ensure section name is full path.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Allow to query section names from other processes.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: Implement K32GetMappedFileName.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Resolve drive symlinks before returning section name.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-MemoryWorkingSetExInformation
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Pipe_SpecialCharacters, ntdll-NtDevicePath, ntdll-NtQueryVirtualMemory
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45667] League of Legends 8.15+ fails due to missing implementation of
# | 	NtQueryVirtualMemory(MemoryWorkingSetExInformation)
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c, include/winternl.h
# |
if test "$enable_ntdll_MemoryWorkingSetExInformation" -eq 1; then
	patch_apply ntdll-MemoryWorkingSetExInformation/0002-ntdll-Stub-for-MemoryWorkingSetExInformation.patch
	(
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: Stub for MemoryWorkingSetExInformation.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtAccessCheck
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/ntdll/sec.c
# |
if test "$enable_ntdll_NtAccessCheck" -eq 1; then
	patch_apply ntdll-NtAccessCheck/0001-ntdll-Improve-invalid-paramater-handling-in-NtAccess.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll: Improve invalid paramater handling in NtAccessCheck.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtContinue
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime, ntdll-Hide_Wine_Exports,
# | 	ntdll-User_Shared_Data, winebuild-Fake_Dlls
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#31910] Add stub for NtContinue
# |   *	[#45572] League of Legends 8.12+ fails to start a game (anticheat engine, hooking of NtContinue)
# |
# | Modified files:
# |   *	dlls/ntdll/exception.c, dlls/ntdll/ntdll.spec, dlls/ntdll/signal_i386.c, dlls/ntdll/signal_x86_64.c
# |
if test "$enable_ntdll_NtContinue" -eq 1; then
	patch_apply ntdll-NtContinue/0001-ntdll-Add-stub-for-NtContinue.patch
	patch_apply ntdll-NtContinue/0002-Use-NtContinue-to-continue-execution-after-exception.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add stub for NtContinue.", 1 },';
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: Use NtContinue to continue execution after exceptions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtQueryEaFile
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_NtQueryEaFile" -eq 1; then
	patch_apply ntdll-NtQueryEaFile/0001-ntdll-Improve-stub-of-NtQueryEaFile.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Improve stub of NtQueryEaFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtQuerySection
# |
# | Modified files:
# |   *	dlls/kernel32/tests/virtual.c
# |
if test "$enable_ntdll_NtQuerySection" -eq 1; then
	patch_apply ntdll-NtQuerySection/0002-kernel32-tests-Add-tests-for-NtQuerySection.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32/tests: Add tests for NtQuerySection.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtSetLdtEntries
# |
# | Modified files:
# |   *	dlls/kernel32/tests/thread.c, dlls/ntdll/nt.c, libs/wine/ldt.c
# |
if test "$enable_ntdll_NtSetLdtEntries" -eq 1; then
	patch_apply ntdll-NtSetLdtEntries/0001-ntdll-Implement-NtSetLdtEntries.patch
	patch_apply ntdll-NtSetLdtEntries/0002-libs-wine-Allow-to-modify-reserved-LDT-entries.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: Implement NtSetLdtEntries.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "libs/wine: Allow to modify reserved LDT entries.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ProcessQuotaLimits
# |
# | Modified files:
# |   *	dlls/ntdll/process.c
# |
if test "$enable_ntdll_ProcessQuotaLimits" -eq 1; then
	patch_apply ntdll-ProcessQuotaLimits/0001-ntdll-Add-fake-data-implementation-for-ProcessQuotaL.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll: Add fake data implementation for ProcessQuotaLimits class.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlGetNativeSystemInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40334] AION - Wine /Unhandled exception: page fault on read access to 0x00000000 in 64-bit code (0x0000000000000000)
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/tests/info.c
# |
if test "$enable_ntdll_RtlGetNativeSystemInformation" -eq 1; then
	patch_apply ntdll-RtlGetNativeSystemInformation/0001-ntdll-Export-RtlGetNativeSystemInformation-function.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Export RtlGetNativeSystemInformation() function.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlIpv4StringToAddress
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46788] ntdll: Implement RtlIpv6AddressToStringA
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/rtl.c, dlls/ntdll/tests/rtl.c
# |
if test "$enable_ntdll_RtlIpv4StringToAddress" -eq 1; then
	patch_apply ntdll-RtlIpv4StringToAddress/0003-ntdll-Add-semi-stub-for-RtlIpv6AddressToString-Ex-A.patch
	patch_apply ntdll-RtlIpv4StringToAddress/0004-ntdll-Implement-RtlIpv6AddressToString-Ex-W.patch
	(
		printf '%s\n' '+    { "Alex Henrie", "ntdll: Add semi-stub for RtlIpv6AddressToString(Ex)A.", 1 },';
		printf '%s\n' '+    { "Alex Henrie", "ntdll: Implement RtlIpv6AddressToString(Ex)W.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlQueryPackageIdentity
# |
# | Modified files:
# |   *	dlls/ntdll/tests/Makefile.in, dlls/ntdll/tests/rtl.c
# |
if test "$enable_ntdll_RtlQueryPackageIdentity" -eq 1; then
	patch_apply ntdll-RtlQueryPackageIdentity/0003-ntdll-tests-Add-basic-tests-for-RtlQueryPackageIdent.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll/tests: Add basic tests for RtlQueryPackageIdentity.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Serial_Port_Detection
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39793] Do a device check before returning a default serial port name
# |
# | Modified files:
# |   *	dlls/mountmgr.sys/device.c
# |
if test "$enable_ntdll_Serial_Port_Detection" -eq 1; then
	patch_apply ntdll-Serial_Port_Detection/0001-ntdll-Do-a-device-check-before-returning-a-default-s.patch
	(
		printf '%s\n' '+    { "Alex Henrie", "mountmgr.sys: Do a device check before returning a default serial port name.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-WRITECOPY
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime, ntdll-Hide_Wine_Exports,
# | 	ntdll-User_Shared_Data
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29384] Voobly expects correct handling of WRITECOPY memory protection
# |   *	[#35561] MSYS2 expects correct handling of WRITECOPY memory protection
# |
# | Modified files:
# |   *	dlls/advapi32/crypt.c, dlls/advapi32/tests/security.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/server.c,
# | 	dlls/ntdll/signal_arm.c, dlls/ntdll/signal_arm64.c, dlls/ntdll/signal_i386.c, dlls/ntdll/signal_powerpc.c,
# | 	dlls/ntdll/signal_x86_64.c, dlls/ntdll/thread.c, dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_WRITECOPY" -eq 1; then
	patch_apply ntdll-WRITECOPY/0001-ntdll-Trigger-write-watches-before-passing-userdata-.patch
	patch_apply ntdll-WRITECOPY/0002-advapi-Trigger-write-watches-before-passing-userdata.patch
	patch_apply ntdll-WRITECOPY/0003-ntdll-Setup-a-temporary-signal-handler-during-proces.patch
	patch_apply ntdll-WRITECOPY/0004-ntdll-Properly-handle-PAGE_WRITECOPY-protection.-try.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Trigger write watches before passing userdata pointer to wait_reply.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "advapi: Trigger write watches before passing userdata pointer to read syscall.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Setup a temporary signal handler during process startup to handle page faults.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Properly handle PAGE_WRITECOPY protection.", 5 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Signal_Handler
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime, ntdll-Hide_Wine_Exports,
# | 	ntdll-User_Shared_Data, ntdll-WRITECOPY
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c
# |
if test "$enable_ntdll_Signal_Handler" -eq 1; then
	patch_apply ntdll-Signal_Handler/0001-ntdll-Avoid-stack-protector-frame-in-signal-handler-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Avoid stack protector frame in signal handler functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Status_Mapping
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_Status_Mapping" -eq 1; then
	patch_apply ntdll-Status_Mapping/0001-ntdll-Return-STATUS_INVALID_DEVICE_REQUEST-when-tryi.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Return STATUS_INVALID_DEVICE_REQUEST when trying to call NtReadFile on directory.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Syscall_Emulation
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, ntdll-ThreadTime, ntdll-Hide_Wine_Exports,
# | 	ntdll-User_Shared_Data, winebuild-Fake_Dlls
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#48291] Detroit: Become Human crashes on launch
# |
# | Modified files:
# |   *	configure.ac, dlls/ntdll/signal_x86_64.c, tools/winebuild/spec32.c
# |
if test "$enable_ntdll_Syscall_Emulation" -eq 1; then
	patch_apply ntdll-Syscall_Emulation/0001-ntdll-Support-x86_64-syscall-emulation.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Support x86_64 syscall emulation.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemExtendedProcessInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46870] League of Legends 8.12+ fails to start a game in Vista+ mode (anticheat engine,
# | 	SystemExtendedProcessInformation)
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c
# |
if test "$enable_ntdll_SystemExtendedProcessInformation" -eq 1; then
	patch_apply ntdll-SystemExtendedProcessInformation/0001-ntdll-Add-stub-for-NtQuerySystemInformation-SystemEx.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Add stub for NtQuerySystemInformation(SystemExtendedProcessInformation).", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemInterruptInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39123] Return buffer filled with random values from SystemInterruptInformation
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c
# |
if test "$enable_ntdll_SystemInterruptInformation" -eq 1; then
	patch_apply ntdll-SystemInterruptInformation/0001-ntdll-Return-buffer-filled-with-random-values-from-S.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Return buffer filled with random values from SystemInterruptInformation.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemModuleInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45550] League of Legends 8.15+ anticheat fails due to incorrect implementation of
# | 	NtQuerySystemInformation(SystemModuleInformation)
# |   *	[#45666] League of Legends 8.15+ fails due to missing implementation of
# | 	NtQuerySystemInformation(SystemModuleInformationEx) in Windows Vista+ mode
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c, include/winternl.h
# |
if test "$enable_ntdll_SystemModuleInformation" -eq 1; then
	patch_apply ntdll-SystemModuleInformation/0001-ntdll-Don-t-call-LdrQueryProcessModuleInformation-in.patch
	patch_apply ntdll-SystemModuleInformation/0002-ntdll-Return-ntdll.dll-as-the-first-entry-for-System.patch
	patch_apply ntdll-SystemModuleInformation/0003-ntdll-Add-stub-for-NtQuerySystemInformation-SystemMo.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Don'\''t call LdrQueryProcessModuleInformation in NtQuerySystemInformation(SystemModuleInformation).", 1 },';
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: Return ntdll.dll as the first entry for SystemModuleInformation.", 1 },';
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: Add stub for NtQuerySystemInformation(SystemModuleInformationEx).", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ThreadHideFromDebugger
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#48138] League of Legends 9.23: Crash after champ select
# |
# | Modified files:
# |   *	dlls/ntdll/thread.c
# |
if test "$enable_ntdll_ThreadHideFromDebugger" -eq 1; then
	patch_apply ntdll-ThreadHideFromDebugger/0001-ntdll-Stub-NtQueryInformationThread-ThreadHideFromDe.patch
	(
		printf '%s\n' '+    { "David Torok", "ntdll: Stub NtQueryInformationThread(ThreadHideFromDebugger).", 1 },';
	) >> "$patchlist"
fi

# Patchset wow64cpu-Wow64Transition
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45567] League of Legends 8.12+ fails to start a game (anticheat engine, validation of WoW64 syscall dispatcher)
# |
# | Modified files:
# |   *	configure, configure.ac, dlls/ntdll/loader.c, dlls/ntdll/ntdll.spec, dlls/wow64cpu/Makefile.in,
# | 	dlls/wow64cpu/wow64cpu.spec, dlls/wow64cpu/wow64cpu_main.c
# |
if test "$enable_wow64cpu_Wow64Transition" -eq 1; then
	patch_apply wow64cpu-Wow64Transition/0001-wow64cpu-Add-stub-dll.patch
	patch_apply wow64cpu-Wow64Transition/0002-ntdll-Add-a-stub-implementation-of-Wow64Transition.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "wow64cpu: Add stub dll.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Add a stub implementation of Wow64Transition.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-User_shared_data_fields
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, wow64cpu-Wow64Transition
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#48386] Some CPU features are not reported for Intel CPU (Detroit: Become Human is affected)
# |   *	[#48387] User shared data area should have NumberOfPhysicalPages field filled in (used by Detroit: Become Human)
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c, dlls/ntdll/nt.c
# |
if test "$enable_ntdll_User_shared_data_fields" -eq 1; then
	patch_apply ntdll-User_shared_data_fields/0001-ntdll-Fill-NumberOfPhysicalPages-field-in-user-share.patch
	patch_apply ntdll-User_shared_data_fields/0002-ntdll-Detect-more-processor-features-on-Intel-CPU.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Fill NumberOfPhysicalPages field in user shared data area.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "ntdll: Detect more processor features on Intel CPU.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Zero_mod_name
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_Zero_mod_name" -eq 1; then
	patch_apply ntdll-Zero_mod_name/0001-ntdll-Initialize-mod_name-to-zero.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll: Initialize mod_name to zero.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-aarch-TEB
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38780] AArch64 platforms: register X18 (TEB) must remain reserved for Wine to run 64-bit ARM Windows applications.
# |
# | Modified files:
# |   *	configure.ac, dlls/ntdll/loader.c, dlls/ntdll/relay.c
# |
if test "$enable_ntdll_aarch_TEB" -eq 1; then
	patch_apply ntdll-aarch-TEB/0001-configure-Avoid-clobbering-x18-on-arm64-within-wine.patch
	patch_apply ntdll-aarch-TEB/0002-ntdll-Always-restore-TEB-to-x18-on-aarch-64-on-retur.patch
	(
		printf '%s\n' '+    { "Martin Storsjo", "configure: Avoid clobbering x18 on arm64 within wine.", 1 },';
		printf '%s\n' '+    { "Martin Storsjo", "ntdll: Always restore TEB to x18 on aarch 64 on return from calls to builtins.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ext4-case-folder
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47099] Support for EXT4 case folding per directory.
# |
# | Modified files:
# |   *	dlls/ntdll/server.c
# |
if test "$enable_ntdll_ext4_case_folder" -eq 1; then
	patch_apply ntdll-ext4-case-folder/0002-ntdll-server-Mark-drive_c-as-case-insensitive-when-c.patch
	(
		printf '%s\n' '+    { "Gabriel Ivăncescu", "ntdll/server: Mark drive_c as case-insensitive when created.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-set_full_cpu_context
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c
# |
if test "$enable_ntdll_set_full_cpu_context" -eq 1; then
	patch_apply ntdll-set_full_cpu_context/0001-ntdll-Add-back-SS-segment-prefixes-in-set_full_cpu_c.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add back SS segment prefixes in set_full_cpu_context.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-x86_64_SegDs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47970] Legends of Runeterra crashes at launch
# |
# | Modified files:
# |   *	dlls/ntdll/signal_x86_64.c
# |
if test "$enable_ntdll_x86_64_SegDs" -eq 1; then
	patch_apply ntdll-x86_64_SegDs/0001-ntdll-Report-SegDs-to-be-identical-to-SegSs-on-x86_6.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "ntdll: Report SegDs to be identical to SegSs on x86_64.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntoskrnl-Stubs
# |
# | Modified files:
# |   *	dlls/ntoskrnl.exe/ntoskrnl.c, dlls/ntoskrnl.exe/ntoskrnl.exe.spec
# |
if test "$enable_ntoskrnl_Stubs" -eq 1; then
	patch_apply ntoskrnl-Stubs/0009-ntoskrnl.exe-Implement-MmMapLockedPages-and-MmUnmapL.patch
	patch_apply ntoskrnl-Stubs/0011-ntoskrnl.exe-Add-IoGetDeviceAttachmentBaseRef-stub.patch
	(
		printf '%s\n' '+    { "Christian Costa", "ntoskrnl.exe: Implement MmMapLockedPages and MmUnmapLockedPages.", 1 },';
		printf '%s\n' '+    { "Jarkko Korpi", "ntoskrnl.exe: Add IoGetDeviceAttachmentBaseRef stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvcuvid-CUDA_Video_Support
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support, nvapi-Stub_DLL
# |
# | Modified files:
# |   *	configure.ac, dlls/nvcuvid/Makefile.in, dlls/nvcuvid/nvcuvid.c, dlls/nvcuvid/nvcuvid.spec, include/Makefile.in,
# | 	include/cuviddec.h, include/nvcuvid.h
# |
if test "$enable_nvcuvid_CUDA_Video_Support" -eq 1; then
	patch_apply nvcuvid-CUDA_Video_Support/0001-nvcuvid-First-implementation.patch
	(
		printf '%s\n' '+    { "Michael Müller", "nvcuvid: First implementation.", 2 },';
	) >> "$patchlist"
fi

# Patchset nvencodeapi-Video_Encoder
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support, nvapi-Stub_DLL, nvcuvid-CUDA_Video_Support
# |
# | Modified files:
# |   *	configure.ac, dlls/nvencodeapi/Makefile.in, dlls/nvencodeapi/nvencodeapi.c, dlls/nvencodeapi/nvencodeapi.spec,
# | 	dlls/nvencodeapi64/Makefile.in, dlls/nvencodeapi64/nvencodeapi64.spec, include/Makefile.in, include/nvencodeapi.h
# |
if test "$enable_nvencodeapi_Video_Encoder" -eq 1; then
	patch_apply nvencodeapi-Video_Encoder/0001-nvencodeapi-First-implementation.patch
	patch_apply nvencodeapi-Video_Encoder/0002-nvencodeapi-Add-debian-specific-paths-to-native-libr.patch
	patch_apply nvencodeapi-Video_Encoder/0003-nvencodeapi-Add-support-for-version-6.0.patch
	(
		printf '%s\n' '+    { "Michael Müller", "nvencodeapi: First implementation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvencodeapi: Add debian specific paths to native library.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvencodeapi: Add support for version 6.0.", 1 },';
	) >> "$patchlist"
fi

# Patchset ole32-HGLOBALStream
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41738] Implement proper refcounting and locking for HGLOBAL based IStream
# |
# | Modified files:
# |   *	dlls/ole32/hglobalstream.c, dlls/ole32/tests/hglobalstream.c
# |
if test "$enable_ole32_HGLOBALStream" -eq 1; then
	patch_apply ole32-HGLOBALStream/0001-ole32-tests-Add-a-bunch-of-tests-for-HGLOBAL-based-I.patch
	patch_apply ole32-HGLOBALStream/0002-ole32-Add-a-check-for-hglobal-pointer-to-GetHGlobalF.patch
	patch_apply ole32-HGLOBALStream/0003-ole32-Add-a-wrapper-for-memory-block-managed-by-HGLO.patch
	patch_apply ole32-HGLOBALStream/0004-ole32-Set-DebugInfo-Spare-0-for-handle_wrapper-lock.patch
	patch_apply ole32-HGLOBALStream/0005-ole32-Allow-moving-a-being-reallocated-block-of-memo.patch
	patch_apply ole32-HGLOBALStream/0006-ole32-Improve-thread-safety-of-HGLOBALStreamImpl_Rea.patch
	patch_apply ole32-HGLOBALStream/0007-ole32-Improve-thread-safety-of-HGLOBALStreamImpl_Wri.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "ole32/tests: Add a bunch of tests for HGLOBAL based IStream::Clone.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ole32: Add a check for hglobal pointer to GetHGlobalFromStream.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ole32: Add a wrapper for memory block managed by HGLOBAL based IStream.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ole32: Set DebugInfo->Spare[0] for handle_wrapper lock.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ole32: Allow moving a being reallocated block of memory managed by HGLOBAL based IStream.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ole32: Improve thread-safety of HGLOBALStreamImpl_Read.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ole32: Improve thread-safety of HGLOBALStreamImpl_Write.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-CreateTypeLib
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8780] Forward CreateTypeLib to CreateTypeLib2
# |
# | Modified files:
# |   *	dlls/oleaut32/typelib.c
# |
if test "$enable_oleaut32_CreateTypeLib" -eq 1; then
	patch_apply oleaut32-CreateTypeLib/0001-oleaut32-Implement-semi-stub-for-CreateTypeLib.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "oleaut32: Implement semi-stub for CreateTypeLib.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-Load_Save_EMF
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40523] Implement support for loading and saving EMF to IPicture interface
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_Load_Save_EMF" -eq 1; then
	patch_apply oleaut32-Load_Save_EMF/0001-oleaut32-tests-Add-some-tests-for-loading-and-saving.patch
	patch_apply oleaut32-Load_Save_EMF/0002-oleaut32-Add-support-for-loading-and-saving-EMF-to-I.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32/tests: Add some tests for loading and saving EMF using IPicture interface.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Add support for loading and saving EMF to IPicture interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-OLEPictureImpl_SaveAsFile
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	oleaut32-Load_Save_EMF
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8532] Implement a better stub for IPicture::SaveAsFile
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_OLEPictureImpl_SaveAsFile" -eq 1; then
	patch_apply oleaut32-OLEPictureImpl_SaveAsFile/0002-oleaut32-Implement-a-better-stub-for-IPicture-SaveAs.patch
	patch_apply oleaut32-OLEPictureImpl_SaveAsFile/0003-oleaut32-Implement-SaveAsFile-for-PICTYPE_ENHMETAFIL.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Implement a better stub for IPicture::SaveAsFile.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Implement SaveAsFile for PICTYPE_ENHMETAFILE.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-OleLoadPicture
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39474] Create DIB section in OleLoadPicture
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_OleLoadPicture" -eq 1; then
	patch_apply oleaut32-OleLoadPicture/0001-oleaut32-OleLoadPicture-should-create-a-DIB-section-.patch
	patch_apply oleaut32-OleLoadPicture/0002-oleaut32-Make-OleLoadPicture-load-DIBs-using-WIC-dec.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: OleLoadPicture should create a DIB section for a being loaded bitmap.", 3 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Make OleLoadPicture load DIBs using WIC decoder.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-OleLoadPictureFile
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_OleLoadPictureFile" -eq 1; then
	patch_apply oleaut32-OleLoadPictureFile/0001-oleaut32-Do-not-reimplement-OleLoadPicture-in-OleLoa.patch
	patch_apply oleaut32-OleLoadPictureFile/0002-oleaut32-Factor-out-stream-creation-from-OleLoadPict.patch
	patch_apply oleaut32-OleLoadPictureFile/0003-oleaut32-Implement-OleLoadPictureFile.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Do not reimplement OleLoadPicture in OleLoadPicturePath.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Factor out stream creation from OleLoadPicturePath.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Implement OleLoadPictureFile.", 2 },';
	) >> "$patchlist"
fi

# Patchset opencl-version_1_2
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46470] opencl: Add support for OpenCL 1.2.
# |
# | Modified files:
# |   *	configure, configure.ac, dlls/opencl/opencl.c, dlls/opencl/opencl.spec, include/config.h.in
# |
if test "$enable_opencl_version_1_2" -eq 1; then
	patch_apply opencl-version_1_2/0001-opencl-Add-OpenCL-1.0-function-pointer-loader.patch
	patch_apply opencl-version_1_2/0002-opencl-Use-function-pointer-instead-of-call-the-func.patch
	patch_apply opencl-version_1_2/0003-opencl-Add-OpenCL-1.1-implementation.patch
	patch_apply opencl-version_1_2/0004-opencl-Add-OpenCL-1.2-implementation.patch
	patch_apply opencl-version_1_2/0005-opencl-Expose-all-extensions-list-to-wine.patch
	(
		printf '%s\n' '+    { "Nakarin Khankham", "opencl: Add OpenCL 1.0 function pointer loader.", 1 },';
		printf '%s\n' '+    { "Nakarin Khankham", "opencl: Use function pointer instead of call the function directly.", 1 },';
		printf '%s\n' '+    { "Nakarin Khankham", "opencl: Add OpenCL 1.1 implementation.", 1 },';
		printf '%s\n' '+    { "Nakarin Khankham", "opencl: Add OpenCL 1.2 implementation.", 1 },';
		printf '%s\n' '+    { "Nakarin Khankham", "opencl: Expose all extensions list to wine.", 1 },';
	) >> "$patchlist"
fi

# Patchset opengl32-wglChoosePixelFormat
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43638] Treat invalid pixel types as PFD_TYPE_RGBA in wglChoosePixelFormat
# |
# | Modified files:
# |   *	dlls/opengl32/tests/opengl.c, dlls/opengl32/wgl.c
# |
if test "$enable_opengl32_wglChoosePixelFormat" -eq 1; then
	patch_apply opengl32-wglChoosePixelFormat/0001-opengl32-Treat-invalid-pixel-types-as-PFD_TYPE_RGBA-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "opengl32: Treat invalid pixel types as PFD_TYPE_RGBA in wglChoosePixelFormat.", 1 },';
	) >> "$patchlist"
fi

# Patchset packager-DllMain
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43472] Prefer native version of packager.dll
# |
# | Modified files:
# |   *	dlls/packager/packager_main.c
# |
if test "$enable_packager_DllMain" -eq 1; then
	patch_apply packager-DllMain/0001-packager-Prefer-native-version.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "packager: Prefer native version.", 1 },';
	) >> "$patchlist"
fi

# Patchset pdh-PdhLookupPerfNameByIndex-processor
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33018] pdh: Support the 'Processor' object string.
# |
# | Modified files:
# |   *	dlls/pdh/pdh_main.c, dlls/pdh/tests/pdh.c
# |
if test "$enable_pdh_PdhLookupPerfNameByIndex_processor" -eq 1; then
	patch_apply pdh-PdhLookupPerfNameByIndex-processor/0001-pdh-Support-the-Processor-object-string.patch
	(
		printf '%s\n' '+    { "Erich Hoover", "pdh: Support the '\''Processor'\'' object string.", 1 },';
	) >> "$patchlist"
fi

# Patchset quartz-MediaSeeking_Positions
# |
# | Modified files:
# |   *	dlls/strmbase/pospass.c
# |
if test "$enable_quartz_MediaSeeking_Positions" -eq 1; then
	patch_apply quartz-MediaSeeking_Positions/0001-strmbase-Fix-MediaSeekingPassThru_GetPositions-retur.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "strmbase: Fix MediaSeekingPassThru_GetPositions return when the pins are unconnected.", 1 },';
	) >> "$patchlist"
fi

# Patchset riched20-Class_Tests
# |
# | Modified files:
# |   *	dlls/riched20/tests/editor.c
# |
if test "$enable_riched20_Class_Tests" -eq 1; then
	patch_apply riched20-Class_Tests/0001-riched20-tests-Add-a-test-to-see-what-richedit-class.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "riched20/tests: Add a test to see what richedit class flavours should be available.", 1 },';
	) >> "$patchlist"
fi

# Patchset riched20-IText_Interface
# |
# | Modified files:
# |   *	dlls/riched20/richole.c, dlls/riched20/run.c, dlls/riched20/tests/richole.c
# |
if test "$enable_riched20_IText_Interface" -eq 1; then
	patch_apply riched20-IText_Interface/0003-riched20-Stub-for-ITextPara-interface-and-implement-.patch
	patch_apply riched20-IText_Interface/0004-riched20-Fix-ME_RunOfsFromCharOfs-when-nCharOfs-strl.patch
	patch_apply riched20-IText_Interface/0010-riched20-Silence-repeated-FIXMEs-triggered-by-Adobe-.patch
	(
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Stub for ITextPara interface and implement ITextRange::GetPara.", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Fix ME_RunOfsFromCharOfs() when nCharOfs > strlen().", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "riched20: Silence repeated FIXMEs triggered by Adobe Reader.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Desktop_Refcount
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, kernel32-K32GetPerformanceInfo, ntdll-
# | 	Junction_Points, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-User_Shared_Data, winebuild-Fake_Dlls, ntdll-
# | 	RtlCreateUserThread, ntdll-Exception, ntdll-SystemRoot_Symlink, server-Realtime_Priority, ntdll-Threading, ntdll-
# | 	Wait_User_APC, server-Key_State, server-PeekMessage, server-Signal_Thread, server-Shared_Memory, ws2_32-WSACleanup,
# | 	eventfd_synchronization
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46967] GOG Galaxy doesn't run in virtual desktop.
# |
# | Modified files:
# |   *	dlls/user32/tests/winstation.c, programs/explorer/desktop.c, server/async.c, server/atom.c, server/change.c,
# | 	server/clipboard.c, server/completion.c, server/console.c, server/debugger.c, server/device.c, server/directory.c,
# | 	server/esync.c, server/event.c, server/fd.c, server/file.c, server/handle.c, server/handle.h, server/hook.c,
# | 	server/mailslot.c, server/mapping.c, server/mutex.c, server/named_pipe.c, server/object.c, server/object.h,
# | 	server/process.c, server/queue.c, server/registry.c, server/request.c, server/semaphore.c, server/serial.c,
# | 	server/signal.c, server/snapshot.c, server/sock.c, server/symlink.c, server/thread.c, server/timer.c, server/token.c,
# | 	server/winstation.c
# |
if test "$enable_server_Desktop_Refcount" -eq 1; then
	patch_apply server-Desktop_Refcount/0001-server-Introduce-a-new-alloc_handle-object-callback..patch
	patch_apply server-Desktop_Refcount/0002-server-Track-desktop-handle-count-more-correctly.patch
	patch_apply server-Desktop_Refcount/0004-server-Assign-random-name-when-no-name-was-passed-to.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Introduce a new alloc_handle object callback.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Track desktop handle count more correctly.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Assign random name when no name was passed to create_winstation.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-FileEndOfFileInformation
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, server/fd.c, server/protocol.def
# |
if test "$enable_server_FileEndOfFileInformation" -eq 1; then
	patch_apply server-FileEndOfFileInformation/0001-ntdll-Set-EOF-on-file-which-has-a-memory-mapping-sho.patch
	patch_apply server-FileEndOfFileInformation/0002-server-Growing-files-which-are-mapped-to-memory-shou.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll: Set EOF on file which has a memory mapping should fail.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Growing files which are mapped to memory should still work.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Stored_ACLs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points, ntdll-DOS_Attributes, server-File_Permissions
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33576] Support for stored file ACLs
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, include/wine/port.h, server/change.c, server/file.c, server/file.h, server/object.c,
# | 	server/object.h
# |
if test "$enable_server_Stored_ACLs" -eq 1; then
	patch_apply server-Stored_ACLs/0001-server-Unify-the-storage-of-security-attributes-for-.patch
	patch_apply server-Stored_ACLs/0002-server-Unify-the-retrieval-of-security-attributes-fo.patch
	patch_apply server-Stored_ACLs/0003-server-Add-a-helper-function-set_sd_from_token_inter.patch
	patch_apply server-Stored_ACLs/0004-server-Temporarily-store-the-full-security-descripto.patch
	patch_apply server-Stored_ACLs/0005-server-Store-file-security-attributes-with-extended-.patch
	patch_apply server-Stored_ACLs/0006-server-Convert-return-of-file-security-masks-with-ge.patch
	patch_apply server-Stored_ACLs/0007-server-Retrieve-file-security-attributes-with-extend.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "server: Unify the storage of security attributes for files and directories.", 7 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Unify the retrieval of security attributes for files and directories.", 7 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Add a helper function set_sd_from_token_internal to merge two security descriptors.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Temporarily store the full security descriptor for file objects.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Store file security attributes with extended file attributes.", 8 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Convert return of file security masks with generic access mappings.", 7 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Retrieve file security attributes with extended file attributes.", 7 },';
	) >> "$patchlist"
fi

# Patchset server-Inherited_ACLs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points, ntdll-DOS_Attributes, server-File_Permissions, server-Stored_ACLs
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, server/file.c
# |
if test "$enable_server_Inherited_ACLs" -eq 1; then
	patch_apply server-Inherited_ACLs/0001-server-Inherit-security-attributes-from-parent-direc.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "server: Inherit security attributes from parent directories on creation.", 7 },';
	) >> "$patchlist"
fi

# Patchset server-Object_Types
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Threading, ntdll-Wait_User_APC, server-Key_State, server-PeekMessage, server-Signal_Thread, server-Shared_Memory
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44629] Process Hacker can't enumerate handles
# |   *	[#45374] Yet Another Process Monitor (.NET 2.0 app) reports System.AccessViolationException
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c, dlls/ntdll/om.c, dlls/ntdll/tests/info.c, dlls/ntdll/tests/om.c, include/winternl.h,
# | 	server/completion.c, server/directory.c, server/event.c, server/file.c, server/handle.c, server/mailslot.c,
# | 	server/main.c, server/mapping.c, server/mutex.c, server/named_pipe.c, server/object.c, server/object.h,
# | 	server/process.c, server/protocol.def, server/registry.c, server/semaphore.c, server/symlink.c, server/thread.c,
# | 	server/timer.c, server/token.c, server/winstation.c
# |
if test "$enable_server_Object_Types" -eq 1; then
	patch_apply server-Object_Types/0001-ntdll-Implement-SystemExtendedHandleInformation-in-N.patch
	patch_apply server-Object_Types/0002-ntdll-Implement-ObjectTypesInformation-in-NtQueryObj.patch
	patch_apply server-Object_Types/0003-server-Register-types-during-startup.patch
	patch_apply server-Object_Types/0004-server-Rename-ObjectType-to-Type.patch
	patch_apply server-Object_Types/0008-ntdll-Set-TypeIndex-for-ObjectTypeInformation-in-NtQ.patch
	patch_apply server-Object_Types/0009-ntdll-Set-object-type-for-System-Extended-HandleInfo.patch
	patch_apply server-Object_Types/0010-ntdll-Mimic-object-type-behavior-for-different-windo.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement SystemExtendedHandleInformation in NtQuerySystemInformation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement ObjectTypesInformation in NtQueryObject.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Register types during startup.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Rename ObjectType to Type.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Set TypeIndex for ObjectTypeInformation in NtQueryObject.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Set object type for System(Extended)HandleInformation in NtQuerySystemInformation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Mimic object type behavior for different windows versions.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Registry_Notifications
# |
# | Modified files:
# |   *	dlls/ntdll/tests/reg.c, server/registry.c
# |
if test "$enable_server_Registry_Notifications" -eq 1; then
	patch_apply server-Registry_Notifications/0001-server-Allow-multiple-registry-notifications-for-the.patch
	patch_apply server-Registry_Notifications/0002-server-Introduce-refcounting-for-registry-notificati.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Allow multiple registry notifications for the same key.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Introduce refcounting for registry notifications.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Timestamp_Compat
# |
# | Modified files:
# |   *	server/registry.c
# |
if test "$enable_server_Timestamp_Compat" -eq 1; then
	patch_apply server-Timestamp_Compat/0001-server-Compatibility-with-Wine-Staging-format-for-hi.patch
	(
		printf '%s\n' '+    { "Michael Müller", "server: Compatibility with Wine Staging format for high precision registry timestamps.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-device_manager_destroy
# |
# | Modified files:
# |   *	server/device.c
# |
if test "$enable_server_device_manager_destroy" -eq 1; then
	patch_apply server-device_manager_destroy/0001-server-Fix-crash-when-a-device-driver-segfaults-duri.patch
	(
		printf '%s\n' '+    { "Michael Müller", "server: Fix crash when a device driver segfaults during an open file request.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-DiskSpaceList
# |
# | Modified files:
# |   *	dlls/setupapi/diskspace.c, dlls/setupapi/queue.c, dlls/setupapi/setupapi.spec, dlls/setupapi/setupapi_private.h,
# | 	dlls/setupapi/stubs.c, dlls/setupapi/tests/diskspace.c, include/setupapi.h
# |
if test "$enable_setupapi_DiskSpaceList" -eq 1; then
	patch_apply setupapi-DiskSpaceList/0001-setupapi-Rewrite-DiskSpaceList-logic-using-lists.patch
	patch_apply setupapi-DiskSpaceList/0002-setupapi-Implement-SetupAddToDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0003-setupapi-Implement-SetupQueryDrivesInDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0004-setupapi-Ignore-deletion-of-added-files-in-SetupAddT.patch
	patch_apply setupapi-DiskSpaceList/0005-setupapi-ImplementSetupAddSectionToDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0006-setupapi-Implement-SetupAddInstallSectionToDiskSpace.patch
	(
		printf '%s\n' '+    { "Michael Müller", "setupapi: Rewrite DiskSpaceList logic using lists.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Implement SetupAddToDiskSpaceList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Implement SetupQueryDrivesInDiskSpaceList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Ignore deletion of added files in SetupAddToDiskSpaceList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: ImplementSetupAddSectionToDiskSpaceList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Implement SetupAddInstallSectionToDiskSpaceList.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-SPFILENOTIFY_FILEINCABINET
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42827] Fix Param2 in SPFILENOTIFY_FILEINCABINET handler
# |
# | Modified files:
# |   *	dlls/setupapi/setupcab.c, dlls/setupapi/tests/setupcab.c
# |
if test "$enable_setupapi_SPFILENOTIFY_FILEINCABINET" -eq 1; then
	patch_apply setupapi-SPFILENOTIFY_FILEINCABINET/0001-setupapi-tests-Add-more-tests-for-SPFILENOTIFY_FILEI.patch
	patch_apply setupapi-SPFILENOTIFY_FILEINCABINET/0002-setupapi-Fix-CabinetName-passed-to-SPFILENOTIFY_CABI.patch
	patch_apply setupapi-SPFILENOTIFY_FILEINCABINET/0003-setupapi-tests-Add-tests-for-cabinet-name-passed-to-.patch
	patch_apply setupapi-SPFILENOTIFY_FILEINCABINET/0004-setupapi-Fix-parameters-of-SPFILENOTIFY_FILEINCABINE.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "setupapi/tests: Add more tests for SPFILENOTIFY_FILEINCABINET handler.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "setupapi: Fix CabinetName passed to SPFILENOTIFY_CABINETINFO handler.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "setupapi/tests: Add tests for cabinet name passed to SPFILENOTIFY_FILEEXTRACTED.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "setupapi: Fix parameters of SPFILENOTIFY_FILEINCABINET handler.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-SP_COPY_IN_USE_NEEDS_REBOOT
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36059] Implement support for SP_COPY_IN_USE_NEEDS_REBOOT in do_file_copyW
# |
# | Modified files:
# |   *	dlls/setupapi/queue.c
# |
if test "$enable_setupapi_SP_COPY_IN_USE_NEEDS_REBOOT" -eq 1; then
	patch_apply setupapi-SP_COPY_IN_USE_NEEDS_REBOOT/0001-setupapi-Implement-SP_COPY_IN_USE_NEEDS_REBOOT.patch
	(
		printf '%s\n' '+    { "Michael Müller", "setupapi: Implement SP_COPY_IN_USE_NEEDS_REBOOT.", 1 },';
	) >> "$patchlist"
fi

# Patchset shdocvw-ParseURLFromOutsideSource_Tests
# |
# | Modified files:
# |   *	dlls/shdocvw/shdocvw_main.c, dlls/shdocvw/tests/shdocvw.c
# |
if test "$enable_shdocvw_ParseURLFromOutsideSource_Tests" -eq 1; then
	patch_apply shdocvw-ParseURLFromOutsideSource_Tests/0001-shdocvw-Check-precisely-ParseURLFromOutsideSourceX-r.patch
	(
		printf '%s\n' '+    { "Christian Costa", "shdocvw: Check precisely ParseURLFromOutsideSourceX returned values in tests and make code clearer about that.", 3 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHFileOperation_Move
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25207] SHFileOperation with FO_MOVE should create new directory on Vista+
# |
# | Modified files:
# |   *	dlls/shell32/shlfileop.c, dlls/shell32/tests/shlfileop.c
# |
if test "$enable_shell32_SHFileOperation_Move" -eq 1; then
	patch_apply shell32-SHFileOperation_Move/0001-shell32-Fix-SHFileOperation-FO_MOVE-for-creating-sub.patch
	(
		printf '%s\n' '+    { "Zhenbo Li", "shell32: Fix SHFileOperation(FO_MOVE) for creating subdirectories.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Progress_Dialog
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points, server-File_Permissions, ntdll-FileDispositionInformation, kernel32-CopyFileEx,
# | 	shell32-SHFileOperation_Move
# |
# | Modified files:
# |   *	dlls/shell32/shell32.rc, dlls/shell32/shlfileop.c, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_Progress_Dialog" -eq 1; then
	patch_apply shell32-Progress_Dialog/0001-shell32-Correct-indentation-in-shfileop.c.patch
	patch_apply shell32-Progress_Dialog/0002-shell32-Pass-FILE_INFORMATION-into-SHNotify-function.patch
	patch_apply shell32-Progress_Dialog/0003-shell32-Implement-file-operation-progress-dialog.patch
	patch_apply shell32-Progress_Dialog/0004-shell32-Show-animation-during-SHFileOperation.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Correct indentation in shfileop.c.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Pass FILE_INFORMATION into SHNotify* functions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Implement file operation progress dialog.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Show animation during SHFileOperation.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-ACE_Viewer
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Junction_Points, server-File_Permissions, ntdll-FileDispositionInformation, kernel32-CopyFileEx,
# | 	shell32-SHFileOperation_Move, shell32-Progress_Dialog
# |
# | Modified files:
# |   *	dlls/aclui/Makefile.in, dlls/aclui/aclui.rc, dlls/aclui/aclui_main.c, dlls/aclui/resource.h, dlls/aclui/user_icons.bmp,
# | 	dlls/shell32/Makefile.in, dlls/shell32/shell32.rc, dlls/shell32/shlview_cmenu.c, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_ACE_Viewer" -eq 1; then
	patch_apply shell32-ACE_Viewer/0001-aclui-Add-basic-ACE-viewer.patch
	patch_apply shell32-ACE_Viewer/0002-shell32-Add-security-property-tab.patch
	(
		printf '%s\n' '+    { "Michael Müller", "aclui: Add basic ACE viewer.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Add security property tab.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Context_Menu
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34319] Add support for Paste in context menu
# |   *	[#34322] Fix implementation of Cut file operation
# |   *	[#34321] Fix Cut/Copy/Paste keyboard shortcuts in Total Commander
# |
# | Modified files:
# |   *	dlls/shell32/brsfolder.c, dlls/shell32/clipboard.c, dlls/shell32/dataobject.c, dlls/shell32/recyclebin.c,
# | 	dlls/shell32/shell32.rc, dlls/shell32/shell32_main.h, dlls/shell32/shellfolder.h, dlls/shell32/shfldr_fs.c,
# | 	dlls/shell32/shfldr_unixfs.c, dlls/shell32/shlview.c, dlls/shell32/shlview_cmenu.c
# |
if test "$enable_shell32_Context_Menu" -eq 1; then
	patch_apply shell32-Context_Menu/0001-shell32-Fix-copying-of-files-when-using-a-context-me.patch
	patch_apply shell32-Context_Menu/0002-shell32-Set-return-value-correctly-in-DoPaste.patch
	patch_apply shell32-Context_Menu/0003-shell32-Implement-insert-paste-for-item-context-menu.patch
	patch_apply shell32-Context_Menu/0005-shell32-Add-support-for-setting-getting-PREFERREDDRO.patch
	patch_apply shell32-Context_Menu/0006-shell32-Add-parameter-to-ISFHelper-DeleteItems-to-al.patch
	patch_apply shell32-Context_Menu/0007-shell32-Remove-source-files-when-using-cut-in-the-co.patch
	patch_apply shell32-Context_Menu/0008-shell32-Recognize-cut-copy-paste-string-verbs-in-ite.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Fix copying of files when using a context menu.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Set return value correctly in DoPaste.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Implement insert/paste for item context menus.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Add support for setting/getting PREFERREDDROPEFFECT in IDataObject.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Add parameter to ISFHelper::DeleteItems to allow deleting files without confirmation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Remove source files when using cut in the context menu.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Recognize cut/copy/paste string verbs in item menu context menu.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-IconCache
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45696] shell32: Generate icons from available icons if required.
# |
# | Modified files:
# |   *	dlls/shell32/iconcache.c
# |
if test "$enable_shell32_IconCache" -eq 1; then
	patch_apply shell32-IconCache/0001-shell32-iconcache-Generate-icons-from-available-icons-.patch
	(
		printf '%s\n' '+    { "Gabriel Ivăncescu", "shell32/iconcache: Generate icons from available icons if some icon sizes failed to load.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-NewMenu_Interface
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24812] Implement shell32 NewMenu class with new folder item
# |
# | Modified files:
# |   *	dlls/shell32/Makefile.in, dlls/shell32/shell32_classes.idl, dlls/shell32/shell32_main.h, dlls/shell32/shellnew.c,
# | 	dlls/shell32/shellole.c, dlls/shell32/tests/shlview.c
# |
if test "$enable_shell32_NewMenu_Interface" -eq 1; then
	patch_apply shell32-NewMenu_Interface/0001-shell32-Implement-NewMenu-with-new-folder-item.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Implement NewMenu with new folder item.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SFGAO_HASSUBFOLDER
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24851] Only set SFGAO_HASSUBFOLDER when there are really subfolders
# |
# | Modified files:
# |   *	dlls/shell32/shfldr_unixfs.c, dlls/shell32/shlfolder.c
# |
if test "$enable_shell32_SFGAO_HASSUBFOLDER" -eq 1; then
	patch_apply shell32-SFGAO_HASSUBFOLDER/0001-shell32-Set-SFGAO_HASSUBFOLDER-correctly-for-unixfs.patch
	patch_apply shell32-SFGAO_HASSUBFOLDER/0002-shell32-Set-SFGAO_HASSUBFOLDER-correctly-for-normal-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Set SFGAO_HASSUBFOLDER correctly for unixfs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Set SFGAO_HASSUBFOLDER correctly for normal shellfolders.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHGetStockIconInfo
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45868] Improve semi-stub SHGetStockIconInfo
# |
# | Modified files:
# |   *	dlls/shell32/iconcache.c, dlls/shell32/tests/shelllink.c
# |
if test "$enable_shell32_SHGetStockIconInfo" -eq 1; then
	patch_apply shell32-SHGetStockIconInfo/0001-shell32-Improve-semi-stub-SHGetStockIconInfo-try-fin.patch
	(
		printf '%s\n' '+    { "Louis Lenders", "shell32: Improve semi-stub SHGetStockIconInfo, try find existing iconhandle.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Toolbar_Bitmaps
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40236] Add missing resources for IE6 buttons
# |
# | Modified files:
# |   *	dlls/shell32/Makefile.in, dlls/shell32/resources/ietoolbar.bmp, dlls/shell32/resources/ietoolbar.svg,
# | 	dlls/shell32/resources/ietoolbar_small.bmp, dlls/shell32/resources/ietoolbar_small.svg, dlls/shell32/shell32.rc
# |
if test "$enable_shell32_Toolbar_Bitmaps" -eq 1; then
	patch_apply shell32-Toolbar_Bitmaps/0001-shell32-Add-toolbar-bitmaps-compatible-with-IE6.patch
	patch_apply shell32-Toolbar_Bitmaps/0002-shell32-Add-more-Tango-icons-to-the-IE-toolbar.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "shell32: Add toolbar bitmaps compatible with IE6.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "shell32: Add more Tango icons to the IE toolbar.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-UnixFS
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43109] Do not use unixfs for devices without mountpoint
# |
# | Modified files:
# |   *	dlls/shell32/shfldr_desktop.c, dlls/shell32/tests/shlfolder.c
# |
if test "$enable_shell32_UnixFS" -eq 1; then
	patch_apply shell32-UnixFS/0001-shell32-Do-not-use-unixfs-for-devices-without-mountp.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Do not use unixfs for devices without mountpoint.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-AssocGetPerceivedType
# |
# | Modified files:
# |   *	dlls/shlwapi/assoc.c, dlls/shlwapi/tests/assoc.c
# |
if test "$enable_shlwapi_AssocGetPerceivedType" -eq 1; then
	patch_apply shlwapi-AssocGetPerceivedType/0001-shlwapi-tests-Add-tests-for-AssocGetPerceivedType.patch
	patch_apply shlwapi-AssocGetPerceivedType/0002-shlwapi-Implement-AssocGetPerceivedType.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "shlwapi/tests: Add tests for AssocGetPerceivedType.", 1 },';
		printf '%s\n' '+    { "Mark Jansen", "shlwapi: Implement AssocGetPerceivedType.", 2 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-SHAddDataBlock
# |
# | Modified files:
# |   *	dlls/shlwapi/clist.c, dlls/shlwapi/tests/clist.c
# |
if test "$enable_shlwapi_SHAddDataBlock" -eq 1; then
	patch_apply shlwapi-SHAddDataBlock/0001-shlwapi-Fix-the-return-value-of-SHAddDataBlock.patch
	(
		printf '%s\n' '+    { "Hermès BÉLUSCA-MAÏTO", "shlwapi: Fix the return value of SHAddDataBlock.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-UrlCanonicalize
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23166] shlwapi: Support ./ in UrlCanonicalize.
# |
# | Modified files:
# |   *	dlls/kernelbase/path.c, dlls/shlwapi/tests/url.c
# |
if test "$enable_shlwapi_UrlCanonicalize" -eq 1; then
	patch_apply shlwapi-UrlCanonicalize/0001-shlwapi-Support-.-in-UrlCanonicalize.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "shlwapi: Support ./ in UrlCanonicalize.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-UrlCombine
# |
# | Modified files:
# |   *	dlls/kernelbase/path.c, dlls/shlwapi/tests/url.c
# |
if test "$enable_shlwapi_UrlCombine" -eq 1; then
	patch_apply shlwapi-UrlCombine/0001-shlwapi-tests-Add-additional-tests-for-UrlCombine-and-.patch
	patch_apply shlwapi-UrlCombine/0002-shlwapi-UrlCombineW-workaround-for-relative-paths.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "shlwapi/tests: Add additional tests for UrlCombine and UrlCanonicalize.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "shlwapi: UrlCombineW workaround for relative paths.", 1 },';
	) >> "$patchlist"
fi

# Patchset stdole32.idl-Typelib
# |
# | Modified files:
# |   *	dlls/stdole32.tlb/std_ole_v1.idl, include/Makefile.in, include/stdole32.idl
# |
if test "$enable_stdole32_idl_Typelib" -eq 1; then
	patch_apply stdole32.idl-Typelib/0001-include-Make-stdole32.idl-a-public-component.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "include: Make stdole32.idl a public component.", 1 },';
	) >> "$patchlist"
fi

# Patchset widl-SLTG_Typelib_Support
# |
# | Modified files:
# |   *	dlls/oleaut32/typelib.c, dlls/oleaut32/typelib.h, tools/widl/Makefile.in, tools/widl/register.c, tools/widl/typelib.h,
# | 	tools/widl/widl.c, tools/widl/widl.h, tools/widl/write_sltg.c
# |
if test "$enable_widl_SLTG_Typelib_Support" -eq 1; then
	patch_apply widl-SLTG_Typelib_Support/0001-widl-Add-initial-implementation-of-SLTG-typelib-gene.patch
	patch_apply widl-SLTG_Typelib_Support/0002-widl-Add-support-for-structures.patch
	patch_apply widl-SLTG_Typelib_Support/0003-widl-Properly-align-name-table-entries.patch
	patch_apply widl-SLTG_Typelib_Support/0004-widl-More-accurately-report-variable-descriptions-da.patch
	patch_apply widl-SLTG_Typelib_Support/0005-widl-Calculate-size-of-instance-for-structures.patch
	patch_apply widl-SLTG_Typelib_Support/0006-widl-Write-correct-typekind-to-the-SLTG-typeinfo-blo.patch
	patch_apply widl-SLTG_Typelib_Support/0007-widl-Write-SLTG-blocks-according-to-the-index-order.patch
	patch_apply widl-SLTG_Typelib_Support/0008-widl-Write-correct-syskind-by-SLTG-typelib-generator.patch
	patch_apply widl-SLTG_Typelib_Support/0009-widl-Add-support-for-VT_VOID-and-VT_VARIANT-to-SLTG-.patch
	patch_apply widl-SLTG_Typelib_Support/0010-widl-Add-support-for-VT_USERDEFINED-to-SLTG-typelib-.patch
	patch_apply widl-SLTG_Typelib_Support/0011-widl-Factor-out-SLTG-tail-initialization.patch
	patch_apply widl-SLTG_Typelib_Support/0012-widl-Add-support-for-recursive-type-references-to-SL.patch
	patch_apply widl-SLTG_Typelib_Support/0013-widl-Add-support-for-interfaces-to-SLTG-typelib-gene.patch
	patch_apply widl-SLTG_Typelib_Support/0014-widl-Add-support-for-inherited-interfaces-to-SLTG-ty.patch
	patch_apply widl-SLTG_Typelib_Support/0015-widl-Make-automatic-dispid-generation-scheme-better-.patch
	patch_apply widl-SLTG_Typelib_Support/0016-widl-Create-library-block-index-right-after-the-Comp.patch
	patch_apply widl-SLTG_Typelib_Support/0017-widl-Fix-generation-of-resources-containing-an-old-t.patch
	patch_apply widl-SLTG_Typelib_Support/0018-widl-Add-oldtlb-switch-in-usage-message.patch
	patch_apply widl-SLTG_Typelib_Support/0019-widl-Avoid-relying-on-side-effects-when-marking-func.patch
	patch_apply widl-SLTG_Typelib_Support/0020-widl-Set-the-lowest-bit-in-the-param-name-to-indicat.patch
	patch_apply widl-SLTG_Typelib_Support/0021-oleaut32-Fix-logic-for-deciding-whether-type-descrip.patch
	patch_apply widl-SLTG_Typelib_Support/0022-widl-Add-support-for-function-parameter-flags-to-SLT.patch
	patch_apply widl-SLTG_Typelib_Support/0023-oleaut32-Implement-decoding-of-SLTG-help-strings.patch
	patch_apply widl-SLTG_Typelib_Support/0024-oleaut32-Add-support-for-decoding-SLTG-function-help.patch
	patch_apply widl-SLTG_Typelib_Support/0025-oleaut32-Add-support-for-decoding-SLTG-variable-help.patch
	patch_apply widl-SLTG_Typelib_Support/0026-widl-Minor-cosmetic-clean-up.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add initial implementation of SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for structures.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Properly align name table entries.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: More accurately report variable descriptions data size.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Calculate size of instance for structures.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Write correct typekind to the SLTG typeinfo block.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Write SLTG blocks according to the index order.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Write correct syskind by SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for VT_VOID and VT_VARIANT to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for VT_USERDEFINED to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Factor out SLTG tail initialization.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for recursive type references to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for interfaces to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for inherited interfaces to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Make automatic dispid generation scheme better match what midl does.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Create library block index right after the CompObj one.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Fix generation of resources containing an old typelib.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "widl: Add --oldtlb switch in usage message.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Avoid relying on side effects when marking function index as the last one.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Set the lowest bit in the param name to indicate whether type description follows the name.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Fix logic for deciding whether type description follows the name.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for function parameter flags to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Implement decoding of SLTG help strings.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Add support for decoding SLTG function help strings.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Add support for decoding SLTG variable help strings.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Minor/cosmetic clean up.", 1 },';
	) >> "$patchlist"
fi

# Patchset stdole32.tlb-SLTG_Typelib
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	widl-SLTG_Typelib_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#3689] Compile stdole32.tlb in SLTG typelib format
# |
# | Modified files:
# |   *	dlls/stdole32.tlb/Makefile.in
# |
if test "$enable_stdole32_tlb_SLTG_Typelib" -eq 1; then
	patch_apply stdole32.tlb-SLTG_Typelib/0020-stdole32.tlb-Compile-typelib-with-oldtlb.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "stdole32.tlb: Compile typelib with --oldtlb.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-DM_SETDEFID
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22764] Use root dialog for DM_SETDEFID/DM_GETDEFID in DefDlgProc
# |
# | Modified files:
# |   *	dlls/user32/defdlg.c, dlls/user32/dialog.c, dlls/user32/tests/win.c
# |
if test "$enable_user32_DM_SETDEFID" -eq 1; then
	patch_apply user32-DM_SETDEFID/0001-user32-Do-not-initialize-dialog-info-for-every-windo.patch
	patch_apply user32-DM_SETDEFID/0002-user32-Use-root-dialog-for-DM_SETDEFID-DM_GETDEFID-i.patch
	patch_apply user32-DM_SETDEFID/0003-user32-tests-Add-a-bunch-of-tests-for-DM_SETDEFID-DM.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Do not initialize dialog info for every window passed to DefDlgProc.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Use root dialog for DM_SETDEFID/DM_GETDEFID in DefDlgProc.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add a bunch of tests for DM_SETDEFID/DM_GETDEFID handling by a DefDlgProc.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Dialog_Paint_Event
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35652] Send WM_PAINT event during dialog creation
# |
# | Modified files:
# |   *	dlls/user32/dialog.c
# |
if test "$enable_user32_Dialog_Paint_Event" -eq 1; then
	patch_apply user32-Dialog_Paint_Event/0001-user32-Call-UpdateWindow-during-DIALOG_CreateIndirec.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Call UpdateWindow() during DIALOG_CreateIndirect.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-DrawMenuItem
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40704] Add a check if the menu text is a valid string in MENU_DrawMenuItem
# |
# | Modified files:
# |   *	dlls/user32/menu.c
# |
if test "$enable_user32_DrawMenuItem" -eq 1; then
	patch_apply user32-DrawMenuItem/0001-user32-Add-a-check-if-the-menu-text-is-a-valid-strin.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Add a check if the menu text is a valid string.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-DrawTextExW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22109] Fix handling of invert_y in DrawTextExW
# |
# | Modified files:
# |   *	dlls/user32/text.c
# |
if test "$enable_user32_DrawTextExW" -eq 1; then
	patch_apply user32-DrawTextExW/0001-user32-Fix-handling-of-invert_y-in-DrawTextExW.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Fix handling of invert_y in DrawTextExW.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-FlashWindowEx
# |
# | Modified files:
# |   *	dlls/user32/tests/win.c, dlls/user32/win.c
# |
if test "$enable_user32_FlashWindowEx" -eq 1; then
	patch_apply user32-FlashWindowEx/0001-user32-Improve-FlashWindowEx-message-and-return-valu.patch
	(
		printf '%s\n' '+    { "James Coonradt", "user32: Improve FlashWindowEx message and return value.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-GetSystemMetrics
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18732] Make it possible to change media center / tablet pc status
# |
# | Modified files:
# |   *	dlls/user32/sysparams.c
# |
if test "$enable_user32_GetSystemMetrics" -eq 1; then
	patch_apply user32-GetSystemMetrics/0001-user32-Allow-changing-the-tablet-media-center-status.patch
	(
		printf '%s\n' '+    { "Michael Müller", "user32: Allow changing the tablet / media center status via wine registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Implement-CascadeWindows
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45968] user32: Implement CascadeWindows
# |   *	[#46197] user32: Implement TileWindows
# |
# | Modified files:
# |   *	dlls/user32/mdi.c
# |
if test "$enable_user32_Implement_CascadeWindows" -eq 1; then
	patch_apply user32-Implement-CascadeWindows/0001-user32-Implement-CascadeWindows.patch
	patch_apply user32-Implement-CascadeWindows/0002-user32-Implement-TileWindows.patch
	(
		printf '%s\n' '+    { "katahiromz", "user32: Implement CascadeWindows.", 1 },';
		printf '%s\n' '+    { "Hirofumi Katayama", "user32: Implement TileWindows.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-InternalGetWindowIcon
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47915] user32: AddInternalGetWindowIcon stub.
# |
# | Modified files:
# |   *	dlls/user32/user32.spec, dlls/user32/win.c
# |
if test "$enable_user32_InternalGetWindowIcon" -eq 1; then
	patch_apply user32-InternalGetWindowIcon/0001-user32-AddInternalGetWindowIcon-stub.patch
	(
		printf '%s\n' '+    { "David Torok", "user32: AddInternalGetWindowIcon stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-LR_LOADFROMFILE
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24963] Workaround for Windows 3.1 apps which call LoadImage(LR_LOADFROMFILE) with a resource id
# |
# | Modified files:
# |   *	dlls/user32/cursoricon.c
# |
if test "$enable_user32_LR_LOADFROMFILE" -eq 1; then
	patch_apply user32-LR_LOADFROMFILE/0001-user32-Add-a-workaround-for-Windows-3.1-apps-which-c.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Add a workaround for Windows 3.1 apps which call LoadImage(LR_LOADFROMFILE) with a resource id.", 2 },';
	) >> "$patchlist"
fi

# Patchset user32-ListBox_Size
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38142] Fix calculation of listbox size when horizontal scrollbar is present
# |
# | Modified files:
# |   *	dlls/user32/listbox.c
# |
if test "$enable_user32_ListBox_Size" -eq 1; then
	patch_apply user32-ListBox_Size/0001-user32-Fix-calculation-of-listbox-size-when-horizont.patch
	(
		printf '%s\n' '+    { "Michael Müller", "user32: Fix calculation of listbox size when horizontal scrollbar is present.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-LoadKeyboardLayoutEx
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28170] user32: Added LoadKeyboardLayoutEx stub.
# |
# | Modified files:
# |   *	dlls/user32/input.c, dlls/user32/user32.spec
# |
if test "$enable_user32_LoadKeyboardLayoutEx" -eq 1; then
	patch_apply user32-LoadKeyboardLayoutEx/0001-user32-Added-LoadKeyboardLayoutEx-stub.patch
	(
		printf '%s\n' '+    { "Austin English", "user32: Added LoadKeyboardLayoutEx stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-MessageBox_WS_EX_TOPMOST
# |
# | Modified files:
# |   *	dlls/user32/msgbox.c, dlls/user32/tests/dialog.c
# |
if test "$enable_user32_MessageBox_WS_EX_TOPMOST" -eq 1; then
	patch_apply user32-MessageBox_WS_EX_TOPMOST/0001-user32-tests-Add-some-tests-to-see-when-MessageBox-g.patch
	patch_apply user32-MessageBox_WS_EX_TOPMOST/0002-user32-MessageBox-should-be-topmost-when-MB_SYSTEMMO.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add some tests to see when MessageBox gains WS_EX_TOPMOST style.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: MessageBox should be topmost when MB_SYSTEMMODAL style is set.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Mouse_Message_Hwnd
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22458] Fix issues with inserting symbols by clicking on center in Word 2007 & 2010
# |   *	[#12007] Fix issues with dragging layers between images in Adobe Photoshop 7.0
# |   *	[#9512] Make sure popups don't block access to objects underneath in DVDPro
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/user32/tests/input.c, dlls/winex11.drv/bitblt.c, server/protocol.def, server/window.c
# |
if test "$enable_user32_Mouse_Message_Hwnd" -eq 1; then
	patch_apply user32-Mouse_Message_Hwnd/0001-user32-Try-harder-to-find-a-target-for-mouse-message.patch
	patch_apply user32-Mouse_Message_Hwnd/0002-user32-tests-Add-tests-for-clicking-through-layered-.patch
	patch_apply user32-Mouse_Message_Hwnd/0003-user32-tests-Add-tests-for-window-region-of-layered-.patch
	patch_apply user32-Mouse_Message_Hwnd/0004-user32-tests-Add-tests-for-DC-region.patch
	patch_apply user32-Mouse_Message_Hwnd/0005-server-Add-support-for-a-layered-window-region.-v2.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Try harder to find a target for mouse messages.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32/tests: Add tests for clicking through layered window.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32/tests: Add tests for window region of layered windows.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32/tests: Add tests for DC region.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "server: Add support for a layered window region.", 3 },';
	) >> "$patchlist"
fi

# Patchset user32-Refresh_MDI_Menus
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21855] Refresh MDI menus when DefMDIChildProc(WM_SETTEXT) is called
# |
# | Modified files:
# |   *	dlls/user32/mdi.c
# |
if test "$enable_user32_Refresh_MDI_Menus" -eq 1; then
	patch_apply user32-Refresh_MDI_Menus/0001-user32-Refresh-MDI-menus-when-DefMDIChildProcW-WM_SE.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Refresh MDI menus when DefMDIChildProc(WM_SETTEXT) is called.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-ScrollWindowEx
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37706] Fix return value of ScrollWindowEx for invisible windows
# |
# | Modified files:
# |   *	dlls/user32/painting.c
# |
if test "$enable_user32_ScrollWindowEx" -eq 1; then
	patch_apply user32-ScrollWindowEx/0001-user32-Fix-return-value-of-ScrollWindowEx-for-invisi.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Fix return value of ScrollWindowEx for invisible windows.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-ShowWindow
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39731] Fix handling of ShowWindow when window is already visible
# |
# | Modified files:
# |   *	dlls/user32/winpos.c
# |
if test "$enable_user32_ShowWindow" -eq 1; then
	patch_apply user32-ShowWindow/0001-user32-ShowWindow-should-not-send-message-when-windo.patch
	(
		printf '%s\n' '+    { "Kimmo Myllyvirta", "user32: ShowWindow should not send message when window is already visible.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-msgbox-Support-WM_COPY-mesg
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17205] Support WM_COPY in MessageBox dialogs.
# |
# | Modified files:
# |   *	dlls/user32/msgbox.c, dlls/user32/tests/dialog.c
# |
if test "$enable_user32_msgbox_Support_WM_COPY_mesg" -eq 1; then
	patch_apply user32-msgbox-Support-WM_COPY-mesg/0001-user32-msgbox-Support-WM_COPY-Message.patch
	patch_apply user32-msgbox-Support-WM_COPY-mesg/0002-user32-msgbox-Use-a-windows-hook-to-trap-Ctrl-C.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "user32/msgbox: Support WM_COPY Message.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "user32/msgbox: Use a windows hook to trap Ctrl+C.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11.drv-mouse-coorrds
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46309] winex11.drv: Use root-relative coordinates for events, if possible.
# |
# | Modified files:
# |   *	dlls/winex11.drv/mouse.c
# |
if test "$enable_winex11_drv_mouse_coorrds" -eq 1; then
	patch_apply winex11.drv-mouse-coorrds/0001-winex11.drv-mouse-Use-root-relative-coordinates-for-ev.patch
	(
		printf '%s\n' '+    { "Gabriel Ivăncescu", "winex11.drv/mouse: Use root-relative coordinates for events, if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-rawinput-mouse
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	winex11.drv-mouse-coorrds
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42631] - user32: Add Raw Input support.
# |
# | Modified files:
# |   *	dlls/dinput/device_private.h, dlls/dinput/dinput_main.c, dlls/dinput/mouse.c, dlls/dinput8/tests/device.c,
# | 	dlls/user32/input.c, dlls/user32/rawinput.c, dlls/user32/tests/input.c, dlls/user32/user32.spec,
# | 	dlls/wineandroid.drv/keyboard.c, dlls/wineandroid.drv/window.c, dlls/winemac.drv/ime.c, dlls/winemac.drv/keyboard.c,
# | 	dlls/winemac.drv/mouse.c, dlls/winex11.drv/event.c, dlls/winex11.drv/keyboard.c, dlls/winex11.drv/mouse.c,
# | 	dlls/winex11.drv/x11drv.h, dlls/winex11.drv/x11drv_main.c, include/winuser.h, server/protocol.def, server/queue.c
# |
if test "$enable_user32_rawinput_mouse" -eq 1; then
	patch_apply user32-rawinput-mouse/0001-user32-tests-Add-rawinput-test-for-ClipCursor-intera.patch
	patch_apply user32-rawinput-mouse/0002-user32-tests-Add-rawinput-test-for-cross-thread-inte.patch
	patch_apply user32-rawinput-mouse/0003-user32-tests-Add-rawinput-test-for-cross-process-int.patch
	patch_apply user32-rawinput-mouse/0004-server-Add-send_hardware_message-flags-for-rawinput-.patch
	patch_apply user32-rawinput-mouse/0005-server-Broadcast-rawinput-message-if-request-flag-is.patch
	patch_apply user32-rawinput-mouse/0006-user32-Add-__wine_send_input-flags-to-hint-raw-input.patch
	patch_apply user32-rawinput-mouse/0007-winex11.drv-Advertise-XInput2-version-2.1-support.patch
	patch_apply user32-rawinput-mouse/0008-winex11.drv-Keep-track-of-pointer-and-device-button-.patch
	patch_apply user32-rawinput-mouse/0009-winex11.drv-Listen-to-RawMotion-and-RawButton-events.patch
	patch_apply user32-rawinput-mouse/0010-user32-Implement-GetRegisteredRawInputDevices.patch
	patch_apply user32-rawinput-mouse/0011-dinput8-Add-support-for-dinput-devices-that-use-raw-.patch
	patch_apply user32-rawinput-mouse/0012-dinput8-Use-raw-input-interface-for-dinput8-mouse-de.patch
	(
		printf '%s\n' '+    { "Rémi Bernon", "user32/tests: Add rawinput test for ClipCursor interactions.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "user32/tests: Add rawinput test for cross-thread interactions.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "user32/tests: Add rawinput test for cross-process interactions.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "server: Add send_hardware_message flags for rawinput translation.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "server: Broadcast rawinput message if request flag is SEND_HWMSG_RAWINPUT.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "user32: Add __wine_send_input flags to hint raw input translation.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "winex11.drv: Advertise XInput2 version 2.1 support.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "winex11.drv: Keep track of pointer and device button mappings.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "winex11.drv: Listen to RawMotion and RawButton* events in the desktop thread.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "user32: Implement GetRegisteredRawInputDevices.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "dinput8: Add support for dinput devices that use raw input interface.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "dinput8: Use raw input interface for dinput8 mouse device.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-rawinput-nolegacy
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	winex11.drv-mouse-coorrds, user32-rawinput-mouse
# |
# | Modified files:
# |   *	dlls/dinput/dinput_main.c, dlls/dinput8/tests/device.c, dlls/user32/rawinput.c, server/queue.c
# |
if test "$enable_user32_rawinput_nolegacy" -eq 1; then
	patch_apply user32-rawinput-nolegacy/0001-dinput8-tests-Add-test-for-DISCL_EXCLUSIVE-flag-inte.patch
	patch_apply user32-rawinput-nolegacy/0002-user32-Add-support-for-RIDEV_NOLEGACY-flag-in-Regist.patch
	patch_apply user32-rawinput-nolegacy/0003-dinput-Set-RIDEV_INPUTSINK-flag-only-when-DISCL_BACK.patch
	patch_apply user32-rawinput-nolegacy/0004-dinput-Set-correct-rawinput-flags-for-DISCL_EXCLUSIV.patch
	patch_apply user32-rawinput-nolegacy/0005-server-Update-desktop-cursor-pos-even-if-RIDEV_NOLEG.patch
	(
		printf '%s\n' '+    { "Rémi Bernon", "dinput8/tests: Add test for DISCL_EXCLUSIVE flag interaction with rawinput.", 1 },';
		printf '%s\n' '+    { "Derek Lesho", "user32: Add support for RIDEV_NOLEGACY flag in RegisterRawInputDevices.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "dinput: Set RIDEV_INPUTSINK flag only when DISCL_BACKGROUND is requested.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "dinput: Set correct rawinput flags for DISCL_EXCLUSIVE.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "server: Update desktop cursor pos even if RIDEV_NOLEGACY flag is set.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-rawinput-hid
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	winex11.drv-mouse-coorrds, user32-rawinput-mouse, user32-rawinput-nolegacy
# |
# | Modified files:
# |   *	dlls/hidclass.sys/device.c, dlls/hidclass.sys/hid.h, dlls/hidclass.sys/pnp.c, dlls/user32/message.c,
# | 	dlls/user32/rawinput.c, dlls/user32/user_private.h, server/protocol.def, server/queue.c, server/trace.c
# |
if test "$enable_user32_rawinput_hid" -eq 1; then
	patch_apply user32-rawinput-hid/0001-server-Add-process-argument-to-find_rawinput_device.patch
	patch_apply user32-rawinput-hid/0002-server-Allow-extra-data-for-hardware_msg_data-messag.patch
	patch_apply user32-rawinput-hid/0003-server-Add-HID-input-message-type-to-send_hardware_m.patch
	patch_apply user32-rawinput-hid/0004-user32-Implement-WM_INPUT-RIM_TYPEHID-message-handli.patch
	patch_apply user32-rawinput-hid/0005-hidclass.sys-Send-input-message-to-server-when-HID-r.patch
	(
		printf '%s\n' '+    { "Rémi Bernon", "server: Add process argument to find_rawinput_device.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "server: Allow extra data for hardware_msg_data message.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "server: Add HID input message type to send_hardware_message request.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "user32: Implement WM_INPUT/RIM_TYPEHID message handling.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "hidclass.sys: Send input message to server when HID report is received.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-rawinput-mouse-experimental
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	winex11.drv-mouse-coorrds, user32-rawinput-mouse, user32-rawinput-nolegacy
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45882] - Raw Input should use untransformed mouse values (affects Overwatch, several Source games).
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/winex11.drv/mouse.c, dlls/winex11.drv/x11drv.h, dlls/winex11.drv/x11drv_main.c,
# | 	server/queue.c
# |
if test "$enable_user32_rawinput_mouse_experimental" -eq 1; then
	patch_apply user32-rawinput-mouse-experimental/0001-winex11.drv-Add-support-for-absolute-RawMotion-event.patch
	patch_apply user32-rawinput-mouse-experimental/0002-winex11.drv-Send-relative-RawMotion-events-unprocess.patch
	patch_apply user32-rawinput-mouse-experimental/0003-winex11.drv-Accumulate-mouse-movement-to-avoid-round.patch
	(
		printf '%s\n' '+    { "Derek Lesho", "winex11.drv: Add support for absolute RawMotion events.", 1 },';
		printf '%s\n' '+    { "Rémi Bernon", "winex11.drv: Send relative RawMotion events unprocessed.", 1 },';
		printf '%s\n' '+    { "Jordan Galby", "winex11.drv: Accumulate mouse movement to avoid rounding losses.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-recursive-activation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46274] user32: Prevent a recursive loop with the activation messages.
# |
# | Modified files:
# |   *	dlls/user32/focus.c, dlls/user32/tests/msg.c, dlls/user32/win.h
# |
if test "$enable_user32_recursive_activation" -eq 1; then
	patch_apply user32-recursive-activation/0001-user32-focus-Prevent-a-recursive-loop-with-the-activ.patch
	patch_apply user32-recursive-activation/0002-user32-tests-Test-a-recursive-activation-loop-on-WM_.patch
	(
		printf '%s\n' '+    { "Gabriel Ivăncescu", "user32/focus: Prevent a recursive loop with the activation messages.", 1 },';
		printf '%s\n' '+    { "Gabriel Ivăncescu", "user32/tests: Test a recursive activation loop on WM_ACTIVATE.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-window-activation
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	user32-recursive-activation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47507] Send a WM_ACTIVATE message after restoring a minimized window.
# |
# | Modified files:
# |   *	dlls/user32/tests/msg.c, dlls/user32/winpos.c
# |
if test "$enable_user32_window_activation" -eq 1; then
	patch_apply user32-window-activation/0001-user32-Send-a-WM_ACTIVATE-message-after-restoring-a-.patch
	(
		printf '%s\n' '+    { "Zhiyi Zhang", "user32: Send a WM_ACTIVATE message after restoring a minimized window.", 1 },';
	) >> "$patchlist"
fi

# Patchset uxtheme-CloseThemeClass
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41729] Protect CloseThemeData() from invalid input
# |
# | Modified files:
# |   *	dlls/uxtheme/msstyles.c, dlls/uxtheme/msstyles.h, dlls/uxtheme/tests/system.c
# |
if test "$enable_uxtheme_CloseThemeClass" -eq 1; then
	patch_apply uxtheme-CloseThemeClass/0001-uxtheme-Protect-CloseThemeData-from-invalid-input.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "uxtheme: Protect CloseThemeData() from invalid input.", 1 },';
	) >> "$patchlist"
fi

# Patchset uxtheme-GTK_Theming
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	uxtheme-CloseThemeClass
# |
# | Modified files:
# |   *	configure.ac, dlls/uxtheme/Makefile.in, dlls/uxtheme/buffer.c, dlls/uxtheme/draw.c, dlls/uxtheme/gtk-button.c,
# | 	dlls/uxtheme/gtk-combobox.c, dlls/uxtheme/gtk-edit.c, dlls/uxtheme/gtk-header.c, dlls/uxtheme/gtk-listbox.c,
# | 	dlls/uxtheme/gtk-listview.c, dlls/uxtheme/gtk-menu.c, dlls/uxtheme/gtk-rebar.c, dlls/uxtheme/gtk-status.c, dlls/uxtheme
# | 	/gtk-tab.c, dlls/uxtheme/gtk-toolbar.c, dlls/uxtheme/gtk-trackbar.c, dlls/uxtheme/gtk-window.c, dlls/uxtheme/gtk.c,
# | 	dlls/uxtheme/main.c, dlls/uxtheme/metric.c, dlls/uxtheme/msstyles.c, dlls/uxtheme/property.c, dlls/uxtheme/stylemap.c,
# | 	dlls/uxtheme/system.c, dlls/uxtheme/uxini.c, dlls/uxtheme/uxthemedll.h, dlls/uxtheme/uxthemegtk.h, tools/makedep.c
# |
if test "$enable_uxtheme_GTK_Theming" -eq 1; then
	patch_apply uxtheme-GTK_Theming/0000-Revert-uxtheme-Build-with-msvcrt.patch
	patch_apply uxtheme-GTK_Theming/0001-uxtheme-Initial-implementation-of-GTK-backend.patch
	patch_apply uxtheme-GTK_Theming/0002-makefiles-Only-apply-non-include-path-EXTRAINCL-flag.patch
	patch_apply uxtheme-GTK_Theming/0003-uxtheme-Correctly-render-buttons-with-GTK-3.14.0.patch
	patch_apply uxtheme-GTK_Theming/0004-uxtheme-Reset-FPU-flags-before-calling-GTK3-function.patch
	patch_apply uxtheme-GTK_Theming/0005-uxtheme-Fix-some-incorrect-error-codes.patch
	(
		printf '%s\n' '+    { "Zebediah Figura", "Revert \"uxtheme: Build with msvcrt.\".", 1 },';
		printf '%s\n' '+    { "Ivan Akulinchev", "uxtheme: Initial implementation of GTK backend.", 1 },';
		printf '%s\n' '+    { "Zebediah Figura", "makefiles: Only apply non-include-path EXTRAINCL flags to C sources.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "uxtheme: Correctly render buttons with GTK >= 3.14.0.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "uxtheme: Reset FPU flags before calling GTK3 functions.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "uxtheme: Fix some incorrect error codes.", 1 },';
	) >> "$patchlist"
fi

# Patchset version-VerQueryValue
# |
# | Modified files:
# |   *	dlls/version/tests/info.c
# |
if test "$enable_version_VerQueryValue" -eq 1; then
	patch_apply version-VerQueryValue/0001-version-Test-for-VerQueryValueA-try-2.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "version: Test for VerQueryValueA.", 2 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-GIF_Encoder
# |
# | Modified files:
# |   *	dlls/gdiplus/tests/image.c, dlls/windowscodecs/clsfactory.c, dlls/windowscodecs/gifformat.c,
# | 	dlls/windowscodecs/regsvr.c, dlls/windowscodecs/tests/converter.c, dlls/windowscodecs/wincodecs_private.h,
# | 	dlls/windowscodecs/windowscodecs_wincodec.idl
# |
if test "$enable_windowscodecs_GIF_Encoder" -eq 1; then
	patch_apply windowscodecs-GIF_Encoder/0007-windowscodecs-tests-Add-IWICBitmapEncoderInfo-test.patch
	patch_apply windowscodecs-GIF_Encoder/0008-windowscodecs-Add-initial-implementation-of-the-GIF-.patch
	patch_apply windowscodecs-GIF_Encoder/0010-windowscodecs-Initialize-empty-property-bag-in-GIF-e.patch
	patch_apply windowscodecs-GIF_Encoder/0020-windowscodecs-Add-registration-of-the-GIF-encoder.patch
	patch_apply windowscodecs-GIF_Encoder/0021-windowscodecs-Fix-IWICBitmapDecoder-CopyPalette-for-.patch
	patch_apply windowscodecs-GIF_Encoder/0022-windowscodecs-Better-follow-the-GIF-spec-and-don-t-s.patch
	patch_apply windowscodecs-GIF_Encoder/0026-windowscodecs-tests-Add-the-tests-for-GIF-encoder-an.patch
	patch_apply windowscodecs-GIF_Encoder/0028-windowscodecs-Correctly-indicate-that-the-global-inf.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "windowscodecs/tests: Add IWICBitmapEncoderInfo test.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add initial implementation of the GIF encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Initialize empty property bag in GIF encoder'\''s CreateNewFrame implementation.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add registration of the GIF encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Fix IWICBitmapDecoder::CopyPalette for a not initialized case in the GIF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Better follow the GIF spec and don'\''t specify the local color table size if there is no local palette.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Add the tests for GIF encoder and decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Correctly indicate that the global info was written even without the global palette.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-TIFF_Support
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	windowscodecs-GIF_Encoder
# |
# | Modified files:
# |   *	dlls/gdiplus/image.c, dlls/gdiplus/tests/image.c, dlls/windowscodecs/metadatahandler.c, dlls/windowscodecs/regsvr.c,
# | 	dlls/windowscodecs/tests/tiffformat.c, dlls/windowscodecs/tiffformat.c, include/wincodec.idl
# |
if test "$enable_windowscodecs_TIFF_Support" -eq 1; then
	patch_apply windowscodecs-TIFF_Support/0006-windowscodecs-Add-support-for-16bppGray-and-32bppGra.patch
	patch_apply windowscodecs-TIFF_Support/0007-windowscodecs-Add-support-for-3bps-RGB-format-to-TIF.patch
	patch_apply windowscodecs-TIFF_Support/0008-windowscodecs-Add-support-for-12bpp-RGB-format-to-TI.patch
	patch_apply windowscodecs-TIFF_Support/0009-windowscodecs-Add-support-for-128bppRGBAFloat-format.patch
	patch_apply windowscodecs-TIFF_Support/0011-windowscodecs-Add-support-for-32bppCMYK-and-64bppCMY.patch
	patch_apply windowscodecs-TIFF_Support/0012-windowscodecs-Add-support-for-4bpp-RGBA-format-to-TI.patch
	patch_apply windowscodecs-TIFF_Support/0013-windowscodecs-Add-support-for-16bpp-RGBA-format-to-T.patch
	patch_apply windowscodecs-TIFF_Support/0014-windowscodecs-Add-some-tests-for-various-TIFF-color-.patch
	patch_apply windowscodecs-TIFF_Support/0015-windowscodecs-Tolerate-partial-reads-in-the-IFD-meta.patch
	patch_apply windowscodecs-TIFF_Support/0016-gdiplus-Add-support-for-more-image-color-formats.patch
	patch_apply windowscodecs-TIFF_Support/0017-gdiplus-tests-Add-some-tests-for-loading-TIFF-images.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 16bppGray and 32bppGrayFloat formats to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 3bps RGB format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 12bpp RGB format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 128bppRGBAFloat format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 32bppCMYK and 64bppCMYK formats to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 4bpp RGBA format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 16bpp RGBA format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add some tests for various TIFF color formats.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Tolerate partial reads in the IFD metadata loader.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Add support for more image color formats.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus/tests: Add some tests for loading TIFF images in various color formats.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Directory_ContextMenuHandlers
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29523] Add 'New' context menu handler entry for directories
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_Directory_ContextMenuHandlers" -eq 1; then
	patch_apply wine.inf-Directory_ContextMenuHandlers/0001-wine.inf-Add-New-context-menu-handler-entry-for-dire.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wine.inf: Add '\''New'\'' context menu handler entry for directories.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Dummy_CA_Certificate
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_Dummy_CA_Certificate" -eq 1; then
	patch_apply wine.inf-Dummy_CA_Certificate/0001-wine.inf.in-Add-invalid-dummy-certificate-to-CA-cert.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wine.inf.in: Add invalid dummy certificate to CA certificate store.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Performance
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33661] Add performance library registry keys needed by MS SQL Server Management Studio Express 2008 R2
# |
# | Modified files:
# |   *	dlls/advapi32/tests/registry.c, loader/wine.inf.in
# |
if test "$enable_wine_inf_Performance" -eq 1; then
	patch_apply wine.inf-Performance/0001-wine.inf-Add-registry-keys-for-Windows-Performance-L.patch
	patch_apply wine.inf-Performance/0002-wine.inf-Add-Counters-to-the-perflib-key-as-an-alias.patch
	patch_apply wine.inf-Performance/0003-advapi32-tests-Add-test-for-perflib-registry-key.patch
	(
		printf '%s\n' '+    { "Daniel Jelinski", "wine.inf: Add registry keys for Windows Performance Library.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "wine.inf: Add '\''Counters'\'' to the perflib key as an alias for '\''Counter'\''.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "advapi32/tests: Add test for perflib registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-DriveSerial
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17823] Assign a drive serial number during prefix creation/update
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_DriveSerial" -eq 1; then
	patch_apply wineboot-DriveSerial/0001-wineboot-Assign-a-drive-serial-number-during-prefix-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wineboot: Assign a drive serial number during prefix creation/update.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-HKEY_DYN_DATA
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#7115] Need for Speed 3 installer requires devices in HKEY_DYN_DATA
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_HKEY_DYN_DATA" -eq 1; then
	patch_apply wineboot-HKEY_DYN_DATA/0001-wineboot-Add-some-generic-hardware-in-HKEY_DYN_DATA-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wineboot: Add some generic hardware in HKEY_DYN_DATA\\Config Manager\\Enum.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-drivers_etc_Stubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12076] Create stub files for system32/drivers/etc/{services,hosts,networks,protocol}
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_drivers_etc_Stubs" -eq 1; then
	patch_apply wineboot-drivers_etc_Stubs/0001-wineboot-Init-system32-drivers-etc-host-networks-pro.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wineboot: Init system32/drivers/etc/{host,networks,protocol,services}.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-ProxySettings
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wineboot-DriveSerial, wineboot-drivers_etc_Stubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42024] Create ProxyEnable key on wineprefix update
# |
# | Modified files:
# |   *	programs/wineboot/Makefile.in, programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_ProxySettings" -eq 1; then
	patch_apply wineboot-ProxySettings/0001-wineboot-Initialize-proxy-settings-registry-key.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wineboot: Initialize proxy settings registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Libraries
# |
# | Modified files:
# |   *	programs/winecfg/libraries.c
# |
if test "$enable_winecfg_Libraries" -eq 1; then
	patch_apply winecfg-Libraries/0001-winecfg-Double-click-in-dlls-list-to-edit-item-s-ove.patch
	(
		printf '%s\n' '+    { "Hao Peng", "winecfg: Double click in dlls list to edit item'\''s overides.", 3 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Staging
# |
# | Modified files:
# |   *	programs/winecfg/Makefile.in, programs/winecfg/about.c, programs/winecfg/main.c, programs/winecfg/resource.h,
# | 	programs/winecfg/staging.c, programs/winecfg/winecfg.h, programs/winecfg/winecfg.rc
# |
if test "$enable_winecfg_Staging" -eq 1; then
	patch_apply winecfg-Staging/0001-winecfg-Add-staging-tab-for-CSMT.patch
	patch_apply winecfg-Staging/0002-winecfg-Add-checkbox-to-enable-disable-vaapi-GPU-dec.patch
	patch_apply winecfg-Staging/0003-winecfg-Add-checkbox-to-enable-disable-EAX-support.patch
	patch_apply winecfg-Staging/0004-winecfg-Add-checkbox-to-enable-disable-HideWineExpor.patch
	patch_apply winecfg-Staging/0005-winecfg-Add-option-to-enable-disable-GTK3-theming.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winecfg: Add staging tab for CSMT.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "winecfg: Add checkbox to enable/disable vaapi GPU decoder.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winecfg: Add checkbox to enable/disable EAX support.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "winecfg: Add checkbox to enable/disable HideWineExports registry key.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winecfg: Add option to enable/disable GTK3 theming.", 1 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Unmounted_Devices
# |
# | Modified files:
# |   *	programs/winecfg/drive.c, programs/winecfg/drivedetect.c, programs/winecfg/driveui.c
# |
if test "$enable_winecfg_Unmounted_Devices" -eq 1; then
	patch_apply winecfg-Unmounted_Devices/0001-winecfg-Show-unmounted-devices-and-allow-changing-th.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winecfg: Show unmounted devices and allow changing the device value.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Accounting
# |
# | Modified files:
# |   *	dlls/wined3d/adapter_gl.c, dlls/wined3d/device.c, dlls/wined3d/wined3d_gl.h
# |
if test "$enable_wined3d_Accounting" -eq 1; then
	patch_apply wined3d-Accounting/0001-wined3d-Use-real-values-for-memory-accounting-on-NVI.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Use real values for memory accounting on NVIDIA cards.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-CSMT_Main
# |
# | Modified files:
# |   *	dlls/wined3d/cs.c, dlls/wined3d/device.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_CSMT_Main" -eq 1; then
	patch_apply wined3d-CSMT_Main/0045-wined3d-Improve-wined3d_cs_emit_update_sub_resource.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Improve wined3d_cs_emit_update_sub_resource.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Dual_Source_Blending
# |
# | Modified files:
# |   *	dlls/d3d11/tests/d3d11.c, dlls/wined3d/adapter_gl.c, dlls/wined3d/context.c, dlls/wined3d/glsl_shader.c,
# | 	dlls/wined3d/shader.c, dlls/wined3d/state.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_Dual_Source_Blending" -eq 1; then
	patch_apply wined3d-Dual_Source_Blending/0002-d3d11-tests-Add-basic-dual-source-blend-test.patch
	patch_apply wined3d-Dual_Source_Blending/0003-wined3d-Implement-dual-source-blending.patch
	(
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add basic dual source blend test.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement dual source blending.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-SWVP-shaders
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8051] Sims 2 demo exits prematurely
# |
# | Modified files:
# |   *	dlls/d3d8/directx.c, dlls/d3d9/d3d9_private.h, dlls/d3d9/device.c, dlls/d3d9/directx.c, dlls/d3d9/tests/device.c,
# | 	dlls/d3d9/tests/visual.c, dlls/wined3d/adapter_gl.c, dlls/wined3d/device.c, dlls/wined3d/glsl_shader.c,
# | 	dlls/wined3d/shader.c, dlls/wined3d/shader_sm1.c, dlls/wined3d/state.c, dlls/wined3d/stateblock.c,
# | 	dlls/wined3d/wined3d_private.h, include/wine/wined3d.h
# |
if test "$enable_wined3d_SWVP_shaders" -eq 1; then
	patch_apply wined3d-SWVP-shaders/0001-wined3d-Use-UBO-for-vertex-shader-float-constants-if.patch
	patch_apply wined3d-SWVP-shaders/0002-d3d9-Support-SWVP-vertex-shader-float-constants-limi.patch
	patch_apply wined3d-SWVP-shaders/0003-wined3d-Report-actual-vertex-shader-float-constants-.patch
	patch_apply wined3d-SWVP-shaders/0004-wined3d-Support-SWVP-vertex-shader-constants-limit-i.patch
	patch_apply wined3d-SWVP-shaders/0005-wined3d-Support-SWVP-mode-vertex-shaders.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "wined3d: Use UBO for vertex shader float constants if supported.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "d3d9: Support SWVP vertex shader float constants limits.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "wined3d: Report actual vertex shader float constants limit for SWVP device.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "wined3d: Support SWVP vertex shader constants limit in state tracking.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "wined3d: Support SWVP mode vertex shaders.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Indexed_Vertex_Blending
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wined3d-SWVP-shaders
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39057] Support for Indexed Vertex Blending
# |
# | Modified files:
# |   *	dlls/d3d9/tests/visual.c, dlls/wined3d/adapter_gl.c, dlls/wined3d/cs.c, dlls/wined3d/device.c, dlls/wined3d/directx.c,
# | 	dlls/wined3d/glsl_shader.c, dlls/wined3d/state.c, dlls/wined3d/utils.c, dlls/wined3d/vertexdeclaration.c,
# | 	dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_Indexed_Vertex_Blending" -eq 1; then
	patch_apply wined3d-Indexed_Vertex_Blending/0001-d3d9-tests-Add-test-for-indexed-vertex-blending.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0002-d3d9-tests-Test-normal-calculation-when-indexed-vert.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0003-d3d9-tests-Check-MaxVertexBlendMatrixIndex-capabilit.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0004-wined3d-Allow-higher-world-matrix-states.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0005-wined3d-Support-indexed-vertex-blending.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "d3d9/tests: Add test for indexed vertex blending.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d9/tests: Test normal calculation when indexed vertex blending is enabled.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d9/tests: Check MaxVertexBlendMatrixIndex capability.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "wined3d: Allow higher world matrix states.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "wined3d: Support indexed vertex blending.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/wined3d/surface.c
# |
if test "$enable_wined3d_Silence_FIXMEs" -eq 1; then
	patch_apply wined3d-Silence_FIXMEs/0004-wined3d-Print-FIXME-only-once-in-surface_cpu_blt.patch
	(
		printf '%s\n' '+    { "Christian Costa", "wined3d: Print FIXME only once in surface_cpu_blt.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-UAV_Counters
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/wined3d/cs.c, dlls/wined3d/device.c
# |
if test "$enable_wined3d_UAV_Counters" -eq 1; then
	patch_apply wined3d-UAV_Counters/0001-wined3d-Remaining-UAV-counter-changes.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wined3d: Remaining UAV counter changes.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-WINED3DFMT_B8G8R8X8_UNORM
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44888] Implement WINED3DFMT_B8G8R8X8_UNORM to WINED3DFMT_L8_UNORM conversion
# |
# | Modified files:
# |   *	dlls/wined3d/surface.c
# |
if test "$enable_wined3d_WINED3DFMT_B8G8R8X8_UNORM" -eq 1; then
	patch_apply wined3d-WINED3DFMT_B8G8R8X8_UNORM/0001-wined3d-Implement-WINED3DFMT_B8G8R8X8_UNORM-to-WINED.patch
	(
		printf '%s\n' '+    { "Stanislav Zhukov", "wined3d: Implement WINED3DFMT_B8G8R8X8_UNORM to WINED3DFMT_L8_UNORM conversion.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-WINED3D_RS_COLORWRITEENABLE
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/d3d11/state.c, dlls/wined3d/context.c, dlls/wined3d/device.c, dlls/wined3d/state.c,
# | 	dlls/wined3d/stateblock.c, dlls/wined3d/surface.c, dlls/wined3d/utils.c, dlls/wined3d/wined3d_private.h,
# | 	include/wine/wined3d.h
# |
if test "$enable_wined3d_WINED3D_RS_COLORWRITEENABLE" -eq 1; then
	patch_apply wined3d-WINED3D_RS_COLORWRITEENABLE/0001-wined3d-Implement-all-8-d3d11-color-write-masks.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement all 8 d3d11 color write masks.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-WINED3D_TEXF_ANISOTROPIC
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41929] wined3d: Multiple games need WINED3D_TEXF_ANISOTROPIC filter mode
# |
# | Modified files:
# |   *	dlls/wined3d/surface.c
# |
if test "$enable_wined3d_WINED3D_TEXF_ANISOTROPIC" -eq 1; then
	patch_apply wined3d-WINED3D_TEXF_ANISOTROPIC/0001-wined3d-Multiple-games-need-WINED3D_TEXF_ANISOTROPIC.patch
	(
		printf '%s\n' '+    { "Józef Kucia", "wined3d: Multiple games need WINED3D_TEXF_ANISOTROPIC filter mode.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-mesa_texture_download
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#45901] Avoid GPU synchronization due to GPU-CPU transfer (Overwatch)
# |
# | Modified files:
# |   *	dlls/wined3d/texture.c
# |
if test "$enable_wined3d_mesa_texture_download" -eq 1; then
	patch_apply wined3d-mesa_texture_download/0001-wined3d-Use-glReadPixels-for-RT-texture-download.patch
	(
		printf '%s\n' '+    { "Andrew Wesie", "wined3d: Use glReadPixels for RT texture download.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-unset-flip-gdi
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#47419] wined3d: Dont set DDSCAPS_FLIP for gdi renderer.
# |
# | Modified files:
# |   *	dlls/wined3d/adapter_gl.c, dlls/wined3d/adapter_vk.c, dlls/wined3d/directx.c
# |
if test "$enable_wined3d_unset_flip_gdi" -eq 1; then
	patch_apply wined3d-unset-flip-gdi/0001-wined3d-Dont-set-DDSCAPS_FLIP-for-gdi-renderer.patch
	(
		printf '%s\n' '+    { "Henri Verbeet", "wined3d: Dont set DDSCAPS_FLIP for gdi renderer.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-wined3d_guess_gl_vendor
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42538] Add check for GL_VENDOR = "Brian Paul" to detect Mesa
# |
# | Modified files:
# |   *	dlls/wined3d/adapter_gl.c
# |
if test "$enable_wined3d_wined3d_guess_gl_vendor" -eq 1; then
	patch_apply wined3d-wined3d_guess_gl_vendor/0001-wined3d-Also-check-for-Brian-Paul-to-detect-Mesa-gl_.patch
	(
		printf '%s\n' '+    { "Jarkko Korpi", "wined3d: Also check for '\''Brian Paul'\'' to detect Mesa gl_vendor.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-zero-inf-shaders
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34266] wined3d: Add a setting to workaround 0 * inf problem in shader models 1-3.
# |   *	[#45375] Halo Online: Weird black display problems.
# |
# | Modified files:
# |   *	dlls/wined3d/glsl_shader.c, dlls/wined3d/wined3d_main.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_zero_inf_shaders" -eq 1; then
	patch_apply wined3d-zero-inf-shaders/0001-wined3d-Add-a-setting-to-workaround-0-inf-problem-in.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "wined3d: Add a setting to workaround 0 * inf problem in shader models 1-3.", 1 },';
	) >> "$patchlist"
fi

# Patchset winedbg-Process_Arguments
# |
# | Modified files:
# |   *	programs/winedbg/info.c
# |
if test "$enable_winedbg_Process_Arguments" -eq 1; then
	patch_apply winedbg-Process_Arguments/0001-programs-winedbg-Print-process-arguments-in-info-thr.patch
	(
		printf '%s\n' '+    { "Michael Müller", "programs/winedbg: Print process arguments in info threads.", 1 },';
	) >> "$patchlist"
fi

# Patchset winedevice-Default_Drivers
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dxva2-Video_Decoder, ntoskrnl-Stubs
# |
# | Modified files:
# |   *	configure.ac, dlls/dxgkrnl.sys/Makefile.in, dlls/dxgkrnl.sys/dxgkrnl.sys.spec, dlls/dxgkrnl.sys/main.c,
# | 	dlls/dxgmms1.sys/Makefile.in, dlls/dxgmms1.sys/dxgmms1.sys.spec, dlls/dxgmms1.sys/main.c,
# | 	dlls/ntoskrnl.exe/tests/driver.c, dlls/win32k.sys/Makefile.in, dlls/win32k.sys/main.c, dlls/win32k.sys/win32k.sys.spec,
# | 	loader/wine.inf.in, programs/winedevice/device.c, tools/make_specfiles
# |
if test "$enable_winedevice_Default_Drivers" -eq 1; then
	patch_apply winedevice-Default_Drivers/0001-win32k.sys-Add-stub-driver.patch
	patch_apply winedevice-Default_Drivers/0002-dxgkrnl.sys-Add-stub-driver.patch
	patch_apply winedevice-Default_Drivers/0003-dxgmms1.sys-Add-stub-driver.patch
	patch_apply winedevice-Default_Drivers/0004-programs-winedevice-Load-some-common-drivers-and-fix.patch
	(
		printf '%s\n' '+    { "Michael Müller", "win32k.sys: Add stub driver.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxgkrnl.sys: Add stub driver.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxgmms1.sys: Add stub driver.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "programs/winedevice: Load some common drivers and fix ldr order.", 1 },';
	) >> "$patchlist"
fi

# Patchset winemapi-user-xdg-mail
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#11770] - use xdg-email if it's available.
# |
# | Modified files:
# |   *	dlls/winemapi/Makefile.in, dlls/winemapi/sendmail.c, dlls/winemapi/winemapi_private.h, dlls/winemapi/xdg-email.c
# |
if test "$enable_winemapi_user_xdg_mail" -eq 1; then
	patch_apply winemapi-user-xdg-mail/0001-winemapi-Directly-use-xdg-email-if-available-enablin.patch
	(
		printf '%s\n' '+    { "Jeremy White", "winemapi: Directly use xdg-email if available, enabling file attachments.", 1 },';
	) >> "$patchlist"
fi

# Patchset winemenubuilder-Desktop_Icon_Path
# |
# | Modified files:
# |   *	programs/winemenubuilder/Makefile.in, programs/winemenubuilder/winemenubuilder.c
# |
if test "$enable_winemenubuilder_Desktop_Icon_Path" -eq 1; then
	patch_apply winemenubuilder-Desktop_Icon_Path/0001-winemenubuilder-Create-desktop-shortcuts-with-absolu.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winemenubuilder: Create desktop shortcuts with absolute wine path.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineps.drv-PostScript_Fixes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#4836] Various improvements for wineps.drv for Adobe PageMaker compatibility
# |
# | Modified files:
# |   *	dlls/wineps.drv/download.c, dlls/wineps.drv/escape.c, dlls/wineps.drv/psdrv.h
# |
if test "$enable_wineps_drv_PostScript_Fixes" -eq 1; then
	patch_apply wineps.drv-PostScript_Fixes/0004-wineps.drv-Add-support-for-GETFACENAME-and-DOWNLOADF.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "wineps.drv: Add support for GETFACENAME and DOWNLOADFACE escapes.", 1 },';
	) >> "$patchlist"
fi

# Patchset winepulse-PulseAudio_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37042] Implement exclusive mode in PulseAudio backend
# |   *	[#28282] Sound constantly crackling in a lot of games
# |
# | Modified files:
# |   *	dlls/winepulse.drv/Makefile.in, dlls/winepulse.drv/mmdevdrv.c
# |
if test "$enable_winepulse_PulseAudio_Support" -eq 1; then
	patch_apply winepulse-PulseAudio_Support/0001-winepulse.drv-Use-a-separate-mainloop-and-ctx-for-pu.patch
	patch_apply winepulse-PulseAudio_Support/0002-winepulse-Don-t-rely-on-pulseaudio-callbacks-for-tim.patch
	patch_apply winepulse-PulseAudio_Support/0003-winepulse-expose-audio-devices-directly-to-programs.patch
	patch_apply winepulse-PulseAudio_Support/0004-winepulse-fix-segfault-in-pulse_rd_loop.patch
	patch_apply winepulse-PulseAudio_Support/0005-winepulse-implement-GetPropValue.patch
	patch_apply winepulse-PulseAudio_Support/0006-winepulse-fetch-actual-program-name-if-possible.patch
	patch_apply winepulse-PulseAudio_Support/0007-winepulse-return-PKEY_AudioEndpoint_PhysicalSpeakers.patch
	patch_apply winepulse-PulseAudio_Support/0008-winepulse-Fix-up-recording.patch
	patch_apply winepulse-PulseAudio_Support/0009-winepulse.drv-Fix-getting-the-same-timing-info.patch
	patch_apply winepulse-PulseAudio_Support/0010-winepulse-Update-last-time-on-underrun.patch
	patch_apply winepulse-PulseAudio_Support/0011-winepulse-account-for-PA-devices-that-fall-way-behin.patch
	patch_apply winepulse-PulseAudio_Support/0012-winepulse-Fix-local-buffer-offset-wrapping.patch
	patch_apply winepulse-PulseAudio_Support/0013-winepulse-Don-t-fake-being-one-period-behind-in-GetP.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winepulse.drv: Use a separate mainloop and ctx for pulse_test_connect.", 1 },';
		printf '%s\n' '+    { "Andrew Eikum", "winepulse: Don'\''t rely on pulseaudio callbacks for timing.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Expose audio devices directly to programs.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Fix segfault in pulse_rd_loop.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Implement GetPropValue.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Fetch actual program name if possible.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Return PKEY_AudioEndpoint_PhysicalSpeakers device prop.", 1 },';
		printf '%s\n' '+    { "Andrew Eikum", "winepulse: Fix up recording.", 1 },';
		printf '%s\n' '+    { "Zhiyi Zhang", "winepulse.drv: Fix getting the same timing info.", 1 },';
		printf '%s\n' '+    { "Andrew Eikum", "winepulse: Update last time on underrun.", 1 },';
		printf '%s\n' '+    { "Andrew Eikum", "winepulse: Account for PA devices that fall way behind.", 1 },';
		printf '%s\n' '+    { "Andrew Eikum", "winepulse: Fix local buffer offset wrapping.", 1 },';
		printf '%s\n' '+    { "Andrew Eikum", "winepulse: Don'\''t fake being one period behind in GetPosition.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-CandidateWindowPos
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30938] Update a XIM candidate position when cursor location changes
# |
# | Modified files:
# |   *	dlls/user32/caret.c, dlls/user32/driver.c, dlls/user32/user_private.h, dlls/winex11.drv/winex11.drv.spec,
# | 	dlls/winex11.drv/xim.c
# |
if test "$enable_winex11_CandidateWindowPos" -eq 1; then
	patch_apply winex11-CandidateWindowPos/0001-winex11.drv-Update-a-candidate-window-s-position-wit.patch
	(
		printf '%s\n' '+    { "Felix Yan", "winex11.drv: Update a candidate window'\''s position with over-the-spot style.", 2 },';
	) >> "$patchlist"
fi

# Patchset winex11-DefaultDisplayFrequency
# |
# | Modified files:
# |   *	dlls/winex11.drv/settings.c, dlls/winex11.drv/x11drv.h, dlls/winex11.drv/x11drv_main.c
# |
if test "$enable_winex11_DefaultDisplayFrequency" -eq 1; then
	patch_apply winex11-DefaultDisplayFrequency/0001-winex11.drv-Allow-to-select-default-display-frequenc.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winex11.drv: Allow to select default display frequency in registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-MWM_Decorations
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42117] Avoid double captions observed under some WMs
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_MWM_Decorations" -eq 1; then
	patch_apply winex11-MWM_Decorations/0001-winex11.drv-Don-t-use-MWM_DECOR_RESIZEH-window-resiz.patch
	patch_apply winex11-MWM_Decorations/0002-winex11.drv-Don-t-add-MWM_DECOR_BORDER-to-windows-wi.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11.drv: Don'\''t use MWM_DECOR_RESIZEH, window resizing is controlled by MWM_FUNC_RESIZE.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11.drv: Don'\''t add MWM_DECOR_BORDER to windows without a caption.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-UpdateLayeredWindow
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33943] Fix alpha blending in X11DRV_UpdateLayeredWindow
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_UpdateLayeredWindow" -eq 1; then
	patch_apply winex11-UpdateLayeredWindow/0001-winex11-Fix-alpha-blending-in-X11DRV_UpdateLayeredWi.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winex11: Fix alpha blending in X11DRV_UpdateLayeredWindow.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-Vulkan_support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44775] Allow vulkan support to be detected at runtime.
# |
# | Modified files:
# |   *	dlls/winex11.drv/vulkan.c
# |
if test "$enable_winex11_Vulkan_support" -eq 1; then
	patch_apply winex11-Vulkan_support/0001-winex11-Specify-a-default-vulkan-driver-if-one-not-f.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "winex11: Specify a default vulkan driver if one not found at build time.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-_NET_ACTIVE_WINDOW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#2155] Forward activate window requests to WM using _NET_ACTIVE_WINDOW
# |
# | Modified files:
# |   *	dlls/user32/driver.c, dlls/user32/focus.c, dlls/user32/user_private.h, dlls/winex11.drv/event.c,
# | 	dlls/winex11.drv/window.c, dlls/winex11.drv/winex11.drv.spec, dlls/winex11.drv/x11drv.h, dlls/winex11.drv/x11drv_main.c
# |
if test "$enable_winex11__NET_ACTIVE_WINDOW" -eq 1; then
	patch_apply winex11-_NET_ACTIVE_WINDOW/0001-winex11.drv-Add-support-for-_NET_ACTIVE_WINDOW.patch
	patch_apply winex11-_NET_ACTIVE_WINDOW/0002-user32-Before-asking-a-WM-to-activate-a-window-make-.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11.drv: Add support for _NET_ACTIVE_WINDOW.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Before asking a WM to activate a window make sure that the window is in foreground and not minimized.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-WM_WINDOWPOSCHANGING
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	winex11-_NET_ACTIVE_WINDOW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34594] Fix handling of WM_WINDOWPOS{CHANGING,CHANGED} for deactivated topmost window
# |
# | Modified files:
# |   *	dlls/winex11.drv/event.c
# |
if test "$enable_winex11_WM_WINDOWPOSCHANGING" -eq 1; then
	patch_apply winex11-WM_WINDOWPOSCHANGING/0001-winex11.drv-Send-WM_WINDOWPOSCHANGING-WM_WINDOWPOSCH.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11.drv: Send WM_WINDOWPOSCHANGING/WM_WINDOWPOSCHANGED messages to a being deactivated topmost window.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-Window_Style
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37876] Fix handling of window attributes for WS_EX_LAYERED | WS_EX_COMPOSITED
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_Window_Style" -eq 1; then
	patch_apply winex11-Window_Style/0001-winex11-Fix-handling-of-window-attributes-for-WS_EX_.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11: Fix handling of window attributes for WS_EX_LAYERED | WS_EX_COMPOSITED.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-XEMBED
# |
# | Modified files:
# |   *	dlls/winex11.drv/event.c
# |
if test "$enable_winex11_XEMBED" -eq 1; then
	patch_apply winex11-XEMBED/0001-winex11-Enable-disable-windows-when-they-are-un-mapped.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winex11: Enable/disable windows when they are (un)mapped by foreign applications.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-ime-check-thread-data
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#46263] Final Fantasy XI crashes after accepting EULA when using Ashita
# |   *	[#28861] Final Fantasy XI hangs after character selection
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_ime_check_thread_data" -eq 1; then
	patch_apply winex11-ime-check-thread-data/0001-winex11.drv-handle-missing-thread-data-in-X11DRV_get_ic.patch
	(
		printf '%s\n' '+    { "Enrico Horn", "winex11.drv: Handle missing thread data in X11DRV_get_ic.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-key_translation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30984] Improve key translation.
# |
# | Modified files:
# |   *	dlls/winex11.drv/keyboard.c
# |
if test "$enable_winex11_key_translation" -eq 1; then
	patch_apply winex11-key_translation/0001-winex11-Match-keyboard-in-Unicode.patch
	patch_apply winex11-key_translation/0002-winex11-Fix-more-key-translation.patch
	patch_apply winex11-key_translation/0003-winex11.drv-Fix-main-Russian-keyboard-layout.patch
	(
		printf '%s\n' '+    { "Ken Thomases", "winex11: Match keyboard in Unicode.", 1 },';
		printf '%s\n' '+    { "Philippe Valembois", "winex11: Fix more key translation.", 1 },';
		printf '%s\n' '+    { "Ondrej Kraus", "winex11.drv: Fix main Russian keyboard layout.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-wglShareLists
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#11436] Do not fail when a used context is passed to wglShareLists
# |   *	[#25419] Fix broken textures in XIII Century: Death or Glory
# |
# | Modified files:
# |   *	dlls/opengl32/tests/opengl.c, dlls/winex11.drv/opengl.c
# |
if test "$enable_winex11_wglShareLists" -eq 1; then
	patch_apply winex11-wglShareLists/0001-winex11.drv-Only-warn-about-used-contexts-in-wglShar.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winex11.drv: Only warn about used contexts in wglShareLists.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11.drv-Query_server_position
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#15346] winex11.drv: Query the X server for the actual rect of the window before unmapping it
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_drv_Query_server_position" -eq 1; then
	patch_apply winex11.drv-Query_server_position/0001-winex11.drv-window-Query-the-X-server-for-the-actual.patch
	(
		printf '%s\n' '+    { "Gabriel Ivăncescu", "winex11.drv/window: Query the X server for the actual rect of the window before unmapping it.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-Cleanup
# |
# | Modified files:
# |   *	dlls/wininet/http.c, dlls/wininet/tests/http.c
# |
if test "$enable_wininet_Cleanup" -eq 1; then
	patch_apply wininet-Cleanup/0001-wininet-tests-Add-more-tests-for-cookies.patch
	patch_apply wininet-Cleanup/0002-wininet-tests-Test-auth-credential-reusage-with-host.patch
	patch_apply wininet-Cleanup/0003-wininet-tests-Check-cookie-behaviour-when-overriding.patch
	patch_apply wininet-Cleanup/0004-wininet-Strip-filename-if-no-path-is-set-in-cookie.patch
	patch_apply wininet-Cleanup/0005-wininet-Replacing-header-fields-should-fail-if-they-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wininet/tests: Add more tests for cookies.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet/tests: Test auth credential reusage with host override.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet/tests: Check cookie behaviour when overriding host.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet: Strip filename if no path is set in cookie.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet: Replacing header fields should fail if they do not exist yet.", 1 },';
	) >> "$patchlist"
fi

# Patchset winmm-Delay_Import_Depends
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37983] Jedi Knight: Dark Forces II crashes with winmm set to native
# |
# | Modified files:
# |   *	dlls/winmm/Makefile.in
# |
if test "$enable_winmm_Delay_Import_Depends" -eq 1; then
	patch_apply winmm-Delay_Import_Depends/0001-winmm-Delay-import-ole32-msacm32-to-workaround-bug-w.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winmm: Delay import ole32 msacm32 to workaround bug when loading multiple winmm versions.", 1 },';
	) >> "$patchlist"
fi

# Patchset winmm-mciSendCommandA
# |
# | Modified files:
# |   *	dlls/winmm/mci.c
# |
if test "$enable_winmm_mciSendCommandA" -eq 1; then
	patch_apply winmm-mciSendCommandA/0001-winmm-Do-not-crash-in-Win-9X-mode-when-an-invalid-de.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winmm: Do not crash in Win 9X mode when an invalid device ptr is passed to MCI_OPEN.", 1 },';
	) >> "$patchlist"
fi

# Patchset wintab32-improvements
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#11846] Improve pressure sensitivity.
# |   *	[#15443] Improve Wacom Bambo drawing support
# |   *	[#18517] Improve eraser from working.
# |
# | Modified files:
# |   *	dlls/winex11.drv/wintab.c, dlls/wintab32/context.c
# |
if test "$enable_wintab32_improvements" -eq 1; then
	patch_apply wintab32-improvements/0002-wintab32-Set-lcSysExtX-Y-for-the-first-index-of-WTI_.patch
	patch_apply wintab32-improvements/0003-winex11-Handle-negative-orAltitude-values.patch
	patch_apply wintab32-improvements/0004-winex11.drv-Support-multiplex-categories-WTI_DSCTXS-.patch
	patch_apply wintab32-improvements/0005-winex11-Support-WTI_STATUS-in-WTInfo.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "wintab32: Set lcSysExtX/Y for the first index of WTI_DDCTXS.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "winex11: Handle negative orAltitude values.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "winex11.drv: Support multiplex categories WTI_DSCTXS and WTI_DDCTXS.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "winex11: Support WTI_STATUS in WTInfo.", 1 },';
	) >> "$patchlist"
fi

# Patchset wintrust-WTHelperGetProvCertFromChain
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#44061] Check Parameter in WTHelperGetProvCertFromChain
# |
# | Modified files:
# |   *	dlls/wintrust/tests/softpub.c, dlls/wintrust/wintrust_main.c
# |
if test "$enable_wintrust_WTHelperGetProvCertFromChain" -eq 1; then
	patch_apply wintrust-WTHelperGetProvCertFromChain/0001-wintrust-Add-parameter-check-in-WTHelperGetProvCertF.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "wintrust: Add parameter check in WTHelperGetProvCertFromChain.", 1 },';
	) >> "$patchlist"
fi

# Patchset wpcap-Dynamic_Linking
# |
# | Modified files:
# |   *	configure.ac, dlls/wpcap/Makefile.in, dlls/wpcap/wpcap.c
# |
if test "$enable_wpcap_Dynamic_Linking" -eq 1; then
	patch_apply wpcap-Dynamic_Linking/0001-wpcap-Load-libpcap-dynamically.patch
	(
		printf '%s\n' '+    { "André Hentschel", "wpcap: Load libpcap dynamically.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-APC_Performance
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c
# |
if test "$enable_ws2_32_APC_Performance" -eq 1; then
	patch_apply ws2_32-APC_Performance/0001-ws2_32-Reuse-old-async-ws2_async_io-structures-if-po.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Reuse old async ws2_async_io structures if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-Connect_Time
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_Connect_Time" -eq 1; then
	patch_apply ws2_32-Connect_Time/0001-ws2_32-Implement-returning-the-proper-time-with-SO_C.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Implement returning the proper time with SO_CONNECT_TIME.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-TransmitFile
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-Token_Integrity_Level, kernel32-K32GetPerformanceInfo, ntdll-
# | 	Junction_Points, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-User_Shared_Data, winebuild-Fake_Dlls, ntdll-
# | 	RtlCreateUserThread, ntdll-Exception, ntdll-SystemRoot_Symlink, server-Realtime_Priority, ntdll-Threading, ntdll-
# | 	Wait_User_APC, server-Key_State, server-PeekMessage, server-Signal_Thread, server-Shared_Memory, ws2_32-WSACleanup,
# | 	eventfd_synchronization, server-Desktop_Refcount
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, include/winsock.h, server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_TransmitFile" -eq 1; then
	patch_apply ws2_32-TransmitFile/0001-ws2_32-Add-support-for-TF_DISCONNECT-to-TransmitFile.patch
	patch_apply ws2_32-TransmitFile/0002-ws2_32-Add-support-for-TF_REUSE_SOCKET-to-TransmitFi.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "ws2_32: Add support for TF_DISCONNECT to TransmitFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ws2_32: Add support for TF_REUSE_SOCKET to TransmitFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-getaddrinfo
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c
# |
if test "$enable_ws2_32_getaddrinfo" -eq 1; then
	patch_apply ws2_32-getaddrinfo/0001-ws2_32-Fix-handling-of-empty-string-in-WS_getaddrinf.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Fix handling of empty string in WS_getaddrinfo.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-getsockopt
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8606] Divide values returned by SO_RCVBUF and SO_SNDBUF getsockopt options by two
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c
# |
if test "$enable_ws2_32_getsockopt" -eq 1; then
	patch_apply ws2_32-getsockopt/0001-ws2_32-Divide-values-returned-by-SO_RCVBUF-and-SO_SN.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Divide values returned by SO_RCVBUF and SO_SNDBUF getsockopt options by two.", 1 },';
	) >> "$patchlist"
fi

# Patchset wtsapi32-EnumerateProcesses
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29903] Support for WTSEnumerateProcessesW
# |
# | Modified files:
# |   *	dlls/wtsapi32/tests/wtsapi.c, dlls/wtsapi32/wtsapi32.c
# |
if test "$enable_wtsapi32_EnumerateProcesses" -eq 1; then
	patch_apply wtsapi32-EnumerateProcesses/0001-wtsapi32-Partial-implementation-of-WTSEnumerateProce.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wtsapi32: Partial implementation of WTSEnumerateProcessesW.", 1 },';
	) >> "$patchlist"
fi

# Patchset wusa-MSU_Package_Installer
# |
# | Modified files:
# |   *	programs/wusa/main.c, programs/wusa/manifest.c, programs/wusa/wusa.h
# |
if test "$enable_wusa_MSU_Package_Installer" -eq 1; then
	patch_apply wusa-MSU_Package_Installer/0005-wusa-Add-workaround-to-be-compatible-with-Vista-pack.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wusa: Add workaround to be compatible with Vista packages.", 1 },';
	) >> "$patchlist"
fi


if test "$enable_patchlist" -eq 1; then

	# Generate a temporary patch containing the patchlist and apply it
	patch_data=$(cat "$patchlist" | sort)
	if test ! -z "$patch_data"; then
		patch_lines=$(printf '%s\n' "$patch_data" | wc -l)
		patch_lines=$((${patch_lines}+21))
		cat > "$patchlist" <<EOF
From: Wine Staging Team <webmaster@fds-team.de>
Subject: Autogenerated patch list.

diff --git a/libs/wine/config.c b/libs/wine/config.c
index 5262c76..0a3182f 100644
--- a/libs/wine/config.c
+++ b/libs/wine/config.c
@@ -478,10 +478,${patch_lines} @@ const char *wine_get_version(void)
     return PACKAGE_VERSION;
 }
 
+static const struct
+{
+    const char *author;
+    const char *subject;
+    int revision;
+}
+wine_patch_data[] =
+{
${patch_data}
+    { NULL, NULL, 0 }
+};
+
 /* return the applied non-standard patches */
 const void *wine_get_patches(void)
 {
-    return NULL;
+    return &wine_patch_data[0];
 }
 
 /* return the build id string */
EOF
		patch_apply_file "$patchlist"
	fi
	rm "$patchlist"
fi

if test "$enable_autoconf" -eq 1; then
	if ! update_configure; then
		abort "'autoreconf -f' failed."
	fi
	if ! update_protocol; then
		abort "'./tools/make_requests' failed."
	fi
fi
# Success
exit 0
