/*
Copyright (C) 2015 Victor Luchits

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __UI_FIELD_H__
#define __UI_FIELD_H__

#include "kernel/ui_utils.h"
#include "kernel/ui_common.h"

namespace Rocket
{
namespace Controls
{
	class DataFormatter;
}
}

namespace WSWUI
{
	// this element does nothing but formatting its "value" with specified "formatter"
	// and the emitting the output as text
	class ElementL10n : public Rocket::Core::Element
	{
	public:
		ElementL10n(const Rocket::Core::String& tag);
		virtual ~ElementL10n(){}

		/// Checks for changes to source address.
		virtual void OnAttributeChange(const Rocket::Core::AttributeNameList&);

	private:
		Rocket::Controls::DataFormatter *data_formatter;
		Rocket::Core::String format;
		unsigned int num_args;


		static const unsigned int max_args = 8;
	};
}

#endif // __UI_FIELD_H__
