/*
 * Copyright 2015 MovingBlocks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.terasology.unicode;

/**
 * Unicode Dingbats block with renderable (all) characters from u2700 to u27BF. Unicode 4.1.0.
 */
public final class Dingbats {

   public static final char UPPER_BLADE_SCISSORS = '\u2701';
   public static final char BLACK_SCISSORS = '\u2702';
   public static final char LOWER_BLADE_SCISSORS = '\u2703';
   public static final char WHITE_SCISSORS = '\u2704';
   public static final char TELEPHONE_LOCATION_SIGN = '\u2706';
   public static final char TAPE_DRIVE = '\u2707';
   public static final char AIRPLANE = '\u2708';
   public static final char ENVELOPE = '\u2709';
   public static final char VICTORY_HAND = '\u270C';
   public static final char WRITING_HAND = '\u270D';
   public static final char LOWER_RIGHT_PENCIL = '\u270E';
   public static final char PENCIL = '\u270F';
   public static final char UPPER_RIGHT_PENCIL = '\u2710';
   public static final char WHITE_NIB = '\u2711';
   public static final char BLACK_NIB = '\u2712';
   public static final char CHECK_MARK = '\u2713';
   public static final char HEAVY_CHECK_MARK = '\u2714';
   public static final char MULTIPLICATION_X = '\u2715';
   public static final char HEAVY_MULTIPLICATION_X = '\u2716';
   public static final char BALLOT_X = '\u2717';
   public static final char HEAVY_BALLOT_X = '\u2718';
   public static final char OUTLINED_GREEK_CROSS = '\u2719';
   public static final char HEAVY_GREEK_CROSS = '\u271A';
   public static final char OPEN_CENTER_CROSS = '\u271B';
   public static final char HEAVY_OPEN_CENTER_CROSS = '\u271C';
   public static final char LATIN_CROSS = '\u271D';
   public static final char SHADOWED_WHITE_LATIN_CROSS = '\u271E';
   public static final char OUTLINED_LATIN_CROSS = '\u271F';
   public static final char MALTESE_CROSS = '\u2720';
   public static final char STAR_OF_DAVID = '\u2721';
   public static final char FOUR_TEARDROP_SPOKED_ASTERISK = '\u2722';
   public static final char FOUR_BALLOON_SPOKED_ASTERISK = '\u2723';
   public static final char HEAVY_FOUR_BALLOON_SPOKED_ASTERISK = '\u2724';
   public static final char FOUR_CLUB_SPOKED_ASTERISK = '\u2725';
   public static final char BLACK_FOUR_POINTED_STAR = '\u2726';
   public static final char WHITE_FOUR_POINTED_STAR = '\u2727';
   public static final char STRESS_OUTLINED_WHITE_STAR = '\u2729';
   public static final char CIRCLED_WHITE_STAR = '\u272A';
   public static final char OPEN_CENTER_BLACK_STAR = '\u272B';
   public static final char BLACK_CENTER_WHITE_STAR = '\u272C';
   public static final char OUTLINED_BLACK_STAR = '\u272D';
   public static final char HEAVY_OUTLINED_BLACK_STAR = '\u272E';
   public static final char PINWHEEL_STAR = '\u272F';
   public static final char SHADOWED_WHITE_STAR = '\u2730';
   public static final char HEAVY_ASTERISK = '\u2731';
   public static final char OPEN_CENTER_ASTERISK = '\u2732';
   public static final char EIGHT_SPOKED_ASTERISK = '\u2733';
   public static final char EIGHT_POINTED_BLACK_STAR = '\u2734';
   public static final char EIGHT_POINTED_PINWHEEL_STAR = '\u2735';
   public static final char SIX_POINTED_BLACK_STAR = '\u2736';
   public static final char EIGHT_POINTED_RECTILINEAR_BLACK_STAR = '\u2737';
   public static final char HEAVY_EIGHT_POINTED_RECTILINEAR_BLACK_STAR = '\u2738';
   public static final char TWELVE_POINTED_BLACK_STAR = '\u2739';
   public static final char SIXTEEN_POINTED_ASTERISK = '\u273A';
   public static final char TEARDROP_SPOKED_ASTERISK = '\u273B';
   public static final char OPEN_CENTER_TEARDROP_SPOKED_ASTERISK = '\u273C';
   public static final char HEAVY_TEARDROP_SPOKED_ASTERISK = '\u273D';
   public static final char SIX_PETALLED_BLACK_AND_WHITE_FLORETTE = '\u273E';
   public static final char BLACK_FLORETTE = '\u273F';
   public static final char WHITE_FLORETTE = '\u2740';
   public static final char EIGHT_PETALLED_OUTLINED_BLACK_FLORETTE = '\u2741';
   public static final char CIRCLED_OPEN_CENTER_EIGHT_POINTED_STAR = '\u2742';
   public static final char HEAVY_TEARDROP_SPOKED_PINWHEEL_ASTERISK = '\u2743';
   public static final char SNOWFLAKE = '\u2744';
   public static final char TIGHT_TRIFOLIATE_SNOWFLAKE = '\u2745';
   public static final char HEAVY_CHEVRON_SNOWFLAKE = '\u2746';
   public static final char SPARKLE = '\u2747';
   public static final char HEAVY_SPARKLE = '\u2748';
   public static final char BALLOON_SPOKED_ASTERISK = '\u2749';
   public static final char EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK = '\u274A';
   public static final char HEAVY_EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK = '\u274B';
   public static final char SHADOWED_WHITE_CIRCLE = '\u274D';
   public static final char LOWER_RIGHT_DROP_SHADOWED_WHITE_SQUARE = '\u274F';
   public static final char UPPER_RIGHT_DROP_SHADOWED_WHITE_SQUARE = '\u2750';
   public static final char LOWER_RIGHT_SHADOWED_WHITE_SQUARE = '\u2751';
   public static final char UPPER_RIGHT_SHADOWED_WHITE_SQUARE = '\u2752';
   public static final char BLACK_DIAMOND_MINUS_WHITE_X = '\u2756';
   public static final char LIGHT_VERTICAL_BAR = '\u2758';
   public static final char MEDIUM_VERTICAL_BAR = '\u2759';
   public static final char HEAVY_VERTICAL_BAR = '\u275A';
   public static final char HEAVY_SINGLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT = '\u275B';
   public static final char HEAVY_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT = '\u275C';
   public static final char HEAVY_DOUBLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT = '\u275D';
   public static final char HEAVY_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT = '\u275E';
   public static final char CURVED_STEM_PARAGRAPH_SIGN_ORNAMENT = '\u2761';
   public static final char HEAVY_EXCLAMATION_MARK_ORNAMENT = '\u2762';
   public static final char HEAVY_HEART_EXCLAMATION_MARK_ORNAMENT = '\u2763';
   public static final char HEAVY_BLACK_HEART = '\u2764';
   public static final char ROTATED_HEAVY_BLACK_HEART_BULLET = '\u2765';
   public static final char FLORAL_HEART = '\u2766';
   public static final char ROTATED_FLORAL_HEART_BULLET = '\u2767';
   public static final char MEDIUM_LEFT_PARENTHESIS_ORNAMENT = '\u2768';
   public static final char MEDIUM_RIGHT_PARENTHESIS_ORNAMENT = '\u2769';
   public static final char MEDIUM_FLATTENED_LEFT_PARENTHESIS_ORNAMENT = '\u276A';
   public static final char MEDIUM_FLATTENED_RIGHT_PARENTHESIS_ORNAMENT = '\u276B';
   public static final char MEDIUM_LEFT_POINTING_ANGLE_BRACKET_ORNAMENT = '\u276C';
   public static final char MEDIUM_RIGHT_POINTING_ANGLE_BRACKET_ORNAMENT = '\u276D';
   public static final char HEAVY_LEFT_POINTING_ANGLE_QUOTATION_MARK_ORNAMENT = '\u276E';
   public static final char HEAVY_RIGHT_POINTING_ANGLE_QUOTATION_MARK_ORNAMENT = '\u276F';
   public static final char HEAVY_LEFT_POINTING_ANGLE_BRACKET_ORNAMENT = '\u2770';
   public static final char HEAVY_RIGHT_POINTING_ANGLE_BRACKET_ORNAMENT = '\u2771';
   public static final char LIGHT_LEFT_TORTOISE_SHELL_BRACKET_ORNAMENT = '\u2772';
   public static final char LIGHT_RIGHT_TORTOISE_SHELL_BRACKET_ORNAMENT = '\u2773';
   public static final char MEDIUM_LEFT_CURLY_BRACKET_ORNAMENT = '\u2774';
   public static final char MEDIUM_RIGHT_CURLY_BRACKET_ORNAMENT = '\u2775';
   public static final char INVERSE_CIRCLED_DIGIT_ONE = '\u2776';
   public static final char INVERSE_CIRCLED_DIGIT_TWO = '\u2777';
   public static final char INVERSE_CIRCLED_DIGIT_THREE = '\u2778';
   public static final char INVERSE_CIRCLED_DIGIT_FOUR = '\u2779';
   public static final char INVERSE_CIRCLED_DIGIT_FIVE = '\u277A';
   public static final char INVERSE_CIRCLED_DIGIT_SIX = '\u277B';
   public static final char INVERSE_CIRCLED_DIGIT_SEVEN = '\u277C';
   public static final char INVERSE_CIRCLED_DIGIT_EIGHT = '\u277D';
   public static final char INVERSE_CIRCLED_DIGIT_NINE = '\u277E';
   public static final char INVERSE_CIRCLED_NUMBER_TEN = '\u277F';
   public static final char CIRCLED_SANS_SERIF_DIGIT_ONE = '\u2780';
   public static final char CIRCLED_SANS_SERIF_DIGIT_TWO = '\u2781';
   public static final char CIRCLED_SANS_SERIF_DIGIT_THREE = '\u2782';
   public static final char CIRCLED_SANS_SERIF_DIGIT_FOUR = '\u2783';
   public static final char CIRCLED_SANS_SERIF_DIGIT_FIVE = '\u2784';
   public static final char CIRCLED_SANS_SERIF_DIGIT_SIX = '\u2785';
   public static final char CIRCLED_SANS_SERIF_DIGIT_SEVEN = '\u2786';
   public static final char CIRCLED_SANS_SERIF_DIGIT_EIGHT = '\u2787';
   public static final char CIRCLED_SANS_SERIF_DIGIT_NINE = '\u2788';
   public static final char CIRCLED_SANS_SERIF_NUMBER_TEN = '\u2789';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_ONE = '\u278A';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_TWO = '\u278B';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_THREE = '\u278C';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_FOUR = '\u278D';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_FIVE = '\u278E';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_SIX = '\u278F';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_SEVEN = '\u2790';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_EIGHT = '\u2791';
   public static final char INVERSE_CIRCLED_SANS_SERIF_DIGIT_NINE = '\u2792';
   public static final char INVERSE_CIRCLED_SANS_SERIF_NUMBER_TEN = '\u2793';
   public static final char HEAVY_WIDE_HEADED_RIGHT_ARROW = '\u2794';
   public static final char HEAVY_LOWER_RIGHT_ARROW = '\u2798';
   public static final char HEAVY_RIGHT_ARROW = '\u2799';
   public static final char HEAVY_UPPER_RIGHT_ARROW = '\u279A';
   public static final char DRAFTING_POINT_RIGHT_ARROW = '\u279B';
   public static final char HEAVY_ROUND_TIPPED_RIGHT_ARROW = '\u279C';
   public static final char TRIANGLE_HEADED_RIGHT_ARROW = '\u279D';
   public static final char HEAVY_TRIANGLE_HEADED_RIGHT_ARROW = '\u279E';
   public static final char DASHED_TRIANGLE_HEADED_RIGHT_ARROW = '\u279F';
   public static final char HEAVY_DASHED_TRIANGLE_HEADED_RIGHT_ARROW = '\u27A0';
   public static final char BLACK_RIGHT_ARROW = '\u27A1';
   public static final char THREE_D_TOP_LIGHTED_RIGHT_ARROWHEAD = '\u27A2';
   public static final char THREE_D_BOTTOM_LIGHTED_RIGHT_ARROWHEAD = '\u27A3';
   public static final char BLACK_RIGHT_ARROWHEAD = '\u27A4';
   public static final char HEAVY_BLACK_CURVED_DOWN_AND_RIGHT_ARROW = '\u27A5';
   public static final char HEAVY_BLACK_CURVED_UP_AND_RIGHT_ARROW = '\u27A6';
   public static final char SQUAT_BLACK_RIGHT_ARROW = '\u27A7';
   public static final char HEAVY_CONCAVE_POINTED_BLACK_RIGHT_ARROW = '\u27A8';
   public static final char RIGHT_SHADED_WHITE_RIGHT_ARROW = '\u27A9';
   public static final char LEFT_SHADED_WHITE_RIGHT_ARROW = '\u27AA';
   public static final char BACK_TILTED_SHADOWED_WHITE_RIGHT_ARROW = '\u27AB';
   public static final char FRONT_TILTED_SHADOWED_WHITE_RIGHT_ARROW = '\u27AC';
   public static final char HEAVY_LOWER_RIGHT_SHADOWED_WHITE_RIGHT_ARROW = '\u27AD';
   public static final char HEAVY_UPPER_RIGHT_SHADOWED_WHITE_RIGHT_ARROW = '\u27AE';
   public static final char NOTCHED_LOWER_RIGHT_SHADOWED_WHITE_RIGHT_ARROW = '\u27AF';
   public static final char NOTCHED_UPPER_RIGHT_SHADOWED_WHITE_RIGHT_ARROW = '\u27B1';
   public static final char CIRCLED_HEAVY_WHITE_RIGHT_ARROW = '\u27B2';
   public static final char WHITE_FEATHERED_RIGHT_ARROW = '\u27B3';
   public static final char BLACK_FEATHERED_LOWER_RIGHT_ARROW = '\u27B4';
   public static final char BLACK_FEATHERED_RIGHT_ARROW = '\u27B5';
   public static final char BLACK_FEATHERED_UPPER_RIGHT_ARROW = '\u27B6';
   public static final char HEAVY_BLACK_FEATHERED_LOWER_RIGHT_ARROW = '\u27B7';
   public static final char HEAVY_BLACK_FEATHERED_RIGHT_ARROW = '\u27B8';
   public static final char HEAVY_BLACK_FEATHERED_UPPER_RIGHT_ARROW = '\u27B9';
   public static final char TEARDROP_BARBED_RIGHT_ARROW = '\u27BA';
   public static final char HEAVY_TEARDROP_SHANKED_RIGHT_ARROW = '\u27BB';
   public static final char WEDGE_TAILED_RIGHT_ARROW = '\u27BC';
   public static final char HEAVY_WEDGE_TAILED_RIGHT_ARROW = '\u27BD';
   public static final char OPEN_OUTLINED_RIGHT_ARROW = '\u27BE';

   private Dingbats() {
       // no instances
   }
}
