/*
 * Copyright 2014 MovingBlocks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NUI (Nice UI Framework) is a canvas based UI framework.
 *
 * Its major features are:
 * <ul>
 *  <li>Canvas providing primitive draw operations for UI, including "drawing" interaction regions.</li>
 *  <li>Skins providing display information, handled through the canvas operations.</li>
 *  <li>UIWidget system for encapsulating drawing logic into objects</li>
 *  <li>Skin asset providing the ability to define skins</li>
 *  <li>UI asset providing the ability to define widget layouts</li>
 *  <li>Databinding support</li>
 * </ul>
 */
@API package org.terasology.rendering.nui;

import org.terasology.module.sandbox.API;
