/*
 * Copyright 2014 MovingBlocks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.terasology.rendering.nui;

/**
 * This interface is for widgets that can be used as root nodes of widget structures.
 * They are initialised when added to the UI, and are eligable for injection - but only
 * when they are at the root of the structure.
 */
public interface ControlWidget extends UIWidget {

    void initialise();

    void onOpened();

    void onClosed();

}
