/*
 * Copyright 2013 MovingBlocks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.terasology.persistence.serializers;

import org.terasology.entitySystem.Component;
import org.terasology.entitySystem.entity.internal.EntityInfoComponent;
import org.terasology.entitySystem.metadata.ComponentMetadata;

/**
 * Interface for checks as whether a component should be serialized
 */
@FunctionalInterface
public interface ComponentSerializeCheck {

    boolean serialize(ComponentMetadata<? extends Component> metadata);

    public static final class NullCheck implements ComponentSerializeCheck {
        private static final NullCheck INSTANCE = new NullCheck();

        private NullCheck() {
        }

        public static ComponentSerializeCheck create() {
            return INSTANCE;
        }

        @Override
        public boolean serialize(ComponentMetadata<? extends Component> metadata) {
            return metadata.getType() != EntityInfoComponent.class;
        }
    }
}
