/*
 * Copyright 2013 MovingBlocks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.terasology.network.events;

import org.terasology.entitySystem.event.Event;
import org.terasology.persistence.PlayerStore;

/**
 * Event notifying that a new client has connected - sent against the client by the network system.
 *
 */
public class ConnectedEvent implements Event {

    private PlayerStore playerStore;

    public ConnectedEvent(PlayerStore store) {
        this.playerStore = store;
    }

    /**
     * @return The PlayerStore for the connecting player. It is ready to restore any stored entities.
     */
    public PlayerStore getPlayerStore() {
        return playerStore;
    }

}
