/**
 * @defgroup Bookmarks Bookmarks
 * @ingroup PlayerPlugins
 */

/**
 * @defgroup Equalizer 
 * @ingroup PlayerPlugins
 */

/**
 * @defgroup Components Basic Components
 */

/**
 * @defgroup Broadcasting
 * @ingroup Components
 */

/**
 * @defgroup Covers Covers
 * @brief Contains everythin about cover management. Logic and UI
 * @ingroup Components
 */

/**
 * @defgroup Engine
 * @brief Contains classes used for Sound
 * @ingroup Components
 */

/**
 * @defgroup EngineHelper
 * @ingroup Engine
 * @ingroup Helper
 */


/**
 * @defgroup GUICovers
 * @brief UI side of cover management
 * @ingroup Covers
 * @ingroup GUI
 */

/** 
 * @defgroup Playlists
 * @ingroup Components
 */

/**
 * @defgroup Streams
 * @ingroup Components
 */

/**
 * @defgroup PlaylistHelper Playlist Helpers
 * @brief Classes for handling playlist DB saving and loading
 * @ingroup Playlists
 * @ingroup Helper
 */

/**
 * @defgroup PlaylistParser Playlist Parser
 * @brief Parsers for pls, m3u and asx
 * @ingroup Helper
 */


/**
 * @defgroup Tagging Tagging
 * @brief Metadata tagging
 * @ingroup Components
 */

/**
 * @defgroup Xiph
 * @brief Xiph related header
 * @ingroup Tagging
 */

/**
 * @defgroup ID3v2
 * @brief ID3v2 related header
 * @ingroup Tagging
 */

/**
 * @defgroup MTP MTP Structures
 * @ingroup Components
 */

/**
 * @defgroup Lyrics Lyrics Classes
 * @ingroup Components
 */

/**
 * @defgroup Helper Helper
 * @brief everything what's highly reusable
 */

/**
 * @defgroup MetaDataHelper MetaData Helper
 * @ingroup Helper
 */

/**
 * @defgroup Settings Settings classes
 * @brief the Settings framework
 * @ingroup Helper
 */




/**
 * @defgroup Interfaces Interfaces
 */

/**
 * @defgroup EngineInterfaces
 * @ingroup Engine
 * @ingroup Interfaces
 */


/**
 * @defgroup Library
 * @brief Basic library functions
 * @ingroup Components
 */

/**
 * @defgroup LibraryHelper Library Helper
 * @brief Static Library types and enumerations
 * @ingroup Helper
 * @ingroup Library
 */


/**
 * @defgroup Plugins
 * @brief Library and player plugins
 */

/**
 * @defgroup PlayerPlugins Player Plugins
 * @brief Those little plugins shown between player and playlist
 * @ingroup Plugins
 */

/**
 * @defgroup LibraryPlugins Library Plugins
 * @brief External library view handling
 * @ingroup Plugins
 */

/**
 * @defgroup GUI
 * @brief everything that belongs to the GUI
 */

/**
 * @defgroup GUIHelper GUI Helper
 * @brief highly reusable classes used by the GUI
 * @ingroup GUI
 */

/**
 * @defgroup GUIInterfaces
 * @brief Interfaces for common GUI classes
 */

/**
 * @defgroup Widgets
 * @brief Sayonara widgets
 * @ingroup GUIHelper
 */



/**
 * @defgroup Preferences Preference Dialog
 * @ingroup GUI
 */

/**
 * @defgroup Shortcuts Shortcuts
 * @brief Shortcut handling
 * @ingroup GUI
 */


