TEMPLATE = app
DESTDIR=$$PWD/../bin

include(../install.pri)

# Share object files for faster compiling
RCC_DIR     = $$PWD/.rcc
UI_DIR      = $$PWD/.ui
MOC_DIR     = $$PWD/.moc
OBJECTS_DIR = $$PWD/.obj

CONFIG += qt
CONFIG += warn_on

unix {
    TARGET = qmultirecord
    LIBS += -L../../lib

    INCLUDEPATH += /usr/include/libburn
    LIBS += -lburn
}

QT += core widgets gui xml dbus

RC_FILE = $$PWD/qmultirecord.rc

DEFINES += HAVE_LOCALE

####### Core ###########
SOURCES += application.cpp \
           dvdmodel.cpp \
           checkthread.cpp \
           burnthread.cpp \
           dvdview.cpp \
           generatethread.cpp \
           generatedialog.cpp \
           settingsdialog.cpp \
           selectdialog.cpp \
           nofocusitemdelegate.cpp \
           checkableitemdelegate.cpp \
           drivestablemodel.cpp

HEADERS += application.h \
           dvdmodel.h \
           checkthread.h \
           burnthread.h \
           dvdview.h \
           generatethread.h \
           generatedialog.h \
           settingsdialog.h \
           selectdialog.h \
           nofocusitemdelegate.h \
           checkableitemdelegate.h \
           drivestablemodel.h

FORMS += dvdview.ui settingsdialog.ui generatedialog.ui selectdialog.ui
RESOURCES += dvdview.qrc \
             qmultirecord.qrc

##### Application #######
SOURCES += main.cpp \
    mainwindow.cpp

HEADERS += mainwindow.h

unix {
    INSTALLS += desktop icon48

    desktop.path = $$DATADIR/applications
    desktop.files += qmultirecord.desktop

    icon48.path = $$DATADIR/icons/hicolor/48x48/apps
    icon48.files += icons/qmultirecord.png
}
