/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include "define.h"

#include <QDialog>
#include "ui_settingsdialog.h"

class DrivesTableModel;

class SettingsDialog : public QDialog, Ui_SettingsDialog
{
    Q_OBJECT
public:
    explicit SettingsDialog(QWidget *parent = 0);

    bool drivesConfigChanged() const;

//Q_SIGNALS:
    
public Q_SLOTS:
    void accept();

protected:
    void closeEvent(QCloseEvent *event);

private Q_SLOTS:
    void on_addPathButton_clicked();
    void on_removePathButton_clicked();
    //void on_hashButton_clicked();

//#if HAVE_QT5
//    void drivesModelDataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight, const QVector<int> & roles = QVector<int> ());
//#else
    void drivesModelDataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight);
//#endif

private:
    void updateButtons();
    bool isChecked(const QString &itemName);

    bool m_drivesConfigChanged;
    DrivesTableModel *m_model;
};

#endif // SETTINGSDIALOG_H
