/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
//! -*- coding: UTF-8 -*-
#define SOURCE_CODING "UTF-8"

#include <QtCore>
#include <QtGui>

#include "application.h"
#include "selectdialog.h"

//!
SelectDialog::SelectDialog(QWidget *parent, Qt::WindowFlags f)
    : QDialog(parent, f) {
    setupUi(this);
}

//!
SelectDialog::~SelectDialog() {
    //
}

//!
void SelectDialog::init(const QStringList& list) {
    listWidget->blockSignals(true);
    listWidget->addItems(list);

    m_checkedCount = 0;
    for (int i=0; i < listWidget->count(); i++) {
        QListWidgetItem *item = listWidget->item(i);
        item->setFlags(Qt::ItemIsUserCheckable | Qt::ItemIsEnabled | Qt::ItemIsSelectable);
        item->setCheckState(Qt::Checked);
        m_checkedCount++;
    }

    canContinue();

    listWidget->blockSignals(false);
}

//!
bool SelectDialog::isChecked(const QString &itemName) {
    QList<QListWidgetItem *> items = listWidget->findItems(itemName, Qt::MatchExactly);
    if (items.size() > 0) {
        return (items.at(0)->checkState() == Qt::Checked);
    }

    return false;
}

void SelectDialog::on_listWidget_itemChanged(QListWidgetItem *item) {
    qDebug() << "item changed";

    if (item->checkState() == Qt::Checked) {
        m_checkedCount++;
    } else {
        m_checkedCount--;
    }

    canContinue();
}

void SelectDialog::canContinue() {
    qDebug() << "SelectDialog::canContinue : checkedCount = " << m_checkedCount;
    if (m_checkedCount > 0) {
        buttonBox->button(QDialogButtonBox::Ok)->setEnabled(true);
    } else {
        buttonBox->button(QDialogButtonBox::Ok)->setEnabled(false);
    }
}
