/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/

#ifndef _NOFOCUSITEMDELEGATE_H_
#define _NOFOCUSITEMDELEGATE_H_

#include <QItemDelegate>

/** 
 * class NoFocusItemDelegate represents table cell with no input focus (base class for other project delegates).
 */
class NoFocusItemDelegate: public QItemDelegate {
Q_OBJECT

public:
    NoFocusItemDelegate(QObject *apParent = 0) : QItemDelegate(apParent) {};
    virtual ~NoFocusItemDelegate() {};
    
    virtual void drawFocus ( QPainter * /*painter*/, const QStyleOptionViewItem & /*option*/, const QRect & /*rect*/ ) const {};
    virtual void paint(QPainter * apPainter, const QStyleOptionViewItem & aOption, const QModelIndex & aIndex) const;

};

#endif /* _NOFOCUSITEMDELEGATE_H_ */
