/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#define SOURCE_CODING "UTF-8"

#include <QtCore>
#include <QtGui>

#include "application.h"

#include "selectdialog.h"
#include "dvdview.h"
#include "mainwindow.h"


MainWindow::MainWindow(QWidget * parent, Qt::WindowFlags f)
    : QMainWindow(parent, f)
{
    qDebug() << "MainWindow::MainWindow";
    setWindowTitle("QMultirecord burning tool");
    setWindowIcon(QIcon(QPixmap(":icons/qmultirecord.png")));
}

MainWindow::~MainWindow() {
    qDebug() << "MainWindow::~MainWindow";

    DvdModel::finalize();
}

void MainWindow::showSettings() {
    QList<DvdModel *> list = DvdModel::devices();
    for (int i=0; i < list.size(); i++) {
        if (list.at(i)->enabled()) {
            if ((list.at(i)->processMode() == DvdModel::pmWriting) ||
                (list.at(i)->processMode() == DvdModel::pmChecking))
            {
                QMessageBox::warning(this, tr("QMultiRecord"),
                                     tr("Settings are not allowed while drives are busy."),
                                     QMessageBox::Close,
                                     QMessageBox::Close);

                return ;
            }
        }
    }

    SettingsDialog dialog;
    if (dialog.exec() == QDialog::Accepted) {
        Application::instance()->refreshPaths();
    }
}

int MainWindow::init() {
    DvdModel::initialize();

    QList<DvdModel *> list = DvdModel::devices();
    bool enabled = false;
    for (int i=0; i < list.size(); i++) {
        if (list.at(i)->enabled()) {
            enabled = true;
            break;
        }
    }

    if (list.size() == 0) {
        int ret = QMessageBox::critical(this, tr("QMultiRecord"),
                                        tr("No burning drives was found. Terminating."),
                                        QMessageBox::Close,
                                        QMessageBox::Close);
        return -1;
    }

    if (!enabled) {
        SettingsDialog dialog;
        if (dialog.exec() == QDialog::Rejected) {
            return -2;
        }
    }

    // construct drive views
    constructLayout();

    Application::instance()->refreshPaths();

    return 0;
}

int MainWindow::constructLayout() {
    if (centralWidget()) {
        QWidget *w = centralWidget();
        setCentralWidget(0);
        w->deleteLater();
    }

    QFrame *frame = new QFrame();
    QList<QWidget *> list;

    int counter = 1;
    foreach (DvdModel *drive, DvdModel::devices()) {
        if (drive->enabled()) {
            DvdView *view = new DvdView();
            if (view) {
                view->setModel(drive);
                view->setLabel(QString("%1.").arg(counter++));
                connect(view->settingsButton, SIGNAL(clicked()), this, SLOT(showSettings()));
                list.append(view);
            }
            drive->checkMedia();
            drive->update();
        }
    }

    if (counter == 1) {
        qDebug() << "WTF? We should never reach here (1).";
        return -3;
    }

    // create a layout
    if (list.size()) {
        if (list.size() < 3) {
            QHBoxLayout *hLayout = new QHBoxLayout();

            foreach (QWidget *view, list) {
                hLayout->addWidget(view);
            }

            frame->setLayout(hLayout);
        } else {
            QGridLayout *gLayout = new QGridLayout();
            for (int i=0;i < list.size();i++) {
                gLayout->addWidget(list.at(i),i / 2, i % 2);
            }
            frame->setLayout(gLayout);
        }
    }

    setCentralWidget(frame);

    return 0;
}

void MainWindow::closeEvent(QCloseEvent *event) {
    event->accept();
}


