/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
//! -*- coding: UTF-8 -*-
#define SOURCE_CODING "UTF-8"

#include <QtCore>
#include <QtGui>

#include "application.h"

#include "generatedialog.h"


//!
GenerateDialog::GenerateDialog(QWidget *parent, Qt::WindowFlags f)
    : QWidget(parent, f)
    , m_canClose(false)
    , m_thread(0)
{
    setupUi(this);
}

//!
GenerateDialog::~GenerateDialog() {
    Q_EMIT(closed());

    if (m_thread) {
        m_thread->stop();
        m_thread->quit();
        while (!m_thread->wait(1000));
        delete m_thread;
    }
}

void GenerateDialog::closeEvent(QCloseEvent *event) {
    if (m_canClose) {
        event->accept();
    } else {
        event->ignore();
        setWindowState(Qt::WindowMinimized);
    }
}

void GenerateDialog::setCanClose(bool flag) {
    m_canClose = flag;
}

void GenerateDialog::progress(const QString &jobName, int value, const QString &info) {
    //qDebug() << "GenerateDialog::progress " << jobName << value;
    QList<QTableWidgetItem *> items = tableWidget->findItems(jobName, Qt::MatchExactly);
    if (items.size() > 0) {
        // 1 column (jobname - category/filename)
        //

        // 2 column (progress)
        QProgressBar *bar = qobject_cast<QProgressBar *>(tableWidget->cellWidget(items.at(0)->row(), 1));
        if (bar) {
            bar->setValue(value);
        }

        // 3 column (status)
        if (info!=QString::null) {
            tableWidget->item(items.at(0)->row(), 2)->setText(info);
        }
    }
}

void GenerateDialog::switchJob(const QString &prev, const QString &next) 
{
    QList<QTableWidgetItem *> items;

    if (next!=QString::null) {
        items = tableWidget->findItems(next, Qt::MatchExactly);
    } else
    if (prev!=QString::null)  {
        items = tableWidget->findItems(prev, Qt::MatchExactly);
    }

    if (items.size() > 0) {
        tableWidget->setCurrentItem(items.at(0));

        if (m_thread->jobStatus(items.at(0)->text()) == 0) {
            items.at(0)->setBackground(QBrush(QColor(255, 0, 0, 127)));
        }
    }
}

void GenerateDialog::init(const QStringList &jobList, const QStringList &fullNames) {
    tableWidget->setRowCount(jobList.size());
    for (int i=0; i < jobList.size(); i++) {
        QTableWidgetItem *item0 = new QTableWidgetItem(jobList.at(i));
        QTableWidgetItem *item2 = new QTableWidgetItem("wait...");
        tableWidget->setItem(i,0,item0);
        tableWidget->setCellWidget(i, 1, new QProgressBar);
        tableWidget->setItem(i,2,item2);
    }

    if (!m_thread) {
        m_thread = new GenerateThread ();
        m_thread->init(jobList,fullNames);

        connect(m_thread, SIGNAL(progress(const QString &, int, const QString &)),
                this, SLOT(progress(const QString &, int, const QString &)));

        connect(m_thread, SIGNAL(switchJob(const QString &, const QString &)),
                this, SLOT(switchJob(const QString &, const QString &)));

        connect(m_thread, SIGNAL(finished()), this, SLOT(finished()));

        m_thread->start();
    }
}

void GenerateDialog::resizeEvent(QResizeEvent * event) {
    Q_UNUSED(event)

    int columnSize = tableWidget->width() - 
        (tableWidget->columnWidth (1) +  tableWidget->columnWidth (2) + 18);

    qDebug() << "GenerateDialog::resizeEvent() =" << columnSize;
    tableWidget->setColumnWidth(0, columnSize);
}

void GenerateDialog::on_closeButton_clicked() {
    close();
}

void GenerateDialog::on_cancelButton_clicked() {
    if (m_thread) {
        int row = tableWidget->currentRow();
        if (row >= 0) {
            if (m_thread->jobStatus(tableWidget->item(row,0)->text()) == 1) {
                m_thread->cancelJob(tableWidget->item(row,0)->text());
                tableWidget->item(row,0)->setBackground(QBrush(QColor(255, 0, 0, 127)));
            }
        }
    }
}

void GenerateDialog::on_stopButton_clicked() {
    if (m_thread) {
        m_thread->stop();
    }
    m_canClose = true;
}

void GenerateDialog::finished() {
    m_canClose = true;
    QTimer::singleShot(2000, this, SLOT(close()));
}
