/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#ifndef __DVDVIEW_H__
#define __DVDVIEW_H__

#if HAVE_QT5
#include <QtWidgets>
#else
#include <QtGui>
#endif

#include "dvdmodel.h"
#include "ui_dvdview.h"

class DvdView : public QFrame, public Ui_DvdView {
Q_OBJECT
Q_DISABLE_COPY(DvdView);

public:
    explicit DvdView(QWidget *parent = 0,  Qt::WindowFlags f = 0);
    ~DvdView();

    void setModel(DvdModel *model);
    DvdModel *model();
    void setLabel(const QString& label = QString::null);
/*
    void setDevice(const QString& device = QString::null, const QString& deviceInfo = QString::null);

*/
public slots:
    void statusChanged(const QString &device, 
                       const DvdModel::DeviceType  &deviceType,
                       const DvdModel::DvdStatus   &dvdStatus,
                       const DvdModel::ProcessMode &processMode,
                       quint64 capacity,
                       const QString &hash);

    void progress(int value, const QString &info = QString::null);

private:
    void disableGui();
    QPixmap icon(const QString &name = QString::null);

    void enableWrite();
    void disableWrite();

    void enableCheck();
    void disableCheck();

    void enableCancel();
    void disableCancel();

    void enableCombos();
    void disableCombos();

    void startBurnAnimation();
    void startCheckAnimation();
    void stopAnimation();

    // minor
    int m_speedList;     // 0 - no list, 1 - CD Speeds, 2 - Dvd Speeds
    int m_cdSpeedIndex;  
    int m_dvdSpeedIndex; 
    int m_bdSpeedIndex;

    QString  m_category;
    QString  m_isoFile; 
    quint64  m_isoSize;
    QString  m_isoMd5sum;

    bool m_animateFlag;

    DvdModel *m_model;
    QTimer *m_timer;

    QMenu *m_menu;

private slots:
    void burnAnimate();
    void checkAnimate();

    void refreshRootDirsSlot();

    void on_dataCheck_stateChanged(int state);

    void on_categoryCombo_currentIndexChanged(QString category);
    void on_isoCombo_currentIndexChanged(QString isoFileName);

    void on_speedCombo_currentIndexChanged(int index);

    void on_checkButton_clicked();
    void on_burnButton_clicked();
    void on_cancelButton_clicked();

    void on_menuButton_clicked();
};

#endif // __DVDVIEW_H__
