/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/

//! -*- coding: UTF-8 -*-
#define SOURCE_CODING "UTF-8"

#include "define.h"

#include <QtCore>

#include "dvdmodel.h"
#include "drivestablemodel.h"

//! constuctor
DrivesTableModel::DrivesTableModel(QObject *apParent) 
    : QStandardItemModel(apParent) {
    initialize();
}

//! constuctor
DrivesTableModel::DrivesTableModel(int aRows, int aColumns, QObject * apParent) 
    : QStandardItemModel(aRows, aColumns, apParent) {
    initialize();
}

//! destructor
DrivesTableModel::~DrivesTableModel() {
    //
}

// initialize a model with empty valid structure
void DrivesTableModel::initialize() {
    clear(); setColumnCount(4);

    setHeaderData(0,  Qt::Horizontal, tr(""));
    setHeaderData(1,  Qt::Horizontal, tr("Device File"));
    setHeaderData(2,  Qt::Horizontal, tr("Model"));

    // fill the table
    QList<DvdModel *> devices = DvdModel::devices();

    //for (int j=0; j < 2; j++)
    for (int i=0; i < devices.size(); i++) {
        int vRow = rowCount();
        setRowCount(vRow + 1);

        QStandardItem *itemEnabled = new QStandardItem();
        itemEnabled->setCheckable(true);
        itemEnabled->setCheckState(devices.at(i)->enabled() ? Qt::Checked : Qt::Unchecked);
        //itemEnabled->setData(devices.at(i)->enabled());

        QStandardItem *itemFile = new QStandardItem();
        itemFile->setText(devices.at(i)->deviceFile());

        QStandardItem *itemInfo = new QStandardItem();
        itemInfo->setText(devices.at(i)->deviceInfo());

        setItem(vRow, 0,   itemEnabled);
        setItem(vRow, 1,   itemFile);
        setItem(vRow, 2,   itemInfo);
    }
}
