/****************************************************************************
 ** Copyright (C) 2008-2013 Grigory A. Mozhaev <zcrendel@gmail.com>
 **
 ** This file is part of QMultiRecord (http://qt-apps.org/content/show.php?content=106254).
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://www.trolltech.com/products/qt/opensource.html
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/
#ifndef _CHECKABLEITEMDELEGATE_H_
#define _CHECKABLEITEMDELEGATE_H_

#include "nofocusitemdelegate.h"

/** 
 * class CheckableItemDelegate represents aligned checkbox (by left, right, or center).
 * 
 */
class CheckableItemDelegate : public NoFocusItemDelegate {
Q_OBJECT

public:
    explicit CheckableItemDelegate(Qt::Alignment aFlags, QObject *apParent = 0) : NoFocusItemDelegate(apParent), mAlignFlags(aFlags) {};
    CheckableItemDelegate(QObject *apParent = 0) : NoFocusItemDelegate(apParent) {};

    void paint(QPainter * apPainter, const QStyleOptionViewItem & aOption, const QModelIndex & aIndex) const;

protected:
    virtual void drawCheck(QPainter *apPainter, const QStyleOptionViewItem &aOption,
                           const QRect &, Qt::CheckState aState) const;

    virtual bool editorEvent(QEvent *apEvent, QAbstractItemModel *apModel, const QStyleOptionViewItem &aOption,
                             const QModelIndex &aIndex);

private:
    Qt::Alignment mAlignFlags;

};

#endif /* _CHECKABLEITEMDELEGATE_H_ */
