# encoding: UTF-8
#
# PhotoFilmStrip - Creates movies out of your pictures.
#
# Copyright (C) 2011 Jens Goepfert
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import os
import subprocess

from photofilmstrip.action.IAction import IAction


class ActionPlayVideo(IAction):

    def __init__(self, outpath):
        self.outpath = outpath

    def GetName(self):
        return _(u'Play video')

    def Execute(self):
        for ext in ('avi', 'flv', 'mkv', 'ogv', 'mpg', 'mp4'):
            videoFile = os.path.join(self.outpath, "output.%s" % ext)
            if os.path.exists(videoFile):
                break
        else:
            return

        if os.name == "nt":
            try:
                os.startfile(videoFile)  # pylint: disable=no-member
            except:
                pass
        else:
            subprocess.Popen(["xdg-open", videoFile])
