/*
    scconfig - gui lib detection - lesstif
    Copyright (C) 2015  Tibor Palinkas

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

		Project page: http://repo.hu/projects/scconfig
		Contact via email: scconfig [at] igor2.repo.hu
*/
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "libs.h"
#include "log.h"
#include "db.h"
#include "dep.h"


int find_xopendisplay(const char *name, int logdepth, int fatal)
{
	const char *test_c =
		NL "#include <X11/Xlib.h>"
		NL "#include <stdlib.h>"
		NL "int main()"
		NL "{"
		NL "	Display *d = XOpenDisplay(NULL);"
		NL "	return 0;"
		NL "}";

	const char *node = "libs/gui/xopendisplay";
	char **cflags,  *cflags_arr[]  = {"", "-I/opt/X11/include", NULL};
	char **ldflags, *ldflags_arr[] = {"-lX11", "-L/opt/X11/lib -lX11", NULL};

	if (require("cc/cc", logdepth, fatal))
		return 1;

	report("Checking for XOpenDisplay... ");
	logprintf(logdepth, "find_xopendisplay:\n");
	logdepth++;

	for(cflags = cflags_arr; *cflags != NULL; cflags++) {
		for(ldflags = ldflags_arr; *ldflags != NULL; ldflags++) {
			if (try_icl_norun(logdepth, node, test_c, NULL, *cflags, *ldflags) != 0) {
				return 0;
			}
		}
	}
	return try_fail(logdepth, node);
}



int find_xinerama(const char *name, int logdepth, int fatal)
{
	const char *test_c =
		NL "#include <X11/Xlib.h>"
		NL "#include <stdlib.h>"
		NL "int main()"
		NL "{"
		NL "	Display *d = XOpenDisplay(NULL);"
		NL "	if (d != NULL)"
		NL "		XineramaIsActive(d);"
		NL "	return 0;"
		NL "}";

	const char *node = "libs/gui/xinerama";
	char **cflags,  *cflags_arr[]  = {"", "-I/opt/X11/include", NULL};
	char **ldflags, *ldflags_arr[] = {"-lXinerama", "-lX11 -lXinerama", "-L/opt/X11/lib -lX11 -lXinerama", NULL};

	if (require("cc/cc", logdepth, fatal))
		return 1;

	report("Checking for Xinerama... ");
	logprintf(logdepth, "find_xinerama:\n");
	logdepth++;

	for(cflags = cflags_arr; *cflags != NULL; cflags++) {
		for(ldflags = ldflags_arr; *ldflags != NULL; ldflags++) {
			if (try_icl_norun(logdepth, node, test_c, NULL, *cflags, *ldflags) != 0) {
				return 0;
			}
		}
	}
	return try_fail(logdepth, node);
}

int find_xrender(const char *name, int logdepth, int fatal)
{
	const char *test_c =
		NL "#include <X11/Xlib.h>"
		NL "#include <X11/extensions/Xrender.h>"
		NL "#include <stdlib.h>"
		NL "int main()"
		NL "{"
		NL "	Display *d = XOpenDisplay(NULL);"
		NL "	XRenderFreePicture (d, 0);"
		NL "	return 0;"
		NL "}";

	const char *node = "libs/gui/xrender";
	char **cflags,  *cflags_arr[]  = {"", "-I/opt/X11/include",  NULL};
	char **ldflags, *ldflags_arr[] = {"-lXrender", "-lX11 -lXrender", "-L/opt/X11/lib -lX11 -lXrender", NULL};

	if (require("cc/cc", logdepth, fatal))
		return 1;

	report("Checking for Xrender... ");
	logprintf(logdepth, "find_xrender:\n");
	logdepth++;

	for(cflags = cflags_arr; *cflags != NULL; cflags++) {
		for(ldflags = ldflags_arr; *ldflags != NULL; ldflags++) {
			if (try_icl_norun(logdepth, node, test_c, NULL, *cflags, *ldflags) != 0) {
				return 0;
			}
		}
	}
	return try_fail(logdepth, node);
}
