/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final zzg CREATOR = new zzg();
    private final int zzCY;
    private final List<LatLng> zzaDA;
    private final List<List<LatLng>> zzaDB;
    private float zzaCX = 10.0f;
    private int zzaCY = -16777216;
    private int zzaCZ = 0;
    private float zzaDa = 0.0f;
    private boolean zzaDb = true;
    private boolean zzaDC = false;

    public PolygonOptions() {
        this.zzCY = 1;
        this.zzaDA = new ArrayList<LatLng>();
        this.zzaDB = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.zzCY = versionCode;
        this.zzaDA = points;
        this.zzaDB = holes;
        this.zzaCX = strokeWidth;
        this.zzaCY = strokeColor;
        this.zzaCZ = fillColor;
        this.zzaDa = zIndex;
        this.zzaDb = visible;
        this.zzaDC = geodesic;
    }

    int getVersionCode() {
        return this.zzCY;
    }

    List zzvK() {
        return this.zzaDB;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzg.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.zzaDA.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.zzaDA.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.zzaDA.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.zzaDB.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zzaCX = width;
        return this;
    }

    public PolygonOptions strokeColor(int color2) {
        this.zzaCY = color2;
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        this.zzaCZ = color2;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zzaDa = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zzaDb = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.zzaDC = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzaDA;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzaDB;
    }

    public float getStrokeWidth() {
        return this.zzaCX;
    }

    public int getStrokeColor() {
        return this.zzaCY;
    }

    public int getFillColor() {
        return this.zzaCZ;
    }

    public float getZIndex() {
        return this.zzaDa;
    }

    public boolean isVisible() {
        return this.zzaDb;
    }

    public boolean isGeodesic() {
        return this.zzaDC;
    }
}

