/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

@zzgd
public final class zzdo
implements zzdg {
    private final Map<zzid, Integer> zzwA = new WeakHashMap<zzid, Integer>();

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzk.zzcA().zzb(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaC("Could not parse " + string2 + " in a video GMSG: " + string3);
            }
        }
        return n2;
    }

    @Override
    public void zza(zzid zzid2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzb.zzaC("Action missing from video GMSG.");
            return;
        }
        if (zzb.zzL(3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            zzb.zzay("Video GMSG: " + string2 + " " + object.toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzb.zzaC("Color parameter missing from color video GMSG.");
                return;
            }
            try {
                zzh zzh2;
                int n = Color.parseColor((String)object);
                zzc zzc2 = zzid2.zzgD();
                if (zzc2 != null && (zzh2 = zzc2.zzeq()) != null) {
                    zzh2.setBackgroundColor(n);
                    return;
                }
                this.zzwA.put(zzid2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzb.zzaC("Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzid2.zzgD();
        if (object == null) {
            zzb.zzaC("Could not get ad overlay for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            Context context = zzid2.getContext();
            int n = zzdo.zza(context, map, "x", 0);
            int n2 = zzdo.zza(context, map, "y", 0);
            int n3 = zzdo.zza(context, map, "w", -1);
            int n4 = zzdo.zza(context, map, "h", -1);
            if (bl && ((zzc)object).zzeq() == null) {
                ((zzc)object).zze(n, n2, n3, n4);
                if (this.zzwA.containsKey(zzid2)) {
                    int n5 = this.zzwA.get(zzid2);
                    zzh zzh3 = ((zzc)object).zzeq();
                    zzh3.setBackgroundColor(n5);
                }
            } else {
                ((zzc)object).zzd(n, n2, n3, n4);
            }
        } else {
            zzh zzh4 = ((zzc)object).zzeq();
            if (zzh4 == null) {
                zzh.zzd(zzid2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzid2.getContext();
                int n = zzdo.zza(context, map, "x", 0);
                int n6 = zzdo.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
                zzh4.zzc(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string3 = map.get("time");
                if (string3 == null) {
                    zzb.zzaC("Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string3);
                    int n = (int)(f * 1000.0f);
                    zzh4.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    zzb.zzaC("Could not parse time parameter from currentTime video GMSG: " + string3);
                }
            } else if ("hide".equals(string2)) {
                zzh4.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzh4.zzeH();
            } else if ("muted".equals(string2)) {
                boolean bl3 = Boolean.parseBoolean(map.get("muted"));
                if (bl3) {
                    zzh4.zzeI();
                } else {
                    zzh4.zzeJ();
                }
            } else if ("pause".equals(string2)) {
                zzh4.pause();
            } else if ("play".equals(string2)) {
                zzh4.play();
            } else if ("show".equals(string2)) {
                zzh4.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzh4.zzah(map.get("src"));
            } else if ("volume".equals(string2)) {
                String string4 = map.get("volume");
                if (string4 == null) {
                    zzb.zzaC("Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzh4.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    zzb.zzaC("Could not parse volume parameter from volume video GMSG: " + string4);
                }
            } else if ("watermark".equals(string2)) {
                zzh4.zzeK();
            } else {
                zzb.zzaC("Unknown video action: " + string2);
            }
        }
    }
}

