/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zze;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzx;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzlo;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zze();
    final int zzCY;
    final DriveId zzacT;
    final String zzOx;
    final ParcelFileDescriptor zzadT;
    final ParcelFileDescriptor zzadU;
    final MetadataBundle zzadV;
    final List<String> zzadW;
    final int zzwS;
    final IBinder zzadX;
    private boolean zzadY = false;
    private boolean zzadZ = false;
    private boolean zzaea = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, List<String> trackingTags, int status, IBinder releaseCallback) {
        this.zzCY = versionCode;
        this.zzacT = driveId;
        this.zzOx = accountName;
        this.zzadT = baseParcelFileDescriptor;
        this.zzadU = modifiedParcelFileDescriptor;
        this.zzadV = modifiedMetadataBundle;
        this.zzadW = trackingTags;
        this.zzwS = status;
        this.zzadX = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzpu();
        return this.zzacT;
    }

    public String getAccountName() {
        this.zzpu();
        return this.zzOx;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzpu();
        if (this.zzadT == null) {
            return null;
        }
        if (this.zzadY) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzadY = true;
        return new FileInputStream(this.zzadT.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzpu();
        if (this.zzadU == null) {
            return null;
        }
        if (this.zzadZ) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzadZ = true;
        return new FileInputStream(this.zzadU.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzpu();
        return this.zzadV != null ? new MetadataChangeSet(this.zzadV) : null;
    }

    public List<String> getTrackingTags() {
        this.zzpu();
        return new ArrayList<String>(this.zzadW);
    }

    public int getStatus() {
        this.zzpu();
        return this.zzwS;
    }

    public void dismiss() {
        this.zzv(false);
    }

    public void snooze() {
        this.zzv(true);
    }

    private void zzv(boolean bl) {
        this.zzpu();
        this.zzaea = true;
        zzlg.zza(this.zzadT);
        zzlg.zza(this.zzadU);
        if (this.zzadV != null && this.zzadV.zzc(zzlo.zzaho)) {
            this.zzadV.zza(zzlo.zzaho).release();
        }
        if (this.zzadX == null) {
            zzx.zzv("CompletionEvent", "No callback on " + (bl ? "snooze" : "dismiss"));
            return;
        }
        try {
            zzan.zza.zzaR(this.zzadX).zzv(bl);
        }
        catch (RemoteException remoteException) {
            zzx.zzv("CompletionEvent", "RemoteException on " + (bl ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void zzpu() {
        if (this.zzaea) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string2 = this.zzadW == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.zzadW) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.zzacT, this.zzwS, string2);
    }
}

